/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.geom.Point2D;
import java.util.concurrent.ConcurrentHashMap;
import sun.font.CharToGlyphMapper;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.PhysicalFont;
import sun.font.StrikeCache;
import sun.font.StrikeMetrics;

public abstract class PhysicalStrike
extends FontStrike {
    static final long INTMASK = 0xFFFFFFFFL;
    static boolean longAddresses;
    private PhysicalFont physicalFont;
    protected CharToGlyphMapper mapper;
    protected long pScalerContext;
    protected long[] longGlyphImages;
    protected int[] intGlyphImages;
    ConcurrentHashMap<Integer, Point2D.Float> glyphPointMapCache;
    protected boolean getImageWithAdvance;
    protected static final int complexTX = 124;

    PhysicalStrike(PhysicalFont physicalFont, FontStrikeDesc fontStrikeDesc) {
        this.physicalFont = physicalFont;
        this.desc = fontStrikeDesc;
    }

    protected PhysicalStrike() {
    }

    @Override
    public int getNumGlyphs() {
        return this.physicalFont.getNumGlyphs();
    }

    @Override
    StrikeMetrics getFontMetrics() {
        if (this.strikeMetrics == null) {
            this.strikeMetrics = this.physicalFont.getFontMetrics(this.pScalerContext);
        }
        return this.strikeMetrics;
    }

    @Override
    float getCodePointAdvance(int n) {
        return this.getGlyphAdvance(this.physicalFont.getMapper().charToGlyph(n));
    }

    @Override
    Point2D.Float getCharMetrics(char c) {
        return this.getGlyphMetrics(this.physicalFont.getMapper().charToGlyph(c));
    }

    int getSlot0GlyphImagePtrs(int[] nArray, long[] lArray, int n) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point2D.Float getGlyphPoint(int n, int n2) {
        Point2D.Float float_ = null;
        Integer n3 = n << 16 | n2;
        if (this.glyphPointMapCache == null) {
            PhysicalStrike physicalStrike = this;
            synchronized (physicalStrike) {
                if (this.glyphPointMapCache == null) {
                    this.glyphPointMapCache = new ConcurrentHashMap();
                }
            }
        } else {
            float_ = this.glyphPointMapCache.get(n3);
        }
        if (float_ == null) {
            float_ = this.physicalFont.getGlyphPoint(this.pScalerContext, n, n2);
            this.adjustPoint(float_);
            this.glyphPointMapCache.put(n3, float_);
        }
        return float_;
    }

    protected void adjustPoint(Point2D.Float float_) {
    }

    static {
        switch (StrikeCache.nativeAddressSize) {
            case 8: {
                longAddresses = true;
                break;
            }
            case 4: {
                longAddresses = false;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected address size");
            }
        }
    }
}

