/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import java.io.IOException;
import java.io.InputStream;
import sun.net.httpserver.ExchangeImpl;
import sun.net.httpserver.LeftOverInputStream;

class ChunkedInputStream
extends LeftOverInputStream {
    private int remaining;
    private boolean needToReadHeader = true;
    static final char CR = '\r';
    static final char LF = '\n';
    private static final int MAX_CHUNK_HEADER_SIZE = 2050;

    ChunkedInputStream(ExchangeImpl exchangeImpl, InputStream inputStream) {
        super(exchangeImpl, inputStream);
    }

    private int numeric(char[] cArray, int n) throws IOException {
        assert (cArray.length >= n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            int n3 = 0;
            if (c >= '0' && c <= '9') {
                n3 = c - 48;
            } else if (c >= 'a' && c <= 'f') {
                n3 = c - 97 + 10;
            } else if (c >= 'A' && c <= 'F') {
                n3 = c - 65 + 10;
            } else {
                throw new IOException("invalid chunk length");
            }
            n2 = n2 * 16 + n3;
        }
        return n2;
    }

    private int readChunkHeader() throws IOException {
        int n;
        boolean bl = false;
        char[] cArray = new char[16];
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        while ((n = this.in.read()) != -1) {
            char c = (char)n;
            if (n2 == cArray.length - 1 || ++n3 > 2050) {
                throw new IOException("invalid chunk header");
            }
            if (bl) {
                if (c == '\n') {
                    int n4 = this.numeric(cArray, n2);
                    return n4;
                }
                bl = false;
                if (bl2) continue;
                cArray[n2++] = c;
                continue;
            }
            if (c == '\r') {
                bl = true;
                continue;
            }
            if (c == ';') {
                bl2 = true;
                continue;
            }
            if (bl2) continue;
            cArray[n2++] = c;
        }
        throw new IOException("end of stream reading chunk header");
    }

    @Override
    protected int readImpl(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.eof) {
            return -1;
        }
        if (this.needToReadHeader) {
            this.remaining = this.readChunkHeader();
            if (this.remaining == 0) {
                this.eof = true;
                this.consumeCRLF();
                this.t.getServerImpl().requestCompleted(this.t.getConnection());
                return -1;
            }
            this.needToReadHeader = false;
        }
        if (n2 > this.remaining) {
            n2 = this.remaining;
        }
        if ((n3 = this.in.read(byArray, n, n2)) > -1) {
            this.remaining -= n3;
        }
        if (this.remaining == 0) {
            this.needToReadHeader = true;
            this.consumeCRLF();
        }
        return n3;
    }

    private void consumeCRLF() throws IOException {
        char c = (char)this.in.read();
        if (c != '\r') {
            throw new IOException("invalid chunk end");
        }
        c = (char)this.in.read();
        if (c != '\n') {
            throw new IOException("invalid chunk end");
        }
    }

    @Override
    public int available() throws IOException {
        if (this.eof || this.closed) {
            return 0;
        }
        int n = this.in.available();
        return n > this.remaining ? this.remaining : n;
    }

    @Override
    public boolean isDataBuffered() throws IOException {
        assert (this.eof);
        return this.in.available() > 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

