/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.Month;
import java.time.Ser;
import java.time.Year;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;

public final class MonthDay
implements TemporalAccessor,
TemporalAdjuster,
Comparable<MonthDay>,
Serializable {
    private static final long serialVersionUID = -939150713474957432L;
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendLiteral("--").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
    private final int month;
    private final int day;

    public static MonthDay now() {
        return MonthDay.now(Clock.systemDefaultZone());
    }

    public static MonthDay now(ZoneId zoneId) {
        return MonthDay.now(Clock.system(zoneId));
    }

    public static MonthDay now(Clock clock) {
        LocalDate localDate = LocalDate.now(clock);
        return MonthDay.of(localDate.getMonth(), localDate.getDayOfMonth());
    }

    public static MonthDay of(Month month, int n) {
        Objects.requireNonNull(month, "month");
        ChronoField.DAY_OF_MONTH.checkValidValue(n);
        if (n > month.maxLength()) {
            throw new DateTimeException("Illegal value for DayOfMonth field, value " + n + " is not valid for month " + month.name());
        }
        return new MonthDay(month.getValue(), n);
    }

    public static MonthDay of(int n, int n2) {
        return MonthDay.of(Month.of(n), n2);
    }

    public static MonthDay from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof MonthDay) {
            return (MonthDay)temporalAccessor;
        }
        try {
            if (!IsoChronology.INSTANCE.equals(Chronology.from(temporalAccessor))) {
                temporalAccessor = LocalDate.from(temporalAccessor);
            }
            return MonthDay.of(temporalAccessor.get(ChronoField.MONTH_OF_YEAR), temporalAccessor.get(ChronoField.DAY_OF_MONTH));
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain MonthDay from TemporalAccessor: " + temporalAccessor + " of type " + temporalAccessor.getClass().getName(), dateTimeException);
        }
    }

    public static MonthDay parse(CharSequence charSequence) {
        return MonthDay.parse(charSequence, PARSER);
    }

    public static MonthDay parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.parse(charSequence, MonthDay::from);
    }

    private MonthDay(int n, int n2) {
        this.month = n;
        this.day = n2;
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField == ChronoField.MONTH_OF_YEAR || temporalField == ChronoField.DAY_OF_MONTH;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        if (temporalField == ChronoField.MONTH_OF_YEAR) {
            return temporalField.range();
        }
        if (temporalField == ChronoField.DAY_OF_MONTH) {
            return ValueRange.of(1L, this.getMonth().minLength(), this.getMonth().maxLength());
        }
        return TemporalAccessor.super.range(temporalField);
    }

    @Override
    public int get(TemporalField temporalField) {
        return this.range(temporalField).checkValidIntValue(this.getLong(temporalField), temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case DAY_OF_MONTH: {
                    return this.day;
                }
                case MONTH_OF_YEAR: {
                    return this.month;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.getFrom(this);
    }

    public int getMonthValue() {
        return this.month;
    }

    public Month getMonth() {
        return Month.of(this.month);
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public boolean isValidYear(int n) {
        return !(this.day == 29 && this.month == 2 && !Year.isLeap(n));
    }

    public MonthDay withMonth(int n) {
        return this.with(Month.of(n));
    }

    public MonthDay with(Month month) {
        Objects.requireNonNull(month, "month");
        if (month.getValue() == this.month) {
            return this;
        }
        int n = Math.min(this.day, month.maxLength());
        return new MonthDay(month.getValue(), n);
    }

    public MonthDay withDayOfMonth(int n) {
        if (n == this.day) {
            return this;
        }
        return MonthDay.of(this.month, n);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.chronology()) {
            return (R)IsoChronology.INSTANCE;
        }
        return TemporalAccessor.super.query(temporalQuery);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        if (!Chronology.from(temporal).equals(IsoChronology.INSTANCE)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        temporal = temporal.with(ChronoField.MONTH_OF_YEAR, this.month);
        return temporal.with(ChronoField.DAY_OF_MONTH, Math.min(temporal.range(ChronoField.DAY_OF_MONTH).getMaximum(), (long)this.day));
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    public LocalDate atYear(int n) {
        return LocalDate.of(n, this.month, this.isValidYear(n) ? this.day : 28);
    }

    @Override
    public int compareTo(MonthDay monthDay) {
        int n = this.month - monthDay.month;
        if (n == 0) {
            n = this.day - monthDay.day;
        }
        return n;
    }

    public boolean isAfter(MonthDay monthDay) {
        return this.compareTo(monthDay) > 0;
    }

    public boolean isBefore(MonthDay monthDay) {
        return this.compareTo(monthDay) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MonthDay) {
            MonthDay monthDay = (MonthDay)object;
            return this.month == monthDay.month && this.day == monthDay.day;
        }
        return false;
    }

    public int hashCode() {
        return (this.month << 6) + this.day;
    }

    public String toString() {
        return new StringBuilder(10).append("--").append(this.month < 10 ? "0" : "").append(this.month).append(this.day < 10 ? "-0" : "-").append(this.day).toString();
    }

    private Object writeReplace() {
        return new Ser(13, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.month);
        dataOutput.writeByte(this.day);
    }

    static MonthDay readExternal(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        byte by2 = dataInput.readByte();
        return MonthDay.of(by, (int)by2);
    }
}

