/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.ProviderException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.util.Debug;

final class SessionManager {
    private static final int DEFAULT_MAX_SESSIONS = 32;
    private static final Debug debug = Debug.getInstance("pkcs11");
    private final Token token;
    private final int maxSessions;
    private AtomicInteger activeSessions = new AtomicInteger();
    private final Pool objSessions;
    private final Pool opSessions;
    private int maxActiveSessions;
    private Object maxActiveSessionsLock;
    private final long openSessionFlags;

    SessionManager(Token token) {
        long l;
        if (token.isWriteProtected()) {
            this.openSessionFlags = 4L;
            l = token.tokenInfo.ulMaxSessionCount;
        } else {
            this.openSessionFlags = 6L;
            l = token.tokenInfo.ulMaxRwSessionCount;
        }
        if (l == 0L) {
            l = Integer.MAX_VALUE;
        } else if (l == -1L || l < 0L) {
            l = 32L;
        }
        this.maxSessions = (int)Math.min(l, Integer.MAX_VALUE);
        this.token = token;
        this.objSessions = new Pool(this);
        this.opSessions = new Pool(this);
        if (debug != null) {
            this.maxActiveSessionsLock = new Object();
        }
    }

    boolean lowMaxSessions() {
        return this.maxSessions <= 32;
    }

    Session getObjSession() throws PKCS11Exception {
        Session session = this.objSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        session = this.opSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        session = this.openSession();
        return this.ensureValid(session);
    }

    Session getOpSession() throws PKCS11Exception {
        Session session = this.opSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        if (this.maxSessions == Integer.MAX_VALUE || this.activeSessions.get() < this.maxSessions) {
            session = this.openSession();
            return this.ensureValid(session);
        }
        session = this.objSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        throw new ProviderException("Could not obtain session");
    }

    private Session ensureValid(Session session) {
        session.id();
        return session;
    }

    Session killSession(Session session) {
        if (session == null || !this.token.isValid()) {
            return null;
        }
        if (debug != null) {
            String string = new Exception().getStackTrace()[2].toString();
            System.out.println("Killing session (" + string + ") active: " + this.activeSessions.get());
        }
        this.closeSession(session);
        return null;
    }

    Session releaseSession(Session session) {
        if (session == null || !this.token.isValid()) {
            return null;
        }
        if (session.hasObjects()) {
            this.objSessions.release(session);
        } else {
            this.opSessions.release(session);
        }
        return null;
    }

    void demoteObjSession(Session session) {
        boolean bl;
        if (!this.token.isValid()) {
            return;
        }
        if (debug != null) {
            System.out.println("Demoting session, active: " + this.activeSessions.get());
        }
        if (!(bl = this.objSessions.remove(session))) {
            return;
        }
        this.opSessions.release(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session openSession() throws PKCS11Exception {
        if (this.maxSessions != Integer.MAX_VALUE && this.activeSessions.get() >= this.maxSessions) {
            throw new ProviderException("No more sessions available");
        }
        long l = this.token.p11.C_OpenSession(this.token.provider.slotID, this.openSessionFlags, null, null);
        Session session = new Session(this.token, l);
        this.activeSessions.incrementAndGet();
        if (debug != null) {
            Object object = this.maxActiveSessionsLock;
            synchronized (object) {
                if (this.activeSessions.get() > this.maxActiveSessions) {
                    this.maxActiveSessions = this.activeSessions.get();
                    if (this.maxActiveSessions % 10 == 0) {
                        System.out.println("Open sessions: " + this.maxActiveSessions);
                    }
                }
            }
        }
        return session;
    }

    private void closeSession(Session session) {
        session.close();
        this.activeSessions.decrementAndGet();
    }

    public static final class Pool {
        private final SessionManager mgr;
        private final ConcurrentLinkedDeque<Session> pool;

        Pool(SessionManager sessionManager) {
            this.mgr = sessionManager;
            this.pool = new ConcurrentLinkedDeque();
        }

        boolean remove(Session session) {
            return this.pool.remove(session);
        }

        Session poll() {
            return this.pool.pollLast();
        }

        void release(Session session) {
            Session session2;
            this.pool.offer(session);
            if (session.hasObjects()) {
                return;
            }
            int n = this.pool.size();
            if (n < 5) {
                return;
            }
            long l = System.currentTimeMillis();
            int n2 = 0;
            while ((session2 = this.pool.peek()) != null && !session2.isLive(l) && this.pool.remove(session2)) {
                this.mgr.closeSession(session2);
                if (n - ++n2 > 1) continue;
            }
            if (debug != null) {
                System.out.println("Closing " + n2 + " idle sessions, active: " + this.mgr.activeSessions);
            }
        }
    }
}

