/*
 * Decompiled with CFR 0.152.
 */
package sun.util.cldr;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import sun.security.action.GetPropertyAction;
import sun.util.locale.provider.JRELocaleProviderAdapter;
import sun.util.locale.provider.LocaleProviderAdapter;

public class CLDRLocaleProviderAdapter
extends JRELocaleProviderAdapter {
    private static final String LOCALE_DATA_JAR_NAME = "cldrdata.jar";

    public CLDRLocaleProviderAdapter() {
        String string = File.separator;
        String string2 = AccessController.doPrivileged(new GetPropertyAction("java.home")) + string + "lib" + string + "ext" + string + LOCALE_DATA_JAR_NAME;
        final File file = new File(string2);
        boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
        if (!bl) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public LocaleProviderAdapter.Type getAdapterType() {
        return LocaleProviderAdapter.Type.CLDR;
    }

    @Override
    public BreakIteratorProvider getBreakIteratorProvider() {
        return null;
    }

    @Override
    public CollatorProvider getCollatorProvider() {
        return null;
    }

    @Override
    public Locale[] getAvailableLocales() {
        Set<String> set = this.createLanguageTagSet("All");
        Locale[] localeArray = new Locale[set.size()];
        int n = 0;
        for (String string : set) {
            localeArray[n++] = Locale.forLanguageTag(string);
        }
        return localeArray;
    }

    @Override
    protected Set<String> createLanguageTagSet(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("sun.util.cldr.CLDRLocaleDataMetaInfo", Locale.ROOT);
        String string2 = resourceBundle.getString(string);
        if (string2 == null) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }
}

