/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.ComponentOrientation;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.NavigationFilter;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;
import sun.awt.SunToolkit;

public class DefaultEditorKit
extends EditorKit {
    public static final String EndOfLineStringProperty = "__EndOfLine__";
    public static final String insertContentAction = "insert-content";
    public static final String insertBreakAction = "insert-break";
    public static final String insertTabAction = "insert-tab";
    public static final String deletePrevCharAction = "delete-previous";
    public static final String deleteNextCharAction = "delete-next";
    public static final String deleteNextWordAction = "delete-next-word";
    public static final String deletePrevWordAction = "delete-previous-word";
    public static final String readOnlyAction = "set-read-only";
    public static final String writableAction = "set-writable";
    public static final String cutAction = "cut-to-clipboard";
    public static final String copyAction = "copy-to-clipboard";
    public static final String pasteAction = "paste-from-clipboard";
    public static final String beepAction = "beep";
    public static final String pageUpAction = "page-up";
    public static final String pageDownAction = "page-down";
    static final String selectionPageUpAction = "selection-page-up";
    static final String selectionPageDownAction = "selection-page-down";
    static final String selectionPageLeftAction = "selection-page-left";
    static final String selectionPageRightAction = "selection-page-right";
    public static final String forwardAction = "caret-forward";
    public static final String backwardAction = "caret-backward";
    public static final String selectionForwardAction = "selection-forward";
    public static final String selectionBackwardAction = "selection-backward";
    public static final String upAction = "caret-up";
    public static final String downAction = "caret-down";
    public static final String selectionUpAction = "selection-up";
    public static final String selectionDownAction = "selection-down";
    public static final String beginWordAction = "caret-begin-word";
    public static final String endWordAction = "caret-end-word";
    public static final String selectionBeginWordAction = "selection-begin-word";
    public static final String selectionEndWordAction = "selection-end-word";
    public static final String previousWordAction = "caret-previous-word";
    public static final String nextWordAction = "caret-next-word";
    public static final String selectionPreviousWordAction = "selection-previous-word";
    public static final String selectionNextWordAction = "selection-next-word";
    public static final String beginLineAction = "caret-begin-line";
    public static final String endLineAction = "caret-end-line";
    public static final String selectionBeginLineAction = "selection-begin-line";
    public static final String selectionEndLineAction = "selection-end-line";
    public static final String beginParagraphAction = "caret-begin-paragraph";
    public static final String endParagraphAction = "caret-end-paragraph";
    public static final String selectionBeginParagraphAction = "selection-begin-paragraph";
    public static final String selectionEndParagraphAction = "selection-end-paragraph";
    public static final String beginAction = "caret-begin";
    public static final String endAction = "caret-end";
    public static final String selectionBeginAction = "selection-begin";
    public static final String selectionEndAction = "selection-end";
    public static final String selectWordAction = "select-word";
    public static final String selectLineAction = "select-line";
    public static final String selectParagraphAction = "select-paragraph";
    public static final String selectAllAction = "select-all";
    static final String unselectAction = "unselect";
    static final String toggleComponentOrientationAction = "toggle-componentOrientation";
    public static final String defaultKeyTypedAction = "default-typed";
    private static final Action[] defaultActions = new Action[]{new InsertContentAction(), new DeletePrevCharAction(), new DeleteNextCharAction(), new ReadOnlyAction(), new DeleteWordAction("delete-previous-word"), new DeleteWordAction("delete-next-word"), new WritableAction(), new CutAction(), new CopyAction(), new PasteAction(), new VerticalPageAction("page-up", -1, false), new VerticalPageAction("page-down", 1, false), new VerticalPageAction("selection-page-up", -1, true), new VerticalPageAction("selection-page-down", 1, true), new PageAction("selection-page-left", true, true), new PageAction("selection-page-right", false, true), new InsertBreakAction(), new BeepAction(), new NextVisualPositionAction("caret-forward", false, 3), new NextVisualPositionAction("caret-backward", false, 7), new NextVisualPositionAction("selection-forward", true, 3), new NextVisualPositionAction("selection-backward", true, 7), new NextVisualPositionAction("caret-up", false, 1), new NextVisualPositionAction("caret-down", false, 5), new NextVisualPositionAction("selection-up", true, 1), new NextVisualPositionAction("selection-down", true, 5), new BeginWordAction("caret-begin-word", false), new EndWordAction("caret-end-word", false), new BeginWordAction("selection-begin-word", true), new EndWordAction("selection-end-word", true), new PreviousWordAction("caret-previous-word", false), new NextWordAction("caret-next-word", false), new PreviousWordAction("selection-previous-word", true), new NextWordAction("selection-next-word", true), new BeginLineAction("caret-begin-line", false), new EndLineAction("caret-end-line", false), new BeginLineAction("selection-begin-line", true), new EndLineAction("selection-end-line", true), new BeginParagraphAction("caret-begin-paragraph", false), new EndParagraphAction("caret-end-paragraph", false), new BeginParagraphAction("selection-begin-paragraph", true), new EndParagraphAction("selection-end-paragraph", true), new BeginAction("caret-begin", false), new EndAction("caret-end", false), new BeginAction("selection-begin", true), new EndAction("selection-end", true), new DefaultKeyTypedAction(), new InsertTabAction(), new SelectWordAction(), new SelectLineAction(), new SelectParagraphAction(), new SelectAllAction(), new UnselectAction(), new ToggleComponentOrientationAction(), new DumpModelAction()};

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public ViewFactory getViewFactory() {
        return null;
    }

    @Override
    public Action[] getActions() {
        return defaultActions;
    }

    @Override
    public Caret createCaret() {
        return null;
    }

    @Override
    public Document createDefaultDocument() {
        return new PlainDocument();
    }

    @Override
    public void read(InputStream inputStream, Document document, int n) throws IOException, BadLocationException {
        this.read(new InputStreamReader(inputStream), document, n);
    }

    @Override
    public void write(OutputStream outputStream, Document document, int n, int n2) throws IOException, BadLocationException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        this.write(outputStreamWriter, document, n, n2);
        outputStreamWriter.flush();
    }

    MutableAttributeSet getInputAttributes() {
        return null;
    }

    @Override
    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        int n2;
        char[] cArray = new char[4096];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = document.getLength() == 0;
        MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
        while ((n2 = reader.read(cArray, 0, cArray.length)) != -1) {
            int n3 = 0;
            block5: for (int i = 0; i < n2; ++i) {
                switch (cArray[i]) {
                    case '\r': {
                        if (bl) {
                            bl3 = true;
                            if (i == 0) {
                                document.insertString(n, "\n", mutableAttributeSet);
                                ++n;
                                continue block5;
                            }
                            cArray[i - 1] = 10;
                            continue block5;
                        }
                        bl = true;
                        continue block5;
                    }
                    case '\n': {
                        if (!bl) continue block5;
                        if (i > n3 + 1) {
                            document.insertString(n, new String(cArray, n3, i - n3 - 1), mutableAttributeSet);
                            n += i - n3 - 1;
                        }
                        bl = false;
                        n3 = i;
                        bl2 = true;
                        continue block5;
                    }
                    default: {
                        if (!bl) continue block5;
                        bl3 = true;
                        if (i == 0) {
                            document.insertString(n, "\n", mutableAttributeSet);
                            ++n;
                        } else {
                            cArray[i - 1] = 10;
                        }
                        bl = false;
                    }
                }
            }
            if (n3 >= n2) continue;
            if (bl) {
                if (n3 >= n2 - 1) continue;
                document.insertString(n, new String(cArray, n3, n2 - n3 - 1), mutableAttributeSet);
                n += n2 - n3 - 1;
                continue;
            }
            document.insertString(n, new String(cArray, n3, n2 - n3), mutableAttributeSet);
            n += n2 - n3;
        }
        if (bl) {
            document.insertString(n, "\n", mutableAttributeSet);
            bl3 = true;
        }
        if (bl4) {
            if (bl2) {
                document.putProperty(EndOfLineStringProperty, "\r\n");
            } else if (bl3) {
                document.putProperty(EndOfLineStringProperty, "\r");
            } else {
                document.putProperty(EndOfLineStringProperty, "\n");
            }
        }
    }

    @Override
    public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
        if (n < 0 || n + n2 > document.getLength()) {
            throw new BadLocationException("DefaultEditorKit.write", n);
        }
        Segment segment = new Segment();
        int n3 = n2;
        int n4 = n;
        Object object = document.getProperty(EndOfLineStringProperty);
        if (object == null) {
            try {
                object = System.getProperty("line.separator");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        String string = object instanceof String ? (String)object : null;
        if (object != null && !string.equals("\n")) {
            while (n3 > 0) {
                int n5 = Math.min(n3, 4096);
                document.getText(n4, n5, segment);
                int n6 = segment.offset;
                char[] cArray = segment.array;
                int n7 = n6 + segment.count;
                for (int i = n6; i < n7; ++i) {
                    if (cArray[i] != '\n') continue;
                    if (i > n6) {
                        writer.write(cArray, n6, i - n6);
                    }
                    writer.write(string);
                    n6 = i + 1;
                }
                if (n7 > n6) {
                    writer.write(cArray, n6, n7 - n6);
                }
                n4 += n5;
                n3 -= n5;
            }
        } else {
            while (n3 > 0) {
                int n8 = Math.min(n3, 4096);
                document.getText(n4, n8, segment);
                writer.write(segment.array, segment.offset, segment.count);
                n4 += n8;
                n3 -= n8;
            }
        }
        writer.flush();
    }

    static class ToggleComponentOrientationAction
    extends TextAction {
        ToggleComponentOrientationAction() {
            super(DefaultEditorKit.toggleComponentOrientationAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                ComponentOrientation componentOrientation = jTextComponent.getComponentOrientation();
                ComponentOrientation componentOrientation2 = componentOrientation == ComponentOrientation.RIGHT_TO_LEFT ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT;
                jTextComponent.setComponentOrientation(componentOrientation2);
                jTextComponent.repaint();
            }
        }
    }

    static class UnselectAction
    extends TextAction {
        UnselectAction() {
            super(DefaultEditorKit.unselectAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.setCaretPosition(jTextComponent.getCaretPosition());
            }
        }
    }

    static class SelectAllAction
    extends TextAction {
        SelectAllAction() {
            super(DefaultEditorKit.selectAllAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Document document = jTextComponent.getDocument();
                jTextComponent.setCaretPosition(0);
                jTextComponent.moveCaretPosition(document.getLength());
            }
        }
    }

    static class SelectParagraphAction
    extends TextAction {
        private Action start = new BeginParagraphAction("pigdog", false);
        private Action end = new EndParagraphAction("pigdog", true);

        SelectParagraphAction() {
            super(DefaultEditorKit.selectParagraphAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.start.actionPerformed(actionEvent);
            this.end.actionPerformed(actionEvent);
        }
    }

    static class SelectLineAction
    extends TextAction {
        private Action start = new BeginLineAction("pigdog", false);
        private Action end = new EndLineAction("pigdog", true);

        SelectLineAction() {
            super(DefaultEditorKit.selectLineAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.start.actionPerformed(actionEvent);
            this.end.actionPerformed(actionEvent);
        }
    }

    static class SelectWordAction
    extends TextAction {
        private Action start = new BeginWordAction("pigdog", false);
        private Action end = new EndWordAction("pigdog", true);

        SelectWordAction() {
            super(DefaultEditorKit.selectWordAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.start.actionPerformed(actionEvent);
            this.end.actionPerformed(actionEvent);
        }
    }

    static class EndAction
    extends TextAction {
        private boolean select;

        EndAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Document document = jTextComponent.getDocument();
                int n = document.getLength();
                if (this.select) {
                    jTextComponent.moveCaretPosition(n);
                } else {
                    jTextComponent.setCaretPosition(n);
                }
            }
        }
    }

    static class BeginAction
    extends TextAction {
        private boolean select;

        BeginAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                if (this.select) {
                    jTextComponent.moveCaretPosition(0);
                } else {
                    jTextComponent.setCaretPosition(0);
                }
            }
        }
    }

    static class EndParagraphAction
    extends TextAction {
        private boolean select;

        EndParagraphAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getCaretPosition();
                Element element = Utilities.getParagraphElement(jTextComponent, n);
                n = Math.min(jTextComponent.getDocument().getLength(), element.getEndOffset());
                if (this.select) {
                    jTextComponent.moveCaretPosition(n);
                } else {
                    jTextComponent.setCaretPosition(n);
                }
            }
        }
    }

    static class BeginParagraphAction
    extends TextAction {
        private boolean select;

        BeginParagraphAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getCaretPosition();
                Element element = Utilities.getParagraphElement(jTextComponent, n);
                n = element.getStartOffset();
                if (this.select) {
                    jTextComponent.moveCaretPosition(n);
                } else {
                    jTextComponent.setCaretPosition(n);
                }
            }
        }
    }

    static class EndLineAction
    extends TextAction {
        private boolean select;

        EndLineAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getRowEnd(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                    } else {
                        jTextComponent.setCaretPosition(n2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    static class BeginLineAction
    extends TextAction {
        private boolean select;

        BeginLineAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getRowStart(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                    } else {
                        jTextComponent.setCaretPosition(n2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    static class NextWordAction
    extends TextAction {
        private boolean select;

        NextWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getCaretPosition();
                boolean bl = false;
                int n2 = n;
                Element element = Utilities.getParagraphElement(jTextComponent, n);
                try {
                    n = Utilities.getNextWord(jTextComponent, n);
                    if (n >= element.getEndOffset() && n2 != element.getEndOffset() - 1) {
                        n = element.getEndOffset() - 1;
                    }
                }
                catch (BadLocationException badLocationException) {
                    int n3 = jTextComponent.getDocument().getLength();
                    if (n != n3) {
                        n = n2 != element.getEndOffset() - 1 ? element.getEndOffset() - 1 : n3;
                    }
                    bl = true;
                }
                if (!bl) {
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n);
                    } else {
                        jTextComponent.setCaretPosition(n);
                    }
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    static class PreviousWordAction
    extends TextAction {
        private boolean select;

        PreviousWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getCaretPosition();
                boolean bl = false;
                try {
                    Element element = Utilities.getParagraphElement(jTextComponent, n);
                    n = Utilities.getPreviousWord(jTextComponent, n);
                    if (n < element.getStartOffset()) {
                        n = Utilities.getParagraphElement(jTextComponent, n).getEndOffset() - 1;
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (n != 0) {
                        n = 0;
                    }
                    bl = true;
                }
                if (!bl) {
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n);
                    } else {
                        jTextComponent.setCaretPosition(n);
                    }
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    static class EndWordAction
    extends TextAction {
        private boolean select;

        EndWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getWordEnd(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                    } else {
                        jTextComponent.setCaretPosition(n2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    static class BeginWordAction
    extends TextAction {
        private boolean select;

        BeginWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getWordStart(jTextComponent, n);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                    } else {
                        jTextComponent.setCaretPosition(n2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    static class NextVisualPositionAction
    extends TextAction {
        private boolean select;
        private int direction;

        NextVisualPositionAction(String string, boolean bl, int n) {
            super(string);
            this.select = bl;
            this.direction = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                DefaultCaret defaultCaret = caret instanceof DefaultCaret ? (DefaultCaret)caret : null;
                int n = caret.getDot();
                Position.Bias[] biasArray = new Position.Bias[1];
                Point point = caret.getMagicCaretPosition();
                try {
                    Object object;
                    if (point == null && (this.direction == 1 || this.direction == 5)) {
                        object = defaultCaret != null ? jTextComponent.getUI().modelToView(jTextComponent, n, defaultCaret.getDotBias()) : jTextComponent.modelToView(n);
                        point = new Point(((Rectangle)object).x, ((Rectangle)object).y);
                    }
                    n = (object = jTextComponent.getNavigationFilter()) != null ? ((NavigationFilter)object).getNextVisualPositionFrom(jTextComponent, n, defaultCaret != null ? defaultCaret.getDotBias() : Position.Bias.Forward, this.direction, biasArray) : jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n, defaultCaret != null ? defaultCaret.getDotBias() : Position.Bias.Forward, this.direction, biasArray);
                    if (biasArray[0] == null) {
                        biasArray[0] = Position.Bias.Forward;
                    }
                    if (defaultCaret != null) {
                        if (this.select) {
                            defaultCaret.moveDot(n, biasArray[0]);
                        } else {
                            defaultCaret.setDot(n, biasArray[0]);
                        }
                    } else if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                    if (point != null && (this.direction == 1 || this.direction == 5)) {
                        jTextComponent.getCaret().setMagicCaretPosition(point);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static class DumpModelAction
    extends TextAction {
        DumpModelAction() {
            super("dump-model");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Document document;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && (document = jTextComponent.getDocument()) instanceof AbstractDocument) {
                ((AbstractDocument)document).dump(System.err);
            }
        }
    }

    static class PageAction
    extends TextAction {
        private boolean select;
        private boolean left;

        public PageAction(String string, boolean bl, boolean bl2) {
            super(string);
            this.select = bl2;
            this.left = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Rectangle rectangle = new Rectangle();
                jTextComponent.computeVisibleRect(rectangle);
                rectangle.x = this.left ? Math.max(0, rectangle.x - rectangle.width) : (rectangle.x += rectangle.width);
                int n = jTextComponent.getCaretPosition();
                if (n != -1) {
                    n = this.left ? jTextComponent.viewToModel(new Point(rectangle.x, rectangle.y)) : jTextComponent.viewToModel(new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1));
                    Document document = jTextComponent.getDocument();
                    if (n != 0 && n > document.getLength() - 1) {
                        n = document.getLength() - 1;
                    } else if (n < 0) {
                        n = 0;
                    }
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n);
                    } else {
                        jTextComponent.setCaretPosition(n);
                    }
                }
            }
        }
    }

    static class VerticalPageAction
    extends TextAction {
        private boolean select;
        private int direction;

        public VerticalPageAction(String string, int n, boolean bl) {
            super(string);
            this.select = bl;
            this.direction = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Point point;
                Caret caret;
                Rectangle rectangle;
                block8: {
                    Rectangle rectangle2 = jTextComponent.getVisibleRect();
                    rectangle = new Rectangle(rectangle2);
                    int n = jTextComponent.getCaretPosition();
                    int n2 = this.direction * jTextComponent.getScrollableBlockIncrement(rectangle2, 1, this.direction);
                    int n3 = rectangle2.y;
                    caret = jTextComponent.getCaret();
                    point = caret.getMagicCaretPosition();
                    if (n != -1) {
                        try {
                            Rectangle rectangle3 = jTextComponent.modelToView(n);
                            int n4 = point != null ? point.x : rectangle3.x;
                            int n5 = rectangle3.height;
                            if (n5 > 0) {
                                n2 = n2 / n5 * n5;
                            }
                            rectangle.y = this.constrainY(jTextComponent, n3 + n2, rectangle2.height);
                            int n6 = rectangle2.contains(rectangle3.x, rectangle3.y) ? jTextComponent.viewToModel(new Point(n4, this.constrainY(jTextComponent, rectangle3.y + n2, 0))) : (this.direction == -1 ? jTextComponent.viewToModel(new Point(n4, rectangle.y)) : jTextComponent.viewToModel(new Point(n4, rectangle.y + rectangle2.height)));
                            if ((n6 = this.constrainOffset(jTextComponent, n6)) == n) break block8;
                            int n7 = this.getAdjustedY(jTextComponent, rectangle, n6);
                            if ((this.direction != -1 || n7 > n3) && (this.direction != 1 || n7 < n3)) break block8;
                            rectangle.y = n7;
                            if (this.select) {
                                jTextComponent.moveCaretPosition(n6);
                                break block8;
                            }
                            jTextComponent.setCaretPosition(n6);
                        }
                        catch (BadLocationException badLocationException) {}
                    } else {
                        rectangle.y = this.constrainY(jTextComponent, n3 + n2, rectangle2.height);
                    }
                }
                if (point != null) {
                    caret.setMagicCaretPosition(point);
                }
                jTextComponent.scrollRectToVisible(rectangle);
            }
        }

        private int constrainY(JTextComponent jTextComponent, int n, int n2) {
            if (n < 0) {
                n = 0;
            } else if (n + n2 > jTextComponent.getHeight()) {
                n = Math.max(0, jTextComponent.getHeight() - n2);
            }
            return n;
        }

        private int constrainOffset(JTextComponent jTextComponent, int n) {
            Document document = jTextComponent.getDocument();
            if (n != 0 && n > document.getLength()) {
                n = document.getLength();
            }
            if (n < 0) {
                n = 0;
            }
            return n;
        }

        private int getAdjustedY(JTextComponent jTextComponent, Rectangle rectangle, int n) {
            int n2 = rectangle.y;
            try {
                Rectangle rectangle2 = jTextComponent.modelToView(n);
                if (rectangle2.y < rectangle.y) {
                    n2 = rectangle2.y;
                } else if (rectangle2.y > rectangle.y + rectangle.height || rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                    n2 = rectangle2.y + rectangle2.height - rectangle.height;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return n2;
        }
    }

    public static class BeepAction
    extends TextAction {
        public BeepAction() {
            super(DefaultEditorKit.beepAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
        }
    }

    public static class PasteAction
    extends TextAction {
        public PasteAction() {
            super(DefaultEditorKit.pasteAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.paste();
            }
        }
    }

    public static class CopyAction
    extends TextAction {
        public CopyAction() {
            super(DefaultEditorKit.copyAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.copy();
            }
        }
    }

    public static class CutAction
    extends TextAction {
        public CutAction() {
            super(DefaultEditorKit.cutAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.cut();
            }
        }
    }

    static class WritableAction
    extends TextAction {
        WritableAction() {
            super(DefaultEditorKit.writableAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.setEditable(true);
            }
        }
    }

    static class ReadOnlyAction
    extends TextAction {
        ReadOnlyAction() {
            super(DefaultEditorKit.readOnlyAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.setEditable(false);
            }
        }
    }

    static class DeleteWordAction
    extends TextAction {
        DeleteWordAction(String string) {
            super(string);
            assert (string == DefaultEditorKit.deletePrevWordAction || string == DefaultEditorKit.deleteNextWordAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && actionEvent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                    return;
                }
                boolean bl = true;
                try {
                    int n;
                    int n2;
                    int n3 = jTextComponent.getSelectionStart();
                    Element element = Utilities.getParagraphElement(jTextComponent, n3);
                    if (DefaultEditorKit.deleteNextWordAction == this.getValue("Name")) {
                        n2 = Utilities.getNextWordInParagraph(jTextComponent, element, n3, false);
                        if (n2 == -1) {
                            n = element.getEndOffset();
                            n2 = n3 == n - 1 ? n : n - 1;
                        }
                    } else {
                        n2 = Utilities.getPrevWordInParagraph(jTextComponent, element, n3);
                        if (n2 == -1) {
                            n = element.getStartOffset();
                            n2 = n3 == n ? n - 1 : n;
                        }
                    }
                    n = Math.min(n3, n2);
                    int n4 = Math.abs(n2 - n3);
                    if (n >= 0) {
                        jTextComponent.getDocument().remove(n, n4);
                        bl = false;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (bl) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    static class DeleteNextCharAction
    extends TextAction {
        DeleteNextCharAction() {
            super(DefaultEditorKit.deleteNextCharAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            boolean bl = true;
            if (jTextComponent != null && jTextComponent.isEditable()) {
                try {
                    Document document = jTextComponent.getDocument();
                    Caret caret = jTextComponent.getCaret();
                    int n = caret.getDot();
                    int n2 = caret.getMark();
                    if (n != n2) {
                        document.remove(Math.min(n, n2), Math.abs(n - n2));
                        bl = false;
                    } else if (n < document.getLength()) {
                        int n3 = 1;
                        if (n < document.getLength() - 1) {
                            String string = document.getText(n, 2);
                            char c = string.charAt(0);
                            char c2 = string.charAt(1);
                            if (c >= '\ud800' && c <= '\udbff' && c2 >= '\udc00' && c2 <= '\udfff') {
                                n3 = 2;
                            }
                        }
                        document.remove(n, n3);
                        bl = false;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (bl) {
                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
            }
        }
    }

    static class DeletePrevCharAction
    extends TextAction {
        DeletePrevCharAction() {
            super(DefaultEditorKit.deletePrevCharAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            boolean bl = true;
            if (jTextComponent != null && jTextComponent.isEditable()) {
                try {
                    Document document = jTextComponent.getDocument();
                    Caret caret = jTextComponent.getCaret();
                    int n = caret.getDot();
                    int n2 = caret.getMark();
                    if (n != n2) {
                        document.remove(Math.min(n, n2), Math.abs(n - n2));
                        bl = false;
                    } else if (n > 0) {
                        int n3 = 1;
                        if (n > 1) {
                            String string = document.getText(n - 2, 2);
                            char c = string.charAt(0);
                            char c2 = string.charAt(1);
                            if (c >= '\ud800' && c <= '\udbff' && c2 >= '\udc00' && c2 <= '\udfff') {
                                n3 = 2;
                            }
                        }
                        document.remove(n - n3, n3);
                        bl = false;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (bl) {
                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
            }
        }
    }

    public static class InsertTabAction
    extends TextAction {
        public InsertTabAction() {
            super(DefaultEditorKit.insertTabAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                    return;
                }
                jTextComponent.replaceSelection("\t");
            }
        }
    }

    public static class InsertBreakAction
    extends TextAction {
        public InsertBreakAction() {
            super(DefaultEditorKit.insertBreakAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                    return;
                }
                jTextComponent.replaceSelection("\n");
            }
        }
    }

    public static class InsertContentAction
    extends TextAction {
        public InsertContentAction() {
            super(DefaultEditorKit.insertContentAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && actionEvent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                    return;
                }
                String string = actionEvent.getActionCommand();
                if (string != null) {
                    jTextComponent.replaceSelection(string);
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    public static class DefaultKeyTypedAction
    extends TextAction {
        public DefaultKeyTypedAction() {
            super(DefaultEditorKit.defaultKeyTypedAction);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && actionEvent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    return;
                }
                String string = actionEvent.getActionCommand();
                int n = actionEvent.getModifiers();
                if (string != null && string.length() > 0) {
                    char c;
                    boolean bl = true;
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    if (toolkit instanceof SunToolkit) {
                        bl = ((SunToolkit)toolkit).isPrintableCharacterModifiersMask(n);
                    }
                    if (bl && (c = string.charAt(0)) >= ' ' && c != '\u007f') {
                        jTextComponent.replaceSelection(string);
                    }
                }
            }
        }
    }
}

