/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.Debug;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;

final class ServerNameExtension
extends HelloExtension {
    static final int NAME_HEADER_LENGTH = 3;
    private Map<Integer, SNIServerName> sniMap;
    private int listLength;

    ServerNameExtension() throws IOException {
        super(ExtensionType.EXT_SERVER_NAME);
        this.listLength = 0;
        this.sniMap = Collections.emptyMap();
    }

    ServerNameExtension(List<SNIServerName> list) throws IOException {
        super(ExtensionType.EXT_SERVER_NAME);
        this.listLength = 0;
        this.sniMap = new LinkedHashMap<Integer, SNIServerName>();
        for (SNIServerName sNIServerName : list) {
            if (this.sniMap.put(sNIServerName.getType(), sNIServerName) != null) {
                throw new RuntimeException("Duplicated server name of type " + sNIServerName.getType());
            }
            this.listLength += sNIServerName.getEncoded().length + 3;
        }
        if (this.listLength == 0) {
            throw new RuntimeException("The ServerNameList cannot be empty");
        }
    }

    ServerNameExtension(HandshakeInStream handshakeInStream, int n) throws IOException {
        super(ExtensionType.EXT_SERVER_NAME);
        int n2 = n;
        if (n >= 2) {
            this.listLength = handshakeInStream.getInt16();
            if (this.listLength == 0 || this.listLength + 2 != n) {
                throw new SSLProtocolException("Invalid " + this.type + " extension");
            }
            n2 -= 2;
            this.sniMap = new LinkedHashMap<Integer, SNIServerName>();
            while (n2 > 0) {
                SNIServerName sNIServerName;
                int n3 = handshakeInStream.getInt8();
                byte[] byArray = handshakeInStream.getBytes16();
                switch (n3) {
                    case 0: {
                        if (byArray.length == 0) {
                            throw new SSLProtocolException("Empty HostName in server name indication");
                        }
                        try {
                            sNIServerName = new SNIHostName(byArray);
                            break;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            SSLProtocolException sSLProtocolException = new SSLProtocolException("Illegal server name, type=host_name(" + n3 + "), name=" + new String(byArray, StandardCharsets.UTF_8) + ", value=" + Debug.toString(byArray));
                            sSLProtocolException.initCause(illegalArgumentException);
                            throw sSLProtocolException;
                        }
                    }
                    default: {
                        try {
                            sNIServerName = new UnknownServerName(n3, byArray);
                            break;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            SSLProtocolException sSLProtocolException = new SSLProtocolException("Illegal server name, type=(" + n3 + "), value=" + Debug.toString(byArray));
                            sSLProtocolException.initCause(illegalArgumentException);
                            throw sSLProtocolException;
                        }
                    }
                }
                if (this.sniMap.put(sNIServerName.getType(), sNIServerName) != null) {
                    throw new SSLProtocolException("Duplicated server name of type " + sNIServerName.getType());
                }
                n2 -= byArray.length + 3;
            }
        } else if (n == 0) {
            this.listLength = 0;
            this.sniMap = Collections.emptyMap();
        }
        if (n2 != 0) {
            throw new SSLProtocolException("Invalid server_name extension");
        }
    }

    List<SNIServerName> getServerNames() {
        if (this.sniMap != null && !this.sniMap.isEmpty()) {
            return Collections.unmodifiableList(new ArrayList<SNIServerName>(this.sniMap.values()));
        }
        return Collections.emptyList();
    }

    boolean isMatched(Collection<SNIMatcher> collection) {
        if (this.sniMap != null && !this.sniMap.isEmpty()) {
            for (SNIMatcher sNIMatcher : collection) {
                SNIServerName sNIServerName = this.sniMap.get(sNIMatcher.getType());
                if (sNIServerName == null || sNIMatcher.matches(sNIServerName)) continue;
                return false;
            }
        }
        return true;
    }

    boolean isIdentical(List<SNIServerName> list) {
        if (list.size() == this.sniMap.size()) {
            for (SNIServerName sNIServerName : list) {
                SNIServerName sNIServerName2 = this.sniMap.get(sNIServerName.getType());
                if (sNIServerName2 != null && sNIServerName.equals(sNIServerName2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    int length() {
        return this.listLength == 0 ? 4 : 6 + this.listLength;
    }

    @Override
    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putInt16(this.type.id);
        if (this.listLength == 0) {
            handshakeOutStream.putInt16(this.listLength);
        } else {
            handshakeOutStream.putInt16(this.listLength + 2);
            handshakeOutStream.putInt16(this.listLength);
            for (SNIServerName sNIServerName : this.sniMap.values()) {
                handshakeOutStream.putInt8(sNIServerName.getType());
                handshakeOutStream.putBytes16(sNIServerName.getEncoded());
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (SNIServerName sNIServerName : this.sniMap.values()) {
            stringBuffer.append("[" + sNIServerName + "]");
        }
        return "Extension " + this.type + ", server_name: " + stringBuffer;
    }

    private static class UnknownServerName
    extends SNIServerName {
        UnknownServerName(int n, byte[] byArray) {
            super(n, byArray);
        }
    }
}

