/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XChar2b;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XTextItem16
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 16 : 24;
    }

    @Override
    public int getDataSize() {
        return XTextItem16.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XTextItem16(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XTextItem16() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XTextItem16.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public XChar2b get_chars(int n) {
        log.finest("");
        return Native.getLong(this.pData + 0L) != 0L ? new XChar2b(Native.getLong(this.pData + 0L) + (long)(n * 2)) : null;
    }

    public long get_chars() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_chars(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public int get_nchars() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_nchars(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), n);
    }

    public int get_delta() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 12));
    }

    public void set_delta(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 12), n);
    }

    public long get_font() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 16));
    }

    public void set_font(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 16), l);
    }

    @Override
    String getName() {
        return "XTextItem16";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(160);
        stringBuilder.append("chars = ").append(this.get_chars()).append(", ");
        stringBuilder.append("nchars = ").append(this.get_nchars()).append(", ");
        stringBuilder.append("delta = ").append(this.get_delta()).append(", ");
        stringBuilder.append("font = ").append(this.get_font()).append(", ");
        return stringBuilder.toString();
    }
}

