/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateImpl;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.HijrahChronology;
import java.time.chrono.HijrahEra;
import java.time.chrono.Ser;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;

public final class HijrahDate
extends ChronoLocalDateImpl<HijrahDate>
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = -5207853542612002020L;
    private final transient HijrahChronology chrono;
    private final transient int prolepticYear;
    private final transient int monthOfYear;
    private final transient int dayOfMonth;

    static HijrahDate of(HijrahChronology hijrahChronology, int n, int n2, int n3) {
        return new HijrahDate(hijrahChronology, n, n2, n3);
    }

    static HijrahDate ofEpochDay(HijrahChronology hijrahChronology, long l) {
        return new HijrahDate(hijrahChronology, l);
    }

    public static HijrahDate now() {
        return HijrahDate.now(Clock.systemDefaultZone());
    }

    public static HijrahDate now(ZoneId zoneId) {
        return HijrahDate.now(Clock.system(zoneId));
    }

    public static HijrahDate now(Clock clock) {
        return HijrahDate.ofEpochDay(HijrahChronology.INSTANCE, LocalDate.now(clock).toEpochDay());
    }

    public static HijrahDate of(int n, int n2, int n3) {
        return HijrahChronology.INSTANCE.date(n, n2, n3);
    }

    public static HijrahDate from(TemporalAccessor temporalAccessor) {
        return HijrahChronology.INSTANCE.date(temporalAccessor);
    }

    private HijrahDate(HijrahChronology hijrahChronology, int n, int n2, int n3) {
        hijrahChronology.getEpochDay(n, n2, n3);
        this.chrono = hijrahChronology;
        this.prolepticYear = n;
        this.monthOfYear = n2;
        this.dayOfMonth = n3;
    }

    private HijrahDate(HijrahChronology hijrahChronology, long l) {
        int[] nArray = hijrahChronology.getHijrahDateInfo((int)l);
        this.chrono = hijrahChronology;
        this.prolepticYear = nArray[0];
        this.monthOfYear = nArray[1];
        this.dayOfMonth = nArray[2];
    }

    @Override
    public HijrahChronology getChronology() {
        return this.chrono;
    }

    @Override
    public HijrahEra getEra() {
        return HijrahEra.AH;
    }

    @Override
    public int lengthOfMonth() {
        return this.chrono.getMonthLength(this.prolepticYear, this.monthOfYear);
    }

    @Override
    public int lengthOfYear() {
        return this.chrono.getYearLength(this.prolepticYear);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (this.isSupported(temporalField)) {
                ChronoField chronoField = (ChronoField)temporalField;
                switch (chronoField) {
                    case DAY_OF_MONTH: {
                        return ValueRange.of(1L, this.lengthOfMonth());
                    }
                    case DAY_OF_YEAR: {
                        return ValueRange.of(1L, this.lengthOfYear());
                    }
                    case ALIGNED_WEEK_OF_MONTH: {
                        return ValueRange.of(1L, 5L);
                    }
                }
                return this.getChronology().range(chronoField);
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case DAY_OF_WEEK: {
                    return this.getDayOfWeek();
                }
                case ALIGNED_DAY_OF_WEEK_IN_MONTH: {
                    return (this.getDayOfWeek() - 1) % 7 + 1;
                }
                case ALIGNED_DAY_OF_WEEK_IN_YEAR: {
                    return (this.getDayOfYear() - 1) % 7 + 1;
                }
                case DAY_OF_MONTH: {
                    return this.dayOfMonth;
                }
                case DAY_OF_YEAR: {
                    return this.getDayOfYear();
                }
                case EPOCH_DAY: {
                    return this.toEpochDay();
                }
                case ALIGNED_WEEK_OF_MONTH: {
                    return (this.dayOfMonth - 1) / 7 + 1;
                }
                case ALIGNED_WEEK_OF_YEAR: {
                    return (this.getDayOfYear() - 1) / 7 + 1;
                }
                case MONTH_OF_YEAR: {
                    return this.monthOfYear;
                }
                case PROLEPTIC_MONTH: {
                    return this.getProlepticMonth();
                }
                case YEAR_OF_ERA: {
                    return this.prolepticYear;
                }
                case YEAR: {
                    return this.prolepticYear;
                }
                case ERA: {
                    return this.getEraValue();
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.getFrom(this);
    }

    private long getProlepticMonth() {
        return (long)this.prolepticYear * 12L + (long)this.monthOfYear - 1L;
    }

    @Override
    public HijrahDate with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            this.chrono.range(chronoField).checkValidValue(l, chronoField);
            int n = (int)l;
            switch (chronoField) {
                case DAY_OF_WEEK: {
                    return this.plusDays(l - (long)this.getDayOfWeek());
                }
                case ALIGNED_DAY_OF_WEEK_IN_MONTH: {
                    return this.plusDays(l - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH));
                }
                case ALIGNED_DAY_OF_WEEK_IN_YEAR: {
                    return this.plusDays(l - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR));
                }
                case DAY_OF_MONTH: {
                    return this.resolvePreviousValid(this.prolepticYear, this.monthOfYear, n);
                }
                case DAY_OF_YEAR: {
                    return this.plusDays(Math.min(n, this.lengthOfYear()) - this.getDayOfYear());
                }
                case EPOCH_DAY: {
                    return new HijrahDate(this.chrono, l);
                }
                case ALIGNED_WEEK_OF_MONTH: {
                    return this.plusDays((l - this.getLong(ChronoField.ALIGNED_WEEK_OF_MONTH)) * 7L);
                }
                case ALIGNED_WEEK_OF_YEAR: {
                    return this.plusDays((l - this.getLong(ChronoField.ALIGNED_WEEK_OF_YEAR)) * 7L);
                }
                case MONTH_OF_YEAR: {
                    return this.resolvePreviousValid(this.prolepticYear, n, this.dayOfMonth);
                }
                case PROLEPTIC_MONTH: {
                    return this.plusMonths(l - this.getProlepticMonth());
                }
                case YEAR_OF_ERA: {
                    return this.resolvePreviousValid(this.prolepticYear >= 1 ? n : 1 - n, this.monthOfYear, this.dayOfMonth);
                }
                case YEAR: {
                    return this.resolvePreviousValid(n, this.monthOfYear, this.dayOfMonth);
                }
                case ERA: {
                    return this.resolvePreviousValid(1 - this.prolepticYear, this.monthOfYear, this.dayOfMonth);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return (HijrahDate)super.with(temporalField, l);
    }

    private HijrahDate resolvePreviousValid(int n, int n2, int n3) {
        int n4 = this.chrono.getMonthLength(n, n2);
        if (n3 > n4) {
            n3 = n4;
        }
        return HijrahDate.of(this.chrono, n, n2, n3);
    }

    @Override
    public HijrahDate with(TemporalAdjuster temporalAdjuster) {
        return (HijrahDate)super.with(temporalAdjuster);
    }

    public HijrahDate withVariant(HijrahChronology hijrahChronology) {
        if (this.chrono == hijrahChronology) {
            return this;
        }
        int n = hijrahChronology.getDayOfYear(this.prolepticYear, this.monthOfYear);
        return HijrahDate.of(hijrahChronology, this.prolepticYear, this.monthOfYear, this.dayOfMonth > n ? n : this.dayOfMonth);
    }

    @Override
    public HijrahDate plus(TemporalAmount temporalAmount) {
        return (HijrahDate)super.plus(temporalAmount);
    }

    @Override
    public HijrahDate minus(TemporalAmount temporalAmount) {
        return (HijrahDate)super.minus(temporalAmount);
    }

    @Override
    public long toEpochDay() {
        return this.chrono.getEpochDay(this.prolepticYear, this.monthOfYear, this.dayOfMonth);
    }

    private int getDayOfYear() {
        return this.chrono.getDayOfYear(this.prolepticYear, this.monthOfYear) + this.dayOfMonth;
    }

    private int getDayOfWeek() {
        int n = (int)Math.floorMod(this.toEpochDay() + 3L, 7L);
        return n + 1;
    }

    private int getEraValue() {
        return this.prolepticYear > 1 ? 1 : 0;
    }

    @Override
    public boolean isLeapYear() {
        return this.chrono.isLeapYear(this.prolepticYear);
    }

    @Override
    HijrahDate plusYears(long l) {
        if (l == 0L) {
            return this;
        }
        int n = Math.addExact(this.prolepticYear, (int)l);
        return this.resolvePreviousValid(n, this.monthOfYear, this.dayOfMonth);
    }

    @Override
    HijrahDate plusMonths(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = (long)this.prolepticYear * 12L + (long)(this.monthOfYear - 1);
        long l3 = l2 + l;
        int n = this.chrono.checkValidYear(Math.floorDiv(l3, 12L));
        int n2 = (int)Math.floorMod(l3, 12L) + 1;
        return this.resolvePreviousValid(n, n2, this.dayOfMonth);
    }

    @Override
    HijrahDate plusWeeks(long l) {
        return (HijrahDate)super.plusWeeks(l);
    }

    @Override
    HijrahDate plusDays(long l) {
        return new HijrahDate(this.chrono, this.toEpochDay() + l);
    }

    @Override
    public HijrahDate plus(long l, TemporalUnit temporalUnit) {
        return (HijrahDate)super.plus(l, temporalUnit);
    }

    @Override
    public HijrahDate minus(long l, TemporalUnit temporalUnit) {
        return (HijrahDate)super.minus(l, temporalUnit);
    }

    @Override
    HijrahDate minusYears(long l) {
        return (HijrahDate)super.minusYears(l);
    }

    @Override
    HijrahDate minusMonths(long l) {
        return (HijrahDate)super.minusMonths(l);
    }

    @Override
    HijrahDate minusWeeks(long l) {
        return (HijrahDate)super.minusWeeks(l);
    }

    @Override
    HijrahDate minusDays(long l) {
        return (HijrahDate)super.minusDays(l);
    }

    public final ChronoLocalDateTime<HijrahDate> atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate chronoLocalDate) {
        HijrahDate hijrahDate = this.getChronology().date(chronoLocalDate);
        long l = (hijrahDate.prolepticYear - this.prolepticYear) * 12 + (hijrahDate.monthOfYear - this.monthOfYear);
        int n = hijrahDate.dayOfMonth - this.dayOfMonth;
        if (l > 0L && n < 0) {
            HijrahDate hijrahDate2 = this.plusMonths(--l);
            n = (int)(hijrahDate.toEpochDay() - hijrahDate2.toEpochDay());
        } else if (l < 0L && n > 0) {
            ++l;
            n -= hijrahDate.lengthOfMonth();
        }
        long l2 = l / 12L;
        int n2 = (int)(l % 12L);
        return this.getChronology().period(Math.toIntExact(l2), n2, n);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HijrahDate) {
            HijrahDate hijrahDate = (HijrahDate)object;
            return this.prolepticYear == hijrahDate.prolepticYear && this.monthOfYear == hijrahDate.monthOfYear && this.dayOfMonth == hijrahDate.dayOfMonth && this.getChronology().equals(hijrahDate.getChronology());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = this.prolepticYear;
        int n2 = this.monthOfYear;
        int n3 = this.dayOfMonth;
        return this.getChronology().getId().hashCode() ^ n & 0xFFFFF800 ^ (n << 11) + (n2 << 6) + n3;
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(6, this);
    }

    void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getChronology());
        objectOutput.writeInt(this.get(ChronoField.YEAR));
        objectOutput.writeByte(this.get(ChronoField.MONTH_OF_YEAR));
        objectOutput.writeByte(this.get(ChronoField.DAY_OF_MONTH));
    }

    static HijrahDate readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        HijrahChronology hijrahChronology = (HijrahChronology)objectInput.readObject();
        int n = objectInput.readInt();
        byte by = objectInput.readByte();
        byte by2 = objectInput.readByte();
        return hijrahChronology.date(n, by, by2);
    }
}

