/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;

public abstract class Writer
implements Appendable,
Closeable,
Flushable {
    private char[] writeBuffer;
    private static final int WRITE_BUFFER_SIZE = 1024;
    protected Object lock;

    protected Writer() {
        this.lock = this;
    }

    protected Writer(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.lock = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.writeBuffer == null) {
                this.writeBuffer = new char[1024];
            }
            this.writeBuffer[0] = (char)n;
            this.write(this.writeBuffer, 0, 1);
        }
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public abstract void write(char[] var1, int var2, int var3) throws IOException;

    public void write(String string) throws IOException {
        this.write(string, 0, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char[] cArray;
            if (n2 <= 1024) {
                if (this.writeBuffer == null) {
                    this.writeBuffer = new char[1024];
                }
                cArray = this.writeBuffer;
            } else {
                cArray = new char[n2];
            }
            string.getChars(n, n + n2, cArray, 0);
            this.write(cArray, 0, n2);
        }
    }

    @Override
    public Writer append(CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            this.write("null");
        } else {
            this.write(charSequence.toString());
        }
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n, int n2) throws IOException {
        CharSequence charSequence2 = charSequence == null ? "null" : charSequence;
        this.write(charSequence2.subSequence(n, n2).toString());
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;
}

