/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.HashMap;
import java.util.Locale;

enum UnicodeProp {
    ALPHABETIC{

        @Override
        public boolean is(int n) {
            return Character.isAlphabetic(n);
        }
    }
    ,
    LETTER{

        @Override
        public boolean is(int n) {
            return Character.isLetter(n);
        }
    }
    ,
    IDEOGRAPHIC{

        @Override
        public boolean is(int n) {
            return Character.isIdeographic(n);
        }
    }
    ,
    LOWERCASE{

        @Override
        public boolean is(int n) {
            return Character.isLowerCase(n);
        }
    }
    ,
    UPPERCASE{

        @Override
        public boolean is(int n) {
            return Character.isUpperCase(n);
        }
    }
    ,
    TITLECASE{

        @Override
        public boolean is(int n) {
            return Character.isTitleCase(n);
        }
    }
    ,
    WHITE_SPACE{

        @Override
        public boolean is(int n) {
            return (28672 >> Character.getType(n) & 1) != 0 || n >= 9 && n <= 13 || n == 133;
        }
    }
    ,
    CONTROL{

        @Override
        public boolean is(int n) {
            return Character.getType(n) == 15;
        }
    }
    ,
    PUNCTUATION{

        @Override
        public boolean is(int n) {
            return (1643118592 >> Character.getType(n) & 1) != 0;
        }
    }
    ,
    HEX_DIGIT{

        @Override
        public boolean is(int n) {
            return DIGIT.is(n) || n >= 48 && n <= 57 || n >= 65 && n <= 70 || n >= 97 && n <= 102 || n >= 65296 && n <= 65305 || n >= 65313 && n <= 65318 || n >= 65345 && n <= 65350;
        }
    }
    ,
    ASSIGNED{

        @Override
        public boolean is(int n) {
            return Character.getType(n) != 0;
        }
    }
    ,
    NONCHARACTER_CODE_POINT{

        @Override
        public boolean is(int n) {
            return (n & 0xFFFE) == 65534 || n >= 64976 && n <= 65007;
        }
    }
    ,
    DIGIT{

        @Override
        public boolean is(int n) {
            return Character.isDigit(n);
        }
    }
    ,
    ALNUM{

        @Override
        public boolean is(int n) {
            return ALPHABETIC.is(n) || DIGIT.is(n);
        }
    }
    ,
    BLANK{

        @Override
        public boolean is(int n) {
            return Character.getType(n) == 12 || n == 9;
        }
    }
    ,
    GRAPH{

        @Override
        public boolean is(int n) {
            return (585729 >> Character.getType(n) & 1) == 0;
        }
    }
    ,
    PRINT{

        @Override
        public boolean is(int n) {
            return (GRAPH.is(n) || BLANK.is(n)) && !CONTROL.is(n);
        }
    }
    ,
    WORD{

        @Override
        public boolean is(int n) {
            return ALPHABETIC.is(n) || (8389568 >> Character.getType(n) & 1) != 0;
        }
    };

    private static final HashMap<String, String> posix;
    private static final HashMap<String, String> aliases;

    public static UnicodeProp forName(String string) {
        String string2 = aliases.get(string = string.toUpperCase(Locale.ENGLISH));
        if (string2 != null) {
            string = string2;
        }
        try {
            return UnicodeProp.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static UnicodeProp forPOSIXName(String string) {
        if ((string = posix.get(string.toUpperCase(Locale.ENGLISH))) == null) {
            return null;
        }
        return UnicodeProp.valueOf(string);
    }

    public abstract boolean is(int var1);

    static {
        posix = new HashMap();
        aliases = new HashMap();
        posix.put("ALPHA", "ALPHABETIC");
        posix.put("LOWER", "LOWERCASE");
        posix.put("UPPER", "UPPERCASE");
        posix.put("SPACE", "WHITE_SPACE");
        posix.put("PUNCT", "PUNCTUATION");
        posix.put("XDIGIT", "HEX_DIGIT");
        posix.put("ALNUM", "ALNUM");
        posix.put("CNTRL", "CONTROL");
        posix.put("DIGIT", "DIGIT");
        posix.put("BLANK", "BLANK");
        posix.put("GRAPH", "GRAPH");
        posix.put("PRINT", "PRINT");
        aliases.put("WHITESPACE", "WHITE_SPACE");
        aliases.put("HEXDIGIT", "HEX_DIGIT");
        aliases.put("NONCHARACTERCODEPOINT", "NONCHARACTER_CODE_POINT");
    }
}

