/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class LinkedHashMap<K, V>
extends HashMap<K, V>
implements Map<K, V> {
    private static final long serialVersionUID = 3801124242820219131L;
    transient Entry<K, V> head;
    transient Entry<K, V> tail;
    final boolean accessOrder;

    private void linkNodeLast(Entry<K, V> entry) {
        Entry<K, V> entry2 = this.tail;
        this.tail = entry;
        if (entry2 == null) {
            this.head = entry;
        } else {
            entry.before = entry2;
            entry2.after = entry;
        }
    }

    private void transferLinks(Entry<K, V> entry, Entry<K, V> entry2) {
        Entry entry3 = entry2.before = entry.before;
        Entry entry4 = entry2.after = entry.after;
        if (entry3 == null) {
            this.head = entry2;
        } else {
            entry3.after = entry2;
        }
        if (entry4 == null) {
            this.tail = entry2;
        } else {
            entry4.before = entry2;
        }
    }

    @Override
    void reinitialize() {
        super.reinitialize();
        this.tail = null;
        this.head = null;
    }

    @Override
    HashMap.Node<K, V> newNode(int n, K k, V v, HashMap.Node<K, V> node) {
        Entry<K, V> entry = new Entry<K, V>(n, k, v, node);
        this.linkNodeLast(entry);
        return entry;
    }

    @Override
    HashMap.Node<K, V> replacementNode(HashMap.Node<K, V> node, HashMap.Node<K, V> node2) {
        Entry entry = (Entry)node;
        Entry<Object, Object> entry2 = new Entry<Object, Object>(entry.hash, entry.key, entry.value, node2);
        this.transferLinks(entry, entry2);
        return entry2;
    }

    @Override
    HashMap.TreeNode<K, V> newTreeNode(int n, K k, V v, HashMap.Node<K, V> node) {
        HashMap.TreeNode<K, V> treeNode = new HashMap.TreeNode<K, V>(n, k, v, node);
        this.linkNodeLast(treeNode);
        return treeNode;
    }

    @Override
    HashMap.TreeNode<K, V> replacementTreeNode(HashMap.Node<K, V> node, HashMap.Node<K, V> node2) {
        Entry entry = (Entry)node;
        HashMap.TreeNode<Object, Object> treeNode = new HashMap.TreeNode<Object, Object>(entry.hash, entry.key, entry.value, node2);
        this.transferLinks(entry, treeNode);
        return treeNode;
    }

    @Override
    void afterNodeRemoval(HashMap.Node<K, V> node) {
        Entry entry = (Entry)node;
        Entry entry2 = entry.before;
        Entry entry3 = entry.after;
        entry.after = null;
        entry.before = null;
        if (entry2 == null) {
            this.head = entry3;
        } else {
            entry2.after = entry3;
        }
        if (entry3 == null) {
            this.tail = entry2;
        } else {
            entry3.before = entry2;
        }
    }

    @Override
    void afterNodeInsertion(boolean bl) {
        Entry<K, V> entry;
        if (bl && (entry = this.head) != null && this.removeEldestEntry(entry)) {
            Object object = entry.key;
            this.removeNode(LinkedHashMap.hash(object), object, null, false, true);
        }
    }

    @Override
    void afterNodeAccess(HashMap.Node<K, V> node) {
        Entry<K, V> entry;
        if (this.accessOrder && (entry = this.tail) != node) {
            Entry entry2 = (Entry)node;
            Entry entry3 = entry2.before;
            Entry entry4 = entry2.after;
            entry2.after = null;
            if (entry3 == null) {
                this.head = entry4;
            } else {
                entry3.after = entry4;
            }
            if (entry4 != null) {
                entry4.before = entry3;
            } else {
                entry = entry3;
            }
            if (entry == null) {
                this.head = entry2;
            } else {
                entry2.before = entry;
                entry.after = entry2;
            }
            this.tail = entry2;
            ++this.modCount;
        }
    }

    @Override
    void internalWriteEntries(ObjectOutputStream objectOutputStream) throws IOException {
        Entry<K, V> entry = this.head;
        while (entry != null) {
            objectOutputStream.writeObject(entry.key);
            objectOutputStream.writeObject(entry.value);
            entry = entry.after;
        }
    }

    public LinkedHashMap(int n, float f) {
        super(n, f);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n) {
        super(n);
        this.accessOrder = false;
    }

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(Map<? extends K, ? extends V> map) {
        this.accessOrder = false;
        this.putMapEntries(map, false);
    }

    public LinkedHashMap(int n, float f, boolean bl) {
        super(n, f);
        this.accessOrder = bl;
    }

    @Override
    public boolean containsValue(Object object) {
        Entry<K, V> entry = this.head;
        while (entry != null) {
            Object object2 = entry.value;
            if (object2 == object || object != null && object.equals(object2)) {
                return true;
            }
            entry = entry.after;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        HashMap.Node node = this.getNode(LinkedHashMap.hash(object), object);
        if (node == null) {
            return null;
        }
        if (this.accessOrder) {
            this.afterNodeAccess(node);
        }
        return node.value;
    }

    @Override
    public V getOrDefault(Object object, V v) {
        HashMap.Node node = this.getNode(LinkedHashMap.hash(object), object);
        if (node == null) {
            return v;
        }
        if (this.accessOrder) {
            this.afterNodeAccess(node);
        }
        return node.value;
    }

    @Override
    public void clear() {
        super.clear();
        this.tail = null;
        this.head = null;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return false;
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        return set == null ? (this.keySet = new LinkedKeySet()) : set;
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        return collection == null ? (this.values = new LinkedValues()) : collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set set = this.entrySet;
        return set == null ? (this.entrySet = new LinkedEntrySet()) : set;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        if (biConsumer == null) {
            throw new NullPointerException();
        }
        int n = this.modCount;
        Entry<K, V> entry = this.head;
        while (entry != null) {
            biConsumer.accept(entry.key, entry.value);
            entry = entry.after;
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        if (biFunction == null) {
            throw new NullPointerException();
        }
        int n = this.modCount;
        Entry<K, V> entry = this.head;
        while (entry != null) {
            entry.value = biFunction.apply(entry.key, entry.value);
            entry = entry.after;
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
    }

    final class LinkedEntryIterator
    extends LinkedHashIterator
    implements Iterator<Map.Entry<K, V>> {
        LinkedEntryIterator() {
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.nextNode();
        }
    }

    final class LinkedValueIterator
    extends LinkedHashIterator
    implements Iterator<V> {
        LinkedValueIterator() {
        }

        @Override
        public final V next() {
            return this.nextNode().value;
        }
    }

    final class LinkedKeyIterator
    extends LinkedHashIterator
    implements Iterator<K> {
        LinkedKeyIterator() {
        }

        @Override
        public final K next() {
            return this.nextNode().getKey();
        }
    }

    abstract class LinkedHashIterator {
        Entry<K, V> next;
        Entry<K, V> current;
        int expectedModCount;

        LinkedHashIterator() {
            this.next = LinkedHashMap.this.head;
            this.expectedModCount = LinkedHashMap.this.modCount;
            this.current = null;
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextNode() {
            Entry entry = this.next;
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (entry == null) {
                throw new NoSuchElementException();
            }
            this.current = entry;
            this.next = entry.after;
            return entry;
        }

        public final void remove() {
            Entry entry = this.current;
            if (entry == null) {
                throw new IllegalStateException();
            }
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
            Object k = entry.key;
            LinkedHashMap.this.removeNode(HashMap.hash(k), k, null, false, false);
            this.expectedModCount = LinkedHashMap.this.modCount;
        }
    }

    final class LinkedEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        LinkedEntrySet() {
        }

        @Override
        public final int size() {
            return LinkedHashMap.this.size;
        }

        @Override
        public final void clear() {
            LinkedHashMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new LinkedEntryIterator();
        }

        @Override
        public final boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            HashMap.Node node = LinkedHashMap.this.getNode(HashMap.hash(k), k);
            return node != null && node.equals(entry);
        }

        @Override
        public final boolean remove(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                return LinkedHashMap.this.removeNode(HashMap.hash(k), k, v, true, true) != null;
            }
            return false;
        }

        @Override
        public final Spliterator<Map.Entry<K, V>> spliterator() {
            return Spliterators.spliterator(this, 81);
        }

        @Override
        public final void forEach(Consumer<? super Map.Entry<K, V>> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            int n = LinkedHashMap.this.modCount;
            Entry entry = LinkedHashMap.this.head;
            while (entry != null) {
                consumer.accept(entry);
                entry = entry.after;
            }
            if (LinkedHashMap.this.modCount != n) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class LinkedValues
    extends AbstractCollection<V> {
        LinkedValues() {
        }

        @Override
        public final int size() {
            return LinkedHashMap.this.size;
        }

        @Override
        public final void clear() {
            LinkedHashMap.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new LinkedValueIterator();
        }

        @Override
        public final boolean contains(Object object) {
            return LinkedHashMap.this.containsValue(object);
        }

        @Override
        public final Spliterator<V> spliterator() {
            return Spliterators.spliterator(this, 80);
        }

        @Override
        public final void forEach(Consumer<? super V> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            int n = LinkedHashMap.this.modCount;
            Entry entry = LinkedHashMap.this.head;
            while (entry != null) {
                consumer.accept(entry.value);
                entry = entry.after;
            }
            if (LinkedHashMap.this.modCount != n) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class LinkedKeySet
    extends AbstractSet<K> {
        LinkedKeySet() {
        }

        @Override
        public final int size() {
            return LinkedHashMap.this.size;
        }

        @Override
        public final void clear() {
            LinkedHashMap.this.clear();
        }

        @Override
        public final Iterator<K> iterator() {
            return new LinkedKeyIterator();
        }

        @Override
        public final boolean contains(Object object) {
            return LinkedHashMap.this.containsKey(object);
        }

        @Override
        public final boolean remove(Object object) {
            return LinkedHashMap.this.removeNode(HashMap.hash(object), object, null, false, true) != null;
        }

        @Override
        public final Spliterator<K> spliterator() {
            return Spliterators.spliterator(this, 81);
        }

        @Override
        public final void forEach(Consumer<? super K> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            int n = LinkedHashMap.this.modCount;
            Entry entry = LinkedHashMap.this.head;
            while (entry != null) {
                consumer.accept(entry.key);
                entry = entry.after;
            }
            if (LinkedHashMap.this.modCount != n) {
                throw new ConcurrentModificationException();
            }
        }
    }

    static class Entry<K, V>
    extends HashMap.Node<K, V> {
        Entry<K, V> before;
        Entry<K, V> after;

        Entry(int n, K k, V v, HashMap.Node<K, V> node) {
            super(n, k, v, node);
        }
    }
}

