/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractExecutorService
implements ExecutorService {
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        return new FutureTask<T>(runnable, t);
    }

    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new FutureTask<T>(callable);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableFuture<Object> runnableFuture = this.newTaskFor(runnable, null);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> runnableFuture = this.newTaskFor(runnable, t);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> runnableFuture = this.newTaskFor(callable);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    private <T> T doInvokeAny(Collection<? extends Callable<T>> collection, boolean bl, long l) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionException executionException;
        ArrayList arrayList;
        block17: {
            if (collection == null) {
                throw new NullPointerException();
            }
            int n = collection.size();
            if (n == 0) {
                throw new IllegalArgumentException();
            }
            arrayList = new ArrayList(n);
            ExecutorCompletionService<T> executorCompletionService = new ExecutorCompletionService<T>(this);
            executionException = null;
            long l2 = bl ? System.nanoTime() + l : 0L;
            Iterator<Callable<T>> iterator = collection.iterator();
            arrayList.add(executorCompletionService.submit(iterator.next()));
            --n;
            int n2 = 1;
            while (true) {
                Object v;
                Future future;
                if ((future = executorCompletionService.poll()) == null) {
                    if (n > 0) {
                        --n;
                        arrayList.add(executorCompletionService.submit(iterator.next()));
                        ++n2;
                    } else {
                        if (n2 == 0) break;
                        if (bl) {
                            future = executorCompletionService.poll(l, TimeUnit.NANOSECONDS);
                            if (future == null) {
                                throw new TimeoutException();
                            }
                            l = l2 - System.nanoTime();
                        } else {
                            future = executorCompletionService.take();
                        }
                    }
                }
                if (future == null) continue;
                --n2;
                try {
                    v = future.get();
                }
                catch (ExecutionException executionException2) {
                    executionException = executionException2;
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    executionException = new ExecutionException(runtimeException);
                    continue;
                }
                return (T)v;
                break;
            }
            if (executionException != null) break block17;
            executionException = new ExecutionException();
        }
        throw executionException;
        finally {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ((Future)arrayList.get(i)).cancel(true);
            }
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(collection, false, 0L);
        }
        catch (TimeoutException timeoutException) {
            assert (false);
            return null;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(collection, true, timeUnit.toNanos(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        ArrayList<Future<T>> arrayList;
        block11: {
            int n;
            int n2;
            if (collection == null) {
                throw new NullPointerException();
            }
            ArrayList<Future<T>> arrayList2 = new ArrayList<Future<T>>(collection.size());
            boolean bl = false;
            try {
                Future<Object> future;
                for (Callable<T> callable : collection) {
                    future = this.newTaskFor(callable);
                    arrayList2.add(future);
                    this.execute((Runnable)((Object)future));
                }
                n2 = arrayList2.size();
                for (int i = 0; i < n2; ++i) {
                    future = (Future)arrayList2.get(i);
                    if (future.isDone()) continue;
                    try {
                        future.get();
                        continue;
                    }
                    catch (CancellationException cancellationException) {
                        continue;
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
                bl = true;
                arrayList = arrayList2;
                if (bl) break block11;
                n = arrayList2.size();
            }
            catch (Throwable throwable) {
                if (!bl) {
                    int n3 = arrayList2.size();
                    for (int i = 0; i < n3; ++i) {
                        ((Future)arrayList2.get(i)).cancel(true);
                    }
                }
                throw throwable;
            }
            for (n2 = 0; n2 < n; ++n2) {
                arrayList2.get(n2).cancel(true);
            }
        }
        return arrayList;
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> var1_1, long var2_2, TimeUnit var4_3) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

