/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import javax.swing.colorchooser.ColorModel;

final class ColorModelHSL
extends ColorModel {
    ColorModelHSL() {
        super("hsl", "Hue", "Saturation", "Lightness", "Transparency");
    }

    @Override
    void setColor(int n, float[] fArray) {
        super.setColor(n, fArray);
        ColorModelHSL.RGBtoHSL(fArray, fArray);
        fArray[3] = 1.0f - fArray[3];
    }

    @Override
    int getColor(float[] fArray) {
        fArray[3] = 1.0f - fArray[3];
        ColorModelHSL.HSLtoRGB(fArray, fArray);
        return super.getColor(fArray);
    }

    @Override
    int getMaximum(int n) {
        return n == 0 ? 360 : 100;
    }

    @Override
    float getDefault(int n) {
        return n == 0 ? -1.0f : (n == 2 ? 0.5f : 1.0f);
    }

    private static float[] HSLtoRGB(float[] fArray, float[] fArray2) {
        if (fArray2 == null) {
            fArray2 = new float[3];
        }
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        if (f2 > 0.0f) {
            f = f < 1.0f ? f * 6.0f : 0.0f;
            float f4 = f3 + f2 * (f3 > 0.5f ? 1.0f - f3 : f3);
            float f5 = 2.0f * f3 - f4;
            fArray2[0] = ColorModelHSL.normalize(f4, f5, f < 4.0f ? f + 2.0f : f - 4.0f);
            fArray2[1] = ColorModelHSL.normalize(f4, f5, f);
            fArray2[2] = ColorModelHSL.normalize(f4, f5, f < 2.0f ? f + 4.0f : f - 2.0f);
        } else {
            fArray2[0] = f3;
            fArray2[1] = f3;
            fArray2[2] = f3;
        }
        return fArray2;
    }

    private static float[] RGBtoHSL(float[] fArray, float[] fArray2) {
        if (fArray2 == null) {
            fArray2 = new float[3];
        }
        float f = ColorModelHSL.max(fArray[0], fArray[1], fArray[2]);
        float f2 = ColorModelHSL.min(fArray[0], fArray[1], fArray[2]);
        float f3 = f + f2;
        float f4 = f - f2;
        if (f4 > 0.0f) {
            f4 /= f3 > 1.0f ? 2.0f - f3 : f3;
        }
        fArray2[0] = ColorModelHSL.getHue(fArray[0], fArray[1], fArray[2], f, f2);
        fArray2[1] = f4;
        fArray2[2] = f3 / 2.0f;
        return fArray2;
    }

    static float min(float f, float f2, float f3) {
        float f4 = f < f2 ? f : f2;
        return f4 < f3 ? f4 : f3;
    }

    static float max(float f, float f2, float f3) {
        float f4 = f > f2 ? f : f2;
        return f4 > f3 ? f4 : f3;
    }

    static float getHue(float f, float f2, float f3, float f4, float f5) {
        float f6 = f4 - f5;
        if (f6 > 0.0f) {
            if (f4 == f) {
                if ((f6 = (f2 - f3) / f6) < 0.0f) {
                    f6 += 6.0f;
                }
            } else {
                f6 = f4 == f2 ? 2.0f + (f3 - f) / f6 : 4.0f + (f - f2) / f6;
            }
            f6 /= 6.0f;
        }
        return f6;
    }

    private static float normalize(float f, float f2, float f3) {
        if (f3 < 1.0f) {
            return f2 + (f - f2) * f3;
        }
        if (f3 < 3.0f) {
            return f;
        }
        if (f3 < 4.0f) {
            return f2 + (f - f2) * (4.0f - f3);
        }
        return f2;
    }
}

