/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import sun.misc.ServiceConfigurationError;

public final class Service<S> {
    private static final String prefix = "META-INF/services/";

    private Service() {
    }

    private static void fail(Class<?> clazz, String string, Throwable throwable) throws ServiceConfigurationError {
        ServiceConfigurationError serviceConfigurationError = new ServiceConfigurationError(clazz.getName() + ": " + string);
        serviceConfigurationError.initCause(throwable);
        throw serviceConfigurationError;
    }

    private static void fail(Class<?> clazz, String string) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(clazz.getName() + ": " + string);
    }

    private static void fail(Class<?> clazz, URL uRL, int n, String string) throws ServiceConfigurationError {
        Service.fail(clazz, uRL + ":" + n + ": " + string);
    }

    private static int parseLine(Class<?> clazz, URL uRL, BufferedReader bufferedReader, int n, List<String> list, Set<String> set) throws IOException, ServiceConfigurationError {
        int n2;
        String string = bufferedReader.readLine();
        if (string == null) {
            return -1;
        }
        int n3 = string.indexOf(35);
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        if ((n2 = (string = string.trim()).length()) != 0) {
            int n4;
            if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0) {
                Service.fail(clazz, uRL, n, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(n4 = string.codePointAt(0))) {
                Service.fail(clazz, uRL, n, "Illegal provider-class name: " + string);
            }
            for (int i = Character.charCount(n4); i < n2; i += Character.charCount(n4)) {
                n4 = string.codePointAt(i);
                if (Character.isJavaIdentifierPart(n4) || n4 == 46) continue;
                Service.fail(clazz, uRL, n, "Illegal provider-class name: " + string);
            }
            if (!set.contains(string)) {
                list.add(string);
                set.add(string);
            }
        }
        return n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterator<String> parse(Class<?> clazz, URL uRL, Set<String> set) throws ServiceConfigurationError {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            inputStream = uRL.openStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            int n = 1;
            while ((n = Service.parseLine(clazz, uRL, bufferedReader, n, arrayList, set)) >= 0) {
            }
        }
        catch (IOException iOException) {
            Service.fail(clazz, ": " + iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Service.fail(clazz, ": " + iOException);
            }
        }
        return arrayList.iterator();
    }

    public static <S> Iterator<S> providers(Class<S> clazz, ClassLoader classLoader) throws ServiceConfigurationError {
        return new LazyIterator(clazz, classLoader);
    }

    public static <S> Iterator<S> providers(Class<S> clazz) throws ServiceConfigurationError {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Service.providers(clazz, classLoader);
    }

    public static <S> Iterator<S> installedProviders(Class<S> clazz) throws ServiceConfigurationError {
        ClassLoader classLoader = null;
        for (ClassLoader classLoader2 = ClassLoader.getSystemClassLoader(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
            classLoader = classLoader2;
        }
        return Service.providers(clazz, classLoader);
    }

    private static class LazyIterator<S>
    implements Iterator<S> {
        Class<S> service;
        ClassLoader loader;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        Set<String> returned = new TreeSet<String>();
        String nextName = null;

        private LazyIterator(Class<S> clazz, ClassLoader classLoader) {
            this.service = clazz;
            this.loader = classLoader;
        }

        @Override
        public boolean hasNext() throws ServiceConfigurationError {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String string = Service.prefix + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(string) : this.loader.getResources(string);
                }
                catch (IOException iOException) {
                    Service.fail(this.service, ": " + iOException);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.pending = Service.parse(this.service, this.configs.nextElement(), this.returned);
            }
            this.nextName = this.pending.next();
            return true;
        }

        @Override
        public S next() throws ServiceConfigurationError {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string = this.nextName;
            this.nextName = null;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string, false, this.loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Service.fail(this.service, "Provider " + string + " not found");
            }
            if (!this.service.isAssignableFrom(clazz)) {
                Service.fail(this.service, "Provider " + string + " not a subtype");
            }
            try {
                return this.service.cast(clazz.newInstance());
            }
            catch (Throwable throwable) {
                Service.fail(this.service, "Provider " + string + " could not be instantiated", throwable);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

