/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherCore;
import com.sun.crypto.provider.RC2Crypt;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.RC2ParameterSpec;

public final class RC2Cipher
extends CipherSpi {
    private final CipherCore core;
    private final RC2Crypt embeddedCipher = new RC2Crypt();

    public RC2Cipher() {
        this.core = new CipherCore(this.embeddedCipher, 8);
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        this.core.setMode(string);
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        this.core.setPadding(string);
    }

    @Override
    protected int engineGetBlockSize() {
        return 8;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return this.core.getOutputSize(n);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.core.getIV();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return this.core.getParameters("RC2");
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.embeddedCipher.initEffectiveKeyBits(0);
        this.core.init(n, key, secureRandom);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null && algorithmParameterSpec instanceof RC2ParameterSpec) {
            this.embeddedCipher.initEffectiveKeyBits(((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits());
        } else {
            this.embeddedCipher.initEffectiveKeyBits(0);
        }
        this.core.init(n, key, algorithmParameterSpec, secureRandom);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null && algorithmParameters.getAlgorithm().equals("RC2")) {
            try {
                RC2ParameterSpec rC2ParameterSpec = algorithmParameters.getParameterSpec(RC2ParameterSpec.class);
                this.engineInit(n, key, rC2ParameterSpec, secureRandom);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: RC2 expected");
            }
        } else {
            this.embeddedCipher.initEffectiveKeyBits(0);
            this.core.init(n, key, algorithmParameters, secureRandom);
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        return this.core.update(byArray, n, n2);
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.core.update(byArray, n, n2, byArray2, n3);
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.core.doFinal(byArray, n, n2);
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        return this.core.doFinal(byArray, n, n2, byArray2, n3);
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] byArray = CipherCore.getKeyBytes(key);
        RC2Crypt.checkKey(key.getAlgorithm(), byArray.length);
        return byArray.length << 3;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.core.wrap(key);
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.core.unwrap(byArray, string, n);
    }
}

