/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.security.pkcs.PKCS10Attribute;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PKCS10Attributes
implements DerEncoder {
    private Hashtable<String, PKCS10Attribute> map = new Hashtable(3);

    public PKCS10Attributes() {
    }

    public PKCS10Attributes(PKCS10Attribute[] pKCS10AttributeArray) {
        for (int i = 0; i < pKCS10AttributeArray.length; ++i) {
            this.map.put(pKCS10AttributeArray[i].getAttributeId().toString(), pKCS10AttributeArray[i]);
        }
    }

    public PKCS10Attributes(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = derInputStream.getSet(3, true);
        if (derValueArray == null) {
            throw new IOException("Illegal encoding of attributes");
        }
        for (int i = 0; i < derValueArray.length; ++i) {
            PKCS10Attribute pKCS10Attribute = new PKCS10Attribute(derValueArray[i]);
            this.map.put(pKCS10Attribute.getAttributeId().toString(), pKCS10Attribute);
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.derEncode(outputStream);
    }

    @Override
    public void derEncode(OutputStream outputStream) throws IOException {
        Collection<PKCS10Attribute> collection = this.map.values();
        DerEncoder[] derEncoderArray = collection.toArray(new PKCS10Attribute[this.map.size()]);
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOrderedSetOf(DerValue.createTag((byte)-128, true, (byte)0), derEncoderArray);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void setAttribute(String string, Object object) {
        if (object instanceof PKCS10Attribute) {
            this.map.put(string, (PKCS10Attribute)object);
        }
    }

    public Object getAttribute(String string) {
        return this.map.get(string);
    }

    public void deleteAttribute(String string) {
        this.map.remove(string);
    }

    public Enumeration<PKCS10Attribute> getElements() {
        return this.map.elements();
    }

    public Collection<PKCS10Attribute> getAttributes() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PKCS10Attributes)) {
            return false;
        }
        Collection<PKCS10Attribute> collection = ((PKCS10Attributes)object).getAttributes();
        PKCS10Attribute[] pKCS10AttributeArray = collection.toArray(new PKCS10Attribute[collection.size()]);
        int n = pKCS10AttributeArray.length;
        if (n != this.map.size()) {
            return false;
        }
        String string = null;
        for (int i = 0; i < n; ++i) {
            PKCS10Attribute pKCS10Attribute = pKCS10AttributeArray[i];
            string = pKCS10Attribute.getAttributeId().toString();
            if (string == null) {
                return false;
            }
            PKCS10Attribute pKCS10Attribute2 = this.map.get(string);
            if (pKCS10Attribute2 == null) {
                return false;
            }
            if (pKCS10Attribute2.equals(pKCS10Attribute)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        String string = this.map.size() + "\n" + this.map.toString();
        return string;
    }
}

