/*
 * Decompiled with CFR 0.152.
 */
package sun.security.timestamp;

import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Extension;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public class TSRequest {
    private int version = 1;
    private AlgorithmId hashAlgorithmId = null;
    private byte[] hashValue;
    private String policyId = null;
    private BigInteger nonce = null;
    private boolean returnCertificate = false;
    private X509Extension[] extensions = null;

    public TSRequest(String string, byte[] byArray, MessageDigest messageDigest) throws NoSuchAlgorithmException {
        this.policyId = string;
        this.hashAlgorithmId = AlgorithmId.get(messageDigest.getAlgorithm());
        this.hashValue = messageDigest.digest(byArray);
    }

    public byte[] getHashedMessage() {
        return (byte[])this.hashValue.clone();
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public void setPolicyId(String string) {
        this.policyId = string;
    }

    public void setNonce(BigInteger bigInteger) {
        this.nonce = bigInteger;
    }

    public void requestCertificate(boolean bl) {
        this.returnCertificate = bl;
    }

    public void setExtensions(X509Extension[] x509ExtensionArray) {
        this.extensions = x509ExtensionArray;
    }

    public byte[] encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(this.version);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.hashAlgorithmId.encode(derOutputStream2);
        derOutputStream2.putOctetString(this.hashValue);
        derOutputStream.write((byte)48, derOutputStream2);
        if (this.policyId != null) {
            derOutputStream.putOID(new ObjectIdentifier(this.policyId));
        }
        if (this.nonce != null) {
            derOutputStream.putInteger(this.nonce);
        }
        if (this.returnCertificate) {
            derOutputStream.putBoolean(true);
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream);
        return derOutputStream3.toByteArray();
    }
}

