/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.ScreenPopupFactory;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.PopupFactory;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class AquaPopupMenuUI
extends BasicPopupMenuUI {
    static final int OVERLAP_SLACK = 10;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaPopupMenuUI();
    }

    @Override
    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return mouseEvent.isPopupTrigger();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (!(graphics instanceof Graphics2D)) {
            super.paint(graphics, jComponent);
            return;
        }
        if (!(PopupFactory.getSharedInstance() instanceof ScreenPopupFactory)) {
            super.paint(graphics, jComponent);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Rectangle rectangle = this.popupMenu.getBounds();
        this.paintRoundRect(graphics2D, rectangle);
        this.clipEdges(graphics2D, rectangle);
        graphics2D.dispose();
        super.paint(graphics, jComponent);
    }

    protected void paintRoundRect(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.setStroke(new BasicStroke(3.0f));
        graphics2D.drawRoundRect(-2, -2, rectangle.width + 3, rectangle.height + 3, 12, 12);
    }

    protected void clipEdges(Graphics2D graphics2D, Rectangle rectangle) {
        boolean bl;
        Component component = this.popupMenu.getInvoker();
        if (!(component instanceof JMenu)) {
            return;
        }
        Rectangle rectangle2 = component.getBounds();
        rectangle2.setLocation(component.getLocationOnScreen());
        rectangle.setLocation(this.popupMenu.getLocationOnScreen());
        Point point = new Point((int)rectangle2.getCenterX(), (int)rectangle2.getCenterY());
        if (rectangle.contains(point)) {
            return;
        }
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setColor(this.popupMenu.getBackground());
        Point point2 = new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY());
        boolean bl2 = bl = point.y <= point2.y;
        if (rectangle2.x + rectangle2.width < rectangle.x + 10) {
            if (bl) {
                graphics2D.fillRect(-2, -2, 8, 8);
                return;
            }
            graphics2D.fillRect(-2, rectangle.height - 6, 8, 8);
            return;
        }
        if (rectangle.x + rectangle.width < rectangle2.x + 10) {
            if (bl) {
                graphics2D.fillRect(rectangle.width - 6, -2, 8, 8);
                return;
            }
            graphics2D.fillRect(rectangle.width - 6, rectangle.height - 6, 8, 8);
            return;
        }
        if (rectangle2.y + rectangle2.height < rectangle.y + 10) {
            graphics2D.fillRect(-2, -2, rectangle.width + 4, 8);
            return;
        }
    }
}

