#!/usr/bin/env python3
#
# Script to generate gcc/text-art/box-drawing-chars.inc
#
# This file is part of GCC.
#
# GCC is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3, or (at your option) any later
# version.
#
# GCC is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License
# along with GCC; see the file COPYING3.  If not see
# <http://www.gnu.org/licenses/>.

import unicodedata

def get_box_drawing_char_name(up: bool,
                              down: bool,
                              left: bool,
                              right: bool) -> str:
    if 0:
        print(f'{locals()=}')
    if up and down:
        vertical = True
        up = False
        down = False
    else:
        vertical = False

    if left and right:
        horizontal = True
        left = False
        right = False
    else:
        horizontal = False

    weights = []
    heavy = []
    light = []
    dirs = []
    for dir_name in ('up', 'down', 'vertical', 'left', 'right', 'horizontal'):
        val = locals()[dir_name]
        if val:
            dirs.append(dir_name.upper())

    if not dirs:
        return 'SPACE'

    name = 'BOX DRAWINGS'
    #print(f'{light=} {heavy=}')

    if 0:
        print(dirs)

    def weights_frag(weight: str, dirs: list, prefix: bool):
        """
        Generate a fragment where all directions share the same weight, e.g.:
        'HEAVY HORIZONTAL'
        'DOWN LIGHT'
        'LEFT DOWN HEAVY'
        'HEAVY DOWN AND RIGHT'
        """
        assert len(dirs) >= 1
        assert len(dirs) <= 2
        if prefix:
            return f' {weight} ' + (' AND '.join(dirs))
        else:
            return ' ' + (' '.join(dirs)) + f' {weight}'

    assert(len(dirs) >= 1 and len(dirs) <= 2)
    name += weights_frag('LIGHT', dirs, True)

    return name

print('/* Generated by contrib/unicode/gen-box-drawing-chars.py.  */')
print()
for i in range(16):
    up = (i & 8)
    down = (i & 4)
    left = (i & 2)
    right = (i & 1)
    name = get_box_drawing_char_name(up, down, left, right)
    if i < 15:
        trailing_comma = ','
    else:
        trailing_comma = ' '
    unichar = unicodedata.lookup(name)
    print(f'0x{ord(unichar):04X}{trailing_comma} /* "{unichar}": U+{ord(unichar):04X}: {name} */')
