/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import sun.font.XRTextRenderer;
import sun.java2d.SunGraphics2D;
import sun.java2d.jules.TrapezoidList;
import sun.java2d.loops.XORComposite;
import sun.java2d.xr.GrowableEltArray;
import sun.java2d.xr.GrowableRectArray;
import sun.java2d.xr.MaskTileManager;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRBackendNative;
import sun.java2d.xr.XRColor;
import sun.java2d.xr.XRMaskImage;
import sun.java2d.xr.XRPaints;
import sun.java2d.xr.XRSurfaceData;
import sun.java2d.xr.XRUtils;

public class XRCompositeManager {
    private static boolean enableGradCache = true;
    private static XRCompositeManager instance;
    XRSurfaceData src;
    XRSurfaceData texture;
    XRSurfaceData gradient;
    int alphaMask = 0;
    XRColor solidColor = new XRColor();
    float extraAlpha = 1.0f;
    byte compRule = (byte)3;
    XRColor alphaColor = new XRColor();
    XRSurfaceData solidSrcPict;
    int alphaMaskPict;
    int gradCachePixmap;
    int gradCachePicture;
    boolean xorEnabled = false;
    int validatedPixel = 0;
    Composite validatedComp;
    Paint validatedPaint;
    float validatedExtraAlpha = 1.0f;
    XRBackend con = new XRBackendNative();
    MaskTileManager maskBuffer;
    XRTextRenderer textRenderer;
    XRMaskImage maskImage;

    public static synchronized XRCompositeManager getInstance(XRSurfaceData xRSurfaceData) {
        if (instance == null) {
            instance = new XRCompositeManager(xRSurfaceData);
        }
        return instance;
    }

    private XRCompositeManager(XRSurfaceData xRSurfaceData) {
        String string = System.getProperty("sun.java2d.xrgradcache");
        enableGradCache = string == null || !string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("f");
        XRPaints.register(this);
        this.initResources(xRSurfaceData);
        this.maskBuffer = new MaskTileManager(this, xRSurfaceData.getXid());
        this.textRenderer = new XRTextRenderer(this);
        this.maskImage = new XRMaskImage(this, xRSurfaceData.getXid());
    }

    public void initResources(XRSurfaceData xRSurfaceData) {
        int n = xRSurfaceData.getXid();
        int n2 = this.con.createPixmap(n, 32, 1, 1);
        int n3 = this.con.createPicture(n2, 0);
        this.con.setPictureRepeat(n3, 1);
        this.con.renderRectangle(n3, (byte)1, XRColor.FULL_ALPHA, 0, 0, 1, 1);
        this.solidSrcPict = new XRSurfaceData.XRInternalSurfaceData(this.con, n3, null);
        this.setForeground(0);
        int n4 = this.con.createPixmap(n, 8, 1, 1);
        this.alphaMaskPict = this.con.createPicture(n4, 2);
        this.con.setPictureRepeat(this.alphaMaskPict, 1);
        this.con.renderRectangle(this.alphaMaskPict, (byte)0, XRColor.NO_ALPHA, 0, 0, 1, 1);
        if (enableGradCache) {
            this.gradCachePixmap = this.con.createPixmap(n, 32, 256, 256);
            this.gradCachePicture = this.con.createPicture(this.gradCachePixmap, 0);
        }
    }

    public void setForeground(int n) {
        this.solidColor.setColorValues(n, false);
        this.con.renderRectangle(this.solidSrcPict.picture, (byte)1, this.solidColor, 0, 0, 1, 1);
    }

    public void setGradientPaint(XRSurfaceData xRSurfaceData) {
        if (this.gradient != null) {
            this.con.freePicture(this.gradient.picture);
        }
        this.gradient = xRSurfaceData;
        this.src = xRSurfaceData;
    }

    public void setTexturePaint(XRSurfaceData xRSurfaceData) {
        this.texture = xRSurfaceData;
        this.src = xRSurfaceData;
    }

    public void XRResetPaint() {
        this.src = this.solidSrcPict;
    }

    public void validateCompositeState(Composite composite, AffineTransform affineTransform, Paint paint, SunGraphics2D sunGraphics2D) {
        boolean bl;
        boolean bl2 = bl = paint != this.validatedPaint || paint == null;
        if (composite != this.validatedComp) {
            if (composite != null) {
                this.setComposite(composite);
            } else {
                composite = AlphaComposite.getInstance(3);
                this.setComposite(composite);
            }
            bl = true;
            this.validatedComp = composite;
        }
        if (sunGraphics2D != null && this.validatedPixel != sunGraphics2D.pixel) {
            this.validatedPixel = sunGraphics2D.pixel;
            this.setForeground(this.validatedPixel);
        }
        if (bl) {
            if (paint != null && sunGraphics2D != null && sunGraphics2D.paintState >= 2) {
                XRPaints.setPaint(sunGraphics2D, paint);
            } else {
                this.XRResetPaint();
            }
            this.validatedPaint = paint;
        }
        if (this.src != this.solidSrcPict) {
            AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
            try {
                affineTransform2.invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                affineTransform2.setToIdentity();
            }
            this.src.validateAsSource(affineTransform2, -1, -1);
        }
    }

    private void setComposite(Composite composite) {
        if (composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            this.validatedExtraAlpha = alphaComposite.getAlpha();
            this.compRule = XRUtils.j2dAlphaCompToXR(alphaComposite.getRule());
            this.extraAlpha = this.validatedExtraAlpha;
            if (this.extraAlpha == 1.0f) {
                this.alphaMask = 0;
                this.alphaColor.alpha = XRColor.FULL_ALPHA.alpha;
            } else {
                this.alphaColor.alpha = XRColor.byteToXRColorValue((int)(this.extraAlpha * 255.0f));
                this.alphaMask = this.alphaMaskPict;
                this.con.renderRectangle(this.alphaMaskPict, (byte)1, this.alphaColor, 0, 0, 1, 1);
            }
            this.xorEnabled = false;
        } else if (composite instanceof XORComposite) {
            this.xorEnabled = true;
        } else {
            throw new InternalError("Composite accaleration not implemented for: " + composite.getClass().getName());
        }
    }

    public boolean maskRequired() {
        return !this.xorEnabled && (this.src != this.solidSrcPict || this.src == this.solidSrcPict && this.solidColor.alpha != 65535 || this.extraAlpha != 1.0f);
    }

    public void XRComposite(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int n12 = n == 0 ? this.src.picture : n;
        int n13 = n4;
        int n14 = n5;
        if (enableGradCache && this.gradient != null && n12 == this.gradient.picture) {
            this.con.renderComposite((byte)1, this.gradient.picture, 0, this.gradCachePicture, n4, n5, 0, 0, 0, 0, n10, n11);
            n13 = 0;
            n14 = 0;
            n12 = this.gradCachePicture;
        }
        this.con.renderComposite(this.compRule, n12, n2, n3, n13, n14, n6, n7, n8, n9, n10, n11);
    }

    public void XRCompositeTraps(int n, int n2, int n3, TrapezoidList trapezoidList) {
        int n4 = 0;
        int n5 = 0;
        if (trapezoidList.getP1YLeft(0) < trapezoidList.getP2YLeft(0)) {
            n4 = trapezoidList.getP1XLeft(0);
            n5 = trapezoidList.getP1YLeft(0);
        } else {
            n4 = trapezoidList.getP2XLeft(0);
            n5 = trapezoidList.getP2YLeft(0);
        }
        n4 = (int)Math.floor(XRUtils.XFixedToDouble(n4));
        n5 = (int)Math.floor(XRUtils.XFixedToDouble(n5));
        this.con.renderCompositeTrapezoids(this.compRule, this.src.picture, 2, n, n4, n5, trapezoidList);
    }

    public void XRRenderRectangles(XRSurfaceData xRSurfaceData, GrowableRectArray growableRectArray) {
        if (this.xorEnabled) {
            this.con.GCRectangles(xRSurfaceData.getXid(), xRSurfaceData.getGC(), growableRectArray);
        } else {
            this.con.renderRectangles(xRSurfaceData.getPicture(), this.compRule, this.solidColor, growableRectArray);
        }
    }

    public void compositeBlit(XRSurfaceData xRSurfaceData, XRSurfaceData xRSurfaceData2, int n, int n2, int n3, int n4, int n5, int n6) {
        this.con.renderComposite(this.compRule, xRSurfaceData.picture, this.alphaMask, xRSurfaceData2.picture, n, n2, 0, 0, n3, n4, n5, n6);
    }

    public void compositeText(int n, int n2, int n3, GrowableEltArray growableEltArray) {
        this.con.XRenderCompositeText(this.compRule, this.src.picture, n, n3, 0, 0, 0, 0, n2, growableEltArray);
    }

    public XRColor getMaskColor() {
        return !this.isTexturePaintActive() ? XRColor.FULL_ALPHA : this.getAlphaColor();
    }

    public int getExtraAlphaMask() {
        return this.alphaMask;
    }

    public boolean isTexturePaintActive() {
        return this.src == this.texture;
    }

    public XRColor getAlphaColor() {
        return this.alphaColor;
    }

    public XRBackend getBackend() {
        return this.con;
    }

    public float getExtraAlpha() {
        return this.validatedExtraAlpha;
    }

    public byte getCompRule() {
        return this.compRule;
    }

    public XRTextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public MaskTileManager getMaskBuffer() {
        return this.maskBuffer;
    }

    public XRMaskImage getMaskImage() {
        return this.maskImage;
    }
}

