// SPDX-License-Identifier: GPL-2.0
/*
 * r8a7779 processor support - PFC hardware block
 *
 * Copyright (C) 2011, 2013  Renesas Solutions Corp.
 * Copyright (C) 2011  Magnus Damm
 * Copyright (C) 2013  Cogent Embedded, Inc.
 */

#include <linux/kernel.h>

#include "sh_pfc.h"

#define CPU_ALL_GP(fn, sfx)						\
	PORT_GP_32(0, fn, sfx),						\
	PORT_GP_32(1, fn, sfx),						\
	PORT_GP_32(2, fn, sfx),						\
	PORT_GP_32(3, fn, sfx),						\
	PORT_GP_32(4, fn, sfx),						\
	PORT_GP_32(5, fn, sfx),						\
	PORT_GP_9(6, fn, sfx)

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	GP_ALL(DATA), /* GP_0_0_DATA -> GP_6_8_DATA */
	PINMUX_DATA_END,

	PINMUX_FUNCTION_BEGIN,
	GP_ALL(FN), /* GP_0_0_FN -> GP_6_8_FN */

	/* GPSR0 */
	FN_AVS1, FN_AVS2, FN_IP0_7_6, FN_A17,
	FN_A18, FN_A19, FN_IP0_9_8, FN_IP0_11_10,
	FN_IP0_13_12, FN_IP0_15_14, FN_IP0_18_16, FN_IP0_22_19,
	FN_IP0_24_23, FN_IP0_25, FN_IP0_27_26, FN_IP1_1_0,
	FN_IP1_3_2, FN_IP1_6_4, FN_IP1_10_7, FN_IP1_14_11,
	FN_IP1_18_15, FN_IP0_5_3, FN_IP0_30_28, FN_IP2_18_16,
	FN_IP2_21_19, FN_IP2_30_28, FN_IP3_2_0, FN_IP3_11_9,
	FN_IP3_14_12, FN_IP3_22_21, FN_IP3_26_24, FN_IP3_31_29,

	/* GPSR1 */
	FN_IP4_1_0, FN_IP4_4_2, FN_IP4_7_5, FN_IP4_10_8,
	FN_IP4_11, FN_IP4_12, FN_IP4_13, FN_IP4_14,
	FN_IP4_15, FN_IP4_16, FN_IP4_19_17, FN_IP4_22_20,
	FN_IP4_23, FN_IP4_24, FN_IP4_25, FN_IP4_26,
	FN_IP4_27, FN_IP4_28, FN_IP4_31_29, FN_IP5_2_0,
	FN_IP5_3, FN_IP5_4, FN_IP5_5, FN_IP5_6,
	FN_IP5_7, FN_IP5_8, FN_IP5_10_9, FN_IP5_12_11,
	FN_IP5_14_13, FN_IP5_16_15, FN_IP5_20_17, FN_IP5_23_21,

	/* GPSR2 */
	FN_IP5_27_24, FN_IP8_20, FN_IP8_22_21, FN_IP8_24_23,
	FN_IP8_27_25, FN_IP8_30_28, FN_IP9_1_0, FN_IP9_3_2,
	FN_IP9_4, FN_IP9_5, FN_IP9_6, FN_IP9_7,
	FN_IP9_9_8, FN_IP9_11_10, FN_IP9_13_12, FN_IP9_15_14,
	FN_IP9_18_16, FN_IP9_21_19, FN_IP9_23_22, FN_IP9_25_24,
	FN_IP9_27_26, FN_IP9_29_28, FN_IP10_2_0, FN_IP10_5_3,
	FN_IP10_8_6, FN_IP10_11_9, FN_IP10_14_12, FN_IP10_17_15,
	FN_IP10_20_18, FN_IP10_23_21, FN_IP10_25_24, FN_IP10_28_26,

	/* GPSR3 */
	FN_IP10_31_29, FN_IP11_2_0, FN_IP11_5_3, FN_IP11_8_6,
	FN_IP11_11_9, FN_IP11_14_12, FN_IP11_17_15, FN_IP11_20_18,
	FN_IP11_23_21, FN_IP11_26_24, FN_IP11_29_27, FN_IP12_2_0,
	FN_IP12_5_3, FN_IP12_8_6, FN_IP12_11_9, FN_IP12_14_12,
	FN_IP12_17_15, FN_IP7_16_15, FN_IP7_18_17, FN_IP7_28_27,
	FN_IP7_30_29, FN_IP7_20_19, FN_IP7_22_21, FN_IP7_24_23,
	FN_IP7_26_25, FN_IP1_20_19, FN_IP1_22_21, FN_IP1_24_23,
	FN_IP5_28, FN_IP5_30_29, FN_IP6_1_0, FN_IP6_3_2,

	/* GPSR4 */
	FN_IP6_5_4, FN_IP6_7_6, FN_IP6_8, FN_IP6_11_9,
	FN_IP6_14_12, FN_IP6_17_15, FN_IP6_19_18, FN_IP6_22_20,
	FN_IP6_24_23, FN_IP6_26_25, FN_IP6_30_29, FN_IP7_1_0,
	FN_IP7_3_2, FN_IP7_6_4, FN_IP7_9_7, FN_IP7_12_10,
	FN_IP7_14_13, FN_IP2_7_4, FN_IP2_11_8, FN_IP2_15_12,
	FN_IP1_28_25, FN_IP2_3_0, FN_IP8_3_0, FN_IP8_7_4,
	FN_IP8_11_8, FN_IP8_15_12, FN_USB_PENC0, FN_USB_PENC1,
	FN_IP0_2_0, FN_IP8_17_16, FN_IP8_18, FN_IP8_19,

	/* GPSR5 */
	FN_A1, FN_A2, FN_A3, FN_A4,
	FN_A5, FN_A6, FN_A7, FN_A8,
	FN_A9, FN_A10, FN_A11, FN_A12,
	FN_A13, FN_A14, FN_A15, FN_A16,
	FN_RD, FN_WE0, FN_WE1, FN_EX_WAIT0,
	FN_IP3_23, FN_IP3_27, FN_IP3_28, FN_IP2_22,
	FN_IP2_23, FN_IP2_24, FN_IP2_25, FN_IP2_26,
	FN_IP2_27, FN_IP3_3, FN_IP3_4, FN_IP3_5,

	/* GPSR6 */
	FN_IP3_6, FN_IP3_7, FN_IP3_8, FN_IP3_15,
	FN_IP3_16, FN_IP3_17, FN_IP3_18, FN_IP3_19,
	FN_IP3_20,

	/* IPSR0 */
	FN_RD_WR, FN_FWE, FN_ATAG0, FN_VI1_R7,
	FN_HRTS1, FN_RX4_C,
	FN_CS1_A26, FN_HSPI_TX2, FN_SDSELF_B,
	FN_CS0, FN_HSPI_CS2_B,
	FN_CLKOUT, FN_TX3C_IRDA_TX_C, FN_PWM0_B,
	FN_A25, FN_SD1_WP, FN_MMC0_D5, FN_FD5,
	FN_HSPI_RX2, FN_VI1_R3, FN_TX5_B, FN_SSI_SDATA7_B,
	FN_CTS0_B,
	FN_A24, FN_SD1_CD, FN_MMC0_D4, FN_FD4,
	FN_HSPI_CS2, FN_VI1_R2, FN_SSI_WS78_B,
	FN_A23, FN_FCLE, FN_HSPI_CLK2, FN_VI1_R1,
	FN_A22, FN_RX5_D, FN_HSPI_RX2_B, FN_VI1_R0,
	FN_A21, FN_SCK5_D, FN_HSPI_CLK2_B,
	FN_A20, FN_TX5_D, FN_HSPI_TX2_B,
	FN_A0, FN_SD1_DAT3, FN_MMC0_D3, FN_FD3,
	FN_BS, FN_SD1_DAT2, FN_MMC0_D2, FN_FD2,
	FN_ATADIR0, FN_SDSELF, FN_HCTS1, FN_TX4_C,
	FN_USB_PENC2, FN_SCK0, FN_PWM1, FN_PWMFSW0,
	FN_SCIF_CLK, FN_TCLK0_C,

	/* IPSR1 */
	FN_EX_CS0, FN_RX3_C_IRDA_RX_C, FN_MMC0_D6,
	FN_FD6, FN_EX_CS1, FN_MMC0_D7, FN_FD7,
	FN_EX_CS2, FN_SD1_CLK, FN_MMC0_CLK, FN_FALE,
	FN_ATACS00, FN_EX_CS3, FN_SD1_CMD, FN_MMC0_CMD,
	FN_FRE, FN_ATACS10, FN_VI1_R4, FN_RX5_B,
	FN_HSCK1, FN_SSI_SDATA8_B, FN_RTS0_B_TANS_B, FN_SSI_SDATA9,
	FN_EX_CS4, FN_SD1_DAT0, FN_MMC0_D0, FN_FD0,
	FN_ATARD0, FN_VI1_R5, FN_SCK5_B, FN_HTX1,
	FN_TX2_E, FN_TX0_B, FN_SSI_SCK9, FN_EX_CS5,
	FN_SD1_DAT1, FN_MMC0_D1, FN_FD1, FN_ATAWR0,
	FN_VI1_R6, FN_HRX1, FN_RX2_E, FN_RX0_B,
	FN_SSI_WS9, FN_MLB_CLK, FN_PWM2, FN_SCK4,
	FN_MLB_SIG, FN_PWM3, FN_TX4, FN_MLB_DAT,
	FN_PWM4, FN_RX4, FN_HTX0, FN_TX1,
	FN_SDATA, FN_CTS0_C, FN_SUB_TCK, FN_CC5_STATE2,
	FN_CC5_STATE10, FN_CC5_STATE18, FN_CC5_STATE26, FN_CC5_STATE34,

	/* IPSR2 */
	FN_HRX0, FN_RX1, FN_SCKZ, FN_RTS0_C_TANS_C,
	FN_SUB_TDI, FN_CC5_STATE3, FN_CC5_STATE11, FN_CC5_STATE19,
	FN_CC5_STATE27, FN_CC5_STATE35, FN_HSCK0, FN_SCK1,
	FN_MTS, FN_PWM5, FN_SCK0_C, FN_SSI_SDATA9_B,
	FN_SUB_TDO, FN_CC5_STATE0, FN_CC5_STATE8, FN_CC5_STATE16,
	FN_CC5_STATE24, FN_CC5_STATE32, FN_HCTS0, FN_CTS1,
	FN_STM, FN_PWM0_D, FN_RX0_C, FN_SCIF_CLK_C,
	FN_SUB_TRST, FN_TCLK1_B, FN_CC5_OSCOUT, FN_HRTS0,
	FN_RTS1_TANS, FN_MDATA, FN_TX0_C, FN_SUB_TMS,
	FN_CC5_STATE1, FN_CC5_STATE9, FN_CC5_STATE17, FN_CC5_STATE25,
	FN_CC5_STATE33, FN_DU0_DR0, FN_LCDOUT0, FN_DREQ0,
	FN_GPS_CLK_B, FN_AUDATA0, FN_TX5_C, FN_DU0_DR1,
	FN_LCDOUT1, FN_DACK0, FN_DRACK0, FN_GPS_SIGN_B,
	FN_AUDATA1, FN_RX5_C, FN_DU0_DR2, FN_LCDOUT2,
	FN_DU0_DR3, FN_LCDOUT3, FN_DU0_DR4, FN_LCDOUT4,
	FN_DU0_DR5, FN_LCDOUT5, FN_DU0_DR6, FN_LCDOUT6,
	FN_DU0_DR7, FN_LCDOUT7, FN_DU0_DG0, FN_LCDOUT8,
	FN_DREQ1, FN_SCL2, FN_AUDATA2,

	/* IPSR3 */
	FN_DU0_DG1, FN_LCDOUT9, FN_DACK1, FN_SDA2,
	FN_AUDATA3, FN_DU0_DG2, FN_LCDOUT10, FN_DU0_DG3,
	FN_LCDOUT11, FN_DU0_DG4, FN_LCDOUT12, FN_DU0_DG5,
	FN_LCDOUT13, FN_DU0_DG6, FN_LCDOUT14, FN_DU0_DG7,
	FN_LCDOUT15, FN_DU0_DB0, FN_LCDOUT16, FN_EX_WAIT1,
	FN_SCL1, FN_TCLK1, FN_AUDATA4, FN_DU0_DB1,
	FN_LCDOUT17, FN_EX_WAIT2, FN_SDA1, FN_GPS_MAG_B,
	FN_AUDATA5, FN_SCK5_C, FN_DU0_DB2, FN_LCDOUT18,
	FN_DU0_DB3, FN_LCDOUT19, FN_DU0_DB4, FN_LCDOUT20,
	FN_DU0_DB5, FN_LCDOUT21, FN_DU0_DB6, FN_LCDOUT22,
	FN_DU0_DB7, FN_LCDOUT23, FN_DU0_DOTCLKIN, FN_QSTVA_QVS,
	FN_TX3_D_IRDA_TX_D, FN_SCL3_B, FN_DU0_DOTCLKOUT0, FN_QCLK,
	FN_DU0_DOTCLKOUT1, FN_QSTVB_QVE, FN_RX3_D_IRDA_RX_D, FN_SDA3_B,
	FN_SDA2_C, FN_DACK0_B, FN_DRACK0_B, FN_DU0_EXHSYNC_DU0_HSYNC,
	FN_QSTH_QHS, FN_DU0_EXVSYNC_DU0_VSYNC, FN_QSTB_QHE,
	FN_DU0_EXODDF_DU0_ODDF_DISP_CDE, FN_QCPV_QDE, FN_CAN1_TX,
	FN_TX2_C, FN_SCL2_C, FN_REMOCON,

	/* IPSR4 */
	FN_DU0_DISP, FN_QPOLA, FN_CAN_CLK_C, FN_SCK2_C,
	FN_DU0_CDE, FN_QPOLB, FN_CAN1_RX, FN_RX2_C,
	FN_DREQ0_B, FN_SSI_SCK78_B, FN_SCK0_B, FN_DU1_DR0,
	FN_VI2_DATA0_VI2_B0, FN_PWM6, FN_SD3_CLK, FN_TX3_E_IRDA_TX_E,
	FN_AUDCK, FN_PWMFSW0_B, FN_DU1_DR1, FN_VI2_DATA1_VI2_B1,
	FN_PWM0, FN_SD3_CMD, FN_RX3_E_IRDA_RX_E, FN_AUDSYNC,
	FN_CTS0_D, FN_DU1_DR2, FN_VI2_G0, FN_DU1_DR3,
	FN_VI2_G1, FN_DU1_DR4, FN_VI2_G2, FN_DU1_DR5,
	FN_VI2_G3, FN_DU1_DR6, FN_VI2_G4, FN_DU1_DR7,
	FN_VI2_G5, FN_DU1_DG0, FN_VI2_DATA2_VI2_B2, FN_SCL1_B,
	FN_SD3_DAT2, FN_SCK3_E, FN_AUDATA6, FN_TX0_D,
	FN_DU1_DG1, FN_VI2_DATA3_VI2_B3, FN_SDA1_B, FN_SD3_DAT3,
	FN_SCK5, FN_AUDATA7, FN_RX0_D, FN_DU1_DG2,
	FN_VI2_G6, FN_DU1_DG3, FN_VI2_G7, FN_DU1_DG4,
	FN_VI2_R0, FN_DU1_DG5, FN_VI2_R1, FN_DU1_DG6,
	FN_VI2_R2, FN_DU1_DG7, FN_VI2_R3, FN_DU1_DB0,
	FN_VI2_DATA4_VI2_B4, FN_SCL2_B, FN_SD3_DAT0, FN_TX5,
	FN_SCK0_D,

	/* IPSR5 */
	FN_DU1_DB1, FN_VI2_DATA5_VI2_B5, FN_SDA2_B, FN_SD3_DAT1,
	FN_RX5, FN_RTS0_D_TANS_D, FN_DU1_DB2, FN_VI2_R4,
	FN_DU1_DB3, FN_VI2_R5, FN_DU1_DB4, FN_VI2_R6,
	FN_DU1_DB5, FN_VI2_R7, FN_DU1_DB6, FN_SCL2_D,
	FN_DU1_DB7, FN_SDA2_D, FN_DU1_DOTCLKIN, FN_VI2_CLKENB,
	FN_HSPI_CS1, FN_SCL1_D, FN_DU1_DOTCLKOUT, FN_VI2_FIELD,
	FN_SDA1_D, FN_DU1_EXHSYNC_DU1_HSYNC, FN_VI2_HSYNC,
	FN_VI3_HSYNC, FN_DU1_EXVSYNC_DU1_VSYNC, FN_VI2_VSYNC, FN_VI3_VSYNC,
	FN_DU1_EXODDF_DU1_ODDF_DISP_CDE, FN_VI2_CLK, FN_TX3_B_IRDA_TX_B,
	FN_SD3_CD, FN_HSPI_TX1, FN_VI1_CLKENB, FN_VI3_CLKENB,
	FN_AUDIO_CLKC, FN_TX2_D, FN_SPEEDIN, FN_GPS_SIGN_D,
	FN_DU1_DISP, FN_VI2_DATA6_VI2_B6, FN_TCLK0, FN_QSTVA_B_QVS_B,
	FN_HSPI_CLK1, FN_SCK2_D, FN_AUDIO_CLKOUT_B, FN_GPS_MAG_D,
	FN_DU1_CDE, FN_VI2_DATA7_VI2_B7, FN_RX3_B_IRDA_RX_B,
	FN_SD3_WP, FN_HSPI_RX1, FN_VI1_FIELD, FN_VI3_FIELD,
	FN_AUDIO_CLKOUT, FN_RX2_D, FN_GPS_CLK_C, FN_GPS_CLK_D,
	FN_AUDIO_CLKA, FN_CAN_TXCLK, FN_AUDIO_CLKB, FN_USB_OVC2,
	FN_CAN_DEBUGOUT0, FN_MOUT0,

	/* IPSR6 */
	FN_SSI_SCK0129, FN_CAN_DEBUGOUT1, FN_MOUT1, FN_SSI_WS0129,
	FN_CAN_DEBUGOUT2, FN_MOUT2, FN_SSI_SDATA0, FN_CAN_DEBUGOUT3,
	FN_MOUT5, FN_SSI_SDATA1, FN_CAN_DEBUGOUT4, FN_MOUT6,
	FN_SSI_SDATA2, FN_CAN_DEBUGOUT5, FN_SSI_SCK34, FN_CAN_DEBUGOUT6,
	FN_CAN0_TX_B, FN_IERX, FN_SSI_SCK9_C, FN_SSI_WS34,
	FN_CAN_DEBUGOUT7, FN_CAN0_RX_B, FN_IETX, FN_SSI_WS9_C,
	FN_SSI_SDATA3, FN_PWM0_C, FN_CAN_DEBUGOUT8, FN_CAN_CLK_B,
	FN_IECLK, FN_SCIF_CLK_B, FN_TCLK0_B, FN_SSI_SDATA4,
	FN_CAN_DEBUGOUT9, FN_SSI_SDATA9_C, FN_SSI_SCK5, FN_ADICLK,
	FN_CAN_DEBUGOUT10, FN_SCK3, FN_TCLK0_D, FN_SSI_WS5,
	FN_ADICS_SAMP, FN_CAN_DEBUGOUT11, FN_TX3_IRDA_TX, FN_SSI_SDATA5,
	FN_ADIDATA, FN_CAN_DEBUGOUT12, FN_RX3_IRDA_RX, FN_SSI_SCK6,
	FN_ADICHS0, FN_CAN0_TX, FN_IERX_B,

	/* IPSR7 */
	FN_SSI_WS6, FN_ADICHS1, FN_CAN0_RX, FN_IETX_B,
	FN_SSI_SDATA6, FN_ADICHS2, FN_CAN_CLK, FN_IECLK_B,
	FN_SSI_SCK78, FN_CAN_DEBUGOUT13, FN_IRQ0_B, FN_SSI_SCK9_B,
	FN_HSPI_CLK1_C, FN_SSI_WS78, FN_CAN_DEBUGOUT14, FN_IRQ1_B,
	FN_SSI_WS9_B, FN_HSPI_CS1_C, FN_SSI_SDATA7, FN_CAN_DEBUGOUT15,
	FN_IRQ2_B, FN_TCLK1_C, FN_HSPI_TX1_C, FN_SSI_SDATA8,
	FN_VSP, FN_IRQ3_B, FN_HSPI_RX1_C, FN_SD0_CLK,
	FN_ATACS01, FN_SCK1_B, FN_SD0_CMD, FN_ATACS11,
	FN_TX1_B, FN_CC5_TDO, FN_SD0_DAT0, FN_ATADIR1,
	FN_RX1_B, FN_CC5_TRST, FN_SD0_DAT1, FN_ATAG1,
	FN_SCK2_B, FN_CC5_TMS, FN_SD0_DAT2, FN_ATARD1,
	FN_TX2_B, FN_CC5_TCK, FN_SD0_DAT3, FN_ATAWR1,
	FN_RX2_B, FN_CC5_TDI, FN_SD0_CD, FN_DREQ2,
	FN_RTS1_B_TANS_B, FN_SD0_WP, FN_DACK2, FN_CTS1_B,

	/* IPSR8 */
	FN_HSPI_CLK0, FN_CTS0, FN_USB_OVC0, FN_AD_CLK,
	FN_CC5_STATE4, FN_CC5_STATE12, FN_CC5_STATE20, FN_CC5_STATE28,
	FN_CC5_STATE36, FN_HSPI_CS0, FN_RTS0_TANS, FN_USB_OVC1,
	FN_AD_DI, FN_CC5_STATE5, FN_CC5_STATE13, FN_CC5_STATE21,
	FN_CC5_STATE29, FN_CC5_STATE37, FN_HSPI_TX0, FN_TX0,
	FN_CAN_DEBUG_HW_TRIGGER, FN_AD_DO, FN_CC5_STATE6, FN_CC5_STATE14,
	FN_CC5_STATE22, FN_CC5_STATE30, FN_CC5_STATE38, FN_HSPI_RX0,
	FN_RX0, FN_CAN_STEP0, FN_AD_NCS, FN_CC5_STATE7,
	FN_CC5_STATE15, FN_CC5_STATE23, FN_CC5_STATE31, FN_CC5_STATE39,
	FN_FMCLK, FN_RDS_CLK, FN_PCMOE, FN_BPFCLK,
	FN_PCMWE, FN_FMIN, FN_RDS_DATA, FN_VI0_CLK,
	FN_MMC1_CLK, FN_VI0_CLKENB, FN_TX1_C, FN_HTX1_B,
	FN_MT1_SYNC, FN_VI0_FIELD, FN_RX1_C, FN_HRX1_B,
	FN_VI0_HSYNC, FN_VI0_DATA0_B_VI0_B0_B, FN_CTS1_C, FN_TX4_D,
	FN_MMC1_CMD, FN_HSCK1_B, FN_VI0_VSYNC, FN_VI0_DATA1_B_VI0_B1_B,
	FN_RTS1_C_TANS_C, FN_RX4_D, FN_PWMFSW0_C,

	/* IPSR9 */
	FN_VI0_DATA0_VI0_B0, FN_HRTS1_B, FN_MT1_VCXO, FN_VI0_DATA1_VI0_B1,
	FN_HCTS1_B, FN_MT1_PWM, FN_VI0_DATA2_VI0_B2, FN_MMC1_D0,
	FN_VI0_DATA3_VI0_B3, FN_MMC1_D1, FN_VI0_DATA4_VI0_B4, FN_MMC1_D2,
	FN_VI0_DATA5_VI0_B5, FN_MMC1_D3, FN_VI0_DATA6_VI0_B6, FN_MMC1_D4,
	FN_ARM_TRACEDATA_0, FN_VI0_DATA7_VI0_B7, FN_MMC1_D5,
	FN_ARM_TRACEDATA_1, FN_VI0_G0, FN_SSI_SCK78_C, FN_IRQ0,
	FN_ARM_TRACEDATA_2, FN_VI0_G1, FN_SSI_WS78_C, FN_IRQ1,
	FN_ARM_TRACEDATA_3, FN_VI0_G2, FN_ETH_TXD1, FN_MMC1_D6,
	FN_ARM_TRACEDATA_4, FN_TS_SPSYNC0, FN_VI0_G3, FN_ETH_CRS_DV,
	FN_MMC1_D7, FN_ARM_TRACEDATA_5, FN_TS_SDAT0, FN_VI0_G4,
	FN_ETH_TX_EN, FN_SD2_DAT0_B, FN_ARM_TRACEDATA_6, FN_VI0_G5,
	FN_ETH_RX_ER, FN_SD2_DAT1_B, FN_ARM_TRACEDATA_7, FN_VI0_G6,
	FN_ETH_RXD0, FN_SD2_DAT2_B, FN_ARM_TRACEDATA_8, FN_VI0_G7,
	FN_ETH_RXD1, FN_SD2_DAT3_B, FN_ARM_TRACEDATA_9,

	/* IPSR10 */
	FN_VI0_R0, FN_SSI_SDATA7_C, FN_SCK1_C, FN_DREQ1_B,
	FN_ARM_TRACEDATA_10, FN_DREQ0_C, FN_VI0_R1, FN_SSI_SDATA8_C,
	FN_DACK1_B, FN_ARM_TRACEDATA_11, FN_DACK0_C, FN_DRACK0_C,
	FN_VI0_R2, FN_ETH_LINK, FN_SD2_CLK_B, FN_IRQ2,
	FN_ARM_TRACEDATA_12, FN_VI0_R3, FN_ETH_MAGIC, FN_SD2_CMD_B,
	FN_IRQ3, FN_ARM_TRACEDATA_13, FN_VI0_R4, FN_ETH_REFCLK,
	FN_SD2_CD_B, FN_HSPI_CLK1_B, FN_ARM_TRACEDATA_14, FN_MT1_CLK,
	FN_TS_SCK0, FN_VI0_R5, FN_ETH_TXD0, FN_SD2_WP_B, FN_HSPI_CS1_B,
	FN_ARM_TRACEDATA_15, FN_MT1_D, FN_TS_SDEN0, FN_VI0_R6,
	FN_ETH_MDC, FN_DREQ2_C, FN_HSPI_TX1_B, FN_TRACECLK,
	FN_MT1_BEN, FN_PWMFSW0_D, FN_VI0_R7, FN_ETH_MDIO,
	FN_DACK2_C, FN_HSPI_RX1_B, FN_SCIF_CLK_D, FN_TRACECTL,
	FN_MT1_PEN, FN_VI1_CLK, FN_SIM_D, FN_SDA3,
	FN_VI1_HSYNC, FN_VI3_CLK, FN_SSI_SCK4, FN_GPS_SIGN_C,
	FN_PWMFSW0_E, FN_VI1_VSYNC, FN_AUDIO_CLKOUT_C, FN_SSI_WS4,
	FN_SIM_CLK, FN_GPS_MAG_C, FN_SPV_TRST, FN_SCL3,

	/* IPSR11 */
	FN_VI1_DATA0_VI1_B0, FN_SD2_DAT0, FN_SIM_RST, FN_SPV_TCK,
	FN_ADICLK_B, FN_VI1_DATA1_VI1_B1, FN_SD2_DAT1, FN_MT0_CLK,
	FN_SPV_TMS, FN_ADICS_B_SAMP_B, FN_VI1_DATA2_VI1_B2, FN_SD2_DAT2,
	FN_MT0_D, FN_SPVTDI, FN_ADIDATA_B, FN_VI1_DATA3_VI1_B3,
	FN_SD2_DAT3, FN_MT0_BEN, FN_SPV_TDO, FN_ADICHS0_B,
	FN_VI1_DATA4_VI1_B4, FN_SD2_CLK, FN_MT0_PEN, FN_SPA_TRST,
	FN_HSPI_CLK1_D, FN_ADICHS1_B, FN_VI1_DATA5_VI1_B5, FN_SD2_CMD,
	FN_MT0_SYNC, FN_SPA_TCK, FN_HSPI_CS1_D, FN_ADICHS2_B,
	FN_VI1_DATA6_VI1_B6, FN_SD2_CD, FN_MT0_VCXO, FN_SPA_TMS,
	FN_HSPI_TX1_D, FN_VI1_DATA7_VI1_B7, FN_SD2_WP, FN_MT0_PWM,
	FN_SPA_TDI, FN_HSPI_RX1_D, FN_VI1_G0, FN_VI3_DATA0,
	FN_TS_SCK1, FN_DREQ2_B, FN_TX2,
	FN_SPA_TDO, FN_HCTS0_B, FN_VI1_G1, FN_VI3_DATA1,
	FN_SSI_SCK1, FN_TS_SDEN1, FN_DACK2_B, FN_RX2, FN_HRTS0_B,

	/* IPSR12 */
	FN_VI1_G2, FN_VI3_DATA2, FN_SSI_WS1, FN_TS_SPSYNC1,
	FN_SCK2, FN_HSCK0_B, FN_VI1_G3, FN_VI3_DATA3,
	FN_SSI_SCK2, FN_TS_SDAT1, FN_SCL1_C, FN_HTX0_B,
	FN_VI1_G4, FN_VI3_DATA4, FN_SSI_WS2, FN_SDA1_C,
	FN_SIM_RST_B, FN_HRX0_B, FN_VI1_G5, FN_VI3_DATA5,
	FN_GPS_CLK, FN_FSE, FN_TX4_B, FN_SIM_D_B,
	FN_VI1_G6, FN_VI3_DATA6, FN_GPS_SIGN, FN_FRB,
	FN_RX4_B, FN_SIM_CLK_B, FN_VI1_G7, FN_VI3_DATA7,
	FN_GPS_MAG, FN_FCE, FN_SCK4_B,

	FN_SEL_SCIF5_0, FN_SEL_SCIF5_1, FN_SEL_SCIF5_2, FN_SEL_SCIF5_3,
	FN_SEL_SCIF4_0, FN_SEL_SCIF4_1, FN_SEL_SCIF4_2, FN_SEL_SCIF4_3,
	FN_SEL_SCIF3_0, FN_SEL_SCIF3_1, FN_SEL_SCIF3_2,
	FN_SEL_SCIF3_3, FN_SEL_SCIF3_4,
	FN_SEL_SCIF2_0, FN_SEL_SCIF2_1, FN_SEL_SCIF2_2,
	FN_SEL_SCIF2_3, FN_SEL_SCIF2_4,
	FN_SEL_SCIF1_0, FN_SEL_SCIF1_1, FN_SEL_SCIF1_2,
	FN_SEL_SCIF0_0, FN_SEL_SCIF0_1, FN_SEL_SCIF0_2, FN_SEL_SCIF0_3,
	FN_SEL_SSI9_0, FN_SEL_SSI9_1, FN_SEL_SSI9_2,
	FN_SEL_SSI8_0, FN_SEL_SSI8_1, FN_SEL_SSI8_2,
	FN_SEL_SSI7_0, FN_SEL_SSI7_1, FN_SEL_SSI7_2,
	FN_SEL_VI0_0, FN_SEL_VI0_1,
	FN_SEL_SD2_0, FN_SEL_SD2_1,
	FN_SEL_INT3_0, FN_SEL_INT3_1,
	FN_SEL_INT2_0, FN_SEL_INT2_1,
	FN_SEL_INT1_0, FN_SEL_INT1_1,
	FN_SEL_INT0_0, FN_SEL_INT0_1,
	FN_SEL_IE_0, FN_SEL_IE_1,
	FN_SEL_EXBUS2_0, FN_SEL_EXBUS2_1, FN_SEL_EXBUS2_2,
	FN_SEL_EXBUS1_0, FN_SEL_EXBUS1_1,
	FN_SEL_EXBUS0_0, FN_SEL_EXBUS0_1, FN_SEL_EXBUS0_2,

	FN_SEL_TMU1_0, FN_SEL_TMU1_1, FN_SEL_TMU1_2,
	FN_SEL_TMU0_0, FN_SEL_TMU0_1, FN_SEL_TMU0_2, FN_SEL_TMU0_3,
	FN_SEL_SCIF_0, FN_SEL_SCIF_1, FN_SEL_SCIF_2, FN_SEL_SCIF_3,
	FN_SEL_CANCLK_0, FN_SEL_CANCLK_1, FN_SEL_CANCLK_2,
	FN_SEL_CAN0_0, FN_SEL_CAN0_1,
	FN_SEL_HSCIF1_0, FN_SEL_HSCIF1_1,
	FN_SEL_HSCIF0_0, FN_SEL_HSCIF0_1,
	FN_SEL_PWMFSW_0, FN_SEL_PWMFSW_1, FN_SEL_PWMFSW_2,
	FN_SEL_PWMFSW_3, FN_SEL_PWMFSW_4,
	FN_SEL_ADI_0, FN_SEL_ADI_1,
	FN_SEL_GPS_0, FN_SEL_GPS_1, FN_SEL_GPS_2, FN_SEL_GPS_3,
	FN_SEL_SIM_0, FN_SEL_SIM_1,
	FN_SEL_HSPI2_0, FN_SEL_HSPI2_1,
	FN_SEL_HSPI1_0, FN_SEL_HSPI1_1, FN_SEL_HSPI1_2, FN_SEL_HSPI1_3,
	FN_SEL_I2C3_0, FN_SEL_I2C3_1,
	FN_SEL_I2C2_0, FN_SEL_I2C2_1, FN_SEL_I2C2_2, FN_SEL_I2C2_3,
	FN_SEL_I2C1_0, FN_SEL_I2C1_1, FN_SEL_I2C1_2, FN_SEL_I2C1_3,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,
	AVS1_MARK, AVS2_MARK, A17_MARK, A18_MARK,
	A19_MARK,

	RD_WR_MARK, FWE_MARK, ATAG0_MARK, VI1_R7_MARK,
	HRTS1_MARK, RX4_C_MARK,
	CS1_A26_MARK, HSPI_TX2_MARK, SDSELF_B_MARK,
	CS0_MARK, HSPI_CS2_B_MARK,
	CLKOUT_MARK, TX3C_IRDA_TX_C_MARK, PWM0_B_MARK,
	A25_MARK, SD1_WP_MARK, MMC0_D5_MARK, FD5_MARK,
	HSPI_RX2_MARK, VI1_R3_MARK, TX5_B_MARK, SSI_SDATA7_B_MARK, CTS0_B_MARK,
	A24_MARK, SD1_CD_MARK, MMC0_D4_MARK, FD4_MARK,
	HSPI_CS2_MARK, VI1_R2_MARK, SSI_WS78_B_MARK,
	A23_MARK, FCLE_MARK, HSPI_CLK2_MARK, VI1_R1_MARK,
	A22_MARK, RX5_D_MARK, HSPI_RX2_B_MARK, VI1_R0_MARK,
	A21_MARK, SCK5_D_MARK, HSPI_CLK2_B_MARK,
	A20_MARK, TX5_D_MARK, HSPI_TX2_B_MARK,
	A0_MARK, SD1_DAT3_MARK, MMC0_D3_MARK, FD3_MARK,
	BS_MARK, SD1_DAT2_MARK, MMC0_D2_MARK, FD2_MARK,
	ATADIR0_MARK, SDSELF_MARK, HCTS1_MARK, TX4_C_MARK,
	USB_PENC0_MARK, USB_PENC1_MARK, USB_PENC2_MARK,
	SCK0_MARK, PWM1_MARK, PWMFSW0_MARK,
	SCIF_CLK_MARK, TCLK0_C_MARK,

	EX_CS0_MARK, RX3_C_IRDA_RX_C_MARK, MMC0_D6_MARK,
	FD6_MARK, EX_CS1_MARK, MMC0_D7_MARK, FD7_MARK,
	EX_CS2_MARK, SD1_CLK_MARK, MMC0_CLK_MARK, FALE_MARK,
	ATACS00_MARK, EX_CS3_MARK, SD1_CMD_MARK, MMC0_CMD_MARK,
	FRE_MARK, ATACS10_MARK, VI1_R4_MARK, RX5_B_MARK,
	HSCK1_MARK, SSI_SDATA8_B_MARK, RTS0_B_TANS_B_MARK, SSI_SDATA9_MARK,
	EX_CS4_MARK, SD1_DAT0_MARK, MMC0_D0_MARK, FD0_MARK,
	ATARD0_MARK, VI1_R5_MARK, SCK5_B_MARK, HTX1_MARK,
	TX2_E_MARK, TX0_B_MARK, SSI_SCK9_MARK, EX_CS5_MARK,
	SD1_DAT1_MARK, MMC0_D1_MARK, FD1_MARK, ATAWR0_MARK,
	VI1_R6_MARK, HRX1_MARK, RX2_E_MARK, RX0_B_MARK,
	SSI_WS9_MARK, MLB_CLK_MARK, PWM2_MARK, SCK4_MARK,
	MLB_SIG_MARK, PWM3_MARK, TX4_MARK, MLB_DAT_MARK,
	PWM4_MARK, RX4_MARK, HTX0_MARK, TX1_MARK,
	SDATA_MARK, CTS0_C_MARK, SUB_TCK_MARK, CC5_STATE2_MARK,
	CC5_STATE10_MARK, CC5_STATE18_MARK, CC5_STATE26_MARK, CC5_STATE34_MARK,

	HRX0_MARK, RX1_MARK, SCKZ_MARK, RTS0_C_TANS_C_MARK,
	SUB_TDI_MARK, CC5_STATE3_MARK, CC5_STATE11_MARK, CC5_STATE19_MARK,
	CC5_STATE27_MARK, CC5_STATE35_MARK, HSCK0_MARK, SCK1_MARK,
	MTS_MARK, PWM5_MARK, SCK0_C_MARK, SSI_SDATA9_B_MARK,
	SUB_TDO_MARK, CC5_STATE0_MARK, CC5_STATE8_MARK, CC5_STATE16_MARK,
	CC5_STATE24_MARK, CC5_STATE32_MARK, HCTS0_MARK, CTS1_MARK,
	STM_MARK, PWM0_D_MARK, RX0_C_MARK, SCIF_CLK_C_MARK,
	SUB_TRST_MARK, TCLK1_B_MARK, CC5_OSCOUT_MARK, HRTS0_MARK,
	RTS1_TANS_MARK, MDATA_MARK, TX0_C_MARK, SUB_TMS_MARK,
	CC5_STATE1_MARK, CC5_STATE9_MARK, CC5_STATE17_MARK, CC5_STATE25_MARK,
	CC5_STATE33_MARK, DU0_DR0_MARK, LCDOUT0_MARK, DREQ0_MARK,
	GPS_CLK_B_MARK, AUDATA0_MARK, TX5_C_MARK, DU0_DR1_MARK,
	LCDOUT1_MARK, DACK0_MARK, DRACK0_MARK, GPS_SIGN_B_MARK,
	AUDATA1_MARK, RX5_C_MARK, DU0_DR2_MARK, LCDOUT2_MARK,
	DU0_DR3_MARK, LCDOUT3_MARK, DU0_DR4_MARK, LCDOUT4_MARK,
	DU0_DR5_MARK, LCDOUT5_MARK, DU0_DR6_MARK, LCDOUT6_MARK,
	DU0_DR7_MARK, LCDOUT7_MARK, DU0_DG0_MARK, LCDOUT8_MARK,
	DREQ1_MARK, SCL2_MARK, AUDATA2_MARK,

	DU0_DG1_MARK, LCDOUT9_MARK, DACK1_MARK, SDA2_MARK,
	AUDATA3_MARK, DU0_DG2_MARK, LCDOUT10_MARK, DU0_DG3_MARK,
	LCDOUT11_MARK, DU0_DG4_MARK, LCDOUT12_MARK, DU0_DG5_MARK,
	LCDOUT13_MARK, DU0_DG6_MARK, LCDOUT14_MARK, DU0_DG7_MARK,
	LCDOUT15_MARK, DU0_DB0_MARK, LCDOUT16_MARK, EX_WAIT1_MARK,
	SCL1_MARK, TCLK1_MARK, AUDATA4_MARK, DU0_DB1_MARK,
	LCDOUT17_MARK, EX_WAIT2_MARK, SDA1_MARK, GPS_MAG_B_MARK,
	AUDATA5_MARK, SCK5_C_MARK, DU0_DB2_MARK, LCDOUT18_MARK,
	DU0_DB3_MARK, LCDOUT19_MARK, DU0_DB4_MARK, LCDOUT20_MARK,
	DU0_DB5_MARK, LCDOUT21_MARK, DU0_DB6_MARK, LCDOUT22_MARK,
	DU0_DB7_MARK, LCDOUT23_MARK, DU0_DOTCLKIN_MARK, QSTVA_QVS_MARK,
	TX3_D_IRDA_TX_D_MARK, SCL3_B_MARK, DU0_DOTCLKOUT0_MARK, QCLK_MARK,
	DU0_DOTCLKOUT1_MARK, QSTVB_QVE_MARK, RX3_D_IRDA_RX_D_MARK, SDA3_B_MARK,
	SDA2_C_MARK, DACK0_B_MARK, DRACK0_B_MARK, DU0_EXHSYNC_DU0_HSYNC_MARK,
	QSTH_QHS_MARK, DU0_EXVSYNC_DU0_VSYNC_MARK, QSTB_QHE_MARK,
	DU0_EXODDF_DU0_ODDF_DISP_CDE_MARK, QCPV_QDE_MARK, CAN1_TX_MARK,
	TX2_C_MARK, SCL2_C_MARK, REMOCON_MARK,

	DU0_DISP_MARK, QPOLA_MARK, CAN_CLK_C_MARK, SCK2_C_MARK,
	DU0_CDE_MARK, QPOLB_MARK, CAN1_RX_MARK, RX2_C_MARK,
	DREQ0_B_MARK, SSI_SCK78_B_MARK, SCK0_B_MARK, DU1_DR0_MARK,
	VI2_DATA0_VI2_B0_MARK, PWM6_MARK, SD3_CLK_MARK, TX3_E_IRDA_TX_E_MARK,
	AUDCK_MARK, PWMFSW0_B_MARK, DU1_DR1_MARK, VI2_DATA1_VI2_B1_MARK,
	PWM0_MARK, SD3_CMD_MARK, RX3_E_IRDA_RX_E_MARK, AUDSYNC_MARK,
	CTS0_D_MARK, DU1_DR2_MARK, VI2_G0_MARK, DU1_DR3_MARK,
	VI2_G1_MARK, DU1_DR4_MARK, VI2_G2_MARK, DU1_DR5_MARK,
	VI2_G3_MARK, DU1_DR6_MARK, VI2_G4_MARK, DU1_DR7_MARK,
	VI2_G5_MARK, DU1_DG0_MARK, VI2_DATA2_VI2_B2_MARK, SCL1_B_MARK,
	SD3_DAT2_MARK, SCK3_E_MARK, AUDATA6_MARK, TX0_D_MARK,
	DU1_DG1_MARK, VI2_DATA3_VI2_B3_MARK, SDA1_B_MARK, SD3_DAT3_MARK,
	SCK5_MARK, AUDATA7_MARK, RX0_D_MARK, DU1_DG2_MARK,
	VI2_G6_MARK, DU1_DG3_MARK, VI2_G7_MARK, DU1_DG4_MARK,
	VI2_R0_MARK, DU1_DG5_MARK, VI2_R1_MARK, DU1_DG6_MARK,
	VI2_R2_MARK, DU1_DG7_MARK, VI2_R3_MARK, DU1_DB0_MARK,
	VI2_DATA4_VI2_B4_MARK, SCL2_B_MARK, SD3_DAT0_MARK, TX5_MARK,
	SCK0_D_MARK,

	DU1_DB1_MARK, VI2_DATA5_VI2_B5_MARK, SDA2_B_MARK, SD3_DAT1_MARK,
	RX5_MARK, RTS0_D_TANS_D_MARK, DU1_DB2_MARK, VI2_R4_MARK,
	DU1_DB3_MARK, VI2_R5_MARK, DU1_DB4_MARK, VI2_R6_MARK,
	DU1_DB5_MARK, VI2_R7_MARK, DU1_DB6_MARK, SCL2_D_MARK,
	DU1_DB7_MARK, SDA2_D_MARK, DU1_DOTCLKIN_MARK, VI2_CLKENB_MARK,
	HSPI_CS1_MARK, SCL1_D_MARK, DU1_DOTCLKOUT_MARK, VI2_FIELD_MARK,
	SDA1_D_MARK, DU1_EXHSYNC_DU1_HSYNC_MARK, VI2_HSYNC_MARK,
	VI3_HSYNC_MARK, DU1_EXVSYNC_DU1_VSYNC_MARK, VI2_VSYNC_MARK,
	VI3_VSYNC_MARK, DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK, VI2_CLK_MARK,
	TX3_B_IRDA_TX_B_MARK, SD3_CD_MARK, HSPI_TX1_MARK, VI1_CLKENB_MARK,
	VI3_CLKENB_MARK, AUDIO_CLKC_MARK, TX2_D_MARK, SPEEDIN_MARK,
	GPS_SIGN_D_MARK, DU1_DISP_MARK, VI2_DATA6_VI2_B6_MARK, TCLK0_MARK,
	QSTVA_B_QVS_B_MARK, HSPI_CLK1_MARK, SCK2_D_MARK, AUDIO_CLKOUT_B_MARK,
	GPS_MAG_D_MARK, DU1_CDE_MARK, VI2_DATA7_VI2_B7_MARK,
	RX3_B_IRDA_RX_B_MARK, SD3_WP_MARK, HSPI_RX1_MARK, VI1_FIELD_MARK,
	VI3_FIELD_MARK, AUDIO_CLKOUT_MARK, RX2_D_MARK, GPS_CLK_C_MARK,
	GPS_CLK_D_MARK, AUDIO_CLKA_MARK, CAN_TXCLK_MARK, AUDIO_CLKB_MARK,
	USB_OVC2_MARK, CAN_DEBUGOUT0_MARK, MOUT0_MARK,

	SSI_SCK0129_MARK, CAN_DEBUGOUT1_MARK, MOUT1_MARK, SSI_WS0129_MARK,
	CAN_DEBUGOUT2_MARK, MOUT2_MARK, SSI_SDATA0_MARK, CAN_DEBUGOUT3_MARK,
	MOUT5_MARK, SSI_SDATA1_MARK, CAN_DEBUGOUT4_MARK, MOUT6_MARK,
	SSI_SDATA2_MARK, CAN_DEBUGOUT5_MARK, SSI_SCK34_MARK,
	CAN_DEBUGOUT6_MARK, CAN0_TX_B_MARK, IERX_MARK, SSI_SCK9_C_MARK,
	SSI_WS34_MARK, CAN_DEBUGOUT7_MARK, CAN0_RX_B_MARK, IETX_MARK,
	SSI_WS9_C_MARK,	SSI_SDATA3_MARK, PWM0_C_MARK, CAN_DEBUGOUT8_MARK,
	CAN_CLK_B_MARK,	IECLK_MARK, SCIF_CLK_B_MARK, TCLK0_B_MARK,
	SSI_SDATA4_MARK, CAN_DEBUGOUT9_MARK, SSI_SDATA9_C_MARK, SSI_SCK5_MARK,
	ADICLK_MARK, CAN_DEBUGOUT10_MARK, SCK3_MARK, TCLK0_D_MARK,
	SSI_WS5_MARK, ADICS_SAMP_MARK, CAN_DEBUGOUT11_MARK, TX3_IRDA_TX_MARK,
	SSI_SDATA5_MARK, ADIDATA_MARK, CAN_DEBUGOUT12_MARK, RX3_IRDA_RX_MARK,
	SSI_SCK6_MARK, ADICHS0_MARK, CAN0_TX_MARK, IERX_B_MARK,

	SSI_WS6_MARK, ADICHS1_MARK, CAN0_RX_MARK, IETX_B_MARK,
	SSI_SDATA6_MARK, ADICHS2_MARK, CAN_CLK_MARK, IECLK_B_MARK,
	SSI_SCK78_MARK, CAN_DEBUGOUT13_MARK, IRQ0_B_MARK, SSI_SCK9_B_MARK,
	HSPI_CLK1_C_MARK, SSI_WS78_MARK, CAN_DEBUGOUT14_MARK, IRQ1_B_MARK,
	SSI_WS9_B_MARK, HSPI_CS1_C_MARK, SSI_SDATA7_MARK, CAN_DEBUGOUT15_MARK,
	IRQ2_B_MARK, TCLK1_C_MARK, HSPI_TX1_C_MARK, SSI_SDATA8_MARK,
	VSP_MARK, IRQ3_B_MARK, HSPI_RX1_C_MARK, SD0_CLK_MARK,
	ATACS01_MARK, SCK1_B_MARK, SD0_CMD_MARK, ATACS11_MARK,
	TX1_B_MARK, CC5_TDO_MARK, SD0_DAT0_MARK, ATADIR1_MARK,
	RX1_B_MARK, CC5_TRST_MARK, SD0_DAT1_MARK, ATAG1_MARK,
	SCK2_B_MARK, CC5_TMS_MARK, SD0_DAT2_MARK, ATARD1_MARK,
	TX2_B_MARK, CC5_TCK_MARK, SD0_DAT3_MARK, ATAWR1_MARK,
	RX2_B_MARK, CC5_TDI_MARK, SD0_CD_MARK, DREQ2_MARK,
	RTS1_B_TANS_B_MARK, SD0_WP_MARK, DACK2_MARK, CTS1_B_MARK,

	HSPI_CLK0_MARK, CTS0_MARK, USB_OVC0_MARK, AD_CLK_MARK,
	CC5_STATE4_MARK, CC5_STATE12_MARK, CC5_STATE20_MARK, CC5_STATE28_MARK,
	CC5_STATE36_MARK, HSPI_CS0_MARK, RTS0_TANS_MARK, USB_OVC1_MARK,
	AD_DI_MARK, CC5_STATE5_MARK, CC5_STATE13_MARK, CC5_STATE21_MARK,
	CC5_STATE29_MARK, CC5_STATE37_MARK, HSPI_TX0_MARK, TX0_MARK,
	CAN_DEBUG_HW_TRIGGER_MARK, AD_DO_MARK, CC5_STATE6_MARK,
	CC5_STATE14_MARK, CC5_STATE22_MARK, CC5_STATE30_MARK,
	CC5_STATE38_MARK, HSPI_RX0_MARK, RX0_MARK, CAN_STEP0_MARK,
	AD_NCS_MARK, CC5_STATE7_MARK, CC5_STATE15_MARK, CC5_STATE23_MARK,
	CC5_STATE31_MARK, CC5_STATE39_MARK, FMCLK_MARK, RDS_CLK_MARK,
	PCMOE_MARK, BPFCLK_MARK, PCMWE_MARK, FMIN_MARK, RDS_DATA_MARK,
	VI0_CLK_MARK, MMC1_CLK_MARK, VI0_CLKENB_MARK, TX1_C_MARK, HTX1_B_MARK,
	MT1_SYNC_MARK, VI0_FIELD_MARK, RX1_C_MARK, HRX1_B_MARK,
	VI0_HSYNC_MARK, VI0_DATA0_B_VI0_B0_B_MARK, CTS1_C_MARK, TX4_D_MARK,
	MMC1_CMD_MARK, HSCK1_B_MARK, VI0_VSYNC_MARK, VI0_DATA1_B_VI0_B1_B_MARK,
	RTS1_C_TANS_C_MARK, RX4_D_MARK, PWMFSW0_C_MARK,

	VI0_DATA0_VI0_B0_MARK, HRTS1_B_MARK, MT1_VCXO_MARK,
	VI0_DATA1_VI0_B1_MARK, HCTS1_B_MARK, MT1_PWM_MARK,
	VI0_DATA2_VI0_B2_MARK, MMC1_D0_MARK, VI0_DATA3_VI0_B3_MARK,
	MMC1_D1_MARK, VI0_DATA4_VI0_B4_MARK, MMC1_D2_MARK,
	VI0_DATA5_VI0_B5_MARK, MMC1_D3_MARK, VI0_DATA6_VI0_B6_MARK,
	MMC1_D4_MARK, ARM_TRACEDATA_0_MARK, VI0_DATA7_VI0_B7_MARK,
	MMC1_D5_MARK, ARM_TRACEDATA_1_MARK, VI0_G0_MARK, SSI_SCK78_C_MARK,
	IRQ0_MARK, ARM_TRACEDATA_2_MARK, VI0_G1_MARK, SSI_WS78_C_MARK,
	IRQ1_MARK, ARM_TRACEDATA_3_MARK, VI0_G2_MARK, ETH_TXD1_MARK,
	MMC1_D6_MARK, ARM_TRACEDATA_4_MARK, TS_SPSYNC0_MARK, VI0_G3_MARK,
	ETH_CRS_DV_MARK, MMC1_D7_MARK, ARM_TRACEDATA_5_MARK, TS_SDAT0_MARK,
	VI0_G4_MARK, ETH_TX_EN_MARK, SD2_DAT0_B_MARK, ARM_TRACEDATA_6_MARK,
	VI0_G5_MARK, ETH_RX_ER_MARK, SD2_DAT1_B_MARK, ARM_TRACEDATA_7_MARK,
	VI0_G6_MARK, ETH_RXD0_MARK, SD2_DAT2_B_MARK, ARM_TRACEDATA_8_MARK,
	VI0_G7_MARK, ETH_RXD1_MARK, SD2_DAT3_B_MARK, ARM_TRACEDATA_9_MARK,

	VI0_R0_MARK, SSI_SDATA7_C_MARK, SCK1_C_MARK, DREQ1_B_MARK,
	ARM_TRACEDATA_10_MARK, DREQ0_C_MARK, VI0_R1_MARK, SSI_SDATA8_C_MARK,
	DACK1_B_MARK, ARM_TRACEDATA_11_MARK, DACK0_C_MARK, DRACK0_C_MARK,
	VI0_R2_MARK, ETH_LINK_MARK, SD2_CLK_B_MARK, IRQ2_MARK,
	ARM_TRACEDATA_12_MARK, VI0_R3_MARK, ETH_MAGIC_MARK, SD2_CMD_B_MARK,
	IRQ3_MARK, ARM_TRACEDATA_13_MARK, VI0_R4_MARK, ETH_REFCLK_MARK,
	SD2_CD_B_MARK, HSPI_CLK1_B_MARK, ARM_TRACEDATA_14_MARK, MT1_CLK_MARK,
	TS_SCK0_MARK, VI0_R5_MARK, ETH_TXD0_MARK, SD2_WP_B_MARK,
	HSPI_CS1_B_MARK, ARM_TRACEDATA_15_MARK, MT1_D_MARK, TS_SDEN0_MARK,
	VI0_R6_MARK, ETH_MDC_MARK, DREQ2_C_MARK, HSPI_TX1_B_MARK,
	TRACECLK_MARK, MT1_BEN_MARK, PWMFSW0_D_MARK, VI0_R7_MARK,
	ETH_MDIO_MARK, DACK2_C_MARK, HSPI_RX1_B_MARK, SCIF_CLK_D_MARK,
	TRACECTL_MARK, MT1_PEN_MARK, VI1_CLK_MARK, SIM_D_MARK, SDA3_MARK,
	VI1_HSYNC_MARK, VI3_CLK_MARK, SSI_SCK4_MARK, GPS_SIGN_C_MARK,
	PWMFSW0_E_MARK, VI1_VSYNC_MARK, AUDIO_CLKOUT_C_MARK, SSI_WS4_MARK,
	SIM_CLK_MARK, GPS_MAG_C_MARK, SPV_TRST_MARK, SCL3_MARK,

	VI1_DATA0_VI1_B0_MARK, SD2_DAT0_MARK, SIM_RST_MARK, SPV_TCK_MARK,
	ADICLK_B_MARK, VI1_DATA1_VI1_B1_MARK, SD2_DAT1_MARK, MT0_CLK_MARK,
	SPV_TMS_MARK, ADICS_B_SAMP_B_MARK, VI1_DATA2_VI1_B2_MARK,
	SD2_DAT2_MARK, MT0_D_MARK, SPVTDI_MARK, ADIDATA_B_MARK,
	VI1_DATA3_VI1_B3_MARK, SD2_DAT3_MARK, MT0_BEN_MARK, SPV_TDO_MARK,
	ADICHS0_B_MARK,	VI1_DATA4_VI1_B4_MARK, SD2_CLK_MARK, MT0_PEN_MARK,
	SPA_TRST_MARK, HSPI_CLK1_D_MARK, ADICHS1_B_MARK,
	VI1_DATA5_VI1_B5_MARK, SD2_CMD_MARK, MT0_SYNC_MARK, SPA_TCK_MARK,
	HSPI_CS1_D_MARK, ADICHS2_B_MARK, VI1_DATA6_VI1_B6_MARK, SD2_CD_MARK,
	MT0_VCXO_MARK, SPA_TMS_MARK, HSPI_TX1_D_MARK, VI1_DATA7_VI1_B7_MARK,
	SD2_WP_MARK, MT0_PWM_MARK, SPA_TDI_MARK, HSPI_RX1_D_MARK,
	VI1_G0_MARK, VI3_DATA0_MARK, TS_SCK1_MARK,
	DREQ2_B_MARK, TX2_MARK,	SPA_TDO_MARK, HCTS0_B_MARK,
	VI1_G1_MARK, VI3_DATA1_MARK, SSI_SCK1_MARK, TS_SDEN1_MARK,
	DACK2_B_MARK, RX2_MARK, HRTS0_B_MARK,

	VI1_G2_MARK, VI3_DATA2_MARK, SSI_WS1_MARK, TS_SPSYNC1_MARK,
	SCK2_MARK, HSCK0_B_MARK, VI1_G3_MARK, VI3_DATA3_MARK,
	SSI_SCK2_MARK, TS_SDAT1_MARK, SCL1_C_MARK, HTX0_B_MARK,
	VI1_G4_MARK, VI3_DATA4_MARK, SSI_WS2_MARK, SDA1_C_MARK,
	SIM_RST_B_MARK, HRX0_B_MARK, VI1_G5_MARK, VI3_DATA5_MARK,
	GPS_CLK_MARK, FSE_MARK, TX4_B_MARK, SIM_D_B_MARK,
	VI1_G6_MARK, VI3_DATA6_MARK, GPS_SIGN_MARK, FRB_MARK,
	RX4_B_MARK, SIM_CLK_B_MARK, VI1_G7_MARK, VI3_DATA7_MARK,
	GPS_MAG_MARK, FCE_MARK, SCK4_B_MARK,
	PINMUX_MARK_END,
};

static const u16 pinmux_data[] = {
	PINMUX_DATA_GP_ALL(), /* PINMUX_DATA(GP_M_N_DATA, GP_M_N_FN...), */

	PINMUX_SINGLE(AVS1),
	PINMUX_SINGLE(AVS1),
	PINMUX_SINGLE(A17),
	PINMUX_SINGLE(A18),
	PINMUX_SINGLE(A19),

	PINMUX_SINGLE(USB_PENC0),
	PINMUX_SINGLE(USB_PENC1),

	PINMUX_IPSR_GPSR(IP0_2_0, USB_PENC2),
	PINMUX_IPSR_MSEL(IP0_2_0, SCK0, SEL_SCIF0_0),
	PINMUX_IPSR_GPSR(IP0_2_0, PWM1),
	PINMUX_IPSR_MSEL(IP0_2_0, PWMFSW0, SEL_PWMFSW_0),
	PINMUX_IPSR_MSEL(IP0_2_0, SCIF_CLK, SEL_SCIF_0),
	PINMUX_IPSR_MSEL(IP0_2_0, TCLK0_C, SEL_TMU0_2),
	PINMUX_IPSR_GPSR(IP0_5_3, BS),
	PINMUX_IPSR_GPSR(IP0_5_3, SD1_DAT2),
	PINMUX_IPSR_GPSR(IP0_5_3, MMC0_D2),
	PINMUX_IPSR_GPSR(IP0_5_3, FD2),
	PINMUX_IPSR_GPSR(IP0_5_3, ATADIR0),
	PINMUX_IPSR_GPSR(IP0_5_3, SDSELF),
	PINMUX_IPSR_MSEL(IP0_5_3, HCTS1, SEL_HSCIF1_0),
	PINMUX_IPSR_GPSR(IP0_5_3, TX4_C),
	PINMUX_IPSR_GPSR(IP0_7_6, A0),
	PINMUX_IPSR_GPSR(IP0_7_6, SD1_DAT3),
	PINMUX_IPSR_GPSR(IP0_7_6, MMC0_D3),
	PINMUX_IPSR_GPSR(IP0_7_6, FD3),
	PINMUX_IPSR_GPSR(IP0_9_8, A20),
	PINMUX_IPSR_GPSR(IP0_9_8, TX5_D),
	PINMUX_IPSR_GPSR(IP0_9_8, HSPI_TX2_B),
	PINMUX_IPSR_GPSR(IP0_11_10, A21),
	PINMUX_IPSR_MSEL(IP0_11_10, SCK5_D, SEL_SCIF5_3),
	PINMUX_IPSR_MSEL(IP0_11_10, HSPI_CLK2_B, SEL_HSPI2_1),
	PINMUX_IPSR_GPSR(IP0_13_12, A22),
	PINMUX_IPSR_MSEL(IP0_13_12, RX5_D, SEL_SCIF5_3),
	PINMUX_IPSR_MSEL(IP0_13_12, HSPI_RX2_B, SEL_HSPI2_1),
	PINMUX_IPSR_GPSR(IP0_13_12, VI1_R0),
	PINMUX_IPSR_GPSR(IP0_15_14, A23),
	PINMUX_IPSR_GPSR(IP0_15_14, FCLE),
	PINMUX_IPSR_MSEL(IP0_15_14, HSPI_CLK2, SEL_HSPI2_0),
	PINMUX_IPSR_GPSR(IP0_15_14, VI1_R1),
	PINMUX_IPSR_GPSR(IP0_18_16, A24),
	PINMUX_IPSR_GPSR(IP0_18_16, SD1_CD),
	PINMUX_IPSR_GPSR(IP0_18_16, MMC0_D4),
	PINMUX_IPSR_GPSR(IP0_18_16, FD4),
	PINMUX_IPSR_MSEL(IP0_18_16, HSPI_CS2, SEL_HSPI2_0),
	PINMUX_IPSR_GPSR(IP0_18_16, VI1_R2),
	PINMUX_IPSR_MSEL(IP0_18_16, SSI_WS78_B, SEL_SSI7_1),
	PINMUX_IPSR_GPSR(IP0_22_19, A25),
	PINMUX_IPSR_GPSR(IP0_22_19, SD1_WP),
	PINMUX_IPSR_GPSR(IP0_22_19, MMC0_D5),
	PINMUX_IPSR_GPSR(IP0_22_19, FD5),
	PINMUX_IPSR_MSEL(IP0_22_19, HSPI_RX2, SEL_HSPI2_0),
	PINMUX_IPSR_GPSR(IP0_22_19, VI1_R3),
	PINMUX_IPSR_GPSR(IP0_22_19, TX5_B),
	PINMUX_IPSR_MSEL(IP0_22_19, SSI_SDATA7_B, SEL_SSI7_1),
	PINMUX_IPSR_MSEL(IP0_22_19, CTS0_B, SEL_SCIF0_1),
	PINMUX_IPSR_GPSR(IP0_24_23, CLKOUT),
	PINMUX_IPSR_GPSR(IP0_24_23, TX3C_IRDA_TX_C),
	PINMUX_IPSR_GPSR(IP0_24_23, PWM0_B),
	PINMUX_IPSR_GPSR(IP0_25, CS0),
	PINMUX_IPSR_MSEL(IP0_25, HSPI_CS2_B, SEL_HSPI2_1),
	PINMUX_IPSR_GPSR(IP0_27_26, CS1_A26),
	PINMUX_IPSR_GPSR(IP0_27_26, HSPI_TX2),
	PINMUX_IPSR_GPSR(IP0_27_26, SDSELF_B),
	PINMUX_IPSR_GPSR(IP0_30_28, RD_WR),
	PINMUX_IPSR_GPSR(IP0_30_28, FWE),
	PINMUX_IPSR_GPSR(IP0_30_28, ATAG0),
	PINMUX_IPSR_GPSR(IP0_30_28, VI1_R7),
	PINMUX_IPSR_MSEL(IP0_30_28, HRTS1, SEL_HSCIF1_0),
	PINMUX_IPSR_MSEL(IP0_30_28, RX4_C, SEL_SCIF4_2),

	PINMUX_IPSR_GPSR(IP1_1_0, EX_CS0),
	PINMUX_IPSR_MSEL(IP1_1_0, RX3_C_IRDA_RX_C, SEL_SCIF3_2),
	PINMUX_IPSR_GPSR(IP1_1_0, MMC0_D6),
	PINMUX_IPSR_GPSR(IP1_1_0, FD6),
	PINMUX_IPSR_GPSR(IP1_3_2, EX_CS1),
	PINMUX_IPSR_GPSR(IP1_3_2, MMC0_D7),
	PINMUX_IPSR_GPSR(IP1_3_2, FD7),
	PINMUX_IPSR_GPSR(IP1_6_4, EX_CS2),
	PINMUX_IPSR_GPSR(IP1_6_4, SD1_CLK),
	PINMUX_IPSR_GPSR(IP1_6_4, MMC0_CLK),
	PINMUX_IPSR_GPSR(IP1_6_4, FALE),
	PINMUX_IPSR_GPSR(IP1_6_4, ATACS00),
	PINMUX_IPSR_GPSR(IP1_10_7, EX_CS3),
	PINMUX_IPSR_GPSR(IP1_10_7, SD1_CMD),
	PINMUX_IPSR_GPSR(IP1_10_7, MMC0_CMD),
	PINMUX_IPSR_GPSR(IP1_10_7, FRE),
	PINMUX_IPSR_GPSR(IP1_10_7, ATACS10),
	PINMUX_IPSR_GPSR(IP1_10_7, VI1_R4),
	PINMUX_IPSR_MSEL(IP1_10_7, RX5_B, SEL_SCIF5_1),
	PINMUX_IPSR_MSEL(IP1_10_7, HSCK1, SEL_HSCIF1_0),
	PINMUX_IPSR_MSEL(IP1_10_7, SSI_SDATA8_B, SEL_SSI8_1),
	PINMUX_IPSR_MSEL(IP1_10_7, RTS0_B_TANS_B, SEL_SCIF0_1),
	PINMUX_IPSR_MSEL(IP1_10_7, SSI_SDATA9, SEL_SSI9_0),
	PINMUX_IPSR_GPSR(IP1_14_11, EX_CS4),
	PINMUX_IPSR_GPSR(IP1_14_11, SD1_DAT0),
	PINMUX_IPSR_GPSR(IP1_14_11, MMC0_D0),
	PINMUX_IPSR_GPSR(IP1_14_11, FD0),
	PINMUX_IPSR_GPSR(IP1_14_11, ATARD0),
	PINMUX_IPSR_GPSR(IP1_14_11, VI1_R5),
	PINMUX_IPSR_MSEL(IP1_14_11, SCK5_B, SEL_SCIF5_1),
	PINMUX_IPSR_GPSR(IP1_14_11, HTX1),
	PINMUX_IPSR_GPSR(IP1_14_11, TX2_E),
	PINMUX_IPSR_GPSR(IP1_14_11, TX0_B),
	PINMUX_IPSR_MSEL(IP1_14_11, SSI_SCK9, SEL_SSI9_0),
	PINMUX_IPSR_GPSR(IP1_18_15, EX_CS5),
	PINMUX_IPSR_GPSR(IP1_18_15, SD1_DAT1),
	PINMUX_IPSR_GPSR(IP1_18_15, MMC0_D1),
	PINMUX_IPSR_GPSR(IP1_18_15, FD1),
	PINMUX_IPSR_GPSR(IP1_18_15, ATAWR0),
	PINMUX_IPSR_GPSR(IP1_18_15, VI1_R6),
	PINMUX_IPSR_MSEL(IP1_18_15, HRX1, SEL_HSCIF1_0),
	PINMUX_IPSR_MSEL(IP1_18_15, RX2_E, SEL_SCIF2_4),
	PINMUX_IPSR_MSEL(IP1_18_15, RX0_B, SEL_SCIF0_1),
	PINMUX_IPSR_MSEL(IP1_18_15, SSI_WS9, SEL_SSI9_0),
	PINMUX_IPSR_GPSR(IP1_20_19, MLB_CLK),
	PINMUX_IPSR_GPSR(IP1_20_19, PWM2),
	PINMUX_IPSR_MSEL(IP1_20_19, SCK4, SEL_SCIF4_0),
	PINMUX_IPSR_GPSR(IP1_22_21, MLB_SIG),
	PINMUX_IPSR_GPSR(IP1_22_21, PWM3),
	PINMUX_IPSR_GPSR(IP1_22_21, TX4),
	PINMUX_IPSR_GPSR(IP1_24_23, MLB_DAT),
	PINMUX_IPSR_GPSR(IP1_24_23, PWM4),
	PINMUX_IPSR_MSEL(IP1_24_23, RX4, SEL_SCIF4_0),
	PINMUX_IPSR_GPSR(IP1_28_25, HTX0),
	PINMUX_IPSR_GPSR(IP1_28_25, TX1),
	PINMUX_IPSR_GPSR(IP1_28_25, SDATA),
	PINMUX_IPSR_MSEL(IP1_28_25, CTS0_C, SEL_SCIF0_2),
	PINMUX_IPSR_GPSR(IP1_28_25, SUB_TCK),
	PINMUX_IPSR_GPSR(IP1_28_25, CC5_STATE2),
	PINMUX_IPSR_GPSR(IP1_28_25, CC5_STATE10),
	PINMUX_IPSR_GPSR(IP1_28_25, CC5_STATE18),
	PINMUX_IPSR_GPSR(IP1_28_25, CC5_STATE26),
	PINMUX_IPSR_GPSR(IP1_28_25, CC5_STATE34),

	PINMUX_IPSR_MSEL(IP2_3_0, HRX0, SEL_HSCIF0_0),
	PINMUX_IPSR_MSEL(IP2_3_0, RX1, SEL_SCIF1_0),
	PINMUX_IPSR_GPSR(IP2_3_0, SCKZ),
	PINMUX_IPSR_MSEL(IP2_3_0, RTS0_C_TANS_C, SEL_SCIF0_2),
	PINMUX_IPSR_GPSR(IP2_3_0, SUB_TDI),
	PINMUX_IPSR_GPSR(IP2_3_0, CC5_STATE3),
	PINMUX_IPSR_GPSR(IP2_3_0, CC5_STATE11),
	PINMUX_IPSR_GPSR(IP2_3_0, CC5_STATE19),
	PINMUX_IPSR_GPSR(IP2_3_0, CC5_STATE27),
	PINMUX_IPSR_GPSR(IP2_3_0, CC5_STATE35),
	PINMUX_IPSR_MSEL(IP2_7_4, HSCK0, SEL_HSCIF0_0),
	PINMUX_IPSR_MSEL(IP2_7_4, SCK1, SEL_SCIF1_0),
	PINMUX_IPSR_GPSR(IP2_7_4, MTS),
	PINMUX_IPSR_GPSR(IP2_7_4, PWM5),
	PINMUX_IPSR_MSEL(IP2_7_4, SCK0_C, SEL_SCIF0_2),
	PINMUX_IPSR_MSEL(IP2_7_4, SSI_SDATA9_B, SEL_SSI9_1),
	PINMUX_IPSR_GPSR(IP2_7_4, SUB_TDO),
	PINMUX_IPSR_GPSR(IP2_7_4, CC5_STATE0),
	PINMUX_IPSR_GPSR(IP2_7_4, CC5_STATE8),
	PINMUX_IPSR_GPSR(IP2_7_4, CC5_STATE16),
	PINMUX_IPSR_GPSR(IP2_7_4, CC5_STATE24),
	PINMUX_IPSR_GPSR(IP2_7_4, CC5_STATE32),
	PINMUX_IPSR_MSEL(IP2_11_8, HCTS0, SEL_HSCIF0_0),
	PINMUX_IPSR_MSEL(IP2_11_8, CTS1, SEL_SCIF1_0),
	PINMUX_IPSR_GPSR(IP2_11_8, STM),
	PINMUX_IPSR_GPSR(IP2_11_8, PWM0_D),
	PINMUX_IPSR_MSEL(IP2_11_8, RX0_C, SEL_SCIF0_2),
	PINMUX_IPSR_MSEL(IP2_11_8, SCIF_CLK_C, SEL_SCIF_2),
	PINMUX_IPSR_GPSR(IP2_11_8, SUB_TRST),
	PINMUX_IPSR_MSEL(IP2_11_8, TCLK1_B, SEL_TMU1_1),
	PINMUX_IPSR_GPSR(IP2_11_8, CC5_OSCOUT),
	PINMUX_IPSR_MSEL(IP2_15_12, HRTS0, SEL_HSCIF0_0),
	PINMUX_IPSR_MSEL(IP2_15_12, RTS1_TANS, SEL_SCIF1_0),
	PINMUX_IPSR_GPSR(IP2_15_12, MDATA),
	PINMUX_IPSR_GPSR(IP2_15_12, TX0_C),
	PINMUX_IPSR_GPSR(IP2_15_12, SUB_TMS),
	PINMUX_IPSR_GPSR(IP2_15_12, CC5_STATE1),
	PINMUX_IPSR_GPSR(IP2_15_12, CC5_STATE9),
	PINMUX_IPSR_GPSR(IP2_15_12, CC5_STATE17),
	PINMUX_IPSR_GPSR(IP2_15_12, CC5_STATE25),
	PINMUX_IPSR_GPSR(IP2_15_12, CC5_STATE33),
	PINMUX_IPSR_GPSR(IP2_18_16, DU0_DR0),
	PINMUX_IPSR_GPSR(IP2_18_16, LCDOUT0),
	PINMUX_IPSR_MSEL(IP2_18_16, DREQ0, SEL_EXBUS0_0),
	PINMUX_IPSR_MSEL(IP2_18_16, GPS_CLK_B, SEL_GPS_1),
	PINMUX_IPSR_GPSR(IP2_18_16, AUDATA0),
	PINMUX_IPSR_GPSR(IP2_18_16, TX5_C),
	PINMUX_IPSR_GPSR(IP2_21_19, DU0_DR1),
	PINMUX_IPSR_GPSR(IP2_21_19, LCDOUT1),
	PINMUX_IPSR_GPSR(IP2_21_19, DACK0),
	PINMUX_IPSR_GPSR(IP2_21_19, DRACK0),
	PINMUX_IPSR_MSEL(IP2_21_19, GPS_SIGN_B, SEL_GPS_1),
	PINMUX_IPSR_GPSR(IP2_21_19, AUDATA1),
	PINMUX_IPSR_MSEL(IP2_21_19, RX5_C, SEL_SCIF5_2),
	PINMUX_IPSR_GPSR(IP2_22, DU0_DR2),
	PINMUX_IPSR_GPSR(IP2_22, LCDOUT2),
	PINMUX_IPSR_GPSR(IP2_23, DU0_DR3),
	PINMUX_IPSR_GPSR(IP2_23, LCDOUT3),
	PINMUX_IPSR_GPSR(IP2_24, DU0_DR4),
	PINMUX_IPSR_GPSR(IP2_24, LCDOUT4),
	PINMUX_IPSR_GPSR(IP2_25, DU0_DR5),
	PINMUX_IPSR_GPSR(IP2_25, LCDOUT5),
	PINMUX_IPSR_GPSR(IP2_26, DU0_DR6),
	PINMUX_IPSR_GPSR(IP2_26, LCDOUT6),
	PINMUX_IPSR_GPSR(IP2_27, DU0_DR7),
	PINMUX_IPSR_GPSR(IP2_27, LCDOUT7),
	PINMUX_IPSR_GPSR(IP2_30_28, DU0_DG0),
	PINMUX_IPSR_GPSR(IP2_30_28, LCDOUT8),
	PINMUX_IPSR_MSEL(IP2_30_28, DREQ1, SEL_EXBUS1_0),
	PINMUX_IPSR_MSEL(IP2_30_28, SCL2, SEL_I2C2_0),
	PINMUX_IPSR_GPSR(IP2_30_28, AUDATA2),

	PINMUX_IPSR_GPSR(IP3_2_0, DU0_DG1),
	PINMUX_IPSR_GPSR(IP3_2_0, LCDOUT9),
	PINMUX_IPSR_GPSR(IP3_2_0, DACK1),
	PINMUX_IPSR_MSEL(IP3_2_0, SDA2, SEL_I2C2_0),
	PINMUX_IPSR_GPSR(IP3_2_0, AUDATA3),
	PINMUX_IPSR_GPSR(IP3_3, DU0_DG2),
	PINMUX_IPSR_GPSR(IP3_3, LCDOUT10),
	PINMUX_IPSR_GPSR(IP3_4, DU0_DG3),
	PINMUX_IPSR_GPSR(IP3_4, LCDOUT11),
	PINMUX_IPSR_GPSR(IP3_5, DU0_DG4),
	PINMUX_IPSR_GPSR(IP3_5, LCDOUT12),
	PINMUX_IPSR_GPSR(IP3_6, DU0_DG5),
	PINMUX_IPSR_GPSR(IP3_6, LCDOUT13),
	PINMUX_IPSR_GPSR(IP3_7, DU0_DG6),
	PINMUX_IPSR_GPSR(IP3_7, LCDOUT14),
	PINMUX_IPSR_GPSR(IP3_8, DU0_DG7),
	PINMUX_IPSR_GPSR(IP3_8, LCDOUT15),
	PINMUX_IPSR_GPSR(IP3_11_9, DU0_DB0),
	PINMUX_IPSR_GPSR(IP3_11_9, LCDOUT16),
	PINMUX_IPSR_GPSR(IP3_11_9, EX_WAIT1),
	PINMUX_IPSR_MSEL(IP3_11_9, SCL1, SEL_I2C1_0),
	PINMUX_IPSR_MSEL(IP3_11_9, TCLK1, SEL_TMU1_0),
	PINMUX_IPSR_GPSR(IP3_11_9, AUDATA4),
	PINMUX_IPSR_GPSR(IP3_14_12, DU0_DB1),
	PINMUX_IPSR_GPSR(IP3_14_12, LCDOUT17),
	PINMUX_IPSR_GPSR(IP3_14_12, EX_WAIT2),
	PINMUX_IPSR_MSEL(IP3_14_12, SDA1, SEL_I2C1_0),
	PINMUX_IPSR_MSEL(IP3_14_12, GPS_MAG_B, SEL_GPS_1),
	PINMUX_IPSR_GPSR(IP3_14_12, AUDATA5),
	PINMUX_IPSR_MSEL(IP3_14_12, SCK5_C, SEL_SCIF5_2),
	PINMUX_IPSR_GPSR(IP3_15, DU0_DB2),
	PINMUX_IPSR_GPSR(IP3_15, LCDOUT18),
	PINMUX_IPSR_GPSR(IP3_16, DU0_DB3),
	PINMUX_IPSR_GPSR(IP3_16, LCDOUT19),
	PINMUX_IPSR_GPSR(IP3_17, DU0_DB4),
	PINMUX_IPSR_GPSR(IP3_17, LCDOUT20),
	PINMUX_IPSR_GPSR(IP3_18, DU0_DB5),
	PINMUX_IPSR_GPSR(IP3_18, LCDOUT21),
	PINMUX_IPSR_GPSR(IP3_19, DU0_DB6),
	PINMUX_IPSR_GPSR(IP3_19, LCDOUT22),
	PINMUX_IPSR_GPSR(IP3_20, DU0_DB7),
	PINMUX_IPSR_GPSR(IP3_20, LCDOUT23),
	PINMUX_IPSR_GPSR(IP3_22_21, DU0_DOTCLKIN),
	PINMUX_IPSR_GPSR(IP3_22_21, QSTVA_QVS),
	PINMUX_IPSR_GPSR(IP3_22_21, TX3_D_IRDA_TX_D),
	PINMUX_IPSR_MSEL(IP3_22_21, SCL3_B, SEL_I2C3_1),
	PINMUX_IPSR_GPSR(IP3_23, DU0_DOTCLKOUT0),
	PINMUX_IPSR_GPSR(IP3_23, QCLK),
	PINMUX_IPSR_GPSR(IP3_26_24, DU0_DOTCLKOUT1),
	PINMUX_IPSR_GPSR(IP3_26_24, QSTVB_QVE),
	PINMUX_IPSR_MSEL(IP3_26_24, RX3_D_IRDA_RX_D, SEL_SCIF3_3),
	PINMUX_IPSR_MSEL(IP3_26_24, SDA3_B, SEL_I2C3_1),
	PINMUX_IPSR_MSEL(IP3_26_24, SDA2_C, SEL_I2C2_2),
	PINMUX_IPSR_GPSR(IP3_26_24, DACK0_B),
	PINMUX_IPSR_GPSR(IP3_26_24, DRACK0_B),
	PINMUX_IPSR_GPSR(IP3_27, DU0_EXHSYNC_DU0_HSYNC),
	PINMUX_IPSR_GPSR(IP3_27, QSTH_QHS),
	PINMUX_IPSR_GPSR(IP3_28, DU0_EXVSYNC_DU0_VSYNC),
	PINMUX_IPSR_GPSR(IP3_28, QSTB_QHE),
	PINMUX_IPSR_GPSR(IP3_31_29, DU0_EXODDF_DU0_ODDF_DISP_CDE),
	PINMUX_IPSR_GPSR(IP3_31_29, QCPV_QDE),
	PINMUX_IPSR_GPSR(IP3_31_29, CAN1_TX),
	PINMUX_IPSR_GPSR(IP3_31_29, TX2_C),
	PINMUX_IPSR_MSEL(IP3_31_29, SCL2_C, SEL_I2C2_2),
	PINMUX_IPSR_GPSR(IP3_31_29, REMOCON),

	PINMUX_IPSR_GPSR(IP4_1_0, DU0_DISP),
	PINMUX_IPSR_GPSR(IP4_1_0, QPOLA),
	PINMUX_IPSR_MSEL(IP4_1_0, CAN_CLK_C, SEL_CANCLK_2),
	PINMUX_IPSR_MSEL(IP4_1_0, SCK2_C, SEL_SCIF2_2),
	PINMUX_IPSR_GPSR(IP4_4_2, DU0_CDE),
	PINMUX_IPSR_GPSR(IP4_4_2, QPOLB),
	PINMUX_IPSR_GPSR(IP4_4_2, CAN1_RX),
	PINMUX_IPSR_MSEL(IP4_4_2, RX2_C, SEL_SCIF2_2),
	PINMUX_IPSR_MSEL(IP4_4_2, DREQ0_B, SEL_EXBUS0_1),
	PINMUX_IPSR_MSEL(IP4_4_2, SSI_SCK78_B, SEL_SSI7_1),
	PINMUX_IPSR_MSEL(IP4_4_2, SCK0_B, SEL_SCIF0_1),
	PINMUX_IPSR_GPSR(IP4_7_5, DU1_DR0),
	PINMUX_IPSR_GPSR(IP4_7_5, VI2_DATA0_VI2_B0),
	PINMUX_IPSR_GPSR(IP4_7_5, PWM6),
	PINMUX_IPSR_GPSR(IP4_7_5, SD3_CLK),
	PINMUX_IPSR_GPSR(IP4_7_5, TX3_E_IRDA_TX_E),
	PINMUX_IPSR_GPSR(IP4_7_5, AUDCK),
	PINMUX_IPSR_MSEL(IP4_7_5, PWMFSW0_B, SEL_PWMFSW_1),
	PINMUX_IPSR_GPSR(IP4_10_8, DU1_DR1),
	PINMUX_IPSR_GPSR(IP4_10_8, VI2_DATA1_VI2_B1),
	PINMUX_IPSR_GPSR(IP4_10_8, PWM0),
	PINMUX_IPSR_GPSR(IP4_10_8, SD3_CMD),
	PINMUX_IPSR_MSEL(IP4_10_8, RX3_E_IRDA_RX_E, SEL_SCIF3_4),
	PINMUX_IPSR_GPSR(IP4_10_8, AUDSYNC),
	PINMUX_IPSR_MSEL(IP4_10_8, CTS0_D, SEL_SCIF0_3),
	PINMUX_IPSR_GPSR(IP4_11, DU1_DR2),
	PINMUX_IPSR_GPSR(IP4_11, VI2_G0),
	PINMUX_IPSR_GPSR(IP4_12, DU1_DR3),
	PINMUX_IPSR_GPSR(IP4_12, VI2_G1),
	PINMUX_IPSR_GPSR(IP4_13, DU1_DR4),
	PINMUX_IPSR_GPSR(IP4_13, VI2_G2),
	PINMUX_IPSR_GPSR(IP4_14, DU1_DR5),
	PINMUX_IPSR_GPSR(IP4_14, VI2_G3),
	PINMUX_IPSR_GPSR(IP4_15, DU1_DR6),
	PINMUX_IPSR_GPSR(IP4_15, VI2_G4),
	PINMUX_IPSR_GPSR(IP4_16, DU1_DR7),
	PINMUX_IPSR_GPSR(IP4_16, VI2_G5),
	PINMUX_IPSR_GPSR(IP4_19_17, DU1_DG0),
	PINMUX_IPSR_GPSR(IP4_19_17, VI2_DATA2_VI2_B2),
	PINMUX_IPSR_MSEL(IP4_19_17, SCL1_B, SEL_I2C1_1),
	PINMUX_IPSR_GPSR(IP4_19_17, SD3_DAT2),
	PINMUX_IPSR_MSEL(IP4_19_17, SCK3_E, SEL_SCIF3_4),
	PINMUX_IPSR_GPSR(IP4_19_17, AUDATA6),
	PINMUX_IPSR_GPSR(IP4_19_17, TX0_D),
	PINMUX_IPSR_GPSR(IP4_22_20, DU1_DG1),
	PINMUX_IPSR_GPSR(IP4_22_20, VI2_DATA3_VI2_B3),
	PINMUX_IPSR_MSEL(IP4_22_20, SDA1_B, SEL_I2C1_1),
	PINMUX_IPSR_GPSR(IP4_22_20, SD3_DAT3),
	PINMUX_IPSR_MSEL(IP4_22_20, SCK5, SEL_SCIF5_0),
	PINMUX_IPSR_GPSR(IP4_22_20, AUDATA7),
	PINMUX_IPSR_MSEL(IP4_22_20, RX0_D, SEL_SCIF0_3),
	PINMUX_IPSR_GPSR(IP4_23, DU1_DG2),
	PINMUX_IPSR_GPSR(IP4_23, VI2_G6),
	PINMUX_IPSR_GPSR(IP4_24, DU1_DG3),
	PINMUX_IPSR_GPSR(IP4_24, VI2_G7),
	PINMUX_IPSR_GPSR(IP4_25, DU1_DG4),
	PINMUX_IPSR_GPSR(IP4_25, VI2_R0),
	PINMUX_IPSR_GPSR(IP4_26, DU1_DG5),
	PINMUX_IPSR_GPSR(IP4_26, VI2_R1),
	PINMUX_IPSR_GPSR(IP4_27, DU1_DG6),
	PINMUX_IPSR_GPSR(IP4_27, VI2_R2),
	PINMUX_IPSR_GPSR(IP4_28, DU1_DG7),
	PINMUX_IPSR_GPSR(IP4_28, VI2_R3),
	PINMUX_IPSR_GPSR(IP4_31_29, DU1_DB0),
	PINMUX_IPSR_GPSR(IP4_31_29, VI2_DATA4_VI2_B4),
	PINMUX_IPSR_MSEL(IP4_31_29, SCL2_B, SEL_I2C2_1),
	PINMUX_IPSR_GPSR(IP4_31_29, SD3_DAT0),
	PINMUX_IPSR_GPSR(IP4_31_29, TX5),
	PINMUX_IPSR_MSEL(IP4_31_29, SCK0_D, SEL_SCIF0_3),

	PINMUX_IPSR_GPSR(IP5_2_0, DU1_DB1),
	PINMUX_IPSR_GPSR(IP5_2_0, VI2_DATA5_VI2_B5),
	PINMUX_IPSR_MSEL(IP5_2_0, SDA2_B, SEL_I2C2_1),
	PINMUX_IPSR_GPSR(IP5_2_0, SD3_DAT1),
	PINMUX_IPSR_MSEL(IP5_2_0, RX5, SEL_SCIF5_0),
	PINMUX_IPSR_MSEL(IP5_2_0, RTS0_D_TANS_D, SEL_SCIF0_3),
	PINMUX_IPSR_GPSR(IP5_3, DU1_DB2),
	PINMUX_IPSR_GPSR(IP5_3, VI2_R4),
	PINMUX_IPSR_GPSR(IP5_4, DU1_DB3),
	PINMUX_IPSR_GPSR(IP5_4, VI2_R5),
	PINMUX_IPSR_GPSR(IP5_5, DU1_DB4),
	PINMUX_IPSR_GPSR(IP5_5, VI2_R6),
	PINMUX_IPSR_GPSR(IP5_6, DU1_DB5),
	PINMUX_IPSR_GPSR(IP5_6, VI2_R7),
	PINMUX_IPSR_GPSR(IP5_7, DU1_DB6),
	PINMUX_IPSR_MSEL(IP5_7, SCL2_D, SEL_I2C2_3),
	PINMUX_IPSR_GPSR(IP5_8, DU1_DB7),
	PINMUX_IPSR_MSEL(IP5_8, SDA2_D, SEL_I2C2_3),
	PINMUX_IPSR_GPSR(IP5_10_9, DU1_DOTCLKIN),
	PINMUX_IPSR_GPSR(IP5_10_9, VI2_CLKENB),
	PINMUX_IPSR_MSEL(IP5_10_9, HSPI_CS1, SEL_HSPI1_0),
	PINMUX_IPSR_MSEL(IP5_10_9, SCL1_D, SEL_I2C1_3),
	PINMUX_IPSR_GPSR(IP5_12_11, DU1_DOTCLKOUT),
	PINMUX_IPSR_GPSR(IP5_12_11, VI2_FIELD),
	PINMUX_IPSR_MSEL(IP5_12_11, SDA1_D, SEL_I2C1_3),
	PINMUX_IPSR_GPSR(IP5_14_13, DU1_EXHSYNC_DU1_HSYNC),
	PINMUX_IPSR_GPSR(IP5_14_13, VI2_HSYNC),
	PINMUX_IPSR_GPSR(IP5_14_13, VI3_HSYNC),
	PINMUX_IPSR_GPSR(IP5_16_15, DU1_EXVSYNC_DU1_VSYNC),
	PINMUX_IPSR_GPSR(IP5_16_15, VI2_VSYNC),
	PINMUX_IPSR_GPSR(IP5_16_15, VI3_VSYNC),
	PINMUX_IPSR_GPSR(IP5_20_17, DU1_EXODDF_DU1_ODDF_DISP_CDE),
	PINMUX_IPSR_GPSR(IP5_20_17, VI2_CLK),
	PINMUX_IPSR_GPSR(IP5_20_17, TX3_B_IRDA_TX_B),
	PINMUX_IPSR_GPSR(IP5_20_17, SD3_CD),
	PINMUX_IPSR_GPSR(IP5_20_17, HSPI_TX1),
	PINMUX_IPSR_GPSR(IP5_20_17, VI1_CLKENB),
	PINMUX_IPSR_GPSR(IP5_20_17, VI3_CLKENB),
	PINMUX_IPSR_GPSR(IP5_20_17, AUDIO_CLKC),
	PINMUX_IPSR_GPSR(IP5_20_17, TX2_D),
	PINMUX_IPSR_GPSR(IP5_20_17, SPEEDIN),
	PINMUX_IPSR_MSEL(IP5_20_17, GPS_SIGN_D, SEL_GPS_3),
	PINMUX_IPSR_GPSR(IP5_23_21, DU1_DISP),
	PINMUX_IPSR_GPSR(IP5_23_21, VI2_DATA6_VI2_B6),
	PINMUX_IPSR_MSEL(IP5_23_21, TCLK0, SEL_TMU0_0),
	PINMUX_IPSR_GPSR(IP5_23_21, QSTVA_B_QVS_B),
	PINMUX_IPSR_MSEL(IP5_23_21, HSPI_CLK1, SEL_HSPI1_0),
	PINMUX_IPSR_MSEL(IP5_23_21, SCK2_D, SEL_SCIF2_3),
	PINMUX_IPSR_GPSR(IP5_23_21, AUDIO_CLKOUT_B),
	PINMUX_IPSR_MSEL(IP5_23_21, GPS_MAG_D, SEL_GPS_3),
	PINMUX_IPSR_GPSR(IP5_27_24, DU1_CDE),
	PINMUX_IPSR_GPSR(IP5_27_24, VI2_DATA7_VI2_B7),
	PINMUX_IPSR_MSEL(IP5_27_24, RX3_B_IRDA_RX_B, SEL_SCIF3_1),
	PINMUX_IPSR_GPSR(IP5_27_24, SD3_WP),
	PINMUX_IPSR_MSEL(IP5_27_24, HSPI_RX1, SEL_HSPI1_0),
	PINMUX_IPSR_GPSR(IP5_27_24, VI1_FIELD),
	PINMUX_IPSR_GPSR(IP5_27_24, VI3_FIELD),
	PINMUX_IPSR_GPSR(IP5_27_24, AUDIO_CLKOUT),
	PINMUX_IPSR_MSEL(IP5_27_24, RX2_D, SEL_SCIF2_3),
	PINMUX_IPSR_MSEL(IP5_27_24, GPS_CLK_C, SEL_GPS_2),
	PINMUX_IPSR_MSEL(IP5_27_24, GPS_CLK_D, SEL_GPS_3),
	PINMUX_IPSR_GPSR(IP5_28, AUDIO_CLKA),
	PINMUX_IPSR_GPSR(IP5_28, CAN_TXCLK),
	PINMUX_IPSR_GPSR(IP5_30_29, AUDIO_CLKB),
	PINMUX_IPSR_GPSR(IP5_30_29, USB_OVC2),
	PINMUX_IPSR_GPSR(IP5_30_29, CAN_DEBUGOUT0),
	PINMUX_IPSR_GPSR(IP5_30_29, MOUT0),

	PINMUX_IPSR_GPSR(IP6_1_0, SSI_SCK0129),
	PINMUX_IPSR_GPSR(IP6_1_0, CAN_DEBUGOUT1),
	PINMUX_IPSR_GPSR(IP6_1_0, MOUT1),
	PINMUX_IPSR_GPSR(IP6_3_2, SSI_WS0129),
	PINMUX_IPSR_GPSR(IP6_3_2, CAN_DEBUGOUT2),
	PINMUX_IPSR_GPSR(IP6_3_2, MOUT2),
	PINMUX_IPSR_GPSR(IP6_5_4, SSI_SDATA0),
	PINMUX_IPSR_GPSR(IP6_5_4, CAN_DEBUGOUT3),
	PINMUX_IPSR_GPSR(IP6_5_4, MOUT5),
	PINMUX_IPSR_GPSR(IP6_7_6, SSI_SDATA1),
	PINMUX_IPSR_GPSR(IP6_7_6, CAN_DEBUGOUT4),
	PINMUX_IPSR_GPSR(IP6_7_6, MOUT6),
	PINMUX_IPSR_GPSR(IP6_8, SSI_SDATA2),
	PINMUX_IPSR_GPSR(IP6_8, CAN_DEBUGOUT5),
	PINMUX_IPSR_GPSR(IP6_11_9, SSI_SCK34),
	PINMUX_IPSR_GPSR(IP6_11_9, CAN_DEBUGOUT6),
	PINMUX_IPSR_GPSR(IP6_11_9, CAN0_TX_B),
	PINMUX_IPSR_MSEL(IP6_11_9, IERX, SEL_IE_0),
	PINMUX_IPSR_MSEL(IP6_11_9, SSI_SCK9_C, SEL_SSI9_2),
	PINMUX_IPSR_GPSR(IP6_14_12, SSI_WS34),
	PINMUX_IPSR_GPSR(IP6_14_12, CAN_DEBUGOUT7),
	PINMUX_IPSR_MSEL(IP6_14_12, CAN0_RX_B, SEL_CAN0_1),
	PINMUX_IPSR_GPSR(IP6_14_12, IETX),
	PINMUX_IPSR_MSEL(IP6_14_12, SSI_WS9_C, SEL_SSI9_2),
	PINMUX_IPSR_GPSR(IP6_17_15, SSI_SDATA3),
	PINMUX_IPSR_GPSR(IP6_17_15, PWM0_C),
	PINMUX_IPSR_GPSR(IP6_17_15, CAN_DEBUGOUT8),
	PINMUX_IPSR_MSEL(IP6_17_15, CAN_CLK_B, SEL_CANCLK_1),
	PINMUX_IPSR_MSEL(IP6_17_15, IECLK, SEL_IE_0),
	PINMUX_IPSR_MSEL(IP6_17_15, SCIF_CLK_B, SEL_SCIF_1),
	PINMUX_IPSR_MSEL(IP6_17_15, TCLK0_B, SEL_TMU0_1),
	PINMUX_IPSR_GPSR(IP6_19_18, SSI_SDATA4),
	PINMUX_IPSR_GPSR(IP6_19_18, CAN_DEBUGOUT9),
	PINMUX_IPSR_MSEL(IP6_19_18, SSI_SDATA9_C, SEL_SSI9_2),
	PINMUX_IPSR_GPSR(IP6_22_20, SSI_SCK5),
	PINMUX_IPSR_GPSR(IP6_22_20, ADICLK),
	PINMUX_IPSR_GPSR(IP6_22_20, CAN_DEBUGOUT10),
	PINMUX_IPSR_MSEL(IP6_22_20, SCK3, SEL_SCIF3_0),
	PINMUX_IPSR_MSEL(IP6_22_20, TCLK0_D, SEL_TMU0_3),
	PINMUX_IPSR_GPSR(IP6_24_23, SSI_WS5),
	PINMUX_IPSR_MSEL(IP6_24_23, ADICS_SAMP, SEL_ADI_0),
	PINMUX_IPSR_GPSR(IP6_24_23, CAN_DEBUGOUT11),
	PINMUX_IPSR_GPSR(IP6_24_23, TX3_IRDA_TX),
	PINMUX_IPSR_GPSR(IP6_26_25, SSI_SDATA5),
	PINMUX_IPSR_MSEL(IP6_26_25, ADIDATA, SEL_ADI_0),
	PINMUX_IPSR_GPSR(IP6_26_25, CAN_DEBUGOUT12),
	PINMUX_IPSR_MSEL(IP6_26_25, RX3_IRDA_RX, SEL_SCIF3_0),
	PINMUX_IPSR_GPSR(IP6_30_29, SSI_SCK6),
	PINMUX_IPSR_GPSR(IP6_30_29, ADICHS0),
	PINMUX_IPSR_GPSR(IP6_30_29, CAN0_TX),
	PINMUX_IPSR_MSEL(IP6_30_29, IERX_B, SEL_IE_1),

	PINMUX_IPSR_GPSR(IP7_1_0, SSI_WS6),
	PINMUX_IPSR_GPSR(IP7_1_0, ADICHS1),
	PINMUX_IPSR_MSEL(IP7_1_0, CAN0_RX, SEL_CAN0_0),
	PINMUX_IPSR_GPSR(IP7_1_0, IETX_B),
	PINMUX_IPSR_GPSR(IP7_3_2, SSI_SDATA6),
	PINMUX_IPSR_GPSR(IP7_3_2, ADICHS2),
	PINMUX_IPSR_MSEL(IP7_3_2, CAN_CLK, SEL_CANCLK_0),
	PINMUX_IPSR_MSEL(IP7_3_2, IECLK_B, SEL_IE_1),
	PINMUX_IPSR_MSEL(IP7_6_4, SSI_SCK78, SEL_SSI7_0),
	PINMUX_IPSR_GPSR(IP7_6_4, CAN_DEBUGOUT13),
	PINMUX_IPSR_MSEL(IP7_6_4, IRQ0_B, SEL_INT0_1),
	PINMUX_IPSR_MSEL(IP7_6_4, SSI_SCK9_B, SEL_SSI9_1),
	PINMUX_IPSR_MSEL(IP7_6_4, HSPI_CLK1_C, SEL_HSPI1_2),
	PINMUX_IPSR_MSEL(IP7_9_7, SSI_WS78, SEL_SSI7_0),
	PINMUX_IPSR_GPSR(IP7_9_7, CAN_DEBUGOUT14),
	PINMUX_IPSR_MSEL(IP7_9_7, IRQ1_B, SEL_INT1_1),
	PINMUX_IPSR_MSEL(IP7_9_7, SSI_WS9_B, SEL_SSI9_1),
	PINMUX_IPSR_MSEL(IP7_9_7, HSPI_CS1_C, SEL_HSPI1_2),
	PINMUX_IPSR_MSEL(IP7_12_10, SSI_SDATA7, SEL_SSI7_0),
	PINMUX_IPSR_GPSR(IP7_12_10, CAN_DEBUGOUT15),
	PINMUX_IPSR_MSEL(IP7_12_10, IRQ2_B, SEL_INT2_1),
	PINMUX_IPSR_MSEL(IP7_12_10, TCLK1_C, SEL_TMU1_2),
	PINMUX_IPSR_GPSR(IP7_12_10, HSPI_TX1_C),
	PINMUX_IPSR_MSEL(IP7_14_13, SSI_SDATA8, SEL_SSI8_0),
	PINMUX_IPSR_GPSR(IP7_14_13, VSP),
	PINMUX_IPSR_MSEL(IP7_14_13, IRQ3_B, SEL_INT3_1),
	PINMUX_IPSR_MSEL(IP7_14_13, HSPI_RX1_C, SEL_HSPI1_2),
	PINMUX_IPSR_GPSR(IP7_16_15, SD0_CLK),
	PINMUX_IPSR_GPSR(IP7_16_15, ATACS01),
	PINMUX_IPSR_MSEL(IP7_16_15, SCK1_B, SEL_SCIF1_1),
	PINMUX_IPSR_GPSR(IP7_18_17, SD0_CMD),
	PINMUX_IPSR_GPSR(IP7_18_17, ATACS11),
	PINMUX_IPSR_GPSR(IP7_18_17, TX1_B),
	PINMUX_IPSR_GPSR(IP7_18_17, CC5_TDO),
	PINMUX_IPSR_GPSR(IP7_20_19, SD0_DAT0),
	PINMUX_IPSR_GPSR(IP7_20_19, ATADIR1),
	PINMUX_IPSR_MSEL(IP7_20_19, RX1_B, SEL_SCIF1_1),
	PINMUX_IPSR_GPSR(IP7_20_19, CC5_TRST),
	PINMUX_IPSR_GPSR(IP7_22_21, SD0_DAT1),
	PINMUX_IPSR_GPSR(IP7_22_21, ATAG1),
	PINMUX_IPSR_MSEL(IP7_22_21, SCK2_B, SEL_SCIF2_1),
	PINMUX_IPSR_GPSR(IP7_22_21, CC5_TMS),
	PINMUX_IPSR_GPSR(IP7_24_23, SD0_DAT2),
	PINMUX_IPSR_GPSR(IP7_24_23, ATARD1),
	PINMUX_IPSR_GPSR(IP7_24_23, TX2_B),
	PINMUX_IPSR_GPSR(IP7_24_23, CC5_TCK),
	PINMUX_IPSR_GPSR(IP7_26_25, SD0_DAT3),
	PINMUX_IPSR_GPSR(IP7_26_25, ATAWR1),
	PINMUX_IPSR_MSEL(IP7_26_25, RX2_B, SEL_SCIF2_1),
	PINMUX_IPSR_GPSR(IP7_26_25, CC5_TDI),
	PINMUX_IPSR_GPSR(IP7_28_27, SD0_CD),
	PINMUX_IPSR_MSEL(IP7_28_27, DREQ2, SEL_EXBUS2_0),
	PINMUX_IPSR_MSEL(IP7_28_27, RTS1_B_TANS_B, SEL_SCIF1_1),
	PINMUX_IPSR_GPSR(IP7_30_29, SD0_WP),
	PINMUX_IPSR_GPSR(IP7_30_29, DACK2),
	PINMUX_IPSR_MSEL(IP7_30_29, CTS1_B, SEL_SCIF1_1),

	PINMUX_IPSR_GPSR(IP8_3_0, HSPI_CLK0),
	PINMUX_IPSR_MSEL(IP8_3_0, CTS0, SEL_SCIF0_0),
	PINMUX_IPSR_GPSR(IP8_3_0, USB_OVC0),
	PINMUX_IPSR_GPSR(IP8_3_0, AD_CLK),
	PINMUX_IPSR_GPSR(IP8_3_0, CC5_STATE4),
	PINMUX_IPSR_GPSR(IP8_3_0, CC5_STATE12),
	PINMUX_IPSR_GPSR(IP8_3_0, CC5_STATE20),
	PINMUX_IPSR_GPSR(IP8_3_0, CC5_STATE28),
	PINMUX_IPSR_GPSR(IP8_3_0, CC5_STATE36),
	PINMUX_IPSR_GPSR(IP8_7_4, HSPI_CS0),
	PINMUX_IPSR_MSEL(IP8_7_4, RTS0_TANS, SEL_SCIF0_0),
	PINMUX_IPSR_GPSR(IP8_7_4, USB_OVC1),
	PINMUX_IPSR_GPSR(IP8_7_4, AD_DI),
	PINMUX_IPSR_GPSR(IP8_7_4, CC5_STATE5),
	PINMUX_IPSR_GPSR(IP8_7_4, CC5_STATE13),
	PINMUX_IPSR_GPSR(IP8_7_4, CC5_STATE21),
	PINMUX_IPSR_GPSR(IP8_7_4, CC5_STATE29),
	PINMUX_IPSR_GPSR(IP8_7_4, CC5_STATE37),
	PINMUX_IPSR_GPSR(IP8_11_8, HSPI_TX0),
	PINMUX_IPSR_GPSR(IP8_11_8, TX0),
	PINMUX_IPSR_GPSR(IP8_11_8, CAN_DEBUG_HW_TRIGGER),
	PINMUX_IPSR_GPSR(IP8_11_8, AD_DO),
	PINMUX_IPSR_GPSR(IP8_11_8, CC5_STATE6),
	PINMUX_IPSR_GPSR(IP8_11_8, CC5_STATE14),
	PINMUX_IPSR_GPSR(IP8_11_8, CC5_STATE22),
	PINMUX_IPSR_GPSR(IP8_11_8, CC5_STATE30),
	PINMUX_IPSR_GPSR(IP8_11_8, CC5_STATE38),
	PINMUX_IPSR_GPSR(IP8_15_12, HSPI_RX0),
	PINMUX_IPSR_MSEL(IP8_15_12, RX0, SEL_SCIF0_0),
	PINMUX_IPSR_GPSR(IP8_15_12, CAN_STEP0),
	PINMUX_IPSR_GPSR(IP8_15_12, AD_NCS),
	PINMUX_IPSR_GPSR(IP8_15_12, CC5_STATE7),
	PINMUX_IPSR_GPSR(IP8_15_12, CC5_STATE15),
	PINMUX_IPSR_GPSR(IP8_15_12, CC5_STATE23),
	PINMUX_IPSR_GPSR(IP8_15_12, CC5_STATE31),
	PINMUX_IPSR_GPSR(IP8_15_12, CC5_STATE39),
	PINMUX_IPSR_GPSR(IP8_17_16, FMCLK),
	PINMUX_IPSR_GPSR(IP8_17_16, RDS_CLK),
	PINMUX_IPSR_GPSR(IP8_17_16, PCMOE),
	PINMUX_IPSR_GPSR(IP8_18, BPFCLK),
	PINMUX_IPSR_GPSR(IP8_18, PCMWE),
	PINMUX_IPSR_GPSR(IP8_19, FMIN),
	PINMUX_IPSR_GPSR(IP8_19, RDS_DATA),
	PINMUX_IPSR_GPSR(IP8_20, VI0_CLK),
	PINMUX_IPSR_GPSR(IP8_20, MMC1_CLK),
	PINMUX_IPSR_GPSR(IP8_22_21, VI0_CLKENB),
	PINMUX_IPSR_GPSR(IP8_22_21, TX1_C),
	PINMUX_IPSR_GPSR(IP8_22_21, HTX1_B),
	PINMUX_IPSR_GPSR(IP8_22_21, MT1_SYNC),
	PINMUX_IPSR_GPSR(IP8_24_23, VI0_FIELD),
	PINMUX_IPSR_MSEL(IP8_24_23, RX1_C, SEL_SCIF1_2),
	PINMUX_IPSR_MSEL(IP8_24_23, HRX1_B, SEL_HSCIF1_1),
	PINMUX_IPSR_GPSR(IP8_27_25, VI0_HSYNC),
	PINMUX_IPSR_MSEL(IP8_27_25, VI0_DATA0_B_VI0_B0_B, SEL_VI0_1),
	PINMUX_IPSR_MSEL(IP8_27_25, CTS1_C, SEL_SCIF1_2),
	PINMUX_IPSR_GPSR(IP8_27_25, TX4_D),
	PINMUX_IPSR_GPSR(IP8_27_25, MMC1_CMD),
	PINMUX_IPSR_MSEL(IP8_27_25, HSCK1_B, SEL_HSCIF1_1),
	PINMUX_IPSR_GPSR(IP8_30_28, VI0_VSYNC),
	PINMUX_IPSR_MSEL(IP8_30_28, VI0_DATA1_B_VI0_B1_B, SEL_VI0_1),
	PINMUX_IPSR_MSEL(IP8_30_28, RTS1_C_TANS_C, SEL_SCIF1_2),
	PINMUX_IPSR_MSEL(IP8_30_28, RX4_D, SEL_SCIF4_3),
	PINMUX_IPSR_MSEL(IP8_30_28, PWMFSW0_C, SEL_PWMFSW_2),

	PINMUX_IPSR_MSEL(IP9_1_0, VI0_DATA0_VI0_B0, SEL_VI0_0),
	PINMUX_IPSR_MSEL(IP9_1_0, HRTS1_B, SEL_HSCIF1_1),
	PINMUX_IPSR_GPSR(IP9_1_0, MT1_VCXO),
	PINMUX_IPSR_MSEL(IP9_3_2, VI0_DATA1_VI0_B1, SEL_VI0_0),
	PINMUX_IPSR_MSEL(IP9_3_2, HCTS1_B, SEL_HSCIF1_1),
	PINMUX_IPSR_GPSR(IP9_3_2, MT1_PWM),
	PINMUX_IPSR_GPSR(IP9_4, VI0_DATA2_VI0_B2),
	PINMUX_IPSR_GPSR(IP9_4, MMC1_D0),
	PINMUX_IPSR_GPSR(IP9_5, VI0_DATA3_VI0_B3),
	PINMUX_IPSR_GPSR(IP9_5, MMC1_D1),
	PINMUX_IPSR_GPSR(IP9_6, VI0_DATA4_VI0_B4),
	PINMUX_IPSR_GPSR(IP9_6, MMC1_D2),
	PINMUX_IPSR_GPSR(IP9_7, VI0_DATA5_VI0_B5),
	PINMUX_IPSR_GPSR(IP9_7, MMC1_D3),
	PINMUX_IPSR_GPSR(IP9_9_8, VI0_DATA6_VI0_B6),
	PINMUX_IPSR_GPSR(IP9_9_8, MMC1_D4),
	PINMUX_IPSR_GPSR(IP9_9_8, ARM_TRACEDATA_0),
	PINMUX_IPSR_GPSR(IP9_11_10, VI0_DATA7_VI0_B7),
	PINMUX_IPSR_GPSR(IP9_11_10, MMC1_D5),
	PINMUX_IPSR_GPSR(IP9_11_10, ARM_TRACEDATA_1),
	PINMUX_IPSR_GPSR(IP9_13_12, VI0_G0),
	PINMUX_IPSR_MSEL(IP9_13_12, SSI_SCK78_C, SEL_SSI7_2),
	PINMUX_IPSR_MSEL(IP9_13_12, IRQ0, SEL_INT0_0),
	PINMUX_IPSR_GPSR(IP9_13_12, ARM_TRACEDATA_2),
	PINMUX_IPSR_GPSR(IP9_15_14, VI0_G1),
	PINMUX_IPSR_MSEL(IP9_15_14, SSI_WS78_C, SEL_SSI7_2),
	PINMUX_IPSR_MSEL(IP9_15_14, IRQ1, SEL_INT1_0),
	PINMUX_IPSR_GPSR(IP9_15_14, ARM_TRACEDATA_3),
	PINMUX_IPSR_GPSR(IP9_18_16, VI0_G2),
	PINMUX_IPSR_GPSR(IP9_18_16, ETH_TXD1),
	PINMUX_IPSR_GPSR(IP9_18_16, MMC1_D6),
	PINMUX_IPSR_GPSR(IP9_18_16, ARM_TRACEDATA_4),
	PINMUX_IPSR_GPSR(IP9_18_16, TS_SPSYNC0),
	PINMUX_IPSR_GPSR(IP9_21_19, VI0_G3),
	PINMUX_IPSR_GPSR(IP9_21_19, ETH_CRS_DV),
	PINMUX_IPSR_GPSR(IP9_21_19, MMC1_D7),
	PINMUX_IPSR_GPSR(IP9_21_19, ARM_TRACEDATA_5),
	PINMUX_IPSR_GPSR(IP9_21_19, TS_SDAT0),
	PINMUX_IPSR_GPSR(IP9_23_22, VI0_G4),
	PINMUX_IPSR_GPSR(IP9_23_22, ETH_TX_EN),
	PINMUX_IPSR_MSEL(IP9_23_22, SD2_DAT0_B, SEL_SD2_1),
	PINMUX_IPSR_GPSR(IP9_23_22, ARM_TRACEDATA_6),
	PINMUX_IPSR_GPSR(IP9_25_24, VI0_G5),
	PINMUX_IPSR_GPSR(IP9_25_24, ETH_RX_ER),
	PINMUX_IPSR_MSEL(IP9_25_24, SD2_DAT1_B, SEL_SD2_1),
	PINMUX_IPSR_GPSR(IP9_25_24, ARM_TRACEDATA_7),
	PINMUX_IPSR_GPSR(IP9_27_26, VI0_G6),
	PINMUX_IPSR_GPSR(IP9_27_26, ETH_RXD0),
	PINMUX_IPSR_MSEL(IP9_27_26, SD2_DAT2_B, SEL_SD2_1),
	PINMUX_IPSR_GPSR(IP9_27_26, ARM_TRACEDATA_8),
	PINMUX_IPSR_GPSR(IP9_29_28, VI0_G7),
	PINMUX_IPSR_GPSR(IP9_29_28, ETH_RXD1),
	PINMUX_IPSR_MSEL(IP9_29_28, SD2_DAT3_B, SEL_SD2_1),
	PINMUX_IPSR_GPSR(IP9_29_28, ARM_TRACEDATA_9),

	PINMUX_IPSR_GPSR(IP10_2_0, VI0_R0),
	PINMUX_IPSR_MSEL(IP10_2_0, SSI_SDATA7_C, SEL_SSI7_2),
	PINMUX_IPSR_MSEL(IP10_2_0, SCK1_C, SEL_SCIF1_2),
	PINMUX_IPSR_MSEL(IP10_2_0, DREQ1_B, SEL_EXBUS1_0),
	PINMUX_IPSR_GPSR(IP10_2_0, ARM_TRACEDATA_10),
	PINMUX_IPSR_MSEL(IP10_2_0, DREQ0_C, SEL_EXBUS0_2),
	PINMUX_IPSR_GPSR(IP10_5_3, VI0_R1),
	PINMUX_IPSR_MSEL(IP10_5_3, SSI_SDATA8_C, SEL_SSI8_2),
	PINMUX_IPSR_GPSR(IP10_5_3, DACK1_B),
	PINMUX_IPSR_GPSR(IP10_5_3, ARM_TRACEDATA_11),
	PINMUX_IPSR_GPSR(IP10_5_3, DACK0_C),
	PINMUX_IPSR_GPSR(IP10_5_3, DRACK0_C),
	PINMUX_IPSR_GPSR(IP10_8_6, VI0_R2),
	PINMUX_IPSR_GPSR(IP10_8_6, ETH_LINK),
	PINMUX_IPSR_GPSR(IP10_8_6, SD2_CLK_B),
	PINMUX_IPSR_MSEL(IP10_8_6, IRQ2, SEL_INT2_0),
	PINMUX_IPSR_GPSR(IP10_8_6, ARM_TRACEDATA_12),
	PINMUX_IPSR_GPSR(IP10_11_9, VI0_R3),
	PINMUX_IPSR_GPSR(IP10_11_9, ETH_MAGIC),
	PINMUX_IPSR_MSEL(IP10_11_9, SD2_CMD_B, SEL_SD2_1),
	PINMUX_IPSR_MSEL(IP10_11_9, IRQ3, SEL_INT3_0),
	PINMUX_IPSR_GPSR(IP10_11_9, ARM_TRACEDATA_13),
	PINMUX_IPSR_GPSR(IP10_14_12, VI0_R4),
	PINMUX_IPSR_GPSR(IP10_14_12, ETH_REFCLK),
	PINMUX_IPSR_MSEL(IP10_14_12, SD2_CD_B, SEL_SD2_1),
	PINMUX_IPSR_MSEL(IP10_14_12, HSPI_CLK1_B, SEL_HSPI1_1),
	PINMUX_IPSR_GPSR(IP10_14_12, ARM_TRACEDATA_14),
	PINMUX_IPSR_GPSR(IP10_14_12, MT1_CLK),
	PINMUX_IPSR_GPSR(IP10_14_12, TS_SCK0),
	PINMUX_IPSR_GPSR(IP10_17_15, VI0_R5),
	PINMUX_IPSR_GPSR(IP10_17_15, ETH_TXD0),
	PINMUX_IPSR_MSEL(IP10_17_15, SD2_WP_B, SEL_SD2_1),
	PINMUX_IPSR_MSEL(IP10_17_15, HSPI_CS1_B, SEL_HSPI1_1),
	PINMUX_IPSR_GPSR(IP10_17_15, ARM_TRACEDATA_15),
	PINMUX_IPSR_GPSR(IP10_17_15, MT1_D),
	PINMUX_IPSR_GPSR(IP10_17_15, TS_SDEN0),
	PINMUX_IPSR_GPSR(IP10_20_18, VI0_R6),
	PINMUX_IPSR_GPSR(IP10_20_18, ETH_MDC),
	PINMUX_IPSR_MSEL(IP10_20_18, DREQ2_C, SEL_EXBUS2_2),
	PINMUX_IPSR_GPSR(IP10_20_18, HSPI_TX1_B),
	PINMUX_IPSR_GPSR(IP10_20_18, TRACECLK),
	PINMUX_IPSR_GPSR(IP10_20_18, MT1_BEN),
	PINMUX_IPSR_MSEL(IP10_20_18, PWMFSW0_D, SEL_PWMFSW_3),
	PINMUX_IPSR_GPSR(IP10_23_21, VI0_R7),
	PINMUX_IPSR_GPSR(IP10_23_21, ETH_MDIO),
	PINMUX_IPSR_GPSR(IP10_23_21, DACK2_C),
	PINMUX_IPSR_MSEL(IP10_23_21, HSPI_RX1_B, SEL_HSPI1_1),
	PINMUX_IPSR_MSEL(IP10_23_21, SCIF_CLK_D, SEL_SCIF_3),
	PINMUX_IPSR_GPSR(IP10_23_21, TRACECTL),
	PINMUX_IPSR_GPSR(IP10_23_21, MT1_PEN),
	PINMUX_IPSR_GPSR(IP10_25_24, VI1_CLK),
	PINMUX_IPSR_MSEL(IP10_25_24, SIM_D, SEL_SIM_0),
	PINMUX_IPSR_MSEL(IP10_25_24, SDA3, SEL_I2C3_0),
	PINMUX_IPSR_GPSR(IP10_28_26, VI1_HSYNC),
	PINMUX_IPSR_GPSR(IP10_28_26, VI3_CLK),
	PINMUX_IPSR_GPSR(IP10_28_26, SSI_SCK4),
	PINMUX_IPSR_MSEL(IP10_28_26, GPS_SIGN_C, SEL_GPS_2),
	PINMUX_IPSR_MSEL(IP10_28_26, PWMFSW0_E, SEL_PWMFSW_4),
	PINMUX_IPSR_GPSR(IP10_31_29, VI1_VSYNC),
	PINMUX_IPSR_GPSR(IP10_31_29, AUDIO_CLKOUT_C),
	PINMUX_IPSR_GPSR(IP10_31_29, SSI_WS4),
	PINMUX_IPSR_GPSR(IP10_31_29, SIM_CLK),
	PINMUX_IPSR_MSEL(IP10_31_29, GPS_MAG_C, SEL_GPS_2),
	PINMUX_IPSR_GPSR(IP10_31_29, SPV_TRST),
	PINMUX_IPSR_MSEL(IP10_31_29, SCL3, SEL_I2C3_0),

	PINMUX_IPSR_GPSR(IP11_2_0, VI1_DATA0_VI1_B0),
	PINMUX_IPSR_MSEL(IP11_2_0, SD2_DAT0, SEL_SD2_0),
	PINMUX_IPSR_GPSR(IP11_2_0, SIM_RST),
	PINMUX_IPSR_GPSR(IP11_2_0, SPV_TCK),
	PINMUX_IPSR_GPSR(IP11_2_0, ADICLK_B),
	PINMUX_IPSR_GPSR(IP11_5_3, VI1_DATA1_VI1_B1),
	PINMUX_IPSR_MSEL(IP11_5_3, SD2_DAT1, SEL_SD2_0),
	PINMUX_IPSR_GPSR(IP11_5_3, MT0_CLK),
	PINMUX_IPSR_GPSR(IP11_5_3, SPV_TMS),
	PINMUX_IPSR_MSEL(IP11_5_3, ADICS_B_SAMP_B, SEL_ADI_1),
	PINMUX_IPSR_GPSR(IP11_8_6, VI1_DATA2_VI1_B2),
	PINMUX_IPSR_MSEL(IP11_8_6, SD2_DAT2, SEL_SD2_0),
	PINMUX_IPSR_GPSR(IP11_8_6, MT0_D),
	PINMUX_IPSR_GPSR(IP11_8_6, SPVTDI),
	PINMUX_IPSR_MSEL(IP11_8_6, ADIDATA_B, SEL_ADI_1),
	PINMUX_IPSR_GPSR(IP11_11_9, VI1_DATA3_VI1_B3),
	PINMUX_IPSR_MSEL(IP11_11_9, SD2_DAT3, SEL_SD2_0),
	PINMUX_IPSR_GPSR(IP11_11_9, MT0_BEN),
	PINMUX_IPSR_GPSR(IP11_11_9, SPV_TDO),
	PINMUX_IPSR_GPSR(IP11_11_9, ADICHS0_B),
	PINMUX_IPSR_GPSR(IP11_14_12, VI1_DATA4_VI1_B4),
	PINMUX_IPSR_GPSR(IP11_14_12, SD2_CLK),
	PINMUX_IPSR_GPSR(IP11_14_12, MT0_PEN),
	PINMUX_IPSR_GPSR(IP11_14_12, SPA_TRST),
	PINMUX_IPSR_MSEL(IP11_14_12, HSPI_CLK1_D, SEL_HSPI1_3),
	PINMUX_IPSR_GPSR(IP11_14_12, ADICHS1_B),
	PINMUX_IPSR_GPSR(IP11_17_15, VI1_DATA5_VI1_B5),
	PINMUX_IPSR_MSEL(IP11_17_15, SD2_CMD, SEL_SD2_0),
	PINMUX_IPSR_GPSR(IP11_17_15, MT0_SYNC),
	PINMUX_IPSR_GPSR(IP11_17_15, SPA_TCK),
	PINMUX_IPSR_MSEL(IP11_17_15, HSPI_CS1_D, SEL_HSPI1_3),
	PINMUX_IPSR_GPSR(IP11_17_15, ADICHS2_B),
	PINMUX_IPSR_GPSR(IP11_20_18, VI1_DATA6_VI1_B6),
	PINMUX_IPSR_MSEL(IP11_20_18, SD2_CD, SEL_SD2_0),
	PINMUX_IPSR_GPSR(IP11_20_18, MT0_VCXO),
	PINMUX_IPSR_GPSR(IP11_20_18, SPA_TMS),
	PINMUX_IPSR_GPSR(IP11_20_18, HSPI_TX1_D),
	PINMUX_IPSR_GPSR(IP11_23_21, VI1_DATA7_VI1_B7),
	PINMUX_IPSR_MSEL(IP11_23_21, SD2_WP, SEL_SD2_0),
	PINMUX_IPSR_GPSR(IP11_23_21, MT0_PWM),
	PINMUX_IPSR_GPSR(IP11_23_21, SPA_TDI),
	PINMUX_IPSR_MSEL(IP11_23_21, HSPI_RX1_D, SEL_HSPI1_3),
	PINMUX_IPSR_GPSR(IP11_26_24, VI1_G0),
	PINMUX_IPSR_GPSR(IP11_26_24, VI3_DATA0),
	PINMUX_IPSR_GPSR(IP11_26_24, TS_SCK1),
	PINMUX_IPSR_MSEL(IP11_26_24, DREQ2_B, SEL_EXBUS2_1),
	PINMUX_IPSR_GPSR(IP11_26_24, TX2),
	PINMUX_IPSR_GPSR(IP11_26_24, SPA_TDO),
	PINMUX_IPSR_MSEL(IP11_26_24, HCTS0_B, SEL_HSCIF0_1),
	PINMUX_IPSR_GPSR(IP11_29_27, VI1_G1),
	PINMUX_IPSR_GPSR(IP11_29_27, VI3_DATA1),
	PINMUX_IPSR_GPSR(IP11_29_27, SSI_SCK1),
	PINMUX_IPSR_GPSR(IP11_29_27, TS_SDEN1),
	PINMUX_IPSR_GPSR(IP11_29_27, DACK2_B),
	PINMUX_IPSR_MSEL(IP11_29_27, RX2, SEL_SCIF2_0),
	PINMUX_IPSR_MSEL(IP11_29_27, HRTS0_B, SEL_HSCIF0_1),

	PINMUX_IPSR_GPSR(IP12_2_0, VI1_G2),
	PINMUX_IPSR_GPSR(IP12_2_0, VI3_DATA2),
	PINMUX_IPSR_GPSR(IP12_2_0, SSI_WS1),
	PINMUX_IPSR_GPSR(IP12_2_0, TS_SPSYNC1),
	PINMUX_IPSR_MSEL(IP12_2_0, SCK2, SEL_SCIF2_0),
	PINMUX_IPSR_MSEL(IP12_2_0, HSCK0_B, SEL_HSCIF0_1),
	PINMUX_IPSR_GPSR(IP12_5_3, VI1_G3),
	PINMUX_IPSR_GPSR(IP12_5_3, VI3_DATA3),
	PINMUX_IPSR_GPSR(IP12_5_3, SSI_SCK2),
	PINMUX_IPSR_GPSR(IP12_5_3, TS_SDAT1),
	PINMUX_IPSR_MSEL(IP12_5_3, SCL1_C, SEL_I2C1_2),
	PINMUX_IPSR_GPSR(IP12_5_3, HTX0_B),
	PINMUX_IPSR_GPSR(IP12_8_6, VI1_G4),
	PINMUX_IPSR_GPSR(IP12_8_6, VI3_DATA4),
	PINMUX_IPSR_GPSR(IP12_8_6, SSI_WS2),
	PINMUX_IPSR_MSEL(IP12_8_6, SDA1_C, SEL_I2C1_2),
	PINMUX_IPSR_GPSR(IP12_8_6, SIM_RST_B),
	PINMUX_IPSR_MSEL(IP12_8_6, HRX0_B, SEL_HSCIF0_1),
	PINMUX_IPSR_GPSR(IP12_11_9, VI1_G5),
	PINMUX_IPSR_GPSR(IP12_11_9, VI3_DATA5),
	PINMUX_IPSR_MSEL(IP12_11_9, GPS_CLK, SEL_GPS_0),
	PINMUX_IPSR_GPSR(IP12_11_9, FSE),
	PINMUX_IPSR_GPSR(IP12_11_9, TX4_B),
	PINMUX_IPSR_MSEL(IP12_11_9, SIM_D_B, SEL_SIM_1),
	PINMUX_IPSR_GPSR(IP12_14_12, VI1_G6),
	PINMUX_IPSR_GPSR(IP12_14_12, VI3_DATA6),
	PINMUX_IPSR_MSEL(IP12_14_12, GPS_SIGN, SEL_GPS_0),
	PINMUX_IPSR_GPSR(IP12_14_12, FRB),
	PINMUX_IPSR_MSEL(IP12_14_12, RX4_B, SEL_SCIF4_1),
	PINMUX_IPSR_GPSR(IP12_14_12, SIM_CLK_B),
	PINMUX_IPSR_GPSR(IP12_17_15, VI1_G7),
	PINMUX_IPSR_GPSR(IP12_17_15, VI3_DATA7),
	PINMUX_IPSR_MSEL(IP12_17_15, GPS_MAG, SEL_GPS_0),
	PINMUX_IPSR_GPSR(IP12_17_15, FCE),
	PINMUX_IPSR_MSEL(IP12_17_15, SCK4_B, SEL_SCIF4_1),
};

static const struct sh_pfc_pin pinmux_pins[] = {
	PINMUX_GPIO_GP_ALL(),
};

/* - DU0 -------------------------------------------------------------------- */
static const unsigned int du0_rgb666_pins[] = {
	/* R[7:2], G[7:2], B[7:2] */
	RCAR_GP_PIN(5, 28), RCAR_GP_PIN(5, 27), RCAR_GP_PIN(5, 26),
	RCAR_GP_PIN(5, 25), RCAR_GP_PIN(5, 24), RCAR_GP_PIN(5, 23),
	RCAR_GP_PIN(6, 2),  RCAR_GP_PIN(6, 1),  RCAR_GP_PIN(6, 0),
	RCAR_GP_PIN(5, 31), RCAR_GP_PIN(5, 30), RCAR_GP_PIN(5, 29),
	RCAR_GP_PIN(6, 8),  RCAR_GP_PIN(6, 7),  RCAR_GP_PIN(6, 6),
	RCAR_GP_PIN(6, 5),  RCAR_GP_PIN(6, 4),  RCAR_GP_PIN(6, 3),
};
static const unsigned int du0_rgb666_mux[] = {
	DU0_DR7_MARK, DU0_DR6_MARK, DU0_DR5_MARK, DU0_DR4_MARK,
	DU0_DR3_MARK, DU0_DR2_MARK,
	DU0_DG7_MARK, DU0_DG6_MARK, DU0_DG5_MARK, DU0_DG4_MARK,
	DU0_DG3_MARK, DU0_DG2_MARK,
	DU0_DB7_MARK, DU0_DB6_MARK, DU0_DB5_MARK, DU0_DB4_MARK,
	DU0_DB3_MARK, DU0_DB2_MARK,
};
static const unsigned int du0_rgb888_pins[] = {
	/* R[7:0], G[7:0], B[7:0] */
	RCAR_GP_PIN(5, 28), RCAR_GP_PIN(5, 27), RCAR_GP_PIN(5, 26),
	RCAR_GP_PIN(5, 25), RCAR_GP_PIN(5, 24), RCAR_GP_PIN(5, 23),
	RCAR_GP_PIN(0, 24), RCAR_GP_PIN(0, 23), RCAR_GP_PIN(6, 2),
	RCAR_GP_PIN(6, 1),  RCAR_GP_PIN(6, 0),  RCAR_GP_PIN(5, 31),
	RCAR_GP_PIN(5, 30), RCAR_GP_PIN(5, 29), RCAR_GP_PIN(0, 26),
	RCAR_GP_PIN(0, 25), RCAR_GP_PIN(6, 8),  RCAR_GP_PIN(6, 7),
	RCAR_GP_PIN(6, 6),  RCAR_GP_PIN(6, 5),  RCAR_GP_PIN(6, 4),
	RCAR_GP_PIN(6, 3),  RCAR_GP_PIN(0, 28), RCAR_GP_PIN(0, 27),
};
static const unsigned int du0_rgb888_mux[] = {
	DU0_DR7_MARK, DU0_DR6_MARK, DU0_DR5_MARK, DU0_DR4_MARK,
	DU0_DR3_MARK, DU0_DR2_MARK, DU0_DR1_MARK, DU0_DR0_MARK,
	DU0_DG7_MARK, DU0_DG6_MARK, DU0_DG5_MARK, DU0_DG4_MARK,
	DU0_DG3_MARK, DU0_DG2_MARK, DU0_DG1_MARK, DU0_DG0_MARK,
	DU0_DB7_MARK, DU0_DB6_MARK, DU0_DB5_MARK, DU0_DB4_MARK,
	DU0_DB3_MARK, DU0_DB2_MARK, DU0_DB1_MARK, DU0_DB0_MARK,
};
static const unsigned int du0_clk_in_pins[] = {
	/* CLKIN */
	RCAR_GP_PIN(0, 29),
};
static const unsigned int du0_clk_in_mux[] = {
	DU0_DOTCLKIN_MARK,
};
static const unsigned int du0_clk_out_0_pins[] = {
	/* CLKOUT */
	RCAR_GP_PIN(5, 20),
};
static const unsigned int du0_clk_out_0_mux[] = {
	DU0_DOTCLKOUT0_MARK,
};
static const unsigned int du0_clk_out_1_pins[] = {
	/* CLKOUT */
	RCAR_GP_PIN(0, 30),
};
static const unsigned int du0_clk_out_1_mux[] = {
	DU0_DOTCLKOUT1_MARK,
};
static const unsigned int du0_sync_0_pins[] = {
	/* VSYNC, HSYNC, DISP */
	RCAR_GP_PIN(5, 22), RCAR_GP_PIN(5, 21), RCAR_GP_PIN(0, 31),
};
static const unsigned int du0_sync_0_mux[] = {
	DU0_EXHSYNC_DU0_HSYNC_MARK, DU0_EXVSYNC_DU0_VSYNC_MARK,
	DU0_EXODDF_DU0_ODDF_DISP_CDE_MARK
};
static const unsigned int du0_sync_1_pins[] = {
	/* VSYNC, HSYNC, DISP */
	RCAR_GP_PIN(5, 22), RCAR_GP_PIN(5, 21), RCAR_GP_PIN(1, 0),
};
static const unsigned int du0_sync_1_mux[] = {
	DU0_EXHSYNC_DU0_HSYNC_MARK, DU0_EXVSYNC_DU0_VSYNC_MARK,
	DU0_DISP_MARK
};
static const unsigned int du0_oddf_pins[] = {
	/* ODDF */
	RCAR_GP_PIN(0, 31),
};
static const unsigned int du0_oddf_mux[] = {
	DU0_EXODDF_DU0_ODDF_DISP_CDE_MARK
};
static const unsigned int du0_cde_pins[] = {
	/* CDE */
	RCAR_GP_PIN(1, 1),
};
static const unsigned int du0_cde_mux[] = {
	DU0_CDE_MARK
};
/* - DU1 -------------------------------------------------------------------- */
static const unsigned int du1_rgb666_pins[] = {
	/* R[7:2], G[7:2], B[7:2] */
	RCAR_GP_PIN(1, 9),  RCAR_GP_PIN(1, 8),  RCAR_GP_PIN(1, 7),
	RCAR_GP_PIN(1, 6),  RCAR_GP_PIN(1, 5),  RCAR_GP_PIN(1, 4),
	RCAR_GP_PIN(1, 17), RCAR_GP_PIN(1, 16), RCAR_GP_PIN(1, 15),
	RCAR_GP_PIN(1, 14), RCAR_GP_PIN(1, 13), RCAR_GP_PIN(1, 12),
	RCAR_GP_PIN(1, 25), RCAR_GP_PIN(1, 24), RCAR_GP_PIN(1, 23),
	RCAR_GP_PIN(1, 22), RCAR_GP_PIN(1, 21), RCAR_GP_PIN(1, 20),
};
static const unsigned int du1_rgb666_mux[] = {
	DU1_DR7_MARK, DU1_DR6_MARK, DU1_DR5_MARK, DU1_DR4_MARK,
	DU1_DR3_MARK, DU1_DR2_MARK,
	DU1_DG7_MARK, DU1_DG6_MARK, DU1_DG5_MARK, DU1_DG4_MARK,
	DU1_DG3_MARK, DU1_DG2_MARK,
	DU1_DB7_MARK, DU1_DB6_MARK, DU1_DB5_MARK, DU1_DB4_MARK,
	DU1_DB3_MARK, DU1_DB2_MARK,
};
static const unsigned int du1_rgb888_pins[] = {
	/* R[7:0], G[7:0], B[7:0] */
	RCAR_GP_PIN(1, 9),  RCAR_GP_PIN(1, 8),  RCAR_GP_PIN(1, 7),
	RCAR_GP_PIN(1, 6),  RCAR_GP_PIN(1, 5),  RCAR_GP_PIN(1, 4),
	RCAR_GP_PIN(1, 3),  RCAR_GP_PIN(1, 2),  RCAR_GP_PIN(1, 17),
	RCAR_GP_PIN(1, 16), RCAR_GP_PIN(1, 15), RCAR_GP_PIN(1, 14),
	RCAR_GP_PIN(1, 13), RCAR_GP_PIN(1, 12), RCAR_GP_PIN(1, 11),
	RCAR_GP_PIN(1, 0),  RCAR_GP_PIN(1, 25), RCAR_GP_PIN(1, 24),
	RCAR_GP_PIN(1, 23), RCAR_GP_PIN(1, 22), RCAR_GP_PIN(1, 21),
	RCAR_GP_PIN(1, 20), RCAR_GP_PIN(1, 19), RCAR_GP_PIN(1, 18),
};
static const unsigned int du1_rgb888_mux[] = {
	DU1_DR7_MARK, DU1_DR6_MARK, DU1_DR5_MARK, DU1_DR4_MARK,
	DU1_DR3_MARK, DU1_DR2_MARK, DU1_DR1_MARK, DU1_DR0_MARK,
	DU1_DG7_MARK, DU1_DG6_MARK, DU1_DG5_MARK, DU1_DG4_MARK,
	DU1_DG3_MARK, DU1_DG2_MARK, DU1_DG1_MARK, DU1_DG0_MARK,
	DU1_DB7_MARK, DU1_DB6_MARK, DU1_DB5_MARK, DU1_DB4_MARK,
	DU1_DB3_MARK, DU1_DB2_MARK, DU1_DB1_MARK, DU1_DB0_MARK,
};
static const unsigned int du1_clk_in_pins[] = {
	/* CLKIN */
	RCAR_GP_PIN(1, 26),
};
static const unsigned int du1_clk_in_mux[] = {
	DU1_DOTCLKIN_MARK,
};
static const unsigned int du1_clk_out_pins[] = {
	/* CLKOUT */
	RCAR_GP_PIN(1, 27),
};
static const unsigned int du1_clk_out_mux[] = {
	DU1_DOTCLKOUT_MARK,
};
static const unsigned int du1_sync_0_pins[] = {
	/* VSYNC, HSYNC, DISP */
	RCAR_GP_PIN(1, 29), RCAR_GP_PIN(1, 28), RCAR_GP_PIN(1, 30),
};
static const unsigned int du1_sync_0_mux[] = {
	DU1_EXVSYNC_DU1_VSYNC_MARK, DU1_EXHSYNC_DU1_HSYNC_MARK,
	DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK
};
static const unsigned int du1_sync_1_pins[] = {
	/* VSYNC, HSYNC, DISP */
	RCAR_GP_PIN(1, 29), RCAR_GP_PIN(1, 28), RCAR_GP_PIN(1, 31),
};
static const unsigned int du1_sync_1_mux[] = {
	DU1_EXVSYNC_DU1_VSYNC_MARK, DU1_EXHSYNC_DU1_HSYNC_MARK,
	DU1_DISP_MARK
};
static const unsigned int du1_oddf_pins[] = {
	/* ODDF */
	RCAR_GP_PIN(1, 30),
};
static const unsigned int du1_oddf_mux[] = {
	DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK
};
static const unsigned int du1_cde_pins[] = {
	/* CDE */
	RCAR_GP_PIN(2, 0),
};
static const unsigned int du1_cde_mux[] = {
	DU1_CDE_MARK
};
/* - Ether ------------------------------------------------------------------ */
static const unsigned int ether_rmii_pins[] = {
	/*
	 * ETH_TXD0, ETH_TXD1, ETH_TX_EN,  ETH_REFCLK,
	 * ETH_RXD0, ETH_RXD1, ETH_CRS_DV, ETH_RX_ER,
	 * ETH_MDIO, ETH_MDC
	 */
	RCAR_GP_PIN(2, 27), RCAR_GP_PIN(2, 16), RCAR_GP_PIN(2, 18),
	RCAR_GP_PIN(2, 26),
	RCAR_GP_PIN(2, 20), RCAR_GP_PIN(2, 21), RCAR_GP_PIN(2, 17),
	RCAR_GP_PIN(2, 19),
	RCAR_GP_PIN(2, 29), RCAR_GP_PIN(2, 28),
};
static const unsigned int ether_rmii_mux[] = {
	ETH_TXD0_MARK, ETH_TXD1_MARK, ETH_TX_EN_MARK,  ETH_REFCLK_MARK,
	ETH_RXD0_MARK, ETH_RXD1_MARK, ETH_CRS_DV_MARK, ETH_RX_ER_MARK,
	ETH_MDIO_MARK, ETH_MDC_MARK,
};
static const unsigned int ether_link_pins[] = {
	/* ETH_LINK */
	RCAR_GP_PIN(2, 24),
};
static const unsigned int ether_link_mux[] = {
	ETH_LINK_MARK,
};
static const unsigned int ether_magic_pins[] = {
	/* ETH_MAGIC */
	RCAR_GP_PIN(2, 25),
};
static const unsigned int ether_magic_mux[] = {
	ETH_MAGIC_MARK,
};
/* - HSCIF0 ----------------------------------------------------------------- */
static const unsigned int hscif0_data_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(4, 20), RCAR_GP_PIN(4, 21)
};
static const unsigned int hscif0_data_mux[] = {
	HTX0_MARK, HRX0_MARK
};
static const unsigned int hscif0_data_b_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(3, 12), RCAR_GP_PIN(3, 13)
};
static const unsigned int hscif0_data_b_mux[] = {
	HTX0_B_MARK, HRX0_B_MARK
};
static const unsigned int hscif0_ctrl_pins[] = {
	/* CTS, RTS */
	RCAR_GP_PIN(4, 18), RCAR_GP_PIN(4, 19)
};
static const unsigned int hscif0_ctrl_mux[] = {
	HCTS0_MARK, HRTS0_MARK
};
static const unsigned int hscif0_ctrl_b_pins[] = {
	/* CTS, RTS */
	RCAR_GP_PIN(3, 9), RCAR_GP_PIN(3, 10)
};
static const unsigned int hscif0_ctrl_b_mux[] = {
	HCTS0_B_MARK, HRTS0_B_MARK
};
static const unsigned int hscif0_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 17)
};
static const unsigned int hscif0_clk_mux[] = {
	HSCK0_MARK
};
static const unsigned int hscif0_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 11)
};
static const unsigned int hscif0_clk_b_mux[] = {
	HSCK0_B_MARK
};
/* - HSCIF1 ----------------------------------------------------------------- */
static const unsigned int hscif1_data_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(0, 19), RCAR_GP_PIN(0, 20)
};
static const unsigned int hscif1_data_mux[] = {
	HTX1_MARK, HRX1_MARK
};
static const unsigned int hscif1_data_b_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(2, 2), RCAR_GP_PIN(2, 3)
};
static const unsigned int hscif1_data_b_mux[] = {
	HTX1_B_MARK, HRX1_B_MARK
};
static const unsigned int hscif1_ctrl_pins[] = {
	/* CTS, RTS */
	RCAR_GP_PIN(0, 21), RCAR_GP_PIN(0, 22)
};
static const unsigned int hscif1_ctrl_mux[] = {
	HCTS1_MARK, HRTS1_MARK
};
static const unsigned int hscif1_ctrl_b_pins[] = {
	/* CTS, RTS */
	RCAR_GP_PIN(2, 7), RCAR_GP_PIN(2, 6)
};
static const unsigned int hscif1_ctrl_b_mux[] = {
	HCTS1_B_MARK, HRTS1_B_MARK
};
static const unsigned int hscif1_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(0, 18)
};
static const unsigned int hscif1_clk_mux[] = {
	HSCK1_MARK
};
static const unsigned int hscif1_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(2, 4)
};
static const unsigned int hscif1_clk_b_mux[] = {
	HSCK1_B_MARK
};
/* - HSPI0 ------------------------------------------------------------------ */
static const unsigned int hspi0_pins[] = {
	/* CLK, CS, RX, TX */
	RCAR_GP_PIN(4, 22), RCAR_GP_PIN(4, 23), RCAR_GP_PIN(4, 25),
	RCAR_GP_PIN(4, 24),
};
static const unsigned int hspi0_mux[] = {
	HSPI_CLK0_MARK, HSPI_CS0_MARK, HSPI_RX0_MARK, HSPI_TX0_MARK,
};
/* - HSPI1 ------------------------------------------------------------------ */
static const unsigned int hspi1_pins[] = {
	/* CLK, CS, RX, TX */
	RCAR_GP_PIN(1, 31), RCAR_GP_PIN(1, 26), RCAR_GP_PIN(2, 0),
	RCAR_GP_PIN(1, 30),
};
static const unsigned int hspi1_mux[] = {
	HSPI_CLK1_MARK, HSPI_CS1_MARK, HSPI_RX1_MARK, HSPI_TX1_MARK,
};
static const unsigned int hspi1_b_pins[] = {
	/* CLK, CS, RX, TX */
	RCAR_GP_PIN(2, 26), RCAR_GP_PIN(2, 27), RCAR_GP_PIN(2, 29),
	RCAR_GP_PIN(2, 28),
};
static const unsigned int hspi1_b_mux[] = {
	HSPI_CLK1_B_MARK, HSPI_CS1_B_MARK, HSPI_RX1_B_MARK, HSPI_TX1_B_MARK,
};
static const unsigned int hspi1_c_pins[] = {
	/* CLK, CS, RX, TX */
	RCAR_GP_PIN(4, 13), RCAR_GP_PIN(4, 14), RCAR_GP_PIN(4, 16),
	RCAR_GP_PIN(4, 15),
};
static const unsigned int hspi1_c_mux[] = {
	HSPI_CLK1_C_MARK, HSPI_CS1_C_MARK, HSPI_RX1_C_MARK, HSPI_TX1_C_MARK,
};
static const unsigned int hspi1_d_pins[] = {
	/* CLK, CS, RX, TX */
	RCAR_GP_PIN(3, 5), RCAR_GP_PIN(3, 6), RCAR_GP_PIN(3, 8),
	RCAR_GP_PIN(3, 7),
};
static const unsigned int hspi1_d_mux[] = {
	HSPI_CLK1_D_MARK, HSPI_CS1_D_MARK, HSPI_RX1_D_MARK, HSPI_TX1_D_MARK,
};
/* - HSPI2 ------------------------------------------------------------------ */
static const unsigned int hspi2_pins[] = {
	/* CLK, CS, RX, TX */
	RCAR_GP_PIN(0, 9), RCAR_GP_PIN(0, 10), RCAR_GP_PIN(0, 11),
	RCAR_GP_PIN(0, 14),
};
static const unsigned int hspi2_mux[] = {
	HSPI_CLK2_MARK, HSPI_CS2_MARK, HSPI_RX2_MARK, HSPI_TX2_MARK,
};
static const unsigned int hspi2_b_pins[] = {
	/* CLK, CS, RX, TX */
	RCAR_GP_PIN(0, 7), RCAR_GP_PIN(0, 13), RCAR_GP_PIN(0, 8),
	RCAR_GP_PIN(0, 6),
};
static const unsigned int hspi2_b_mux[] = {
	HSPI_CLK2_B_MARK, HSPI_CS2_B_MARK, HSPI_RX2_B_MARK, HSPI_TX2_B_MARK,
};
/* - I2C1 ------------------------------------------------------------------ */
static const unsigned int i2c1_pins[] = {
	/* SCL, SDA, */
	RCAR_GP_PIN(0, 27), RCAR_GP_PIN(0, 28),
};
static const unsigned int i2c1_mux[] = {
	SCL1_MARK, SDA1_MARK,
};
static const unsigned int i2c1_b_pins[] = {
	/* SCL, SDA, */
	RCAR_GP_PIN(1, 10), RCAR_GP_PIN(1, 11),
};
static const unsigned int i2c1_b_mux[] = {
	SCL1_B_MARK, SDA1_B_MARK,
};
static const unsigned int i2c1_c_pins[] = {
	/* SCL, SDA, */
	RCAR_GP_PIN(3, 12), RCAR_GP_PIN(3, 13),
};
static const unsigned int i2c1_c_mux[] = {
	SCL1_C_MARK, SDA1_C_MARK,
};
static const unsigned int i2c1_d_pins[] = {
	/* SCL, SDA, */
	RCAR_GP_PIN(1, 26), RCAR_GP_PIN(1, 27),
};
static const unsigned int i2c1_d_mux[] = {
	SCL1_D_MARK, SDA1_D_MARK,
};
/* - I2C2 ------------------------------------------------------------------ */
static const unsigned int i2c2_pins[] = {
	/* SCL, SDA, */
	RCAR_GP_PIN(0, 25), RCAR_GP_PIN(0, 26),
};
static const unsigned int i2c2_mux[] = {
	SCL2_MARK, SDA2_MARK,
};
static const unsigned int i2c2_b_pins[] = {
	/* SCL, SDA, */
	RCAR_GP_PIN(1, 18), RCAR_GP_PIN(1, 19),
};
static const unsigned int i2c2_b_mux[] = {
	SCL2_B_MARK, SDA2_B_MARK,
};
static const unsigned int i2c2_c_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(0, 31), RCAR_GP_PIN(0, 30),
};
static const unsigned int i2c2_c_mux[] = {
	SCL2_C_MARK, SDA2_C_MARK,
};
static const unsigned int i2c2_d_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(1, 24), RCAR_GP_PIN(1, 25),
};
static const unsigned int i2c2_d_mux[] = {
	SCL2_D_MARK, SDA2_D_MARK,
};
/* - I2C3 ------------------------------------------------------------------ */
static const unsigned int i2c3_pins[] = {
	/* SCL, SDA, */
	RCAR_GP_PIN(3, 0), RCAR_GP_PIN(2, 30),
};
static const unsigned int i2c3_mux[] = {
	SCL3_MARK, SDA3_MARK,
};
static const unsigned int i2c3_b_pins[] = {
	/* SCL, SDA, */
	RCAR_GP_PIN(0, 29), RCAR_GP_PIN(0, 30),
};
static const unsigned int i2c3_b_mux[] = {
	SCL3_B_MARK, SDA3_B_MARK,
};
/* - INTC ------------------------------------------------------------------- */
static const unsigned int intc_irq0_pins[] = {
	/* IRQ */
	RCAR_GP_PIN(2, 14),
};
static const unsigned int intc_irq0_mux[] = {
	IRQ0_MARK,
};
static const unsigned int intc_irq0_b_pins[] = {
	/* IRQ */
	RCAR_GP_PIN(4, 13),
};
static const unsigned int intc_irq0_b_mux[] = {
	IRQ0_B_MARK,
};
static const unsigned int intc_irq1_pins[] = {
	/* IRQ */
	RCAR_GP_PIN(2, 15),
};
static const unsigned int intc_irq1_mux[] = {
	IRQ1_MARK,
};
static const unsigned int intc_irq1_b_pins[] = {
	/* IRQ */
	RCAR_GP_PIN(4, 14),
};
static const unsigned int intc_irq1_b_mux[] = {
	IRQ1_B_MARK,
};
static const unsigned int intc_irq2_pins[] = {
	/* IRQ */
	RCAR_GP_PIN(2, 24),
};
static const unsigned int intc_irq2_mux[] = {
	IRQ2_MARK,
};
static const unsigned int intc_irq2_b_pins[] = {
	/* IRQ */
	RCAR_GP_PIN(4, 15),
};
static const unsigned int intc_irq2_b_mux[] = {
	IRQ2_B_MARK,
};
static const unsigned int intc_irq3_pins[] = {
	/* IRQ */
	RCAR_GP_PIN(2, 25),
};
static const unsigned int intc_irq3_mux[] = {
	IRQ3_MARK,
};
static const unsigned int intc_irq3_b_pins[] = {
	/* IRQ */
	RCAR_GP_PIN(4, 16),
};
static const unsigned int intc_irq3_b_mux[] = {
	IRQ3_B_MARK,
};
/* - LSBC ------------------------------------------------------------------- */
static const unsigned int lbsc_cs0_pins[] = {
	/* CS */
	RCAR_GP_PIN(0, 13),
};
static const unsigned int lbsc_cs0_mux[] = {
	CS0_MARK,
};
static const unsigned int lbsc_cs1_pins[] = {
	/* CS */
	RCAR_GP_PIN(0, 14),
};
static const unsigned int lbsc_cs1_mux[] = {
	CS1_A26_MARK,
};
static const unsigned int lbsc_ex_cs0_pins[] = {
	/* CS */
	RCAR_GP_PIN(0, 15),
};
static const unsigned int lbsc_ex_cs0_mux[] = {
	EX_CS0_MARK,
};
static const unsigned int lbsc_ex_cs1_pins[] = {
	/* CS */
	RCAR_GP_PIN(0, 16),
};
static const unsigned int lbsc_ex_cs1_mux[] = {
	EX_CS1_MARK,
};
static const unsigned int lbsc_ex_cs2_pins[] = {
	/* CS */
	RCAR_GP_PIN(0, 17),
};
static const unsigned int lbsc_ex_cs2_mux[] = {
	EX_CS2_MARK,
};
static const unsigned int lbsc_ex_cs3_pins[] = {
	/* CS */
	RCAR_GP_PIN(0, 18),
};
static const unsigned int lbsc_ex_cs3_mux[] = {
	EX_CS3_MARK,
};
static const unsigned int lbsc_ex_cs4_pins[] = {
	/* CS */
	RCAR_GP_PIN(0, 19),
};
static const unsigned int lbsc_ex_cs4_mux[] = {
	EX_CS4_MARK,
};
static const unsigned int lbsc_ex_cs5_pins[] = {
	/* CS */
	RCAR_GP_PIN(0, 20),
};
static const unsigned int lbsc_ex_cs5_mux[] = {
	EX_CS5_MARK,
};
/* - MMCIF ------------------------------------------------------------------ */
static const unsigned int mmc0_data1_pins[] = {
	/* D[0] */
	RCAR_GP_PIN(0, 19),
};
static const unsigned int mmc0_data1_mux[] = {
	MMC0_D0_MARK,
};
static const unsigned int mmc0_data4_pins[] = {
	/* D[0:3] */
	RCAR_GP_PIN(0, 19), RCAR_GP_PIN(0, 20), RCAR_GP_PIN(0, 21),
	RCAR_GP_PIN(0, 2),
};
static const unsigned int mmc0_data4_mux[] = {
	MMC0_D0_MARK, MMC0_D1_MARK, MMC0_D2_MARK, MMC0_D3_MARK,
};
static const unsigned int mmc0_data8_pins[] = {
	/* D[0:7] */
	RCAR_GP_PIN(0, 19), RCAR_GP_PIN(0, 20), RCAR_GP_PIN(0, 21),
	RCAR_GP_PIN(0, 2),  RCAR_GP_PIN(0, 10), RCAR_GP_PIN(0, 11),
	RCAR_GP_PIN(0, 15), RCAR_GP_PIN(0, 16),
};
static const unsigned int mmc0_data8_mux[] = {
	MMC0_D0_MARK, MMC0_D1_MARK, MMC0_D2_MARK, MMC0_D3_MARK,
	MMC0_D4_MARK, MMC0_D5_MARK, MMC0_D6_MARK, MMC0_D7_MARK,
};
static const unsigned int mmc0_ctrl_pins[] = {
	/* CMD, CLK */
	RCAR_GP_PIN(0, 18), RCAR_GP_PIN(0, 17),
};
static const unsigned int mmc0_ctrl_mux[] = {
	MMC0_CMD_MARK, MMC0_CLK_MARK,
};
static const unsigned int mmc1_data1_pins[] = {
	/* D[0] */
	RCAR_GP_PIN(2, 8),
};
static const unsigned int mmc1_data1_mux[] = {
	MMC1_D0_MARK,
};
static const unsigned int mmc1_data4_pins[] = {
	/* D[0:3] */
	RCAR_GP_PIN(2, 8), RCAR_GP_PIN(2, 9), RCAR_GP_PIN(2, 10),
	RCAR_GP_PIN(2, 11),
};
static const unsigned int mmc1_data4_mux[] = {
	MMC1_D0_MARK, MMC1_D1_MARK, MMC1_D2_MARK, MMC1_D3_MARK,
};
static const unsigned int mmc1_data8_pins[] = {
	/* D[0:7] */
	RCAR_GP_PIN(2, 8),  RCAR_GP_PIN(2, 9),  RCAR_GP_PIN(2, 10),
	RCAR_GP_PIN(2, 11), RCAR_GP_PIN(2, 12), RCAR_GP_PIN(2, 13),
	RCAR_GP_PIN(2, 16), RCAR_GP_PIN(2, 17),
};
static const unsigned int mmc1_data8_mux[] = {
	MMC1_D0_MARK, MMC1_D1_MARK, MMC1_D2_MARK, MMC1_D3_MARK,
	MMC1_D4_MARK, MMC1_D5_MARK, MMC1_D6_MARK, MMC1_D7_MARK,
};
static const unsigned int mmc1_ctrl_pins[] = {
	/* CMD, CLK */
	RCAR_GP_PIN(2, 4), RCAR_GP_PIN(2, 1),
};
static const unsigned int mmc1_ctrl_mux[] = {
	MMC1_CMD_MARK, MMC1_CLK_MARK,
};
/* - SCIF0 ------------------------------------------------------------------ */
static const unsigned int scif0_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(4, 25), RCAR_GP_PIN(4, 24),
};
static const unsigned int scif0_data_mux[] = {
	RX0_MARK, TX0_MARK,
};
static const unsigned int scif0_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 28),
};
static const unsigned int scif0_clk_mux[] = {
	SCK0_MARK,
};
static const unsigned int scif0_ctrl_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(4, 23), RCAR_GP_PIN(4, 22),
};
static const unsigned int scif0_ctrl_mux[] = {
	RTS0_TANS_MARK, CTS0_MARK,
};
static const unsigned int scif0_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(0, 20), RCAR_GP_PIN(0, 19),
};
static const unsigned int scif0_data_b_mux[] = {
	RX0_B_MARK, TX0_B_MARK,
};
static const unsigned int scif0_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(1, 1),
};
static const unsigned int scif0_clk_b_mux[] = {
	SCK0_B_MARK,
};
static const unsigned int scif0_ctrl_b_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(0, 18), RCAR_GP_PIN(0, 11),
};
static const unsigned int scif0_ctrl_b_mux[] = {
	RTS0_B_TANS_B_MARK, CTS0_B_MARK,
};
static const unsigned int scif0_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(4, 18), RCAR_GP_PIN(4, 19),
};
static const unsigned int scif0_data_c_mux[] = {
	RX0_C_MARK, TX0_C_MARK,
};
static const unsigned int scif0_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 17),
};
static const unsigned int scif0_clk_c_mux[] = {
	SCK0_C_MARK,
};
static const unsigned int scif0_ctrl_c_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(4, 21), RCAR_GP_PIN(4, 20),
};
static const unsigned int scif0_ctrl_c_mux[] = {
	RTS0_C_TANS_C_MARK, CTS0_C_MARK,
};
static const unsigned int scif0_data_d_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(1, 11), RCAR_GP_PIN(1, 10),
};
static const unsigned int scif0_data_d_mux[] = {
	RX0_D_MARK, TX0_D_MARK,
};
static const unsigned int scif0_clk_d_pins[] = {
	/* SCK */
	RCAR_GP_PIN(1, 18),
};
static const unsigned int scif0_clk_d_mux[] = {
	SCK0_D_MARK,
};
static const unsigned int scif0_ctrl_d_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(1, 19), RCAR_GP_PIN(1, 3),
};
static const unsigned int scif0_ctrl_d_mux[] = {
	RTS0_D_TANS_D_MARK, CTS0_D_MARK,
};
/* - SCIF1 ------------------------------------------------------------------ */
static const unsigned int scif1_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(4, 21), RCAR_GP_PIN(4, 20),
};
static const unsigned int scif1_data_mux[] = {
	RX1_MARK, TX1_MARK,
};
static const unsigned int scif1_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 17),
};
static const unsigned int scif1_clk_mux[] = {
	SCK1_MARK,
};
static const unsigned int scif1_ctrl_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(4, 19), RCAR_GP_PIN(4, 18),
};
static const unsigned int scif1_ctrl_mux[] = {
	RTS1_TANS_MARK, CTS1_MARK,
};
static const unsigned int scif1_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(3, 21), RCAR_GP_PIN(3, 18),
};
static const unsigned int scif1_data_b_mux[] = {
	RX1_B_MARK, TX1_B_MARK,
};
static const unsigned int scif1_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 17),
};
static const unsigned int scif1_clk_b_mux[] = {
	SCK1_B_MARK,
};
static const unsigned int scif1_ctrl_b_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(3, 19), RCAR_GP_PIN(3, 20),
};
static const unsigned int scif1_ctrl_b_mux[] = {
	RTS1_B_TANS_B_MARK, CTS1_B_MARK,
};
static const unsigned int scif1_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(2, 3), RCAR_GP_PIN(2, 2),
};
static const unsigned int scif1_data_c_mux[] = {
	RX1_C_MARK, TX1_C_MARK,
};
static const unsigned int scif1_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(2, 22),
};
static const unsigned int scif1_clk_c_mux[] = {
	SCK1_C_MARK,
};
static const unsigned int scif1_ctrl_c_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(2, 5), RCAR_GP_PIN(2, 4),
};
static const unsigned int scif1_ctrl_c_mux[] = {
	RTS1_C_TANS_C_MARK, CTS1_C_MARK,
};
/* - SCIF2 ------------------------------------------------------------------ */
static const unsigned int scif2_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(3, 10), RCAR_GP_PIN(3, 9),
};
static const unsigned int scif2_data_mux[] = {
	RX2_MARK, TX2_MARK,
};
static const unsigned int scif2_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 11),
};
static const unsigned int scif2_clk_mux[] = {
	SCK2_MARK,
};
static const unsigned int scif2_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(3, 24), RCAR_GP_PIN(3, 23),
};
static const unsigned int scif2_data_b_mux[] = {
	RX2_B_MARK, TX2_B_MARK,
};
static const unsigned int scif2_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 22),
};
static const unsigned int scif2_clk_b_mux[] = {
	SCK2_B_MARK,
};
static const unsigned int scif2_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(1, 1), RCAR_GP_PIN(0, 31),
};
static const unsigned int scif2_data_c_mux[] = {
	RX2_C_MARK, TX2_C_MARK,
};
static const unsigned int scif2_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(1, 0),
};
static const unsigned int scif2_clk_c_mux[] = {
	SCK2_C_MARK,
};
static const unsigned int scif2_data_d_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(2, 0), RCAR_GP_PIN(1, 30),
};
static const unsigned int scif2_data_d_mux[] = {
	RX2_D_MARK, TX2_D_MARK,
};
static const unsigned int scif2_clk_d_pins[] = {
	/* SCK */
	RCAR_GP_PIN(1, 31),
};
static const unsigned int scif2_clk_d_mux[] = {
	SCK2_D_MARK,
};
static const unsigned int scif2_data_e_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(0, 20), RCAR_GP_PIN(0, 19),
};
static const unsigned int scif2_data_e_mux[] = {
	RX2_E_MARK, TX2_E_MARK,
};
/* - SCIF3 ------------------------------------------------------------------ */
static const unsigned int scif3_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(4, 9), RCAR_GP_PIN(4, 8),
};
static const unsigned int scif3_data_mux[] = {
	RX3_IRDA_RX_MARK, TX3_IRDA_TX_MARK,
};
static const unsigned int scif3_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 7),
};
static const unsigned int scif3_clk_mux[] = {
	SCK3_MARK,
};

static const unsigned int scif3_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(2, 0), RCAR_GP_PIN(1, 30),
};
static const unsigned int scif3_data_b_mux[] = {
	RX3_B_IRDA_RX_B_MARK, TX3_B_IRDA_TX_B_MARK,
};
static const unsigned int scif3_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(0, 15), RCAR_GP_PIN(0, 12),
};
static const unsigned int scif3_data_c_mux[] = {
	RX3_C_IRDA_RX_C_MARK, TX3C_IRDA_TX_C_MARK,
};
static const unsigned int scif3_data_d_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(0, 30), RCAR_GP_PIN(0, 29),
};
static const unsigned int scif3_data_d_mux[] = {
	RX3_D_IRDA_RX_D_MARK, TX3_D_IRDA_TX_D_MARK,
};
static const unsigned int scif3_data_e_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(1, 3), RCAR_GP_PIN(1, 2),
};
static const unsigned int scif3_data_e_mux[] = {
	RX3_E_IRDA_RX_E_MARK, TX3_E_IRDA_TX_E_MARK,
};
static const unsigned int scif3_clk_e_pins[] = {
	/* SCK */
	RCAR_GP_PIN(1, 10),
};
static const unsigned int scif3_clk_e_mux[] = {
	SCK3_E_MARK,
};
/* - SCIF4 ------------------------------------------------------------------ */
static const unsigned int scif4_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(3, 27), RCAR_GP_PIN(3, 26),
};
static const unsigned int scif4_data_mux[] = {
	RX4_MARK, TX4_MARK,
};
static const unsigned int scif4_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 25),
};
static const unsigned int scif4_clk_mux[] = {
	SCK4_MARK,
};
static const unsigned int scif4_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(3, 15), RCAR_GP_PIN(3, 14),
};
static const unsigned int scif4_data_b_mux[] = {
	RX4_B_MARK, TX4_B_MARK,
};
static const unsigned int scif4_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 16),
};
static const unsigned int scif4_clk_b_mux[] = {
	SCK4_B_MARK,
};
static const unsigned int scif4_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(0, 22), RCAR_GP_PIN(0, 21),
};
static const unsigned int scif4_data_c_mux[] = {
	RX4_C_MARK, TX4_C_MARK,
};
static const unsigned int scif4_data_d_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(2, 5), RCAR_GP_PIN(2, 4),
};
static const unsigned int scif4_data_d_mux[] = {
	RX4_D_MARK, TX4_D_MARK,
};
/* - SCIF5 ------------------------------------------------------------------ */
static const unsigned int scif5_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(1, 19), RCAR_GP_PIN(1, 18),
};
static const unsigned int scif5_data_mux[] = {
	RX5_MARK, TX5_MARK,
};
static const unsigned int scif5_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(1, 11),
};
static const unsigned int scif5_clk_mux[] = {
	SCK5_MARK,
};
static const unsigned int scif5_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(0, 18), RCAR_GP_PIN(0, 11),
};
static const unsigned int scif5_data_b_mux[] = {
	RX5_B_MARK, TX5_B_MARK,
};
static const unsigned int scif5_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(0, 19),
};
static const unsigned int scif5_clk_b_mux[] = {
	SCK5_B_MARK,
};
static const unsigned int scif5_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(0, 24), RCAR_GP_PIN(0, 23),
};
static const unsigned int scif5_data_c_mux[] = {
	RX5_C_MARK, TX5_C_MARK,
};
static const unsigned int scif5_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(0, 28),
};
static const unsigned int scif5_clk_c_mux[] = {
	SCK5_C_MARK,
};
static const unsigned int scif5_data_d_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(0, 8), RCAR_GP_PIN(0, 6),
};
static const unsigned int scif5_data_d_mux[] = {
	RX5_D_MARK, TX5_D_MARK,
};
static const unsigned int scif5_clk_d_pins[] = {
	/* SCK */
	RCAR_GP_PIN(0, 7),
};
static const unsigned int scif5_clk_d_mux[] = {
	SCK5_D_MARK,
};
/* - SCIF Clock ------------------------------------------------------------- */
static const unsigned int scif_clk_pins[] = {
	/* SCIF_CLK */
	RCAR_GP_PIN(4, 28),
};
static const unsigned int scif_clk_mux[] = {
	SCIF_CLK_MARK,
};
static const unsigned int scif_clk_b_pins[] = {
	/* SCIF_CLK */
	RCAR_GP_PIN(4, 5),
};
static const unsigned int scif_clk_b_mux[] = {
	SCIF_CLK_B_MARK,
};
static const unsigned int scif_clk_c_pins[] = {
	/* SCIF_CLK */
	RCAR_GP_PIN(4, 18),
};
static const unsigned int scif_clk_c_mux[] = {
	SCIF_CLK_C_MARK,
};
static const unsigned int scif_clk_d_pins[] = {
	/* SCIF_CLK */
	RCAR_GP_PIN(2, 29),
};
static const unsigned int scif_clk_d_mux[] = {
	SCIF_CLK_D_MARK,
};
/* - SDHI0 ------------------------------------------------------------------ */
static const unsigned int sdhi0_data1_pins[] = {
	/* D0 */
	RCAR_GP_PIN(3, 21),
};
static const unsigned int sdhi0_data1_mux[] = {
	SD0_DAT0_MARK,
};
static const unsigned int sdhi0_data4_pins[] = {
	/* D[0:3] */
	RCAR_GP_PIN(3, 21), RCAR_GP_PIN(3, 22), RCAR_GP_PIN(3, 23),
	RCAR_GP_PIN(3, 24),
};
static const unsigned int sdhi0_data4_mux[] = {
	SD0_DAT0_MARK, SD0_DAT1_MARK, SD0_DAT2_MARK, SD0_DAT3_MARK,
};
static const unsigned int sdhi0_ctrl_pins[] = {
	/* CMD, CLK */
	RCAR_GP_PIN(3, 18), RCAR_GP_PIN(3, 17),
};
static const unsigned int sdhi0_ctrl_mux[] = {
	SD0_CMD_MARK, SD0_CLK_MARK,
};
static const unsigned int sdhi0_cd_pins[] = {
	/* CD */
	RCAR_GP_PIN(3, 19),
};
static const unsigned int sdhi0_cd_mux[] = {
	SD0_CD_MARK,
};
static const unsigned int sdhi0_wp_pins[] = {
	/* WP */
	RCAR_GP_PIN(3, 20),
};
static const unsigned int sdhi0_wp_mux[] = {
	SD0_WP_MARK,
};
/* - SDHI1 ------------------------------------------------------------------ */
static const unsigned int sdhi1_data1_pins[] = {
	/* D0 */
	RCAR_GP_PIN(0, 19),
};
static const unsigned int sdhi1_data1_mux[] = {
	SD1_DAT0_MARK,
};
static const unsigned int sdhi1_data4_pins[] = {
	/* D[0:3] */
	RCAR_GP_PIN(0, 19), RCAR_GP_PIN(0, 20), RCAR_GP_PIN(0, 21),
	RCAR_GP_PIN(0, 2),
};
static const unsigned int sdhi1_data4_mux[] = {
	SD1_DAT0_MARK, SD1_DAT1_MARK, SD1_DAT2_MARK, SD1_DAT3_MARK,
};
static const unsigned int sdhi1_ctrl_pins[] = {
	/* CMD, CLK */
	RCAR_GP_PIN(0, 18), RCAR_GP_PIN(0, 17),
};
static const unsigned int sdhi1_ctrl_mux[] = {
	SD1_CMD_MARK, SD1_CLK_MARK,
};
static const unsigned int sdhi1_cd_pins[] = {
	/* CD */
	RCAR_GP_PIN(0, 10),
};
static const unsigned int sdhi1_cd_mux[] = {
	SD1_CD_MARK,
};
static const unsigned int sdhi1_wp_pins[] = {
	/* WP */
	RCAR_GP_PIN(0, 11),
};
static const unsigned int sdhi1_wp_mux[] = {
	SD1_WP_MARK,
};
/* - SDHI2 ------------------------------------------------------------------ */
static const unsigned int sdhi2_data1_pins[] = {
	/* D0 */
	RCAR_GP_PIN(3, 1),
};
static const unsigned int sdhi2_data1_mux[] = {
	SD2_DAT0_MARK,
};
static const unsigned int sdhi2_data4_pins[] = {
	/* D[0:3] */
	RCAR_GP_PIN(3, 1), RCAR_GP_PIN(3, 2), RCAR_GP_PIN(3, 3),
	RCAR_GP_PIN(3, 4),
};
static const unsigned int sdhi2_data4_mux[] = {
	SD2_DAT0_MARK, SD2_DAT1_MARK, SD2_DAT2_MARK, SD2_DAT3_MARK,
};
static const unsigned int sdhi2_ctrl_pins[] = {
	/* CMD, CLK */
	RCAR_GP_PIN(3, 6), RCAR_GP_PIN(3, 5),
};
static const unsigned int sdhi2_ctrl_mux[] = {
	SD2_CMD_MARK, SD2_CLK_MARK,
};
static const unsigned int sdhi2_cd_pins[] = {
	/* CD */
	RCAR_GP_PIN(3, 7),
};
static const unsigned int sdhi2_cd_mux[] = {
	SD2_CD_MARK,
};
static const unsigned int sdhi2_wp_pins[] = {
	/* WP */
	RCAR_GP_PIN(3, 8),
};
static const unsigned int sdhi2_wp_mux[] = {
	SD2_WP_MARK,
};
/* - SDHI3 ------------------------------------------------------------------ */
static const unsigned int sdhi3_data1_pins[] = {
	/* D0 */
	RCAR_GP_PIN(1, 18),
};
static const unsigned int sdhi3_data1_mux[] = {
	SD3_DAT0_MARK,
};
static const unsigned int sdhi3_data4_pins[] = {
	/* D[0:3] */
	RCAR_GP_PIN(1, 18), RCAR_GP_PIN(1, 19), RCAR_GP_PIN(1, 20),
	RCAR_GP_PIN(1, 21),
};
static const unsigned int sdhi3_data4_mux[] = {
	SD3_DAT0_MARK, SD3_DAT1_MARK, SD3_DAT2_MARK, SD3_DAT3_MARK,
};
static const unsigned int sdhi3_ctrl_pins[] = {
	/* CMD, CLK */
	RCAR_GP_PIN(1, 3), RCAR_GP_PIN(1, 2),
};
static const unsigned int sdhi3_ctrl_mux[] = {
	SD3_CMD_MARK, SD3_CLK_MARK,
};
static const unsigned int sdhi3_cd_pins[] = {
	/* CD */
	RCAR_GP_PIN(1, 30),
};
static const unsigned int sdhi3_cd_mux[] = {
	SD3_CD_MARK,
};
static const unsigned int sdhi3_wp_pins[] = {
	/* WP */
	RCAR_GP_PIN(2, 0),
};
static const unsigned int sdhi3_wp_mux[] = {
	SD3_WP_MARK,
};
/* - USB0 ------------------------------------------------------------------- */
static const unsigned int usb0_pins[] = {
	/* PENC */
	RCAR_GP_PIN(4, 26),
};
static const unsigned int usb0_mux[] = {
	USB_PENC0_MARK,
};
static const unsigned int usb0_ovc_pins[] = {
	/* USB_OVC */
	RCAR_GP_PIN(4, 22),
};
static const unsigned int usb0_ovc_mux[] = {
	USB_OVC0_MARK,
};
/* - USB1 ------------------------------------------------------------------- */
static const unsigned int usb1_pins[] = {
	/* PENC */
	RCAR_GP_PIN(4, 27),
};
static const unsigned int usb1_mux[] = {
	USB_PENC1_MARK,
};
static const unsigned int usb1_ovc_pins[] = {
	/* USB_OVC */
	RCAR_GP_PIN(4, 24),
};
static const unsigned int usb1_ovc_mux[] = {
	USB_OVC1_MARK,
};
/* - USB2 ------------------------------------------------------------------- */
static const unsigned int usb2_pins[] = {
	/* PENC */
	RCAR_GP_PIN(4, 28),
};
static const unsigned int usb2_mux[] = {
	USB_PENC2_MARK,
};
static const unsigned int usb2_ovc_pins[] = {
	/* USB_OVC */
	RCAR_GP_PIN(3, 29),
};
static const unsigned int usb2_ovc_mux[] = {
	USB_OVC2_MARK,
};
/* - VIN0 ------------------------------------------------------------------- */
static const unsigned int vin0_data8_pins[] = {
	/* D[0:7] */
	RCAR_GP_PIN(2, 6),  RCAR_GP_PIN(2, 7),  RCAR_GP_PIN(2, 8),
	RCAR_GP_PIN(2, 9),  RCAR_GP_PIN(2, 10), RCAR_GP_PIN(2, 11),
	RCAR_GP_PIN(2, 12), RCAR_GP_PIN(2, 13),
};
static const unsigned int vin0_data8_mux[] = {
	VI0_DATA0_VI0_B0_MARK, VI0_DATA1_VI0_B1_MARK, VI0_DATA2_VI0_B2_MARK,
	VI0_DATA3_VI0_B3_MARK, VI0_DATA4_VI0_B4_MARK, VI0_DATA5_VI0_B5_MARK,
	VI0_DATA6_VI0_B6_MARK, VI0_DATA7_VI0_B7_MARK,
};
static const unsigned int vin0_clk_pins[] = {
	/* CLK */
	RCAR_GP_PIN(2, 1),
};
static const unsigned int vin0_clk_mux[] = {
	VI0_CLK_MARK,
};
static const unsigned int vin0_sync_pins[] = {
	/* HSYNC, VSYNC */
	RCAR_GP_PIN(2, 4), RCAR_GP_PIN(2, 5),
};
static const unsigned int vin0_sync_mux[] = {
	VI0_HSYNC_MARK, VI0_VSYNC_MARK,
};
/* - VIN1 ------------------------------------------------------------------- */
static const unsigned int vin1_data8_pins[] = {
	/* D[0:7] */
	RCAR_GP_PIN(3, 1), RCAR_GP_PIN(3, 2), RCAR_GP_PIN(3, 3),
	RCAR_GP_PIN(3, 4), RCAR_GP_PIN(3, 5), RCAR_GP_PIN(3, 6),
	RCAR_GP_PIN(3, 7), RCAR_GP_PIN(3, 8),
};
static const unsigned int vin1_data8_mux[] = {
	VI1_DATA0_VI1_B0_MARK, VI1_DATA1_VI1_B1_MARK, VI1_DATA2_VI1_B2_MARK,
	VI1_DATA3_VI1_B3_MARK, VI1_DATA4_VI1_B4_MARK, VI1_DATA5_VI1_B5_MARK,
	VI1_DATA6_VI1_B6_MARK, VI1_DATA7_VI1_B7_MARK,
};
static const unsigned int vin1_clk_pins[] = {
	/* CLK */
	RCAR_GP_PIN(2, 30),
};
static const unsigned int vin1_clk_mux[] = {
	VI1_CLK_MARK,
};
static const unsigned int vin1_sync_pins[] = {
	/* HSYNC, VSYNC */
	RCAR_GP_PIN(2, 31), RCAR_GP_PIN(3, 0),
};
static const unsigned int vin1_sync_mux[] = {
	VI1_HSYNC_MARK, VI1_VSYNC_MARK,
};
/* - VIN2 ------------------------------------------------------------------- */
static const unsigned int vin2_data8_pins[] = {
	/* D[0:7] */
	RCAR_GP_PIN(1, 2),  RCAR_GP_PIN(1, 3),  RCAR_GP_PIN(1, 10),
	RCAR_GP_PIN(1, 11), RCAR_GP_PIN(1, 18), RCAR_GP_PIN(1, 19),
	RCAR_GP_PIN(1, 31), RCAR_GP_PIN(2, 0),
};
static const unsigned int vin2_data8_mux[] = {
	VI2_DATA0_VI2_B0_MARK, VI2_DATA1_VI2_B1_MARK, VI2_DATA2_VI2_B2_MARK,
	VI2_DATA3_VI2_B3_MARK, VI2_DATA4_VI2_B4_MARK, VI2_DATA5_VI2_B5_MARK,
	VI2_DATA6_VI2_B6_MARK, VI2_DATA7_VI2_B7_MARK,
};
static const unsigned int vin2_clk_pins[] = {
	/* CLK */
	RCAR_GP_PIN(1, 30),
};
static const unsigned int vin2_clk_mux[] = {
	VI2_CLK_MARK,
};
static const unsigned int vin2_sync_pins[] = {
	/* HSYNC, VSYNC */
	RCAR_GP_PIN(1, 28), RCAR_GP_PIN(1, 29),
};
static const unsigned int vin2_sync_mux[] = {
	VI2_HSYNC_MARK, VI2_VSYNC_MARK,
};
/* - VIN3 ------------------------------------------------------------------- */
static const unsigned int vin3_data8_pins[] = {
	/* D[0:7] */
	RCAR_GP_PIN(3, 9),  RCAR_GP_PIN(3, 10), RCAR_GP_PIN(3, 11),
	RCAR_GP_PIN(3, 12), RCAR_GP_PIN(3, 13), RCAR_GP_PIN(3, 14),
	RCAR_GP_PIN(3, 15), RCAR_GP_PIN(3, 16),
};
static const unsigned int vin3_data8_mux[] = {
	VI3_DATA0_MARK, VI3_DATA1_MARK, VI3_DATA2_MARK,
	VI3_DATA3_MARK, VI3_DATA4_MARK, VI3_DATA5_MARK,
	VI3_DATA6_MARK, VI3_DATA7_MARK,
};
static const unsigned int vin3_clk_pins[] = {
	/* CLK */
	RCAR_GP_PIN(2, 31),
};
static const unsigned int vin3_clk_mux[] = {
	VI3_CLK_MARK,
};
static const unsigned int vin3_sync_pins[] = {
	/* HSYNC, VSYNC */
	RCAR_GP_PIN(1, 28), RCAR_GP_PIN(1, 29),
};
static const unsigned int vin3_sync_mux[] = {
	VI3_HSYNC_MARK, VI3_VSYNC_MARK,
};

static const struct sh_pfc_pin_group pinmux_groups[] = {
	SH_PFC_PIN_GROUP(du0_rgb666),
	SH_PFC_PIN_GROUP(du0_rgb888),
	SH_PFC_PIN_GROUP(du0_clk_in),
	SH_PFC_PIN_GROUP(du0_clk_out_0),
	SH_PFC_PIN_GROUP(du0_clk_out_1),
	SH_PFC_PIN_GROUP(du0_sync_0),
	SH_PFC_PIN_GROUP(du0_sync_1),
	SH_PFC_PIN_GROUP(du0_oddf),
	SH_PFC_PIN_GROUP(du0_cde),
	SH_PFC_PIN_GROUP(du1_rgb666),
	SH_PFC_PIN_GROUP(du1_rgb888),
	SH_PFC_PIN_GROUP(du1_clk_in),
	SH_PFC_PIN_GROUP(du1_clk_out),
	SH_PFC_PIN_GROUP(du1_sync_0),
	SH_PFC_PIN_GROUP(du1_sync_1),
	SH_PFC_PIN_GROUP(du1_oddf),
	SH_PFC_PIN_GROUP(du1_cde),
	SH_PFC_PIN_GROUP(ether_rmii),
	SH_PFC_PIN_GROUP(ether_link),
	SH_PFC_PIN_GROUP(ether_magic),
	SH_PFC_PIN_GROUP(hscif0_data),
	SH_PFC_PIN_GROUP(hscif0_data_b),
	SH_PFC_PIN_GROUP(hscif0_ctrl),
	SH_PFC_PIN_GROUP(hscif0_ctrl_b),
	SH_PFC_PIN_GROUP(hscif0_clk),
	SH_PFC_PIN_GROUP(hscif0_clk_b),
	SH_PFC_PIN_GROUP(hscif1_data),
	SH_PFC_PIN_GROUP(hscif1_data_b),
	SH_PFC_PIN_GROUP(hscif1_ctrl),
	SH_PFC_PIN_GROUP(hscif1_ctrl_b),
	SH_PFC_PIN_GROUP(hscif1_clk),
	SH_PFC_PIN_GROUP(hscif1_clk_b),
	SH_PFC_PIN_GROUP(hspi0),
	SH_PFC_PIN_GROUP(hspi1),
	SH_PFC_PIN_GROUP(hspi1_b),
	SH_PFC_PIN_GROUP(hspi1_c),
	SH_PFC_PIN_GROUP(hspi1_d),
	SH_PFC_PIN_GROUP(hspi2),
	SH_PFC_PIN_GROUP(hspi2_b),
	SH_PFC_PIN_GROUP(i2c1),
	SH_PFC_PIN_GROUP(i2c1_b),
	SH_PFC_PIN_GROUP(i2c1_c),
	SH_PFC_PIN_GROUP(i2c1_d),
	SH_PFC_PIN_GROUP(i2c2),
	SH_PFC_PIN_GROUP(i2c2_b),
	SH_PFC_PIN_GROUP(i2c2_c),
	SH_PFC_PIN_GROUP(i2c2_d),
	SH_PFC_PIN_GROUP(i2c3),
	SH_PFC_PIN_GROUP(i2c3_b),
	SH_PFC_PIN_GROUP(intc_irq0),
	SH_PFC_PIN_GROUP(intc_irq0_b),
	SH_PFC_PIN_GROUP(intc_irq1),
	SH_PFC_PIN_GROUP(intc_irq1_b),
	SH_PFC_PIN_GROUP(intc_irq2),
	SH_PFC_PIN_GROUP(intc_irq2_b),
	SH_PFC_PIN_GROUP(intc_irq3),
	SH_PFC_PIN_GROUP(intc_irq3_b),
	SH_PFC_PIN_GROUP(lbsc_cs0),
	SH_PFC_PIN_GROUP(lbsc_cs1),
	SH_PFC_PIN_GROUP(lbsc_ex_cs0),
	SH_PFC_PIN_GROUP(lbsc_ex_cs1),
	SH_PFC_PIN_GROUP(lbsc_ex_cs2),
	SH_PFC_PIN_GROUP(lbsc_ex_cs3),
	SH_PFC_PIN_GROUP(lbsc_ex_cs4),
	SH_PFC_PIN_GROUP(lbsc_ex_cs5),
	SH_PFC_PIN_GROUP(mmc0_data1),
	SH_PFC_PIN_GROUP(mmc0_data4),
	SH_PFC_PIN_GROUP(mmc0_data8),
	SH_PFC_PIN_GROUP(mmc0_ctrl),
	SH_PFC_PIN_GROUP(mmc1_data1),
	SH_PFC_PIN_GROUP(mmc1_data4),
	SH_PFC_PIN_GROUP(mmc1_data8),
	SH_PFC_PIN_GROUP(mmc1_ctrl),
	SH_PFC_PIN_GROUP(scif0_data),
	SH_PFC_PIN_GROUP(scif0_clk),
	SH_PFC_PIN_GROUP(scif0_ctrl),
	SH_PFC_PIN_GROUP(scif0_data_b),
	SH_PFC_PIN_GROUP(scif0_clk_b),
	SH_PFC_PIN_GROUP(scif0_ctrl_b),
	SH_PFC_PIN_GROUP(scif0_data_c),
	SH_PFC_PIN_GROUP(scif0_clk_c),
	SH_PFC_PIN_GROUP(scif0_ctrl_c),
	SH_PFC_PIN_GROUP(scif0_data_d),
	SH_PFC_PIN_GROUP(scif0_clk_d),
	SH_PFC_PIN_GROUP(scif0_ctrl_d),
	SH_PFC_PIN_GROUP(scif1_data),
	SH_PFC_PIN_GROUP(scif1_clk),
	SH_PFC_PIN_GROUP(scif1_ctrl),
	SH_PFC_PIN_GROUP(scif1_data_b),
	SH_PFC_PIN_GROUP(scif1_clk_b),
	SH_PFC_PIN_GROUP(scif1_ctrl_b),
	SH_PFC_PIN_GROUP(scif1_data_c),
	SH_PFC_PIN_GROUP(scif1_clk_c),
	SH_PFC_PIN_GROUP(scif1_ctrl_c),
	SH_PFC_PIN_GROUP(scif2_data),
	SH_PFC_PIN_GROUP(scif2_clk),
	SH_PFC_PIN_GROUP(scif2_data_b),
	SH_PFC_PIN_GROUP(scif2_clk_b),
	SH_PFC_PIN_GROUP(scif2_data_c),
	SH_PFC_PIN_GROUP(scif2_clk_c),
	SH_PFC_PIN_GROUP(scif2_data_d),
	SH_PFC_PIN_GROUP(scif2_clk_d),
	SH_PFC_PIN_GROUP(scif2_data_e),
	SH_PFC_PIN_GROUP(scif3_data),
	SH_PFC_PIN_GROUP(scif3_clk),
	SH_PFC_PIN_GROUP(scif3_data_b),
	SH_PFC_PIN_GROUP(scif3_data_c),
	SH_PFC_PIN_GROUP(scif3_data_d),
	SH_PFC_PIN_GROUP(scif3_data_e),
	SH_PFC_PIN_GROUP(scif3_clk_e),
	SH_PFC_PIN_GROUP(scif4_data),
	SH_PFC_PIN_GROUP(scif4_clk),
	SH_PFC_PIN_GROUP(scif4_data_b),
	SH_PFC_PIN_GROUP(scif4_clk_b),
	SH_PFC_PIN_GROUP(scif4_data_c),
	SH_PFC_PIN_GROUP(scif4_data_d),
	SH_PFC_PIN_GROUP(scif5_data),
	SH_PFC_PIN_GROUP(scif5_clk),
	SH_PFC_PIN_GROUP(scif5_data_b),
	SH_PFC_PIN_GROUP(scif5_clk_b),
	SH_PFC_PIN_GROUP(scif5_data_c),
	SH_PFC_PIN_GROUP(scif5_clk_c),
	SH_PFC_PIN_GROUP(scif5_data_d),
	SH_PFC_PIN_GROUP(scif5_clk_d),
	SH_PFC_PIN_GROUP(scif_clk),
	SH_PFC_PIN_GROUP(scif_clk_b),
	SH_PFC_PIN_GROUP(scif_clk_c),
	SH_PFC_PIN_GROUP(scif_clk_d),
	SH_PFC_PIN_GROUP(sdhi0_data1),
	SH_PFC_PIN_GROUP(sdhi0_data4),
	SH_PFC_PIN_GROUP(sdhi0_ctrl),
	SH_PFC_PIN_GROUP(sdhi0_cd),
	SH_PFC_PIN_GROUP(sdhi0_wp),
	SH_PFC_PIN_GROUP(sdhi1_data1),
	SH_PFC_PIN_GROUP(sdhi1_data4),
	SH_PFC_PIN_GROUP(sdhi1_ctrl),
	SH_PFC_PIN_GROUP(sdhi1_cd),
	SH_PFC_PIN_GROUP(sdhi1_wp),
	SH_PFC_PIN_GROUP(sdhi2_data1),
	SH_PFC_PIN_GROUP(sdhi2_data4),
	SH_PFC_PIN_GROUP(sdhi2_ctrl),
	SH_PFC_PIN_GROUP(sdhi2_cd),
	SH_PFC_PIN_GROUP(sdhi2_wp),
	SH_PFC_PIN_GROUP(sdhi3_data1),
	SH_PFC_PIN_GROUP(sdhi3_data4),
	SH_PFC_PIN_GROUP(sdhi3_ctrl),
	SH_PFC_PIN_GROUP(sdhi3_cd),
	SH_PFC_PIN_GROUP(sdhi3_wp),
	SH_PFC_PIN_GROUP(usb0),
	SH_PFC_PIN_GROUP(usb0_ovc),
	SH_PFC_PIN_GROUP(usb1),
	SH_PFC_PIN_GROUP(usb1_ovc),
	SH_PFC_PIN_GROUP(usb2),
	SH_PFC_PIN_GROUP(usb2_ovc),
	SH_PFC_PIN_GROUP(vin0_data8),
	SH_PFC_PIN_GROUP(vin0_clk),
	SH_PFC_PIN_GROUP(vin0_sync),
	SH_PFC_PIN_GROUP(vin1_data8),
	SH_PFC_PIN_GROUP(vin1_clk),
	SH_PFC_PIN_GROUP(vin1_sync),
	SH_PFC_PIN_GROUP(vin2_data8),
	SH_PFC_PIN_GROUP(vin2_clk),
	SH_PFC_PIN_GROUP(vin2_sync),
	SH_PFC_PIN_GROUP(vin3_data8),
	SH_PFC_PIN_GROUP(vin3_clk),
	SH_PFC_PIN_GROUP(vin3_sync),
};

static const char * const du0_groups[] = {
	"du0_rgb666",
	"du0_rgb888",
	"du0_clk_in",
	"du0_clk_out_0",
	"du0_clk_out_1",
	"du0_sync_0",
	"du0_sync_1",
	"du0_oddf",
	"du0_cde",
};

static const char * const du1_groups[] = {
	"du1_rgb666",
	"du1_rgb888",
	"du1_clk_in",
	"du1_clk_out",
	"du1_sync_0",
	"du1_sync_1",
	"du1_oddf",
	"du1_cde",
};

static const char * const ether_groups[] = {
	"ether_rmii",
	"ether_link",
	"ether_magic",
};

static const char * const hscif0_groups[] = {
	"hscif0_data",
	"hscif0_data_b",
	"hscif0_ctrl",
	"hscif0_ctrl_b",
	"hscif0_clk",
	"hscif0_clk_b",
};

static const char * const hscif1_groups[] = {
	"hscif1_data",
	"hscif1_data_b",
	"hscif1_ctrl",
	"hscif1_ctrl_b",
	"hscif1_clk",
	"hscif1_clk_b",
};

static const char * const hspi0_groups[] = {
	"hspi0",
};

static const char * const hspi1_groups[] = {
	"hspi1",
	"hspi1_b",
	"hspi1_c",
	"hspi1_d",
};

static const char * const hspi2_groups[] = {
	"hspi2",
	"hspi2_b",
};

static const char * const i2c1_groups[] = {
	"i2c1",
	"i2c1_b",
	"i2c1_c",
	"i2c1_d",
};

static const char * const i2c2_groups[] = {
	"i2c2",
	"i2c2_b",
	"i2c2_c",
	"i2c2_d",
};

static const char * const i2c3_groups[] = {
	"i2c3",
	"i2c3_b",
};

static const char * const intc_groups[] = {
	"intc_irq0",
	"intc_irq0_b",
	"intc_irq1",
	"intc_irq1_b",
	"intc_irq2",
	"intc_irq2_b",
	"intc_irq3",
	"intc_irq3_b",
};

static const char * const lbsc_groups[] = {
	"lbsc_cs0",
	"lbsc_cs1",
	"lbsc_ex_cs0",
	"lbsc_ex_cs1",
	"lbsc_ex_cs2",
	"lbsc_ex_cs3",
	"lbsc_ex_cs4",
	"lbsc_ex_cs5",
};

static const char * const mmc0_groups[] = {
	"mmc0_data1",
	"mmc0_data4",
	"mmc0_data8",
	"mmc0_ctrl",
};

static const char * const mmc1_groups[] = {
	"mmc1_data1",
	"mmc1_data4",
	"mmc1_data8",
	"mmc1_ctrl",
};

static const char * const scif0_groups[] = {
	"scif0_data",
	"scif0_clk",
	"scif0_ctrl",
	"scif0_data_b",
	"scif0_clk_b",
	"scif0_ctrl_b",
	"scif0_data_c",
	"scif0_clk_c",
	"scif0_ctrl_c",
	"scif0_data_d",
	"scif0_clk_d",
	"scif0_ctrl_d",
};

static const char * const scif1_groups[] = {
	"scif1_data",
	"scif1_clk",
	"scif1_ctrl",
	"scif1_data_b",
	"scif1_clk_b",
	"scif1_ctrl_b",
	"scif1_data_c",
	"scif1_clk_c",
	"scif1_ctrl_c",
};

static const char * const scif2_groups[] = {
	"scif2_data",
	"scif2_clk",
	"scif2_data_b",
	"scif2_clk_b",
	"scif2_data_c",
	"scif2_clk_c",
	"scif2_data_d",
	"scif2_clk_d",
	"scif2_data_e",
};

static const char * const scif3_groups[] = {
	"scif3_data",
	"scif3_clk",
	"scif3_data_b",
	"scif3_data_c",
	"scif3_data_d",
	"scif3_data_e",
	"scif3_clk_e",
};

static const char * const scif4_groups[] = {
	"scif4_data",
	"scif4_clk",
	"scif4_data_b",
	"scif4_clk_b",
	"scif4_data_c",
	"scif4_data_d",
};

static const char * const scif5_groups[] = {
	"scif5_data",
	"scif5_clk",
	"scif5_data_b",
	"scif5_clk_b",
	"scif5_data_c",
	"scif5_clk_c",
	"scif5_data_d",
	"scif5_clk_d",
};

static const char * const scif_clk_groups[] = {
	"scif_clk",
	"scif_clk_b",
	"scif_clk_c",
	"scif_clk_d",
};

static const char * const sdhi0_groups[] = {
	"sdhi0_data1",
	"sdhi0_data4",
	"sdhi0_ctrl",
	"sdhi0_cd",
	"sdhi0_wp",
};

static const char * const sdhi1_groups[] = {
	"sdhi1_data1",
	"sdhi1_data4",
	"sdhi1_ctrl",
	"sdhi1_cd",
	"sdhi1_wp",
};

static const char * const sdhi2_groups[] = {
	"sdhi2_data1",
	"sdhi2_data4",
	"sdhi2_ctrl",
	"sdhi2_cd",
	"sdhi2_wp",
};

static const char * const sdhi3_groups[] = {
	"sdhi3_data1",
	"sdhi3_data4",
	"sdhi3_ctrl",
	"sdhi3_cd",
	"sdhi3_wp",
};

static const char * const usb0_groups[] = {
	"usb0",
	"usb0_ovc",
};

static const char * const usb1_groups[] = {
	"usb1",
	"usb1_ovc",
};

static const char * const usb2_groups[] = {
	"usb2",
	"usb2_ovc",
};

static const char * const vin0_groups[] = {
	"vin0_data8",
	"vin0_clk",
	"vin0_sync",
};

static const char * const vin1_groups[] = {
	"vin1_data8",
	"vin1_clk",
	"vin1_sync",
};

static const char * const vin2_groups[] = {
	"vin2_data8",
	"vin2_clk",
	"vin2_sync",
};

static const char * const vin3_groups[] = {
	"vin3_data8",
	"vin3_clk",
	"vin3_sync",
};

static const struct sh_pfc_function pinmux_functions[] = {
	SH_PFC_FUNCTION(du0),
	SH_PFC_FUNCTION(du1),
	SH_PFC_FUNCTION(ether),
	SH_PFC_FUNCTION(hscif0),
	SH_PFC_FUNCTION(hscif1),
	SH_PFC_FUNCTION(hspi0),
	SH_PFC_FUNCTION(hspi1),
	SH_PFC_FUNCTION(hspi2),
	SH_PFC_FUNCTION(i2c1),
	SH_PFC_FUNCTION(i2c2),
	SH_PFC_FUNCTION(i2c3),
	SH_PFC_FUNCTION(intc),
	SH_PFC_FUNCTION(lbsc),
	SH_PFC_FUNCTION(mmc0),
	SH_PFC_FUNCTION(mmc1),
	SH_PFC_FUNCTION(sdhi0),
	SH_PFC_FUNCTION(sdhi1),
	SH_PFC_FUNCTION(sdhi2),
	SH_PFC_FUNCTION(sdhi3),
	SH_PFC_FUNCTION(scif0),
	SH_PFC_FUNCTION(scif1),
	SH_PFC_FUNCTION(scif2),
	SH_PFC_FUNCTION(scif3),
	SH_PFC_FUNCTION(scif4),
	SH_PFC_FUNCTION(scif5),
	SH_PFC_FUNCTION(scif_clk),
	SH_PFC_FUNCTION(usb0),
	SH_PFC_FUNCTION(usb1),
	SH_PFC_FUNCTION(usb2),
	SH_PFC_FUNCTION(vin0),
	SH_PFC_FUNCTION(vin1),
	SH_PFC_FUNCTION(vin2),
	SH_PFC_FUNCTION(vin3),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("GPSR0", 0xfffc0004, 32, 1, GROUP(
		GP_0_31_FN, FN_IP3_31_29,
		GP_0_30_FN, FN_IP3_26_24,
		GP_0_29_FN, FN_IP3_22_21,
		GP_0_28_FN, FN_IP3_14_12,
		GP_0_27_FN, FN_IP3_11_9,
		GP_0_26_FN, FN_IP3_2_0,
		GP_0_25_FN, FN_IP2_30_28,
		GP_0_24_FN, FN_IP2_21_19,
		GP_0_23_FN, FN_IP2_18_16,
		GP_0_22_FN, FN_IP0_30_28,
		GP_0_21_FN, FN_IP0_5_3,
		GP_0_20_FN, FN_IP1_18_15,
		GP_0_19_FN, FN_IP1_14_11,
		GP_0_18_FN, FN_IP1_10_7,
		GP_0_17_FN, FN_IP1_6_4,
		GP_0_16_FN, FN_IP1_3_2,
		GP_0_15_FN, FN_IP1_1_0,
		GP_0_14_FN, FN_IP0_27_26,
		GP_0_13_FN, FN_IP0_25,
		GP_0_12_FN, FN_IP0_24_23,
		GP_0_11_FN, FN_IP0_22_19,
		GP_0_10_FN, FN_IP0_18_16,
		GP_0_9_FN, FN_IP0_15_14,
		GP_0_8_FN, FN_IP0_13_12,
		GP_0_7_FN, FN_IP0_11_10,
		GP_0_6_FN, FN_IP0_9_8,
		GP_0_5_FN, FN_A19,
		GP_0_4_FN, FN_A18,
		GP_0_3_FN, FN_A17,
		GP_0_2_FN, FN_IP0_7_6,
		GP_0_1_FN, FN_AVS2,
		GP_0_0_FN, FN_AVS1 ))
	},
	{ PINMUX_CFG_REG("GPSR1", 0xfffc0008, 32, 1, GROUP(
		GP_1_31_FN, FN_IP5_23_21,
		GP_1_30_FN, FN_IP5_20_17,
		GP_1_29_FN, FN_IP5_16_15,
		GP_1_28_FN, FN_IP5_14_13,
		GP_1_27_FN, FN_IP5_12_11,
		GP_1_26_FN, FN_IP5_10_9,
		GP_1_25_FN, FN_IP5_8,
		GP_1_24_FN, FN_IP5_7,
		GP_1_23_FN, FN_IP5_6,
		GP_1_22_FN, FN_IP5_5,
		GP_1_21_FN, FN_IP5_4,
		GP_1_20_FN, FN_IP5_3,
		GP_1_19_FN, FN_IP5_2_0,
		GP_1_18_FN, FN_IP4_31_29,
		GP_1_17_FN, FN_IP4_28,
		GP_1_16_FN, FN_IP4_27,
		GP_1_15_FN, FN_IP4_26,
		GP_1_14_FN, FN_IP4_25,
		GP_1_13_FN, FN_IP4_24,
		GP_1_12_FN, FN_IP4_23,
		GP_1_11_FN, FN_IP4_22_20,
		GP_1_10_FN, FN_IP4_19_17,
		GP_1_9_FN, FN_IP4_16,
		GP_1_8_FN, FN_IP4_15,
		GP_1_7_FN, FN_IP4_14,
		GP_1_6_FN, FN_IP4_13,
		GP_1_5_FN, FN_IP4_12,
		GP_1_4_FN, FN_IP4_11,
		GP_1_3_FN, FN_IP4_10_8,
		GP_1_2_FN, FN_IP4_7_5,
		GP_1_1_FN, FN_IP4_4_2,
		GP_1_0_FN, FN_IP4_1_0 ))
	},
	{ PINMUX_CFG_REG("GPSR2", 0xfffc000c, 32, 1, GROUP(
		GP_2_31_FN, FN_IP10_28_26,
		GP_2_30_FN, FN_IP10_25_24,
		GP_2_29_FN, FN_IP10_23_21,
		GP_2_28_FN, FN_IP10_20_18,
		GP_2_27_FN, FN_IP10_17_15,
		GP_2_26_FN, FN_IP10_14_12,
		GP_2_25_FN, FN_IP10_11_9,
		GP_2_24_FN, FN_IP10_8_6,
		GP_2_23_FN, FN_IP10_5_3,
		GP_2_22_FN, FN_IP10_2_0,
		GP_2_21_FN, FN_IP9_29_28,
		GP_2_20_FN, FN_IP9_27_26,
		GP_2_19_FN, FN_IP9_25_24,
		GP_2_18_FN, FN_IP9_23_22,
		GP_2_17_FN, FN_IP9_21_19,
		GP_2_16_FN, FN_IP9_18_16,
		GP_2_15_FN, FN_IP9_15_14,
		GP_2_14_FN, FN_IP9_13_12,
		GP_2_13_FN, FN_IP9_11_10,
		GP_2_12_FN, FN_IP9_9_8,
		GP_2_11_FN, FN_IP9_7,
		GP_2_10_FN, FN_IP9_6,
		GP_2_9_FN, FN_IP9_5,
		GP_2_8_FN, FN_IP9_4,
		GP_2_7_FN, FN_IP9_3_2,
		GP_2_6_FN, FN_IP9_1_0,
		GP_2_5_FN, FN_IP8_30_28,
		GP_2_4_FN, FN_IP8_27_25,
		GP_2_3_FN, FN_IP8_24_23,
		GP_2_2_FN, FN_IP8_22_21,
		GP_2_1_FN, FN_IP8_20,
		GP_2_0_FN, FN_IP5_27_24 ))
	},
	{ PINMUX_CFG_REG("GPSR3", 0xfffc0010, 32, 1, GROUP(
		GP_3_31_FN, FN_IP6_3_2,
		GP_3_30_FN, FN_IP6_1_0,
		GP_3_29_FN, FN_IP5_30_29,
		GP_3_28_FN, FN_IP5_28,
		GP_3_27_FN, FN_IP1_24_23,
		GP_3_26_FN, FN_IP1_22_21,
		GP_3_25_FN, FN_IP1_20_19,
		GP_3_24_FN, FN_IP7_26_25,
		GP_3_23_FN, FN_IP7_24_23,
		GP_3_22_FN, FN_IP7_22_21,
		GP_3_21_FN, FN_IP7_20_19,
		GP_3_20_FN, FN_IP7_30_29,
		GP_3_19_FN, FN_IP7_28_27,
		GP_3_18_FN, FN_IP7_18_17,
		GP_3_17_FN, FN_IP7_16_15,
		GP_3_16_FN, FN_IP12_17_15,
		GP_3_15_FN, FN_IP12_14_12,
		GP_3_14_FN, FN_IP12_11_9,
		GP_3_13_FN, FN_IP12_8_6,
		GP_3_12_FN, FN_IP12_5_3,
		GP_3_11_FN, FN_IP12_2_0,
		GP_3_10_FN, FN_IP11_29_27,
		GP_3_9_FN, FN_IP11_26_24,
		GP_3_8_FN, FN_IP11_23_21,
		GP_3_7_FN, FN_IP11_20_18,
		GP_3_6_FN, FN_IP11_17_15,
		GP_3_5_FN, FN_IP11_14_12,
		GP_3_4_FN, FN_IP11_11_9,
		GP_3_3_FN, FN_IP11_8_6,
		GP_3_2_FN, FN_IP11_5_3,
		GP_3_1_FN, FN_IP11_2_0,
		GP_3_0_FN, FN_IP10_31_29 ))
	},
	{ PINMUX_CFG_REG("GPSR4", 0xfffc0014, 32, 1, GROUP(
		GP_4_31_FN, FN_IP8_19,
		GP_4_30_FN, FN_IP8_18,
		GP_4_29_FN, FN_IP8_17_16,
		GP_4_28_FN, FN_IP0_2_0,
		GP_4_27_FN, FN_USB_PENC1,
		GP_4_26_FN, FN_USB_PENC0,
		GP_4_25_FN, FN_IP8_15_12,
		GP_4_24_FN, FN_IP8_11_8,
		GP_4_23_FN, FN_IP8_7_4,
		GP_4_22_FN, FN_IP8_3_0,
		GP_4_21_FN, FN_IP2_3_0,
		GP_4_20_FN, FN_IP1_28_25,
		GP_4_19_FN, FN_IP2_15_12,
		GP_4_18_FN, FN_IP2_11_8,
		GP_4_17_FN, FN_IP2_7_4,
		GP_4_16_FN, FN_IP7_14_13,
		GP_4_15_FN, FN_IP7_12_10,
		GP_4_14_FN, FN_IP7_9_7,
		GP_4_13_FN, FN_IP7_6_4,
		GP_4_12_FN, FN_IP7_3_2,
		GP_4_11_FN, FN_IP7_1_0,
		GP_4_10_FN, FN_IP6_30_29,
		GP_4_9_FN, FN_IP6_26_25,
		GP_4_8_FN, FN_IP6_24_23,
		GP_4_7_FN, FN_IP6_22_20,
		GP_4_6_FN, FN_IP6_19_18,
		GP_4_5_FN, FN_IP6_17_15,
		GP_4_4_FN, FN_IP6_14_12,
		GP_4_3_FN, FN_IP6_11_9,
		GP_4_2_FN, FN_IP6_8,
		GP_4_1_FN, FN_IP6_7_6,
		GP_4_0_FN, FN_IP6_5_4 ))
	},
	{ PINMUX_CFG_REG("GPSR5", 0xfffc0018, 32, 1, GROUP(
		GP_5_31_FN, FN_IP3_5,
		GP_5_30_FN, FN_IP3_4,
		GP_5_29_FN, FN_IP3_3,
		GP_5_28_FN, FN_IP2_27,
		GP_5_27_FN, FN_IP2_26,
		GP_5_26_FN, FN_IP2_25,
		GP_5_25_FN, FN_IP2_24,
		GP_5_24_FN, FN_IP2_23,
		GP_5_23_FN, FN_IP2_22,
		GP_5_22_FN, FN_IP3_28,
		GP_5_21_FN, FN_IP3_27,
		GP_5_20_FN, FN_IP3_23,
		GP_5_19_FN, FN_EX_WAIT0,
		GP_5_18_FN, FN_WE1,
		GP_5_17_FN, FN_WE0,
		GP_5_16_FN, FN_RD,
		GP_5_15_FN, FN_A16,
		GP_5_14_FN, FN_A15,
		GP_5_13_FN, FN_A14,
		GP_5_12_FN, FN_A13,
		GP_5_11_FN, FN_A12,
		GP_5_10_FN, FN_A11,
		GP_5_9_FN, FN_A10,
		GP_5_8_FN, FN_A9,
		GP_5_7_FN, FN_A8,
		GP_5_6_FN, FN_A7,
		GP_5_5_FN, FN_A6,
		GP_5_4_FN, FN_A5,
		GP_5_3_FN, FN_A4,
		GP_5_2_FN, FN_A3,
		GP_5_1_FN, FN_A2,
		GP_5_0_FN, FN_A1 ))
	},
	{ PINMUX_CFG_REG("GPSR6", 0xfffc001c, 32, 1, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0,	0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,	0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_6_8_FN, FN_IP3_20,
		GP_6_7_FN, FN_IP3_19,
		GP_6_6_FN, FN_IP3_18,
		GP_6_5_FN, FN_IP3_17,
		GP_6_4_FN, FN_IP3_16,
		GP_6_3_FN, FN_IP3_15,
		GP_6_2_FN, FN_IP3_8,
		GP_6_1_FN, FN_IP3_7,
		GP_6_0_FN, FN_IP3_6 ))
	},

	{ PINMUX_CFG_REG_VAR("IPSR0", 0xfffc0020, 32,
			     GROUP(1, 3, 2, 1, 2, 4, 3, 2, 2, 2, 2, 2, 3, 3),
			     GROUP(
		/* IP0_31 [1] */
		0, 0,
		/* IP0_30_28 [3] */
		FN_RD_WR, FN_FWE, FN_ATAG0, FN_VI1_R7,
		FN_HRTS1, FN_RX4_C, 0, 0,
		/* IP0_27_26 [2] */
		FN_CS1_A26, FN_HSPI_TX2, FN_SDSELF_B, 0,
		/* IP0_25 [1] */
		FN_CS0, FN_HSPI_CS2_B,
		/* IP0_24_23 [2] */
		FN_CLKOUT, FN_TX3C_IRDA_TX_C, FN_PWM0_B, 0,
		/* IP0_22_19 [4] */
		FN_A25, FN_SD1_WP, FN_MMC0_D5, FN_FD5,
		FN_HSPI_RX2, FN_VI1_R3, FN_TX5_B, FN_SSI_SDATA7_B,
		FN_CTS0_B, 0, 0, 0,
		0, 0, 0, 0,
		/* IP0_18_16 [3] */
		FN_A24, FN_SD1_CD, FN_MMC0_D4, FN_FD4,
		FN_HSPI_CS2, FN_VI1_R2, FN_SSI_WS78_B, 0,
		/* IP0_15_14 [2] */
		FN_A23, FN_FCLE, FN_HSPI_CLK2, FN_VI1_R1,
		/* IP0_13_12 [2] */
		FN_A22, FN_RX5_D, FN_HSPI_RX2_B, FN_VI1_R0,
		/* IP0_11_10 [2] */
		FN_A21, FN_SCK5_D, FN_HSPI_CLK2_B, 0,
		/* IP0_9_8 [2] */
		FN_A20, FN_TX5_D, FN_HSPI_TX2_B, 0,
		/* IP0_7_6 [2] */
		FN_A0, FN_SD1_DAT3, FN_MMC0_D3, FN_FD3,
		/* IP0_5_3 [3] */
		FN_BS, FN_SD1_DAT2, FN_MMC0_D2, FN_FD2,
		FN_ATADIR0, FN_SDSELF, FN_HCTS1, FN_TX4_C,
		/* IP0_2_0 [3] */
		FN_USB_PENC2, FN_SCK0, FN_PWM1, FN_PWMFSW0,
		FN_SCIF_CLK, FN_TCLK0_C, 0, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("IPSR1", 0xfffc0024, 32,
			     GROUP(3, 4, 2, 2, 2, 4, 4, 4, 3, 2, 2),
			     GROUP(
		/* IP1_31_29 [3] */
		0, 0, 0, 0, 0, 0, 0, 0,
		/* IP1_28_25 [4] */
		FN_HTX0, FN_TX1, FN_SDATA, FN_CTS0_C,
		FN_SUB_TCK, FN_CC5_STATE2, FN_CC5_STATE10, FN_CC5_STATE18,
		FN_CC5_STATE26, FN_CC5_STATE34, 0, 0,
		0, 0, 0, 0,
		/* IP1_24_23 [2] */
		FN_MLB_DAT, FN_PWM4, FN_RX4, 0,
		/* IP1_22_21 [2] */
		FN_MLB_SIG, FN_PWM3, FN_TX4, 0,
		/* IP1_20_19 [2] */
		FN_MLB_CLK, FN_PWM2, FN_SCK4, 0,
		/* IP1_18_15 [4] */
		FN_EX_CS5, FN_SD1_DAT1, FN_MMC0_D1, FN_FD1,
		FN_ATAWR0, FN_VI1_R6, FN_HRX1, FN_RX2_E,
		FN_RX0_B, FN_SSI_WS9, 0, 0,
		0, 0, 0, 0,
		/* IP1_14_11 [4] */
		FN_EX_CS4, FN_SD1_DAT0, FN_MMC0_D0, FN_FD0,
		FN_ATARD0, FN_VI1_R5, FN_SCK5_B, FN_HTX1,
		FN_TX2_E, FN_TX0_B, FN_SSI_SCK9, 0,
		0, 0, 0, 0,
		/* IP1_10_7 [4] */
		FN_EX_CS3, FN_SD1_CMD, FN_MMC0_CMD, FN_FRE,
		FN_ATACS10, FN_VI1_R4, FN_RX5_B, FN_HSCK1,
		FN_SSI_SDATA8_B, FN_RTS0_B_TANS_B, FN_SSI_SDATA9, 0,
		0, 0, 0, 0,
		/* IP1_6_4 [3] */
		FN_EX_CS2, FN_SD1_CLK, FN_MMC0_CLK, FN_FALE,
		FN_ATACS00, 0, 0, 0,
		/* IP1_3_2 [2] */
		FN_EX_CS1, FN_MMC0_D7, FN_FD7, 0,
		/* IP1_1_0 [2] */
		FN_EX_CS0, FN_RX3_C_IRDA_RX_C, FN_MMC0_D6, FN_FD6 ))
	},
	{ PINMUX_CFG_REG_VAR("IPSR2", 0xfffc0028, 32,
			     GROUP(1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 4, 4, 4, 4),
			     GROUP(
		/* IP2_31 [1] */
		0, 0,
		/* IP2_30_28 [3] */
		FN_DU0_DG0, FN_LCDOUT8, FN_DREQ1, FN_SCL2,
		FN_AUDATA2, 0, 0, 0,
		/* IP2_27 [1] */
		FN_DU0_DR7, FN_LCDOUT7,
		/* IP2_26 [1] */
		FN_DU0_DR6, FN_LCDOUT6,
		/* IP2_25 [1] */
		FN_DU0_DR5, FN_LCDOUT5,
		/* IP2_24 [1] */
		FN_DU0_DR4, FN_LCDOUT4,
		/* IP2_23 [1] */
		FN_DU0_DR3, FN_LCDOUT3,
		/* IP2_22 [1] */
		FN_DU0_DR2, FN_LCDOUT2,
		/* IP2_21_19 [3] */
		FN_DU0_DR1, FN_LCDOUT1, FN_DACK0, FN_DRACK0,
		FN_GPS_SIGN_B, FN_AUDATA1, FN_RX5_C, 0,
		/* IP2_18_16 [3] */
		FN_DU0_DR0, FN_LCDOUT0, FN_DREQ0, FN_GPS_CLK_B,
		FN_AUDATA0, FN_TX5_C, 0, 0,
		/* IP2_15_12 [4] */
		FN_HRTS0, FN_RTS1_TANS, FN_MDATA, FN_TX0_C,
		FN_SUB_TMS, FN_CC5_STATE1, FN_CC5_STATE9, FN_CC5_STATE17,
		FN_CC5_STATE25, FN_CC5_STATE33, 0, 0,
		0, 0, 0, 0,
		/* IP2_11_8 [4] */
		FN_HCTS0, FN_CTS1, FN_STM, FN_PWM0_D,
		FN_RX0_C, FN_SCIF_CLK_C, FN_SUB_TRST, FN_TCLK1_B,
		FN_CC5_OSCOUT, 0, 0, 0,
		0, 0, 0, 0,
		/* IP2_7_4 [4] */
		FN_HSCK0, FN_SCK1, FN_MTS, FN_PWM5,
		FN_SCK0_C, FN_SSI_SDATA9_B, FN_SUB_TDO, FN_CC5_STATE0,
		FN_CC5_STATE8, FN_CC5_STATE16, FN_CC5_STATE24, FN_CC5_STATE32,
		0, 0, 0, 0,
		/* IP2_3_0 [4] */
		FN_HRX0, FN_RX1, FN_SCKZ, FN_RTS0_C_TANS_C,
		FN_SUB_TDI, FN_CC5_STATE3, FN_CC5_STATE11, FN_CC5_STATE19,
		FN_CC5_STATE27, FN_CC5_STATE35, 0, 0,
		0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("IPSR3", 0xfffc002c, 32,
			     GROUP(3, 1, 1, 3, 1, 2, 1, 1, 1, 1, 1, 1,
				   3, 3, 1, 1, 1, 1, 1, 1, 3),
			     GROUP(
	    /* IP3_31_29 [3] */
	    FN_DU0_EXODDF_DU0_ODDF_DISP_CDE, FN_QCPV_QDE, FN_CAN1_TX, FN_TX2_C,
	    FN_SCL2_C, FN_REMOCON, 0, 0,
	    /* IP3_28 [1] */
	    FN_DU0_EXVSYNC_DU0_VSYNC, FN_QSTB_QHE,
	    /* IP3_27 [1] */
	    FN_DU0_EXHSYNC_DU0_HSYNC, FN_QSTH_QHS,
	    /* IP3_26_24 [3] */
	    FN_DU0_DOTCLKOUT1, FN_QSTVB_QVE, FN_RX3_D_IRDA_RX_D, FN_SDA3_B,
	    FN_SDA2_C, FN_DACK0_B, FN_DRACK0_B, 0,
	    /* IP3_23 [1] */
	    FN_DU0_DOTCLKOUT0, FN_QCLK,
	    /* IP3_22_21 [2] */
	    FN_DU0_DOTCLKIN, FN_QSTVA_QVS, FN_TX3_D_IRDA_TX_D, FN_SCL3_B,
	    /* IP3_20 [1] */
	    FN_DU0_DB7, FN_LCDOUT23,
	    /* IP3_19 [1] */
	    FN_DU0_DB6, FN_LCDOUT22,
	    /* IP3_18 [1] */
	    FN_DU0_DB5, FN_LCDOUT21,
	    /* IP3_17 [1] */
	    FN_DU0_DB4, FN_LCDOUT20,
	    /* IP3_16 [1] */
	    FN_DU0_DB3, FN_LCDOUT19,
	    /* IP3_15 [1] */
	    FN_DU0_DB2, FN_LCDOUT18,
	    /* IP3_14_12 [3] */
	    FN_DU0_DB1, FN_LCDOUT17, FN_EX_WAIT2, FN_SDA1,
	    FN_GPS_MAG_B, FN_AUDATA5, FN_SCK5_C, 0,
	    /* IP3_11_9 [3] */
	    FN_DU0_DB0, FN_LCDOUT16, FN_EX_WAIT1, FN_SCL1,
	    FN_TCLK1, FN_AUDATA4, 0, 0,
	    /* IP3_8 [1] */
	    FN_DU0_DG7, FN_LCDOUT15,
	    /* IP3_7 [1] */
	    FN_DU0_DG6, FN_LCDOUT14,
	    /* IP3_6 [1] */
	    FN_DU0_DG5, FN_LCDOUT13,
	    /* IP3_5 [1] */
	    FN_DU0_DG4, FN_LCDOUT12,
	    /* IP3_4 [1] */
	    FN_DU0_DG3, FN_LCDOUT11,
	    /* IP3_3 [1] */
	    FN_DU0_DG2, FN_LCDOUT10,
	    /* IP3_2_0 [3] */
	    FN_DU0_DG1, FN_LCDOUT9, FN_DACK1, FN_SDA2,
	    FN_AUDATA3, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("IPSR4", 0xfffc0030, 32,
			     GROUP(3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1,
				   1, 1, 1, 3, 3, 3, 2),
			     GROUP(
	    /* IP4_31_29 [3] */
	    FN_DU1_DB0, FN_VI2_DATA4_VI2_B4, FN_SCL2_B, FN_SD3_DAT0,
	    FN_TX5, FN_SCK0_D, 0, 0,
	    /* IP4_28 [1] */
	    FN_DU1_DG7, FN_VI2_R3,
	    /* IP4_27 [1] */
	    FN_DU1_DG6, FN_VI2_R2,
	    /* IP4_26 [1] */
	    FN_DU1_DG5, FN_VI2_R1,
	    /* IP4_25 [1] */
	    FN_DU1_DG4, FN_VI2_R0,
	    /* IP4_24 [1] */
	    FN_DU1_DG3, FN_VI2_G7,
	    /* IP4_23 [1] */
	    FN_DU1_DG2, FN_VI2_G6,
	    /* IP4_22_20 [3] */
	    FN_DU1_DG1, FN_VI2_DATA3_VI2_B3, FN_SDA1_B, FN_SD3_DAT3,
	    FN_SCK5, FN_AUDATA7, FN_RX0_D, 0,
	    /* IP4_19_17 [3] */
	    FN_DU1_DG0, FN_VI2_DATA2_VI2_B2, FN_SCL1_B, FN_SD3_DAT2,
	    FN_SCK3_E, FN_AUDATA6, FN_TX0_D, 0,
	    /* IP4_16 [1] */
	    FN_DU1_DR7, FN_VI2_G5,
	    /* IP4_15 [1] */
	    FN_DU1_DR6, FN_VI2_G4,
	    /* IP4_14 [1] */
	    FN_DU1_DR5, FN_VI2_G3,
	    /* IP4_13 [1] */
	    FN_DU1_DR4, FN_VI2_G2,
	    /* IP4_12 [1] */
	    FN_DU1_DR3, FN_VI2_G1,
	    /* IP4_11 [1] */
	    FN_DU1_DR2, FN_VI2_G0,
	    /* IP4_10_8 [3] */
	    FN_DU1_DR1, FN_VI2_DATA1_VI2_B1, FN_PWM0, FN_SD3_CMD,
	    FN_RX3_E_IRDA_RX_E, FN_AUDSYNC, FN_CTS0_D, 0,
	    /* IP4_7_5 [3] */
	    FN_DU1_DR0, FN_VI2_DATA0_VI2_B0, FN_PWM6, FN_SD3_CLK,
	    FN_TX3_E_IRDA_TX_E, FN_AUDCK, FN_PWMFSW0_B, 0,
	    /* IP4_4_2 [3] */
	    FN_DU0_CDE, FN_QPOLB, FN_CAN1_RX, FN_RX2_C,
	    FN_DREQ0_B, FN_SSI_SCK78_B, FN_SCK0_B, 0,
	    /* IP4_1_0 [2] */
	    FN_DU0_DISP, FN_QPOLA, FN_CAN_CLK_C, FN_SCK2_C ))
	},
	{ PINMUX_CFG_REG_VAR("IPSR5", 0xfffc0034, 32,
			     GROUP(1, 2, 1, 4, 3, 4, 2, 2, 2, 2, 1, 1,
				   1, 1, 1, 1, 3),
			     GROUP(
	    /* IP5_31 [1] */
	    0, 0,
	    /* IP5_30_29 [2] */
	    FN_AUDIO_CLKB, FN_USB_OVC2, FN_CAN_DEBUGOUT0, FN_MOUT0,
	    /* IP5_28 [1] */
	    FN_AUDIO_CLKA, FN_CAN_TXCLK,
	    /* IP5_27_24 [4] */
	    FN_DU1_CDE, FN_VI2_DATA7_VI2_B7, FN_RX3_B_IRDA_RX_B, FN_SD3_WP,
	    FN_HSPI_RX1, FN_VI1_FIELD, FN_VI3_FIELD, FN_AUDIO_CLKOUT,
	    FN_RX2_D, FN_GPS_CLK_C, FN_GPS_CLK_D, 0,
	    0, 0, 0, 0,
	    /* IP5_23_21 [3] */
	    FN_DU1_DISP, FN_VI2_DATA6_VI2_B6, FN_TCLK0, FN_QSTVA_B_QVS_B,
	    FN_HSPI_CLK1, FN_SCK2_D, FN_AUDIO_CLKOUT_B, FN_GPS_MAG_D,
	    /* IP5_20_17 [4] */
	    FN_DU1_EXODDF_DU1_ODDF_DISP_CDE, FN_VI2_CLK, FN_TX3_B_IRDA_TX_B,
	    FN_SD3_CD, FN_HSPI_TX1, FN_VI1_CLKENB, FN_VI3_CLKENB,
	    FN_AUDIO_CLKC, FN_TX2_D, FN_SPEEDIN, FN_GPS_SIGN_D, 0,
	    0, 0, 0, 0,
	    /* IP5_16_15 [2] */
	    FN_DU1_EXVSYNC_DU1_VSYNC, FN_VI2_VSYNC, FN_VI3_VSYNC, 0,
	    /* IP5_14_13 [2] */
	    FN_DU1_EXHSYNC_DU1_HSYNC, FN_VI2_HSYNC, FN_VI3_HSYNC, 0,
	    /* IP5_12_11 [2] */
	    FN_DU1_DOTCLKOUT, FN_VI2_FIELD, FN_SDA1_D, 0,
	    /* IP5_10_9 [2] */
	    FN_DU1_DOTCLKIN, FN_VI2_CLKENB, FN_HSPI_CS1, FN_SCL1_D,
	    /* IP5_8 [1] */
	    FN_DU1_DB7, FN_SDA2_D,
	    /* IP5_7 [1] */
	    FN_DU1_DB6, FN_SCL2_D,
	    /* IP5_6 [1] */
	    FN_DU1_DB5, FN_VI2_R7,
	    /* IP5_5 [1] */
	    FN_DU1_DB4, FN_VI2_R6,
	    /* IP5_4 [1] */
	    FN_DU1_DB3, FN_VI2_R5,
	    /* IP5_3 [1] */
	    FN_DU1_DB2, FN_VI2_R4,
	    /* IP5_2_0 [3] */
	    FN_DU1_DB1, FN_VI2_DATA5_VI2_B5, FN_SDA2_B, FN_SD3_DAT1,
	    FN_RX5, FN_RTS0_D_TANS_D, 0, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("IPSR6", 0xfffc0038, 32,
			     GROUP(1, 2, 2, 2, 2, 3, 2, 3, 3, 3, 1, 2,
				   2, 2, 2),
			     GROUP(
	    /* IP6_31 [1] */
	    0, 0,
	    /* IP6_30_29 [2] */
	    FN_SSI_SCK6, FN_ADICHS0, FN_CAN0_TX, FN_IERX_B,
	    /* IP_28_27 [2] */
	    0, 0, 0, 0,
	    /* IP6_26_25 [2] */
	    FN_SSI_SDATA5, FN_ADIDATA, FN_CAN_DEBUGOUT12, FN_RX3_IRDA_RX,
	    /* IP6_24_23 [2] */
	    FN_SSI_WS5, FN_ADICS_SAMP, FN_CAN_DEBUGOUT11, FN_TX3_IRDA_TX,
	    /* IP6_22_20 [3] */
	    FN_SSI_SCK5, FN_ADICLK, FN_CAN_DEBUGOUT10, FN_SCK3,
	    FN_TCLK0_D, 0, 0, 0,
	    /* IP6_19_18 [2] */
	    FN_SSI_SDATA4, FN_CAN_DEBUGOUT9, FN_SSI_SDATA9_C, 0,
	    /* IP6_17_15 [3] */
	    FN_SSI_SDATA3, FN_PWM0_C, FN_CAN_DEBUGOUT8, FN_CAN_CLK_B,
	    FN_IECLK, FN_SCIF_CLK_B, FN_TCLK0_B, 0,
	    /* IP6_14_12 [3] */
	    FN_SSI_WS34, FN_CAN_DEBUGOUT7, FN_CAN0_RX_B, FN_IETX,
	    FN_SSI_WS9_C, 0, 0, 0,
	    /* IP6_11_9 [3] */
	    FN_SSI_SCK34, FN_CAN_DEBUGOUT6, FN_CAN0_TX_B, FN_IERX,
	    FN_SSI_SCK9_C, 0, 0, 0,
	    /* IP6_8 [1] */
	    FN_SSI_SDATA2, FN_CAN_DEBUGOUT5,
	    /* IP6_7_6 [2] */
	    FN_SSI_SDATA1, FN_CAN_DEBUGOUT4, FN_MOUT6, 0,
	    /* IP6_5_4 [2] */
	    FN_SSI_SDATA0, FN_CAN_DEBUGOUT3, FN_MOUT5, 0,
	    /* IP6_3_2 [2] */
	    FN_SSI_WS0129, FN_CAN_DEBUGOUT2, FN_MOUT2, 0,
	    /* IP6_1_0 [2] */
	    FN_SSI_SCK0129, FN_CAN_DEBUGOUT1, FN_MOUT1, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("IPSR7", 0xfffc003c, 32,
			     GROUP(1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3,
				   3, 2, 2),
			     GROUP(
	    /* IP7_31 [1] */
	    0, 0,
	    /* IP7_30_29 [2] */
	    FN_SD0_WP, FN_DACK2, FN_CTS1_B, 0,
	    /* IP7_28_27 [2] */
	    FN_SD0_CD, FN_DREQ2, FN_RTS1_B_TANS_B, 0,
	    /* IP7_26_25 [2] */
	    FN_SD0_DAT3, FN_ATAWR1, FN_RX2_B, FN_CC5_TDI,
	    /* IP7_24_23 [2] */
	    FN_SD0_DAT2, FN_ATARD1, FN_TX2_B, FN_CC5_TCK,
	    /* IP7_22_21 [2] */
	    FN_SD0_DAT1, FN_ATAG1, FN_SCK2_B, FN_CC5_TMS,
	    /* IP7_20_19 [2] */
	    FN_SD0_DAT0, FN_ATADIR1, FN_RX1_B, FN_CC5_TRST,
	    /* IP7_18_17 [2] */
	    FN_SD0_CMD, FN_ATACS11, FN_TX1_B, FN_CC5_TDO,
	    /* IP7_16_15 [2] */
	    FN_SD0_CLK, FN_ATACS01, FN_SCK1_B, 0,
	    /* IP7_14_13 [2] */
	    FN_SSI_SDATA8, FN_VSP, FN_IRQ3_B, FN_HSPI_RX1_C,
	    /* IP7_12_10 [3] */
	    FN_SSI_SDATA7, FN_CAN_DEBUGOUT15, FN_IRQ2_B, FN_TCLK1_C,
	    FN_HSPI_TX1_C, 0, 0, 0,
	    /* IP7_9_7 [3] */
	    FN_SSI_WS78, FN_CAN_DEBUGOUT14, FN_IRQ1_B, FN_SSI_WS9_B,
	    FN_HSPI_CS1_C, 0, 0, 0,
	    /* IP7_6_4 [3] */
	    FN_SSI_SCK78, FN_CAN_DEBUGOUT13, FN_IRQ0_B, FN_SSI_SCK9_B,
	    FN_HSPI_CLK1_C, 0, 0, 0,
	    /* IP7_3_2 [2] */
	    FN_SSI_SDATA6, FN_ADICHS2, FN_CAN_CLK, FN_IECLK_B,
	    /* IP7_1_0 [2] */
	    FN_SSI_WS6, FN_ADICHS1, FN_CAN0_RX, FN_IETX_B ))
	},
	{ PINMUX_CFG_REG_VAR("IPSR8", 0xfffc0040, 32,
			     GROUP(1, 3, 3, 2, 2, 1, 1, 1, 2, 4, 4, 4, 4),
			     GROUP(
	    /* IP8_31 [1] */
	    0, 0,
	    /* IP8_30_28 [3] */
	    FN_VI0_VSYNC, FN_VI0_DATA1_B_VI0_B1_B, FN_RTS1_C_TANS_C, FN_RX4_D,
	    FN_PWMFSW0_C, 0, 0, 0,
	    /* IP8_27_25 [3] */
	    FN_VI0_HSYNC, FN_VI0_DATA0_B_VI0_B0_B, FN_CTS1_C, FN_TX4_D,
	    FN_MMC1_CMD, FN_HSCK1_B, 0, 0,
	    /* IP8_24_23 [2] */
	    FN_VI0_FIELD, FN_RX1_C, FN_HRX1_B, 0,
	    /* IP8_22_21 [2] */
	    FN_VI0_CLKENB, FN_TX1_C, FN_HTX1_B, FN_MT1_SYNC,
	    /* IP8_20 [1] */
	    FN_VI0_CLK, FN_MMC1_CLK,
	    /* IP8_19 [1] */
	    FN_FMIN, FN_RDS_DATA,
	    /* IP8_18 [1] */
	    FN_BPFCLK, FN_PCMWE,
	    /* IP8_17_16 [2] */
	    FN_FMCLK, FN_RDS_CLK, FN_PCMOE, 0,
	    /* IP8_15_12 [4] */
	    FN_HSPI_RX0, FN_RX0, FN_CAN_STEP0, FN_AD_NCS,
	    FN_CC5_STATE7, FN_CC5_STATE15, FN_CC5_STATE23, FN_CC5_STATE31,
	    FN_CC5_STATE39, 0, 0, 0,
	    0, 0, 0, 0,
	    /* IP8_11_8 [4] */
	    FN_HSPI_TX0, FN_TX0, FN_CAN_DEBUG_HW_TRIGGER, FN_AD_DO,
	    FN_CC5_STATE6, FN_CC5_STATE14, FN_CC5_STATE22, FN_CC5_STATE30,
	    FN_CC5_STATE38, 0, 0, 0,
	    0, 0, 0, 0,
	    /* IP8_7_4 [4] */
	    FN_HSPI_CS0, FN_RTS0_TANS, FN_USB_OVC1, FN_AD_DI,
	    FN_CC5_STATE5, FN_CC5_STATE13, FN_CC5_STATE21, FN_CC5_STATE29,
	    FN_CC5_STATE37, 0, 0, 0,
	    0, 0, 0, 0,
	    /* IP8_3_0 [4] */
	    FN_HSPI_CLK0, FN_CTS0, FN_USB_OVC0, FN_AD_CLK,
	    FN_CC5_STATE4, FN_CC5_STATE12, FN_CC5_STATE20, FN_CC5_STATE28,
	    FN_CC5_STATE36, 0, 0, 0,
	    0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("IPSR9", 0xfffc0044, 32,
			     GROUP(2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 1,
				   1, 1, 1, 2, 2),
			     GROUP(
	    /* IP9_31_30 [2] */
	    0, 0, 0, 0,
	    /* IP9_29_28 [2] */
	    FN_VI0_G7, FN_ETH_RXD1, FN_SD2_DAT3_B, FN_ARM_TRACEDATA_9,
	    /* IP9_27_26 [2] */
	    FN_VI0_G6, FN_ETH_RXD0, FN_SD2_DAT2_B, FN_ARM_TRACEDATA_8,
	    /* IP9_25_24 [2] */
	    FN_VI0_G5, FN_ETH_RX_ER, FN_SD2_DAT1_B, FN_ARM_TRACEDATA_7,
	    /* IP9_23_22 [2] */
	    FN_VI0_G4, FN_ETH_TX_EN, FN_SD2_DAT0_B, FN_ARM_TRACEDATA_6,
	    /* IP9_21_19 [3] */
	    FN_VI0_G3, FN_ETH_CRS_DV, FN_MMC1_D7, FN_ARM_TRACEDATA_5,
	    FN_TS_SDAT0, 0, 0, 0,
	    /* IP9_18_16 [3] */
	    FN_VI0_G2, FN_ETH_TXD1, FN_MMC1_D6, FN_ARM_TRACEDATA_4,
	    FN_TS_SPSYNC0, 0, 0, 0,
	    /* IP9_15_14 [2] */
	    FN_VI0_G1, FN_SSI_WS78_C, FN_IRQ1, FN_ARM_TRACEDATA_3,
	    /* IP9_13_12 [2] */
	    FN_VI0_G0, FN_SSI_SCK78_C, FN_IRQ0, FN_ARM_TRACEDATA_2,
	    /* IP9_11_10 [2] */
	    FN_VI0_DATA7_VI0_B7, FN_MMC1_D5, FN_ARM_TRACEDATA_1, 0,
	    /* IP9_9_8 [2] */
	    FN_VI0_DATA6_VI0_B6, FN_MMC1_D4, FN_ARM_TRACEDATA_0, 0,
	    /* IP9_7 [1] */
	    FN_VI0_DATA5_VI0_B5, FN_MMC1_D3,
	    /* IP9_6 [1] */
	    FN_VI0_DATA4_VI0_B4, FN_MMC1_D2,
	    /* IP9_5 [1] */
	    FN_VI0_DATA3_VI0_B3, FN_MMC1_D1,
	    /* IP9_4 [1] */
	    FN_VI0_DATA2_VI0_B2, FN_MMC1_D0,
	    /* IP9_3_2 [2] */
	    FN_VI0_DATA1_VI0_B1, FN_HCTS1_B, FN_MT1_PWM, 0,
	    /* IP9_1_0 [2] */
	    FN_VI0_DATA0_VI0_B0, FN_HRTS1_B, FN_MT1_VCXO, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("IPSR10", 0xfffc0048, 32,
			     GROUP(3, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3),
			     GROUP(
	    /* IP10_31_29 [3] */
	    FN_VI1_VSYNC, FN_AUDIO_CLKOUT_C, FN_SSI_WS4, FN_SIM_CLK,
	    FN_GPS_MAG_C, FN_SPV_TRST, FN_SCL3, 0,
	    /* IP10_28_26 [3] */
	    FN_VI1_HSYNC, FN_VI3_CLK, FN_SSI_SCK4, FN_GPS_SIGN_C,
	    FN_PWMFSW0_E, 0, 0, 0,
	    /* IP10_25_24 [2] */
	    FN_VI1_CLK, FN_SIM_D, FN_SDA3, 0,
	    /* IP10_23_21 [3] */
	    FN_VI0_R7, FN_ETH_MDIO, FN_DACK2_C, FN_HSPI_RX1_B,
	    FN_SCIF_CLK_D, FN_TRACECTL, FN_MT1_PEN, 0,
	    /* IP10_20_18 [3] */
	    FN_VI0_R6, FN_ETH_MDC, FN_DREQ2_C, FN_HSPI_TX1_B,
	    FN_TRACECLK, FN_MT1_BEN, FN_PWMFSW0_D, 0,
	    /* IP10_17_15 [3] */
	    FN_VI0_R5, FN_ETH_TXD0, FN_SD2_WP_B, FN_HSPI_CS1_B,
	    FN_ARM_TRACEDATA_15, FN_MT1_D, FN_TS_SDEN0, 0,
	    /* IP10_14_12 [3] */
	    FN_VI0_R4, FN_ETH_REFCLK, FN_SD2_CD_B, FN_HSPI_CLK1_B,
	    FN_ARM_TRACEDATA_14, FN_MT1_CLK, FN_TS_SCK0, 0,
	    /* IP10_11_9 [3] */
	    FN_VI0_R3, FN_ETH_MAGIC, FN_SD2_CMD_B, FN_IRQ3,
	    FN_ARM_TRACEDATA_13, 0, 0, 0,
	    /* IP10_8_6 [3] */
	    FN_VI0_R2, FN_ETH_LINK, FN_SD2_CLK_B, FN_IRQ2,
	    FN_ARM_TRACEDATA_12, 0, 0, 0,
	    /* IP10_5_3 [3] */
	    FN_VI0_R1, FN_SSI_SDATA8_C, FN_DACK1_B, FN_ARM_TRACEDATA_11,
	    FN_DACK0_C, FN_DRACK0_C, 0, 0,
	    /* IP10_2_0 [3] */
	    FN_VI0_R0, FN_SSI_SDATA7_C, FN_SCK1_C, FN_DREQ1_B,
	    FN_ARM_TRACEDATA_10, FN_DREQ0_C, 0, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("IPSR11", 0xfffc004c, 32,
			     GROUP(2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3),
			     GROUP(
	    /* IP11_31_30 [2] */
	    0, 0, 0, 0,
	    /* IP11_29_27 [3] */
	    FN_VI1_G1, FN_VI3_DATA1, FN_SSI_SCK1, FN_TS_SDEN1,
	    FN_DACK2_B, FN_RX2, FN_HRTS0_B, 0,
	    /* IP11_26_24 [3] */
	    FN_VI1_G0, FN_VI3_DATA0, 0, FN_TS_SCK1,
	    FN_DREQ2_B, FN_TX2, FN_SPA_TDO, FN_HCTS0_B,
	    /* IP11_23_21 [3] */
	    FN_VI1_DATA7_VI1_B7, FN_SD2_WP, FN_MT0_PWM, FN_SPA_TDI,
	    FN_HSPI_RX1_D, 0, 0, 0,
	    /* IP11_20_18 [3] */
	    FN_VI1_DATA6_VI1_B6, FN_SD2_CD, FN_MT0_VCXO, FN_SPA_TMS,
	    FN_HSPI_TX1_D, 0, 0, 0,
	    /* IP11_17_15 [3] */
	    FN_VI1_DATA5_VI1_B5, FN_SD2_CMD, FN_MT0_SYNC, FN_SPA_TCK,
	    FN_HSPI_CS1_D, FN_ADICHS2_B, 0, 0,
	    /* IP11_14_12 [3] */
	    FN_VI1_DATA4_VI1_B4, FN_SD2_CLK, FN_MT0_PEN, FN_SPA_TRST,
	    FN_HSPI_CLK1_D, FN_ADICHS1_B, 0, 0,
	    /* IP11_11_9 [3] */
	    FN_VI1_DATA3_VI1_B3, FN_SD2_DAT3, FN_MT0_BEN, FN_SPV_TDO,
	    FN_ADICHS0_B, 0, 0, 0,
	    /* IP11_8_6 [3] */
	    FN_VI1_DATA2_VI1_B2, FN_SD2_DAT2, FN_MT0_D, FN_SPVTDI,
	    FN_ADIDATA_B, 0, 0, 0,
	    /* IP11_5_3 [3] */
	    FN_VI1_DATA1_VI1_B1, FN_SD2_DAT1, FN_MT0_CLK, FN_SPV_TMS,
	    FN_ADICS_B_SAMP_B, 0, 0, 0,
	    /* IP11_2_0 [3] */
	    FN_VI1_DATA0_VI1_B0, FN_SD2_DAT0, FN_SIM_RST, FN_SPV_TCK,
	    FN_ADICLK_B, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("IPSR12", 0xfffc0050, 32,
			     GROUP(4, 4, 4, 2, 3, 3, 3, 3, 3, 3),
			     GROUP(
	    /* IP12_31_28 [4] */
	    0, 0, 0, 0, 0, 0, 0, 0,
	    0, 0, 0, 0, 0, 0, 0, 0,
	    /* IP12_27_24 [4] */
	    0, 0, 0, 0, 0, 0, 0, 0,
	    0, 0, 0, 0, 0, 0, 0, 0,
	    /* IP12_23_20 [4] */
	    0, 0, 0, 0, 0, 0, 0, 0,
	    0, 0, 0, 0, 0, 0, 0, 0,
	    /* IP12_19_18 [2] */
	    0, 0, 0, 0,
	    /* IP12_17_15 [3] */
	    FN_VI1_G7, FN_VI3_DATA7, FN_GPS_MAG, FN_FCE,
	    FN_SCK4_B, 0, 0, 0,
	    /* IP12_14_12 [3] */
	    FN_VI1_G6, FN_VI3_DATA6, FN_GPS_SIGN, FN_FRB,
	    FN_RX4_B, FN_SIM_CLK_B, 0, 0,
	    /* IP12_11_9 [3] */
	    FN_VI1_G5, FN_VI3_DATA5, FN_GPS_CLK, FN_FSE,
	    FN_TX4_B, FN_SIM_D_B, 0, 0,
	    /* IP12_8_6 [3] */
	    FN_VI1_G4, FN_VI3_DATA4, FN_SSI_WS2, FN_SDA1_C,
	    FN_SIM_RST_B, FN_HRX0_B, 0, 0,
	    /* IP12_5_3 [3] */
	    FN_VI1_G3, FN_VI3_DATA3, FN_SSI_SCK2, FN_TS_SDAT1,
	    FN_SCL1_C, FN_HTX0_B, 0, 0,
	    /* IP12_2_0 [3] */
	    FN_VI1_G2, FN_VI3_DATA2, FN_SSI_WS1, FN_TS_SPSYNC1,
	    FN_SCK2, FN_HSCK0_B, 0, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("MOD_SEL", 0xfffc0090, 32,
			     GROUP(2, 2, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1,
				   1, 1, 1, 1, 2, 1, 2),
			     GROUP(
	    /* SEL_SCIF5 [2] */
	    FN_SEL_SCIF5_0, FN_SEL_SCIF5_1, FN_SEL_SCIF5_2, FN_SEL_SCIF5_3,
	    /* SEL_SCIF4 [2] */
	    FN_SEL_SCIF4_0, FN_SEL_SCIF4_1, FN_SEL_SCIF4_2, FN_SEL_SCIF4_3,
	    /* SEL_SCIF3 [3] */
	    FN_SEL_SCIF3_0, FN_SEL_SCIF3_1, FN_SEL_SCIF3_2, FN_SEL_SCIF3_3,
	    FN_SEL_SCIF3_4, 0, 0, 0,
	    /* SEL_SCIF2 [3] */
	    FN_SEL_SCIF2_0, FN_SEL_SCIF2_1, FN_SEL_SCIF2_2, FN_SEL_SCIF2_3,
	    FN_SEL_SCIF2_4, 0, 0, 0,
	    /* SEL_SCIF1 [2] */
	    FN_SEL_SCIF1_0, FN_SEL_SCIF1_1, FN_SEL_SCIF1_2, 0,
	    /* SEL_SCIF0 [2] */
	    FN_SEL_SCIF0_0, FN_SEL_SCIF0_1, FN_SEL_SCIF0_2, FN_SEL_SCIF0_3,
	    /* SEL_SSI9 [2] */
	    FN_SEL_SSI9_0, FN_SEL_SSI9_1, FN_SEL_SSI9_2, 0,
	    /* SEL_SSI8 [2] */
	    FN_SEL_SSI8_0, FN_SEL_SSI8_1, FN_SEL_SSI8_2, 0,
	    /* SEL_SSI7 [2] */
	    FN_SEL_SSI7_0, FN_SEL_SSI7_1, FN_SEL_SSI7_2, 0,
	    /* SEL_VI0 [1] */
	    FN_SEL_VI0_0, FN_SEL_VI0_1,
	    /* SEL_SD2 [1] */
	    FN_SEL_SD2_0, FN_SEL_SD2_1,
	    /* SEL_INT3 [1] */
	    FN_SEL_INT3_0, FN_SEL_INT3_1,
	    /* SEL_INT2 [1] */
	    FN_SEL_INT2_0, FN_SEL_INT2_1,
	    /* SEL_INT1 [1] */
	    FN_SEL_INT1_0, FN_SEL_INT1_1,
	    /* SEL_INT0 [1] */
	    FN_SEL_INT0_0, FN_SEL_INT0_1,
	    /* SEL_IE [1] */
	    FN_SEL_IE_0, FN_SEL_IE_1,
	    /* SEL_EXBUS2 [2] */
	    FN_SEL_EXBUS2_0, FN_SEL_EXBUS2_1, FN_SEL_EXBUS2_2, 0,
	    /* SEL_EXBUS1 [1] */
	    FN_SEL_EXBUS1_0, FN_SEL_EXBUS1_1,
	    /* SEL_EXBUS0 [2] */
	    FN_SEL_EXBUS0_0, FN_SEL_EXBUS0_1, FN_SEL_EXBUS0_2, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("MOD_SEL2", 0xfffc0094, 32,
			     GROUP(2, 2, 2, 2, 1, 1, 1, 3, 1, 2, 2, 2,
				   2, 1, 1, 2, 1, 2, 2),
			     GROUP(
	    /* SEL_TMU1 [2] */
	    FN_SEL_TMU1_0, FN_SEL_TMU1_1, FN_SEL_TMU1_2, 0,
	    /* SEL_TMU0 [2] */
	    FN_SEL_TMU0_0, FN_SEL_TMU0_1, FN_SEL_TMU0_2, FN_SEL_TMU0_3,
	    /* SEL_SCIF [2] */
	    FN_SEL_SCIF_0, FN_SEL_SCIF_1, FN_SEL_SCIF_2, FN_SEL_SCIF_3,
	    /* SEL_CANCLK [2] */
	    FN_SEL_CANCLK_0, FN_SEL_CANCLK_1, FN_SEL_CANCLK_2, 0,
	    /* SEL_CAN0 [1] */
	    FN_SEL_CAN0_0, FN_SEL_CAN0_1,
	    /* SEL_HSCIF1 [1] */
	    FN_SEL_HSCIF1_0, FN_SEL_HSCIF1_1,
	    /* SEL_HSCIF0 [1] */
	    FN_SEL_HSCIF0_0, FN_SEL_HSCIF0_1,
	    /* SEL_PWMFSW [3] */
	    FN_SEL_PWMFSW_0, FN_SEL_PWMFSW_1, FN_SEL_PWMFSW_2,
	    FN_SEL_PWMFSW_3, FN_SEL_PWMFSW_4, 0, 0, 0,
	    /* SEL_ADI [1] */
	    FN_SEL_ADI_0, FN_SEL_ADI_1,
	    /* [2] */
	    0, 0, 0, 0,
	    /* [2] */
	    0, 0, 0, 0,
	    /* [2] */
	    0, 0, 0, 0,
	    /* SEL_GPS [2] */
	    FN_SEL_GPS_0, FN_SEL_GPS_1, FN_SEL_GPS_2, FN_SEL_GPS_3,
	    /* SEL_SIM [1] */
	    FN_SEL_SIM_0, FN_SEL_SIM_1,
	    /* SEL_HSPI2 [1] */
	    FN_SEL_HSPI2_0, FN_SEL_HSPI2_1,
	    /* SEL_HSPI1 [2] */
	    FN_SEL_HSPI1_0, FN_SEL_HSPI1_1, FN_SEL_HSPI1_2, FN_SEL_HSPI1_3,
	    /* SEL_I2C3 [1] */
	    FN_SEL_I2C3_0, FN_SEL_I2C3_1,
	    /* SEL_I2C2 [2] */
	    FN_SEL_I2C2_0, FN_SEL_I2C2_1, FN_SEL_I2C2_2, FN_SEL_I2C2_3,
	    /* SEL_I2C1 [2] */
	    FN_SEL_I2C1_0, FN_SEL_I2C1_1, FN_SEL_I2C1_2, FN_SEL_I2C1_3 ))
	},
	{ },
};

const struct sh_pfc_soc_info r8a7779_pinmux_info = {
	.name = "r8a7779_pfc",

	.unlock_reg = 0xfffc0000, /* PMMR */

	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),
	.groups = pinmux_groups,
	.nr_groups = ARRAY_SIZE(pinmux_groups),
	.functions = pinmux_functions,
	.nr_functions = ARRAY_SIZE(pinmux_functions),

	.cfg_regs = pinmux_config_regs,

	.pinmux_data = pinmux_data,
	.pinmux_data_size = ARRAY_SIZE(pinmux_data),
};
