/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.SerializationTester;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.TooManyListenersException;

public class DragSourceContext
implements DragSourceListener,
DragSourceMotionListener,
Serializable {
    private static final long serialVersionUID = -115407898692194719L;
    protected static final int DEFAULT = 0;
    protected static final int ENTER = 1;
    protected static final int OVER = 2;
    protected static final int CHANGED = 3;
    private static Transferable emptyTransferable;
    private transient DragSourceContextPeer peer;
    private DragGestureEvent trigger;
    private Cursor cursor;
    private transient Transferable transferable;
    private transient DragSourceListener listener;
    private boolean useCustomCursor;
    private final int sourceActions;

    public DragSourceContext(DragSourceContextPeer dragSourceContextPeer, DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) {
        if (dragSourceContextPeer == null) {
            throw new NullPointerException("DragSourceContextPeer");
        }
        if (dragGestureEvent == null) {
            throw new NullPointerException("Trigger");
        }
        if (dragGestureEvent.getDragSource() == null) {
            throw new IllegalArgumentException("DragSource");
        }
        if (dragGestureEvent.getComponent() == null) {
            throw new IllegalArgumentException("Component");
        }
        if (dragGestureEvent.getSourceAsDragGestureRecognizer().getSourceActions() == 0) {
            throw new IllegalArgumentException("source actions");
        }
        if (dragGestureEvent.getDragAction() == 0) {
            throw new IllegalArgumentException("no drag action");
        }
        if (transferable == null) {
            throw new NullPointerException("Transferable");
        }
        if (image != null && point == null) {
            throw new NullPointerException("offset");
        }
        this.peer = dragSourceContextPeer;
        this.trigger = dragGestureEvent;
        this.cursor = cursor;
        this.transferable = transferable;
        this.listener = dragSourceListener;
        this.sourceActions = dragGestureEvent.getSourceAsDragGestureRecognizer().getSourceActions();
        this.useCustomCursor = cursor != null;
        this.updateCurrentCursor(dragGestureEvent.getDragAction(), this.getSourceActions(), 0);
    }

    public DragSource getDragSource() {
        return this.trigger.getDragSource();
    }

    public Component getComponent() {
        return this.trigger.getComponent();
    }

    public DragGestureEvent getTrigger() {
        return this.trigger;
    }

    public int getSourceActions() {
        return this.sourceActions;
    }

    public synchronized void setCursor(Cursor cursor) {
        this.useCustomCursor = cursor != null;
        this.setCursorImpl(cursor);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public synchronized void addDragSourceListener(DragSourceListener dragSourceListener) throws TooManyListenersException {
        if (dragSourceListener == null) {
            return;
        }
        if (this.equals(dragSourceListener)) {
            throw new IllegalArgumentException("DragSourceContext may not be its own listener");
        }
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = dragSourceListener;
    }

    public synchronized void removeDragSourceListener(DragSourceListener dragSourceListener) {
        if (this.listener == null || !this.listener.equals(dragSourceListener)) {
            throw new IllegalArgumentException();
        }
        this.listener = null;
    }

    public void transferablesFlavorsChanged() {
        if (this.peer != null) {
            this.peer.transferablesFlavorsChanged();
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceListener dragSourceListener = this.listener;
        if (dragSourceListener != null) {
            dragSourceListener.dragEnter(dragSourceDragEvent);
        }
        this.getDragSource().processDragEnter(dragSourceDragEvent);
        this.updateCurrentCursor(this.getSourceActions(), dragSourceDragEvent.getTargetActions(), 1);
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceListener dragSourceListener = this.listener;
        if (dragSourceListener != null) {
            dragSourceListener.dragOver(dragSourceDragEvent);
        }
        this.getDragSource().processDragOver(dragSourceDragEvent);
        this.updateCurrentCursor(this.getSourceActions(), dragSourceDragEvent.getTargetActions(), 2);
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        DragSourceListener dragSourceListener = this.listener;
        if (dragSourceListener != null) {
            dragSourceListener.dragExit(dragSourceEvent);
        }
        this.getDragSource().processDragExit(dragSourceEvent);
        this.updateCurrentCursor(0, 0, 0);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceListener dragSourceListener = this.listener;
        if (dragSourceListener != null) {
            dragSourceListener.dropActionChanged(dragSourceDragEvent);
        }
        this.getDragSource().processDropActionChanged(dragSourceDragEvent);
        this.updateCurrentCursor(this.getSourceActions(), dragSourceDragEvent.getTargetActions(), 3);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        DragSourceListener dragSourceListener = this.listener;
        if (dragSourceListener != null) {
            dragSourceListener.dragDropEnd(dragSourceDropEvent);
        }
        this.getDragSource().processDragDropEnd(dragSourceDropEvent);
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
        this.getDragSource().processDragMouseMoved(dragSourceDragEvent);
    }

    public Transferable getTransferable() {
        return this.transferable;
    }

    protected synchronized void updateCurrentCursor(int n, int n2, int n3) {
        if (this.useCustomCursor) {
            return;
        }
        Cursor cursor = null;
        switch (n3) {
            default: {
                n2 = 0;
            }
            case 1: 
            case 2: 
            case 3: 
        }
        int n4 = n & n2;
        cursor = n4 == 0 ? ((n & 0x40000000) == 0x40000000 ? DragSource.DefaultLinkNoDrop : ((n & 2) == 2 ? DragSource.DefaultMoveNoDrop : DragSource.DefaultCopyNoDrop)) : ((n4 & 0x40000000) == 0x40000000 ? DragSource.DefaultLinkDrop : ((n4 & 2) == 2 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop));
        this.setCursorImpl(cursor);
    }

    private void setCursorImpl(Cursor cursor) {
        if (this.cursor == null || !this.cursor.equals(cursor)) {
            this.cursor = cursor;
            if (this.peer != null) {
                this.peer.setCursor(this.cursor);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(SerializationTester.test(this.transferable) ? this.transferable : null);
        objectOutputStream.writeObject(SerializationTester.test(this.listener) ? this.listener : null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.transferable = (Transferable)objectInputStream.readObject();
        this.listener = (DragSourceListener)objectInputStream.readObject();
        if (this.transferable == null) {
            if (emptyTransferable == null) {
                emptyTransferable = new Transferable(){

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        return new DataFlavor[0];
                    }

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                        return false;
                    }

                    @Override
                    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                        throw new UnsupportedFlavorException(dataFlavor);
                    }
                };
            }
            this.transferable = emptyTransferable;
        }
    }
}

