/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.EntryPair;
import java.text.ParseException;
import java.text.RBTableBuilder;
import java.util.Vector;
import sun.text.IntHashtable;
import sun.text.UCompactIntArray;

final class RBCollationTables {
    static final int EXPANDCHARINDEX = 0x7E000000;
    static final int CONTRACTCHARINDEX = 0x7F000000;
    static final int UNMAPPED = -1;
    static final int PRIMARYORDERMASK = -65536;
    static final int SECONDARYORDERMASK = 65280;
    static final int TERTIARYORDERMASK = 255;
    static final int PRIMARYDIFFERENCEONLY = -65536;
    static final int SECONDARYDIFFERENCEONLY = -256;
    static final int PRIMARYORDERSHIFT = 16;
    static final int SECONDARYORDERSHIFT = 8;
    private String rules = null;
    private boolean frenchSec = false;
    private boolean seAsianSwapping = false;
    private UCompactIntArray mapping = null;
    private Vector contractTable = null;
    private Vector expandTable = null;
    private IntHashtable contractFlags = null;
    private short maxSecOrder = 0;
    private short maxTerOrder = 0;

    public RBCollationTables(String string, int n) throws ParseException {
        this.rules = string;
        RBTableBuilder rBTableBuilder = new RBTableBuilder(new BuildAPI());
        rBTableBuilder.build(string, n);
    }

    public String getRules() {
        return this.rules;
    }

    public boolean isFrenchSec() {
        return this.frenchSec;
    }

    public boolean isSEAsianSwapping() {
        return this.seAsianSwapping;
    }

    Vector getContractValues(int n) {
        int n2 = this.mapping.elementAt(n);
        return this.getContractValuesImpl(n2 - 0x7F000000);
    }

    private Vector getContractValuesImpl(int n) {
        if (n >= 0) {
            return (Vector)this.contractTable.elementAt(n);
        }
        return null;
    }

    boolean usedInContractSeq(int n) {
        return this.contractFlags.get(n) == 1;
    }

    int getMaxExpansion(int n) {
        int n2 = 1;
        if (this.expandTable != null) {
            for (int i = 0; i < this.expandTable.size(); ++i) {
                int[] nArray = (int[])this.expandTable.elementAt(i);
                int n3 = nArray.length;
                if (n3 <= n2 || nArray[n3 - 1] != n) continue;
                n2 = n3;
            }
        }
        return n2;
    }

    final int[] getExpandValueList(int n) {
        return (int[])this.expandTable.elementAt(n - 0x7E000000);
    }

    int getUnicodeOrder(int n) {
        return this.mapping.elementAt(n);
    }

    short getMaxSecOrder() {
        return this.maxSecOrder;
    }

    short getMaxTerOrder() {
        return this.maxTerOrder;
    }

    static void reverse(StringBuffer stringBuffer, int n, int n2) {
        int n3 = n;
        for (int i = n2 - 1; n3 < i; ++n3, --i) {
            char c = stringBuffer.charAt(n3);
            stringBuffer.setCharAt(n3, stringBuffer.charAt(i));
            stringBuffer.setCharAt(i, c);
        }
    }

    static final int getEntry(Vector vector, String string, boolean bl) {
        for (int i = 0; i < vector.size(); ++i) {
            EntryPair entryPair = (EntryPair)vector.elementAt(i);
            if (entryPair.fwd != bl || !entryPair.entryName.equals(string)) continue;
            return i;
        }
        return -1;
    }

    final class BuildAPI {
        private BuildAPI() {
        }

        void fillInTables(boolean bl, boolean bl2, UCompactIntArray uCompactIntArray, Vector vector, Vector vector2, IntHashtable intHashtable, short s, short s2) {
            RBCollationTables.this.frenchSec = bl;
            RBCollationTables.this.seAsianSwapping = bl2;
            RBCollationTables.this.mapping = uCompactIntArray;
            RBCollationTables.this.contractTable = vector;
            RBCollationTables.this.expandTable = vector2;
            RBCollationTables.this.contractFlags = intHashtable;
            RBCollationTables.this.maxSecOrder = s;
            RBCollationTables.this.maxTerOrder = s2;
        }
    }
}

