/*
 * Decompiled with CFR 0.152.
 */
package com.sun.awt;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import sun.awt.AWTAccessor;
import sun.awt.SunToolkit;

public final class AWTUtilities {
    private AWTUtilities() {
    }

    public static boolean isTranslucencySupported(Translucency translucency) {
        switch (translucency) {
            case PERPIXEL_TRANSPARENT: {
                return AWTUtilities.isWindowShapingSupported();
            }
            case TRANSLUCENT: {
                return AWTUtilities.isWindowOpacitySupported();
            }
            case PERPIXEL_TRANSLUCENT: {
                return AWTUtilities.isWindowTranslucencySupported();
            }
        }
        return false;
    }

    private static boolean isWindowOpacitySupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (!(toolkit instanceof SunToolkit)) {
            return false;
        }
        return ((SunToolkit)toolkit).isWindowOpacitySupported();
    }

    public static void setWindowOpacity(Window window, float f) {
        if (window == null) {
            throw new NullPointerException("The window argument should not be null.");
        }
        AWTAccessor.getWindowAccessor().setOpacity(window, f);
    }

    public static float getWindowOpacity(Window window) {
        if (window == null) {
            throw new NullPointerException("The window argument should not be null.");
        }
        return AWTAccessor.getWindowAccessor().getOpacity(window);
    }

    public static boolean isWindowShapingSupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (!(toolkit instanceof SunToolkit)) {
            return false;
        }
        return ((SunToolkit)toolkit).isWindowShapingSupported();
    }

    public static Shape getWindowShape(Window window) {
        if (window == null) {
            throw new NullPointerException("The window argument should not be null.");
        }
        return AWTAccessor.getWindowAccessor().getShape(window);
    }

    public static void setWindowShape(Window window, Shape shape) {
        if (window == null) {
            throw new NullPointerException("The window argument should not be null.");
        }
        AWTAccessor.getWindowAccessor().setShape(window, shape);
    }

    private static boolean isWindowTranslucencySupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (!(toolkit instanceof SunToolkit)) {
            return false;
        }
        if (!((SunToolkit)toolkit).isWindowTranslucencySupported()) {
            return false;
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (AWTUtilities.isTranslucencyCapable(graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration())) {
            return true;
        }
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDeviceArray[i].getConfigurations();
            for (int j = 0; j < graphicsConfigurationArray.length; ++j) {
                if (!AWTUtilities.isTranslucencyCapable(graphicsConfigurationArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static void setWindowOpaque(Window window, boolean bl) {
        if (window == null) {
            throw new NullPointerException("The window argument should not be null.");
        }
        if (!bl && !AWTUtilities.isTranslucencySupported(Translucency.PERPIXEL_TRANSLUCENT)) {
            throw new UnsupportedOperationException("The PERPIXEL_TRANSLUCENT translucency kind is not supported");
        }
        AWTAccessor.getWindowAccessor().setOpaque(window, bl);
    }

    public static boolean isWindowOpaque(Window window) {
        if (window == null) {
            throw new NullPointerException("The window argument should not be null.");
        }
        return window.isOpaque();
    }

    public static boolean isTranslucencyCapable(GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            throw new NullPointerException("The gc argument should not be null");
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (!(toolkit instanceof SunToolkit)) {
            return false;
        }
        return ((SunToolkit)toolkit).isTranslucencyCapable(graphicsConfiguration);
    }

    public static void setComponentMixingCutoutShape(Component component, Shape shape) {
        if (component == null) {
            throw new NullPointerException("The component argument should not be null.");
        }
        AWTAccessor.getComponentAccessor().setMixingCutoutShape(component, shape);
    }

    public static enum Translucency {
        PERPIXEL_TRANSPARENT,
        TRANSLUCENT,
        PERPIXEL_TRANSLUCENT;

    }
}

