/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class InhibitAnyPolicyExtension
extends Extension
implements CertAttrSet<String> {
    private static final Debug debug = Debug.getInstance("certpath");
    public static final String IDENT = "x509.info.extensions.InhibitAnyPolicy";
    public static ObjectIdentifier AnyPolicy_Id;
    public static final String NAME = "InhibitAnyPolicy";
    public static final String SKIP_CERTS = "skip_certs";
    private int skipCerts = Integer.MAX_VALUE;

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(this.skipCerts);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public InhibitAnyPolicyExtension(int n) throws IOException {
        if (n < -1) {
            throw new IOException("Invalid value for skipCerts");
        }
        this.skipCerts = n == -1 ? Integer.MAX_VALUE : n;
        this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
        this.critical = true;
        this.encodeThis();
    }

    public InhibitAnyPolicyExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
        if (!bl.booleanValue()) {
            throw new IOException("Criticality cannot be false for InhibitAnyPolicy");
        }
        this.critical = bl;
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        if (derValue.tag != 2) {
            throw new IOException("Invalid encoding of InhibitAnyPolicy: data not integer");
        }
        if (derValue.data == null) {
            throw new IOException("Invalid encoding of InhibitAnyPolicy: null data");
        }
        int n = derValue.getInteger();
        if (n < -1) {
            throw new IOException("Invalid value for skipCerts");
        }
        this.skipCerts = n == -1 ? Integer.MAX_VALUE : n;
    }

    @Override
    public String toString() {
        String string = super.toString() + "InhibitAnyPolicy: " + this.skipCerts + "\n";
        return string;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(SKIP_CERTS)) {
            if (!(object instanceof Integer)) {
                throw new IOException("Attribute value should be of type Integer.");
            }
            int n = (Integer)object;
            if (n < -1) {
                throw new IOException("Invalid value for skipCerts");
            }
            this.skipCerts = n == -1 ? Integer.MAX_VALUE : n;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
        }
        this.encodeThis();
    }

    @Override
    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(SKIP_CERTS)) {
            return new Integer(this.skipCerts);
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(SKIP_CERTS)) {
            throw new IOException("Attribute skip_certs may not be deleted.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(SKIP_CERTS);
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    static {
        try {
            AnyPolicy_Id = new ObjectIdentifier("2.5.29.32.0");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

