/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.net.www.http.HttpCapture;

public class HttpCaptureInputStream
extends FilterInputStream {
    private HttpCapture capture = null;

    public HttpCaptureInputStream(InputStream inputStream, HttpCapture httpCapture) {
        super(inputStream);
        this.capture = httpCapture;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        this.capture.received(n);
        return n;
    }

    @Override
    public void close() throws IOException {
        try {
            this.capture.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.close();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        for (int i = 0; i < n; ++i) {
            this.capture.received(byArray[i]);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        for (int i = 0; i < n3; ++i) {
            this.capture.received(byArray[n + i]);
        }
        return n3;
    }
}

