/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;

final class ZipCoder {
    private Charset cs;
    private CharsetDecoder dec;
    private CharsetEncoder enc;
    private boolean isUTF8;
    private ZipCoder utf8;

    String toString(byte[] byArray, int n) {
        CharBuffer charBuffer;
        CharsetDecoder charsetDecoder = this.decoder().reset();
        int n2 = (int)((float)n * charsetDecoder.maxCharsPerByte());
        char[] cArray = new char[n2];
        if (n2 == 0) {
            return new String(cArray);
        }
        if (this.isUTF8 && charsetDecoder instanceof ArrayDecoder) {
            int n3 = ((ArrayDecoder)((Object)charsetDecoder)).decode(byArray, 0, n, cArray);
            if (n3 == -1) {
                throw new IllegalArgumentException("MALFORMED");
            }
            return new String(cArray, 0, n3);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n);
        CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer = CharBuffer.wrap(cArray), true);
        if (!coderResult.isUnderflow()) {
            throw new IllegalArgumentException(coderResult.toString());
        }
        coderResult = charsetDecoder.flush(charBuffer);
        if (!coderResult.isUnderflow()) {
            throw new IllegalArgumentException(coderResult.toString());
        }
        return new String(cArray, 0, charBuffer.position());
    }

    String toString(byte[] byArray) {
        return this.toString(byArray, byArray.length);
    }

    byte[] getBytes(String string) {
        CharsetEncoder charsetEncoder = this.encoder().reset();
        char[] cArray = string.toCharArray();
        int n = (int)((float)cArray.length * charsetEncoder.maxBytesPerChar());
        byte[] byArray = new byte[n];
        if (n == 0) {
            return byArray;
        }
        if (this.isUTF8 && charsetEncoder instanceof ArrayEncoder) {
            int n2 = ((ArrayEncoder)((Object)charsetEncoder)).encode(cArray, 0, cArray.length, byArray);
            if (n2 == -1) {
                throw new IllegalArgumentException("MALFORMED");
            }
            return Arrays.copyOf(byArray, n2);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
        if (!coderResult.isUnderflow()) {
            throw new IllegalArgumentException(coderResult.toString());
        }
        coderResult = charsetEncoder.flush(byteBuffer);
        if (!coderResult.isUnderflow()) {
            throw new IllegalArgumentException(coderResult.toString());
        }
        if (byteBuffer.position() == byArray.length) {
            return byArray;
        }
        return Arrays.copyOf(byArray, byteBuffer.position());
    }

    byte[] getBytesUTF8(String string) {
        if (this.isUTF8) {
            return this.getBytes(string);
        }
        if (this.utf8 == null) {
            this.utf8 = new ZipCoder(StandardCharsets.UTF_8);
        }
        return this.utf8.getBytes(string);
    }

    String toStringUTF8(byte[] byArray, int n) {
        if (this.isUTF8) {
            return this.toString(byArray, n);
        }
        if (this.utf8 == null) {
            this.utf8 = new ZipCoder(StandardCharsets.UTF_8);
        }
        return this.utf8.toString(byArray, n);
    }

    boolean isUTF8() {
        return this.isUTF8;
    }

    private ZipCoder(Charset charset) {
        this.cs = charset;
        this.isUTF8 = charset.name().equals(StandardCharsets.UTF_8.name());
    }

    static ZipCoder get(Charset charset) {
        return new ZipCoder(charset);
    }

    private CharsetDecoder decoder() {
        if (this.dec == null) {
            this.dec = this.cs.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return this.dec;
    }

    private CharsetEncoder encoder() {
        if (this.enc == null) {
            this.enc = this.cs.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return this.enc;
    }
}

