/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http.spnego;

import com.sun.security.jgss.ExtendedGSSContext;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.net.www.protocol.http.HttpCallerInfo;
import sun.net.www.protocol.http.Negotiator;
import sun.security.action.GetBooleanAction;
import sun.security.jgss.GSSManagerImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.HttpCaller;

public class NegotiatorImpl
extends Negotiator {
    private static final boolean DEBUG = AccessController.doPrivileged(new GetBooleanAction("sun.security.krb5.debug"));
    private GSSContext context;
    private byte[] oneToken;

    private void init(HttpCallerInfo httpCallerInfo) throws GSSException {
        Object object;
        Oid oid = httpCallerInfo.scheme.equalsIgnoreCase("Kerberos") ? GSSUtil.GSS_KRB5_MECH_OID : (((String)(object = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("http.auth.preference", "spnego");
            }
        }))).equalsIgnoreCase("kerberos") ? GSSUtil.GSS_KRB5_MECH_OID : GSSUtil.GSS_SPNEGO_MECH_OID);
        object = new GSSManagerImpl(new HttpCaller(httpCallerInfo));
        String string = "HTTP@" + httpCallerInfo.host.toLowerCase();
        GSSName gSSName = ((GSSManagerImpl)object).createName(string, GSSName.NT_HOSTBASED_SERVICE);
        this.context = ((GSSManagerImpl)object).createContext(gSSName, oid, null, 0);
        if (this.context instanceof ExtendedGSSContext) {
            ((ExtendedGSSContext)this.context).requestDelegPolicy(true);
        }
        this.oneToken = this.context.initSecContext(new byte[0], 0, 0);
    }

    public NegotiatorImpl(HttpCallerInfo httpCallerInfo) throws IOException {
        try {
            this.init(httpCallerInfo);
        }
        catch (GSSException gSSException) {
            if (DEBUG) {
                System.out.println("Negotiate support not initiated, will fallback to other scheme if allowed. Reason:");
                gSSException.printStackTrace();
            }
            IOException iOException = new IOException("Negotiate support not initiated");
            iOException.initCause(gSSException);
            throw iOException;
        }
    }

    @Override
    public byte[] firstToken() {
        return this.oneToken;
    }

    @Override
    public byte[] nextToken(byte[] byArray) throws IOException {
        try {
            return this.context.initSecContext(byArray, 0, byArray.length);
        }
        catch (GSSException gSSException) {
            if (DEBUG) {
                System.out.println("Negotiate support cannot continue. Reason:");
                gSSException.printStackTrace();
            }
            IOException iOException = new IOException("Negotiate support cannot continue");
            iOException.initCause(gSSException);
            throw iOException;
        }
    }
}

