/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;

public class SimpleBindings
implements Bindings {
    private Map<String, Object> map;

    public SimpleBindings(Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        this.map = map;
    }

    public SimpleBindings() {
        this(new HashMap<String, Object>());
    }

    @Override
    public Object put(String string, Object object) {
        this.checkKey(string);
        return this.map.put(string, object);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        if (map == null) {
            throw new NullPointerException("toMerge map is null");
        }
        for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
            String string = entry.getKey();
            this.checkKey(string);
            this.put(string, entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        this.checkKey(object);
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Object get(Object object) {
        this.checkKey(object);
        return this.map.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Object remove(Object object) {
        this.checkKey(object);
        return this.map.remove(object);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    private void checkKey(Object object) {
        if (object == null) {
            throw new NullPointerException("key can not be null");
        }
        if (!(object instanceof String)) {
            throw new ClassCastException("key should be a String");
        }
        if (object.equals("")) {
            throw new IllegalArgumentException("key can not be empty");
        }
    }
}

