/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.lang.reflect.Constructor;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.InternationalFormatter;
import sun.reflect.misc.ReflectUtil;
import sun.swing.SwingUtilities2;

public class NumberFormatter
extends InternationalFormatter {
    private String specialChars;

    public NumberFormatter() {
        this(NumberFormat.getNumberInstance());
    }

    public NumberFormatter(NumberFormat numberFormat) {
        super(numberFormat);
        this.setFormat(numberFormat);
        this.setAllowsInvalid(true);
        this.setCommitsOnValidEdit(false);
        this.setOverwriteMode(false);
    }

    @Override
    public void setFormat(Format format) {
        super.setFormat(format);
        DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
        if (decimalFormatSymbols != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(decimalFormatSymbols.getCurrencySymbol());
            stringBuilder.append(decimalFormatSymbols.getDecimalSeparator());
            stringBuilder.append(decimalFormatSymbols.getGroupingSeparator());
            stringBuilder.append(decimalFormatSymbols.getInfinity());
            stringBuilder.append(decimalFormatSymbols.getInternationalCurrencySymbol());
            stringBuilder.append(decimalFormatSymbols.getMinusSign());
            stringBuilder.append(decimalFormatSymbols.getMonetaryDecimalSeparator());
            stringBuilder.append(decimalFormatSymbols.getNaN());
            stringBuilder.append(decimalFormatSymbols.getPercent());
            stringBuilder.append('+');
            this.specialChars = stringBuilder.toString();
        } else {
            this.specialChars = "";
        }
    }

    @Override
    Object stringToValue(String string, Format format) throws ParseException {
        if (format == null) {
            return string;
        }
        Object object = format.parseObject(string);
        return this.convertValueToValueClass(object, this.getValueClass());
    }

    private Object convertValueToValueClass(Object object, Class clazz) {
        if (clazz != null && object instanceof Number) {
            Number number = (Number)object;
            if (clazz == Integer.class) {
                return number.intValue();
            }
            if (clazz == Long.class) {
                return number.longValue();
            }
            if (clazz == Float.class) {
                return Float.valueOf(number.floatValue());
            }
            if (clazz == Double.class) {
                return number.doubleValue();
            }
            if (clazz == Byte.class) {
                return number.byteValue();
            }
            if (clazz == Short.class) {
                return number.shortValue();
            }
        }
        return object;
    }

    private char getPositiveSign() {
        return '+';
    }

    private char getMinusSign() {
        DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
        if (decimalFormatSymbols != null) {
            return decimalFormatSymbols.getMinusSign();
        }
        return '-';
    }

    private char getDecimalSeparator() {
        DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
        if (decimalFormatSymbols != null) {
            return decimalFormatSymbols.getDecimalSeparator();
        }
        return '.';
    }

    private DecimalFormatSymbols getDecimalFormatSymbols() {
        Format format = this.getFormat();
        if (format instanceof DecimalFormat) {
            return ((DecimalFormat)format).getDecimalFormatSymbols();
        }
        return null;
    }

    @Override
    boolean isLegalInsertText(String string) {
        if (this.getAllowsInvalid()) {
            return true;
        }
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || this.specialChars.indexOf(c) != -1) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isLiteral(Map map) {
        if (!super.isLiteral(map)) {
            if (map == null) {
                return false;
            }
            int n = map.size();
            if (map.get(NumberFormat.Field.GROUPING_SEPARATOR) != null) {
                --n;
                if (map.get(NumberFormat.Field.INTEGER) != null) {
                    --n;
                }
            }
            if (map.get(NumberFormat.Field.EXPONENT_SYMBOL) != null) {
                --n;
            }
            if (map.get(NumberFormat.Field.PERCENT) != null) {
                --n;
            }
            if (map.get(NumberFormat.Field.PERMILLE) != null) {
                --n;
            }
            if (map.get(NumberFormat.Field.CURRENCY) != null) {
                --n;
            }
            if (map.get(NumberFormat.Field.SIGN) != null) {
                --n;
            }
            return n == 0;
        }
        return true;
    }

    @Override
    boolean isNavigatable(int n) {
        if (!super.isNavigatable(n)) {
            return this.getBufferedChar(n) == this.getDecimalSeparator();
        }
        return true;
    }

    private NumberFormat.Field getFieldFrom(int n, int n2) {
        if (this.isValidMask()) {
            int n3 = this.getFormattedTextField().getDocument().getLength();
            AttributedCharacterIterator attributedCharacterIterator = this.getIterator();
            if (n >= n3) {
                n += n2;
            }
            while (n >= 0 && n < n3) {
                attributedCharacterIterator.setIndex(n);
                Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
                if (map != null && map.size() > 0) {
                    for (AttributedCharacterIterator.Attribute attribute : map.keySet()) {
                        if (!(attribute instanceof NumberFormat.Field)) continue;
                        return (NumberFormat.Field)attribute;
                    }
                }
                n += n2;
            }
        }
        return null;
    }

    @Override
    void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        if (!this.getAllowsInvalid() && n2 == 0 && string != null && string.length() == 1 && this.toggleSignIfNecessary(filterBypass, n, string.charAt(0))) {
            return;
        }
        super.replace(filterBypass, n, n2, string, attributeSet);
    }

    private boolean toggleSignIfNecessary(DocumentFilter.FilterBypass filterBypass, int n, char c) throws BadLocationException {
        if (c == this.getMinusSign() || c == this.getPositiveSign()) {
            NumberFormat.Field field = this.getFieldFrom(n, -1);
            try {
                Object object = field == null || field != NumberFormat.Field.EXPONENT && field != NumberFormat.Field.EXPONENT_SYMBOL && field != NumberFormat.Field.EXPONENT_SIGN ? this.toggleSign(c == this.getPositiveSign()) : this.toggleExponentSign(n, c);
                if (object != null && this.isValidValue(object, false)) {
                    int n2 = this.getLiteralCountTo(n);
                    String string = this.valueToString(object);
                    filterBypass.remove(0, filterBypass.getDocument().getLength());
                    filterBypass.insertString(0, string, null);
                    this.updateValue(object);
                    this.repositionCursor(this.getLiteralCountTo(n) - n2 + n, 1);
                    return true;
                }
            }
            catch (ParseException parseException) {
                this.invalidEdit();
            }
        }
        return false;
    }

    private Object toggleSign(boolean bl) throws ParseException {
        String string;
        Object object = this.stringToValue(this.getFormattedTextField().getText());
        if (object != null && (string = object.toString()) != null && string.length() > 0) {
            if (bl) {
                if (string.charAt(0) == '-') {
                    string = string.substring(1);
                }
            } else {
                if (string.charAt(0) == '+') {
                    string = string.substring(1);
                }
                if (string.length() > 0 && string.charAt(0) != '-') {
                    string = "-" + string;
                }
            }
            if (string != null) {
                Class<?> clazz = this.getValueClass();
                if (clazz == null) {
                    clazz = object.getClass();
                }
                try {
                    ReflectUtil.checkPackageAccess(clazz);
                    SwingUtilities2.checkAccess(clazz.getModifiers());
                    Constructor<?> constructor = clazz.getConstructor(String.class);
                    if (constructor != null) {
                        SwingUtilities2.checkAccess(constructor.getModifiers());
                        return constructor.newInstance(string);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private Object toggleExponentSign(int n, char c) throws BadLocationException, ParseException {
        String string = this.getFormattedTextField().getText();
        int n2 = 0;
        int n3 = this.getAttributeStart(NumberFormat.Field.EXPONENT_SIGN);
        if (n3 >= 0) {
            n2 = 1;
            n = n3;
        }
        string = c == this.getPositiveSign() ? this.getReplaceString(n, n2, null) : this.getReplaceString(n, n2, new String(new char[]{c}));
        return this.stringToValue(string);
    }
}

