/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;

public abstract class Size2DSyntax
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5584439964938660530L;
    private int x;
    private int y;
    public static final int INCH = 25400;
    public static final int MM = 1000;

    protected Size2DSyntax(float f, float f2, int n) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("x < 0");
        }
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("y < 0");
        }
        if (n < 1) {
            throw new IllegalArgumentException("units < 1");
        }
        this.x = (int)(f * (float)n + 0.5f);
        this.y = (int)(f2 * (float)n + 0.5f);
    }

    protected Size2DSyntax(int n, int n2, int n3) {
        if (n < 0) {
            throw new IllegalArgumentException("x < 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("y < 0");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("units < 1");
        }
        this.x = n * n3;
        this.y = n2 * n3;
    }

    private static float convertFromMicrometers(int n, int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("units is < 1");
        }
        return (float)n / (float)n2;
    }

    public float[] getSize(int n) {
        return new float[]{this.getX(n), this.getY(n)};
    }

    public float getX(int n) {
        return Size2DSyntax.convertFromMicrometers(this.x, n);
    }

    public float getY(int n) {
        return Size2DSyntax.convertFromMicrometers(this.y, n);
    }

    public String toString(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getX(n));
        stringBuffer.append('x');
        stringBuffer.append(this.getY(n));
        if (string != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Size2DSyntax && this.x == ((Size2DSyntax)object).x && this.y == ((Size2DSyntax)object).y;
    }

    public int hashCode() {
        return this.x & 0xFFFF | (this.y & 0xFFFF) << 16;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.x);
        stringBuffer.append('x');
        stringBuffer.append(this.y);
        stringBuffer.append(" um");
        return stringBuffer.toString();
    }

    protected int getXMicrometers() {
        return this.x;
    }

    protected int getYMicrometers() {
        return this.y;
    }
}

