/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.Screen;
import sun.awt.X11.Visual;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XWindowAttributes
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 92 : 136;
    }

    @Override
    public int getDataSize() {
        return XWindowAttributes.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XWindowAttributes(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XWindowAttributes() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XWindowAttributes.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_x() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_x(int n) {
        log.finest("");
        Native.putInt(this.pData + 0L, n);
    }

    public int get_y() {
        log.finest("");
        return Native.getInt(this.pData + 4L);
    }

    public void set_y(int n) {
        log.finest("");
        Native.putInt(this.pData + 4L, n);
    }

    public int get_width() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_width(int n) {
        log.finest("");
        Native.putInt(this.pData + 8L, n);
    }

    public int get_height() {
        log.finest("");
        return Native.getInt(this.pData + 12L);
    }

    public void set_height(int n) {
        log.finest("");
        Native.putInt(this.pData + 12L, n);
    }

    public int get_border_width() {
        log.finest("");
        return Native.getInt(this.pData + 16L);
    }

    public void set_border_width(int n) {
        log.finest("");
        Native.putInt(this.pData + 16L, n);
    }

    public int get_depth() {
        log.finest("");
        return Native.getInt(this.pData + 20L);
    }

    public void set_depth(int n) {
        log.finest("");
        Native.putInt(this.pData + 20L, n);
    }

    public Visual get_visual(int n) {
        log.finest("");
        return Native.getLong(this.pData + 24L) != 0L ? new Visual(Native.getLong(this.pData + 24L) + (long)(n * (XlibWrapper.dataModel == 32 ? 32 : 56))) : null;
    }

    public long get_visual() {
        log.finest("");
        return Native.getLong(this.pData + 24L);
    }

    public void set_visual(long l) {
        log.finest("");
        Native.putLong(this.pData + 24L, l);
    }

    public long get_root() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 32));
    }

    public void set_root(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 32), l);
    }

    public int get_class() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 40));
    }

    public void set_class(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 40), n);
    }

    public int get_bit_gravity() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 44));
    }

    public void set_bit_gravity(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 44), n);
    }

    public int get_win_gravity() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 48));
    }

    public void set_win_gravity(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 48), n);
    }

    public int get_backing_store() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 44 : 52));
    }

    public void set_backing_store(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 44 : 52), n);
    }

    public long get_backing_planes() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 48 : 56));
    }

    public void set_backing_planes(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 48 : 56), l);
    }

    public long get_backing_pixel() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 52 : 64));
    }

    public void set_backing_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 52 : 64), l);
    }

    public boolean get_save_under() {
        log.finest("");
        return Native.getBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 56 : 72));
    }

    public void set_save_under(boolean bl) {
        log.finest("");
        Native.putBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 56 : 72), bl);
    }

    public long get_colormap() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 60 : 80));
    }

    public void set_colormap(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 60 : 80), l);
    }

    public boolean get_map_installed() {
        log.finest("");
        return Native.getBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 64 : 88));
    }

    public void set_map_installed(boolean bl) {
        log.finest("");
        Native.putBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 64 : 88), bl);
    }

    public int get_map_state() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 68 : 92));
    }

    public void set_map_state(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 68 : 92), n);
    }

    public long get_all_event_masks() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 72 : 96));
    }

    public void set_all_event_masks(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 72 : 96), l);
    }

    public long get_your_event_mask() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 76 : 104));
    }

    public void set_your_event_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 76 : 104), l);
    }

    public long get_do_not_propagate_mask() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 80 : 112));
    }

    public void set_do_not_propagate_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 80 : 112), l);
    }

    public boolean get_override_redirect() {
        log.finest("");
        return Native.getBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 84 : 120));
    }

    public void set_override_redirect(boolean bl) {
        log.finest("");
        Native.putBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 84 : 120), bl);
    }

    public Screen get_screen(int n) {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 88 : 128)) != 0L ? new Screen(Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 88 : 128)) + (long)(n * (XlibWrapper.dataModel == 32 ? 80 : 128))) : null;
    }

    public long get_screen() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 88 : 128));
    }

    public void set_screen(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 88 : 128), l);
    }

    @Override
    String getName() {
        return "XWindowAttributes";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(920);
        stringBuilder.append("x = ").append(this.get_x()).append(", ");
        stringBuilder.append("y = ").append(this.get_y()).append(", ");
        stringBuilder.append("width = ").append(this.get_width()).append(", ");
        stringBuilder.append("height = ").append(this.get_height()).append(", ");
        stringBuilder.append("border_width = ").append(this.get_border_width()).append(", ");
        stringBuilder.append("depth = ").append(this.get_depth()).append(", ");
        stringBuilder.append("visual = ").append(this.get_visual()).append(", ");
        stringBuilder.append("root = ").append(this.get_root()).append(", ");
        stringBuilder.append("class = ").append(this.get_class()).append(", ");
        stringBuilder.append("bit_gravity = ").append(this.get_bit_gravity()).append(", ");
        stringBuilder.append("win_gravity = ").append(this.get_win_gravity()).append(", ");
        stringBuilder.append("backing_store = ").append(this.get_backing_store()).append(", ");
        stringBuilder.append("backing_planes = ").append(this.get_backing_planes()).append(", ");
        stringBuilder.append("backing_pixel = ").append(this.get_backing_pixel()).append(", ");
        stringBuilder.append("save_under = ").append(this.get_save_under()).append(", ");
        stringBuilder.append("colormap = ").append(this.get_colormap()).append(", ");
        stringBuilder.append("map_installed = ").append(this.get_map_installed()).append(", ");
        stringBuilder.append("map_state = ").append(this.get_map_state()).append(", ");
        stringBuilder.append("all_event_masks = ").append(this.get_all_event_masks()).append(", ");
        stringBuilder.append("your_event_mask = ").append(this.get_your_event_mask()).append(", ");
        stringBuilder.append("do_not_propagate_mask = ").append(this.get_do_not_propagate_mask()).append(", ");
        stringBuilder.append("override_redirect = ").append(this.get_override_redirect()).append(", ");
        stringBuilder.append("screen = ").append(this.get_screen()).append(", ");
        return stringBuilder.toString();
    }
}

