/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.zipfs;

import com.sun.nio.zipfs.ZipFileAttributeView;
import com.sun.nio.zipfs.ZipFileAttributes;
import com.sun.nio.zipfs.ZipFileSystem;
import com.sun.nio.zipfs.ZipPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.zip.ZipError;

public class ZipFileSystemProvider
extends FileSystemProvider {
    private final Map<Path, ZipFileSystem> filesystems = new HashMap<Path, ZipFileSystem>();

    @Override
    public String getScheme() {
        return "jar";
    }

    protected Path uriToPath(URI uRI) {
        String string = uRI.getScheme();
        if (string == null || !string.equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI scheme is not '" + this.getScheme() + "'");
        }
        try {
            String string2 = uRI.getRawSchemeSpecificPart();
            int n = string2.indexOf("!/");
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            return Paths.get(new URI(string2)).toAbsolutePath();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    private boolean ensureFile(Path path) {
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            if (!basicFileAttributes.isRegularFile()) {
                throw new UnsupportedOperationException();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem newFileSystem(URI uRI, Map<String, ?> map) throws IOException {
        Path path = this.uriToPath(uRI);
        Map<Path, ZipFileSystem> map2 = this.filesystems;
        synchronized (map2) {
            Path path2 = null;
            if (this.ensureFile(path) && this.filesystems.containsKey(path2 = path.toRealPath(new LinkOption[0]))) {
                throw new FileSystemAlreadyExistsException();
            }
            ZipFileSystem zipFileSystem = null;
            try {
                zipFileSystem = new ZipFileSystem(this, path, map);
            }
            catch (ZipError zipError) {
                String string = path.toString();
                if (string.endsWith(".zip") || string.endsWith(".jar")) {
                    throw zipError;
                }
                throw new UnsupportedOperationException();
            }
            this.filesystems.put(path2, zipFileSystem);
            return zipFileSystem;
        }
    }

    @Override
    public FileSystem newFileSystem(Path path, Map<String, ?> map) throws IOException {
        if (path.getFileSystem() != FileSystems.getDefault()) {
            throw new UnsupportedOperationException();
        }
        this.ensureFile(path);
        try {
            return new ZipFileSystem(this, path, map);
        }
        catch (ZipError zipError) {
            String string = path.toString();
            if (string.endsWith(".zip") || string.endsWith(".jar")) {
                throw zipError;
            }
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Path getPath(URI uRI) {
        String string = uRI.getSchemeSpecificPart();
        int n = string.indexOf("!/");
        if (n == -1) {
            throw new IllegalArgumentException("URI: " + uRI + " does not contain path info ex. jar:file:/c:/foo.zip!/BAR");
        }
        return this.getFileSystem(uRI).getPath(string.substring(n + 1), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem getFileSystem(URI uRI) {
        Map<Path, ZipFileSystem> map = this.filesystems;
        synchronized (map) {
            ZipFileSystem zipFileSystem = null;
            try {
                zipFileSystem = this.filesystems.get(this.uriToPath(uRI).toRealPath(new LinkOption[0]));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (zipFileSystem == null) {
                throw new FileSystemNotFoundException();
            }
            return zipFileSystem;
        }
    }

    static final ZipPath toZipPath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof ZipPath)) {
            throw new ProviderMismatchException();
        }
        return (ZipPath)path;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... accessModeArray) throws IOException {
        ZipFileSystemProvider.toZipPath(path).checkAccess(accessModeArray);
    }

    @Override
    public void copy(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        ZipFileSystemProvider.toZipPath(path).copy(ZipFileSystemProvider.toZipPath(path2), copyOptionArray);
    }

    @Override
    public void createDirectory(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        ZipFileSystemProvider.toZipPath(path).createDirectory(fileAttributeArray);
    }

    @Override
    public final void delete(Path path) throws IOException {
        ZipFileSystemProvider.toZipPath(path).delete();
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> clazz, LinkOption ... linkOptionArray) {
        return ZipFileAttributeView.get(ZipFileSystemProvider.toZipPath(path), clazz);
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).getFileStore();
    }

    @Override
    public boolean isHidden(Path path) {
        return ZipFileSystemProvider.toZipPath(path).isHidden();
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).isSameFile(path2);
    }

    @Override
    public void move(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        ZipFileSystemProvider.toZipPath(path).move(ZipFileSystemProvider.toZipPath(path2), copyOptionArray);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> set, ExecutorService executorService, FileAttribute<?> ... fileAttributeArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).newByteChannel(set, fileAttributeArray);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).newDirectoryStream(filter);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).newFileChannel(set, fileAttributeArray);
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... openOptionArray) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).newInputStream(openOptionArray);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... openOptionArray) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).newOutputStream(openOptionArray);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> clazz, LinkOption ... linkOptionArray) throws IOException {
        if (clazz == BasicFileAttributes.class || clazz == ZipFileAttributes.class) {
            return (A)ZipFileSystemProvider.toZipPath(path).getAttributes();
        }
        return null;
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String string, LinkOption ... linkOptionArray) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).readAttributes(string, linkOptionArray);
    }

    @Override
    public Path readSymbolicLink(Path path) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void setAttribute(Path path, String string, Object object, LinkOption ... linkOptionArray) throws IOException {
        ZipFileSystemProvider.toZipPath(path).setAttribute(string, object, linkOptionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFileSystem(Path path, ZipFileSystem zipFileSystem) throws IOException {
        Map<Path, ZipFileSystem> map = this.filesystems;
        synchronized (map) {
            path = path.toRealPath(new LinkOption[0]);
            if (this.filesystems.get(path) == zipFileSystem) {
                this.filesystems.remove(path);
            }
        }
    }
}

