/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import sun.misc.Unsafe;

public class ConcurrentLinkedQueue<E>
extends AbstractQueue<E>
implements Queue<E>,
Serializable {
    private static final long serialVersionUID = 196745693267521676L;
    private volatile transient Node<E> head;
    private volatile transient Node<E> tail;
    private static final Unsafe UNSAFE;
    private static final long headOffset;
    private static final long tailOffset;

    public ConcurrentLinkedQueue() {
        this.tail = new Node<Object>(null);
        this.head = this.tail;
    }

    public ConcurrentLinkedQueue(Collection<? extends E> collection) {
        Node<Object> node = null;
        Node<Object> node2 = null;
        for (E e : collection) {
            ConcurrentLinkedQueue.checkNotNull(e);
            Node<E> node3 = new Node<E>(e);
            if (node == null) {
                node = node2 = node3;
                continue;
            }
            node2.lazySetNext(node3);
            node2 = node3;
        }
        if (node == null) {
            node = node2 = new Node<Object>(null);
        }
        this.head = node;
        this.tail = node2;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    final void updateHead(Node<E> node, Node<E> node2) {
        if (node != node2 && this.casHead(node, node2)) {
            node.lazySetNext(node);
        }
    }

    final Node<E> succ(Node<E> node) {
        Node node2 = node.next;
        return node == node2 ? this.head : node2;
    }

    @Override
    public boolean offer(E e) {
        Node node;
        ConcurrentLinkedQueue.checkNotNull(e);
        Node<E> node2 = new Node<E>(e);
        Node node3 = node = this.tail;
        while (true) {
            Node node4;
            if ((node4 = node3.next) == null) {
                if (!node3.casNext(null, node2)) continue;
                if (node3 != node) {
                    this.casTail(node, node2);
                }
                return true;
            }
            if (node3 == node4) {
                node3 = node != (node = this.tail) ? node : this.head;
                continue;
            }
            node3 = node3 != node && node != (node = this.tail) ? node : node4;
        }
    }

    @Override
    public E poll() {
        block0: while (true) {
            Node<Object> node;
            Node<Object> node2 = node = this.head;
            while (true) {
                Node node3;
                Object e;
                if ((e = node2.item) != null && node2.casItem(e, null)) {
                    if (node2 != node) {
                        node3 = node2.next;
                        this.updateHead(node, node3 != null ? node3 : node2);
                    }
                    return e;
                }
                node3 = node2.next;
                if (node3 == null) {
                    this.updateHead(node, node2);
                    return null;
                }
                if (node2 == node3) continue block0;
                node2 = node3;
            }
            break;
        }
    }

    @Override
    public E peek() {
        block0: while (true) {
            Node<E> node;
            Node<E> node2 = node = this.head;
            while (true) {
                Node node3;
                Object e;
                if ((e = node2.item) != null || (node3 = node2.next) == null) {
                    this.updateHead(node, node2);
                    return e;
                }
                if (node2 == node3) continue block0;
                node2 = node3;
            }
            break;
        }
    }

    Node<E> first() {
        block0: while (true) {
            Node<E> node;
            Node<E> node2 = node = this.head;
            while (true) {
                Node node3;
                boolean bl;
                boolean bl2 = bl = node2.item != null;
                if (bl || (node3 = node2.next) == null) {
                    this.updateHead(node, node2);
                    return bl ? node2 : null;
                }
                if (node2 == node3) continue block0;
                node2 = node3;
            }
            break;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.first() == null;
    }

    @Override
    public int size() {
        int n = 0;
        Node<E> node = this.first();
        while (node != null && (node.item == null || ++n != Integer.MAX_VALUE)) {
            node = this.succ(node);
        }
        return n;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        Node<E> node = this.first();
        while (node != null) {
            Object e = node.item;
            if (e != null && object.equals(e)) {
                return true;
            }
            node = this.succ(node);
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        Node<E> node = null;
        Node<E> node2 = this.first();
        while (node2 != null) {
            Object e = node2.item;
            if (e != null && object.equals(e) && node2.casItem(e, null)) {
                Node<E> node3 = this.succ(node2);
                if (node != null && node3 != null) {
                    node.casNext(node2, node3);
                }
                return true;
            }
            node = node2;
            node2 = this.succ(node2);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Node<E> node;
        Object object2;
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        Node<E> node2 = null;
        Node<E> node3 = null;
        for (Object object2 : collection) {
            ConcurrentLinkedQueue.checkNotNull(object2);
            node = new Node<E>(object2);
            if (node2 == null) {
                node2 = node3 = node;
                continue;
            }
            node3.lazySetNext(node);
            node3 = node;
        }
        if (node2 == null) {
            return false;
        }
        Node<E> node4 = this.tail;
        object2 = node4;
        while (true) {
            if ((node = ((Node)object2).next) == null) {
                if (!((Node)object2).casNext(null, node2)) continue;
                if (!this.casTail(node4, node3)) {
                    node4 = this.tail;
                    if (node3.next == null) {
                        this.casTail(node4, node3);
                    }
                }
                return true;
            }
            if (object2 == node) {
                object2 = node4 != (node4 = this.tail) ? node4 : this.head;
                continue;
            }
            object2 = object2 != node4 && node4 != (node4 = this.tail) ? node4 : node;
        }
    }

    @Override
    public Object[] toArray() {
        ArrayList arrayList = new ArrayList();
        Node<E> node = this.first();
        while (node != null) {
            Object e = node.item;
            if (e != null) {
                arrayList.add(e);
            }
            node = this.succ(node);
        }
        return arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        ArrayList arrayList;
        int n = 0;
        Node<E> node = this.first();
        while (node != null && n < TArray.length) {
            arrayList = node.item;
            if (arrayList != null) {
                TArray[n++] = arrayList;
            }
            node = this.succ(node);
        }
        if (node == null) {
            if (n < TArray.length) {
                TArray[n] = null;
            }
            return TArray;
        }
        arrayList = new ArrayList();
        Node<E> node2 = this.first();
        while (node2 != null) {
            Object e = node2.item;
            if (e != null) {
                arrayList.add(e);
            }
            node2 = this.succ(node2);
        }
        return arrayList.toArray(TArray);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Node<E> node = this.first();
        while (node != null) {
            Object e = node.item;
            if (e != null) {
                objectOutputStream.writeObject(e);
            }
            node = this.succ(node);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        Node<Object> node = null;
        Node<Object> node2 = null;
        while ((object = objectInputStream.readObject()) != null) {
            Node<Object> node3 = new Node<Object>(object);
            if (node == null) {
                node = node2 = node3;
                continue;
            }
            node2.lazySetNext(node3);
            node2 = node3;
        }
        if (node == null) {
            node = node2 = new Node<Object>(null);
        }
        this.head = node;
        this.tail = node2;
    }

    @Override
    public Spliterator<E> spliterator() {
        return new CLQSpliterator(this);
    }

    private static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    private boolean casTail(Node<E> node, Node<E> node2) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, node, node2);
    }

    private boolean casHead(Node<E> node, Node<E> node2) {
        return UNSAFE.compareAndSwapObject(this, headOffset, node, node2);
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<ConcurrentLinkedQueue> clazz = ConcurrentLinkedQueue.class;
            headOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("tail"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    static final class CLQSpliterator<E>
    implements Spliterator<E> {
        static final int MAX_BATCH = 0x2000000;
        final ConcurrentLinkedQueue<E> queue;
        Node<E> current;
        int batch;
        boolean exhausted;

        CLQSpliterator(ConcurrentLinkedQueue<E> concurrentLinkedQueue) {
            this.queue = concurrentLinkedQueue;
        }

        @Override
        public Spliterator<E> trySplit() {
            Node<E> node;
            int n;
            ConcurrentLinkedQueue<E> concurrentLinkedQueue = this.queue;
            int n2 = this.batch;
            int n3 = n2 <= 0 ? 1 : (n = n2 >= 0x2000000 ? 0x2000000 : n2 + 1);
            if (!(this.exhausted || (node = this.current) == null && (node = concurrentLinkedQueue.first()) == null || node.next == null)) {
                Object[] objectArray = new Object[n];
                int n4 = 0;
                do {
                    if ((objectArray[n4] = node.item) != null) {
                        ++n4;
                    }
                    if (node != (node = node.next)) continue;
                    node = concurrentLinkedQueue.first();
                } while (node != null && n4 < n);
                this.current = node;
                if (this.current == null) {
                    this.exhausted = true;
                }
                if (n4 > 0) {
                    this.batch = n4;
                    return Spliterators.spliterator(objectArray, 0, n4, 4368);
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            Node<E> node;
            if (consumer == null) {
                throw new NullPointerException();
            }
            ConcurrentLinkedQueue<E> concurrentLinkedQueue = this.queue;
            if (!(this.exhausted || (node = this.current) == null && (node = concurrentLinkedQueue.first()) == null)) {
                this.exhausted = true;
                do {
                    Object e = node.item;
                    if (node == (node = node.next)) {
                        node = concurrentLinkedQueue.first();
                    }
                    if (e == null) continue;
                    consumer.accept(e);
                } while (node != null);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> consumer) {
            Node<E> node;
            if (consumer == null) {
                throw new NullPointerException();
            }
            ConcurrentLinkedQueue<E> concurrentLinkedQueue = this.queue;
            if (!(this.exhausted || (node = this.current) == null && (node = concurrentLinkedQueue.first()) == null)) {
                Object e;
                do {
                    e = node.item;
                    if (node != (node = node.next)) continue;
                    node = concurrentLinkedQueue.first();
                } while (e == null && node != null);
                this.current = node;
                if (this.current == null) {
                    this.exhausted = true;
                }
                if (e != null) {
                    consumer.accept(e);
                    return true;
                }
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 4368;
        }
    }

    private class Itr
    implements Iterator<E> {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;

        Itr() {
            this.advance();
        }

        private E advance() {
            Node node;
            Node node2;
            this.lastRet = this.nextNode;
            Object e = this.nextItem;
            if (this.nextNode == null) {
                node2 = ConcurrentLinkedQueue.this.first();
                node = null;
            } else {
                node = this.nextNode;
                node2 = ConcurrentLinkedQueue.this.succ(this.nextNode);
            }
            while (true) {
                if (node2 == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    return e;
                }
                Object e2 = node2.item;
                if (e2 != null) {
                    this.nextNode = node2;
                    this.nextItem = e2;
                    return e;
                }
                Node node3 = ConcurrentLinkedQueue.this.succ(node2);
                if (node != null && node3 != null) {
                    node.casNext(node2, node3);
                }
                node2 = node3;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public E next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            return this.advance();
        }

        @Override
        public void remove() {
            Node node = this.lastRet;
            if (node == null) {
                throw new IllegalStateException();
            }
            node.item = null;
            this.lastRet = null;
        }
    }

    private static class Node<E> {
        volatile E item;
        volatile Node<E> next;
        private static final Unsafe UNSAFE;
        private static final long itemOffset;
        private static final long nextOffset;

        Node(E e) {
            UNSAFE.putObject((Object)this, itemOffset, e);
        }

        boolean casItem(E e, E e2) {
            return UNSAFE.compareAndSwapObject(this, itemOffset, e, e2);
        }

        void lazySetNext(Node<E> node) {
            UNSAFE.putOrderedObject(this, nextOffset, node);
        }

        boolean casNext(Node<E> node, Node<E> node2) {
            return UNSAFE.compareAndSwapObject(this, nextOffset, node, node2);
        }

        static {
            try {
                UNSAFE = Unsafe.getUnsafe();
                Class<Node> clazz = Node.class;
                itemOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("item"));
                nextOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("next"));
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }
    }
}

