/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.util.concurrent.ExecutionException;
import sun.misc.Unsafe;

abstract class Cancellable
implements Runnable {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private final long pollingAddress;
    private final Object lock = new Object();
    private boolean completed;
    private Throwable exception;

    protected Cancellable() {
        this.pollingAddress = unsafe.allocateMemory(4L);
        unsafe.putIntVolatile(null, this.pollingAddress, 0);
    }

    protected long addressToPollForCancel() {
        return this.pollingAddress;
    }

    protected int cancelValue() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completed) {
                unsafe.putIntVolatile(null, this.pollingAddress, this.cancelValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable exception() {
        Object object = this.lock;
        synchronized (object) {
            return this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            this.implRun();
        }
        catch (Throwable throwable) {
            Object object = this.lock;
            synchronized (object) {
                this.exception = throwable;
            }
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.completed = true;
                unsafe.freeMemory(this.pollingAddress);
            }
        }
    }

    abstract void implRun() throws Throwable;

    static void runInterruptibly(Cancellable cancellable) throws ExecutionException {
        Throwable throwable;
        Thread thread = new Thread(cancellable);
        thread.start();
        boolean bl = false;
        while (thread.isAlive()) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                cancellable.cancel();
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        if ((throwable = cancellable.exception()) != null) {
            throw new ExecutionException(throwable);
        }
    }
}

