/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.NativeLibLoader;
import java.io.IOException;
import java.io.ObjectInputStream;
import sun.awt.SunToolkit;

public class MouseEvent
extends InputEvent {
    public static final int MOUSE_FIRST = 500;
    public static final int MOUSE_LAST = 507;
    public static final int MOUSE_CLICKED = 500;
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int MOUSE_DRAGGED = 506;
    public static final int MOUSE_WHEEL = 507;
    public static final int NOBUTTON = 0;
    public static final int BUTTON1 = 1;
    public static final int BUTTON2 = 2;
    public static final int BUTTON3 = 3;
    int x;
    int y;
    private int xAbs;
    private int yAbs;
    int clickCount;
    int button;
    boolean popupTrigger = false;
    private static final long serialVersionUID = -991214153494842848L;
    private static int cachedNumberOfButtons;
    private transient boolean shouldExcludeButtonFromExtModifiers = false;

    private static native void initIDs();

    public Point getLocationOnScreen() {
        return new Point(this.xAbs, this.yAbs);
    }

    public int getXOnScreen() {
        return this.xAbs;
    }

    public int getYOnScreen() {
        return this.yAbs;
    }

    public MouseEvent(Component component, int n, long l, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        this(component, n, l, n2, n3, n4, 0, 0, n5, bl, n6);
        Point point = new Point(0, 0);
        try {
            point = component.getLocationOnScreen();
            this.xAbs = point.x + n3;
            this.yAbs = point.y + n4;
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            this.xAbs = 0;
            this.yAbs = 0;
        }
    }

    public MouseEvent(Component component, int n, long l, int n2, int n3, int n4, int n5, boolean bl) {
        this(component, n, l, n2, n3, n4, n5, bl, 0);
    }

    @Override
    public int getModifiersEx() {
        int n = this.modifiers;
        if (this.shouldExcludeButtonFromExtModifiers) {
            n &= ~InputEvent.getMaskForButton(this.getButton());
        }
        return n & 0xFFFFFFC0;
    }

    public MouseEvent(Component component, int n, long l, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, int n8) {
        super(component, n, l, n2);
        this.x = n3;
        this.y = n4;
        this.xAbs = n5;
        this.yAbs = n6;
        this.clickCount = n7;
        this.popupTrigger = bl;
        if (n8 < 0) {
            throw new IllegalArgumentException("Invalid button value :" + n8);
        }
        if (n8 > 3) {
            if (!Toolkit.getDefaultToolkit().areExtraMouseButtonsEnabled()) {
                throw new IllegalArgumentException("Extra mouse events are disabled " + n8);
            }
            if (n8 > cachedNumberOfButtons) {
                throw new IllegalArgumentException("Nonexistent button " + n8);
            }
            if (this.getModifiersEx() != 0 && (n == 502 || n == 500)) {
                this.shouldExcludeButtonFromExtModifiers = true;
            }
        }
        this.button = n8;
        if (this.getModifiers() != 0 && this.getModifiersEx() == 0) {
            this.setNewModifiers();
        } else if (this.getModifiers() == 0 && (this.getModifiersEx() != 0 || n8 != 0) && n8 <= 3) {
            this.setOldModifiers();
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getPoint() {
        int n;
        int n2;
        MouseEvent mouseEvent = this;
        synchronized (mouseEvent) {
            n2 = this.x;
            n = this.y;
        }
        return new Point(n2, n);
    }

    public synchronized void translatePoint(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public int getButton() {
        return this.button;
    }

    public boolean isPopupTrigger() {
        return this.popupTrigger;
    }

    public static String getMouseModifiersText(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 8) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.alt", "Alt"));
            stringBuilder.append("+");
        }
        if ((n & 4) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.meta", "Meta"));
            stringBuilder.append("+");
        }
        if ((n & 2) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.control", "Ctrl"));
            stringBuilder.append("+");
        }
        if ((n & 1) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.shift", "Shift"));
            stringBuilder.append("+");
        }
        if ((n & 0x20) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
            stringBuilder.append("+");
        }
        if ((n & 0x10) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.button1", "Button1"));
            stringBuilder.append("+");
        }
        if ((n & 8) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.button2", "Button2"));
            stringBuilder.append("+");
        }
        if ((n & 4) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.button3", "Button3"));
            stringBuilder.append("+");
        }
        for (int i = 1; i <= cachedNumberOfButtons; ++i) {
            int n2 = InputEvent.getMaskForButton(i);
            if ((n & n2) == 0 || stringBuilder.indexOf(Toolkit.getProperty("AWT.button" + i, "Button" + i)) != -1) continue;
            stringBuilder.append(Toolkit.getProperty("AWT.button" + i, "Button" + i));
            stringBuilder.append("+");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    @Override
    public String paramString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        switch (this.id) {
            case 501: {
                stringBuilder.append("MOUSE_PRESSED");
                break;
            }
            case 502: {
                stringBuilder.append("MOUSE_RELEASED");
                break;
            }
            case 500: {
                stringBuilder.append("MOUSE_CLICKED");
                break;
            }
            case 504: {
                stringBuilder.append("MOUSE_ENTERED");
                break;
            }
            case 505: {
                stringBuilder.append("MOUSE_EXITED");
                break;
            }
            case 503: {
                stringBuilder.append("MOUSE_MOVED");
                break;
            }
            case 506: {
                stringBuilder.append("MOUSE_DRAGGED");
                break;
            }
            case 507: {
                stringBuilder.append("MOUSE_WHEEL");
                break;
            }
            default: {
                stringBuilder.append("unknown type");
            }
        }
        stringBuilder.append(",(").append(this.x).append(",").append(this.y).append(")");
        stringBuilder.append(",absolute(").append(this.xAbs).append(",").append(this.yAbs).append(")");
        if (this.id != 506 && this.id != 503) {
            stringBuilder.append(",button=").append(this.getButton());
        }
        if (this.getModifiers() != 0) {
            stringBuilder.append(",modifiers=").append(MouseEvent.getMouseModifiersText(this.modifiers));
        }
        if (this.getModifiersEx() != 0) {
            stringBuilder.append(",extModifiers=").append(MouseEvent.getModifiersExText(this.getModifiersEx()));
        }
        stringBuilder.append(",clickCount=").append(this.clickCount);
        return stringBuilder.toString();
    }

    private void setNewModifiers() {
        if ((this.modifiers & 0x10) != 0) {
            this.modifiers |= 0x400;
        }
        if ((this.modifiers & 8) != 0) {
            this.modifiers |= 0x800;
        }
        if ((this.modifiers & 4) != 0) {
            this.modifiers |= 0x1000;
        }
        if (this.id == 501 || this.id == 502 || this.id == 500) {
            if ((this.modifiers & 0x10) != 0) {
                this.button = 1;
                this.modifiers &= 0xFFFFFFF3;
                if (this.id != 501) {
                    this.modifiers &= 0xFFFFFBFF;
                }
            } else if ((this.modifiers & 8) != 0) {
                this.button = 2;
                this.modifiers &= 0xFFFFFFEB;
                if (this.id != 501) {
                    this.modifiers &= 0xFFFFF7FF;
                }
            } else if ((this.modifiers & 4) != 0) {
                this.button = 3;
                this.modifiers &= 0xFFFFFFE7;
                if (this.id != 501) {
                    this.modifiers &= 0xFFFFEFFF;
                }
            }
        }
        if ((this.modifiers & 8) != 0) {
            this.modifiers |= 0x200;
        }
        if ((this.modifiers & 4) != 0) {
            this.modifiers |= 0x100;
        }
        if ((this.modifiers & 1) != 0) {
            this.modifiers |= 0x40;
        }
        if ((this.modifiers & 2) != 0) {
            this.modifiers |= 0x80;
        }
        if ((this.modifiers & 0x20) != 0) {
            this.modifiers |= 0x2000;
        }
    }

    private void setOldModifiers() {
        if (this.id == 501 || this.id == 502 || this.id == 500) {
            switch (this.button) {
                case 1: {
                    this.modifiers |= 0x10;
                    break;
                }
                case 2: {
                    this.modifiers |= 8;
                    break;
                }
                case 3: {
                    this.modifiers |= 4;
                }
            }
        } else {
            if ((this.modifiers & 0x400) != 0) {
                this.modifiers |= 0x10;
            }
            if ((this.modifiers & 0x800) != 0) {
                this.modifiers |= 8;
            }
            if ((this.modifiers & 0x1000) != 0) {
                this.modifiers |= 4;
            }
        }
        if ((this.modifiers & 0x200) != 0) {
            this.modifiers |= 8;
        }
        if ((this.modifiers & 0x100) != 0) {
            this.modifiers |= 4;
        }
        if ((this.modifiers & 0x40) != 0) {
            this.modifiers |= 1;
        }
        if ((this.modifiers & 0x80) != 0) {
            this.modifiers |= 2;
        }
        if ((this.modifiers & 0x2000) != 0) {
            this.modifiers |= 0x20;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getModifiers() != 0 && this.getModifiersEx() == 0) {
            this.setNewModifiers();
        }
    }

    static {
        Toolkit toolkit;
        NativeLibLoader.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            MouseEvent.initIDs();
        }
        cachedNumberOfButtons = (toolkit = Toolkit.getDefaultToolkit()) instanceof SunToolkit ? ((SunToolkit)toolkit).getNumberOfButtons() : 3;
    }
}

