/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.CharToGlyphMapper;
import sun.font.NativeFont;
import sun.font.XMap;

public class NativeGlyphMapper
extends CharToGlyphMapper {
    NativeFont font;
    XMap xmapper;
    int numGlyphs;

    NativeGlyphMapper(NativeFont nativeFont) {
        this.font = nativeFont;
        this.xmapper = XMap.getXMapper(this.font.encoding);
        this.numGlyphs = nativeFont.getNumGlyphs();
        this.missingGlyph = 0;
    }

    @Override
    public int getNumGlyphs() {
        return this.numGlyphs;
    }

    @Override
    public int charToGlyph(char c) {
        if (c >= this.xmapper.convertedGlyphs.length) {
            return 0;
        }
        return this.xmapper.convertedGlyphs[c];
    }

    @Override
    public int charToGlyph(int n) {
        if (n >= this.xmapper.convertedGlyphs.length) {
            return 0;
        }
        return this.xmapper.convertedGlyphs[n];
    }

    @Override
    public void charsToGlyphs(int n, char[] cArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            nArray[i] = c >= this.xmapper.convertedGlyphs.length ? 0 : this.xmapper.convertedGlyphs[c];
        }
    }

    @Override
    public boolean charsToGlyphsNS(int n, char[] cArray, int[] nArray) {
        this.charsToGlyphs(n, cArray, nArray);
        return false;
    }

    @Override
    public void charsToGlyphs(int n, int[] nArray, int[] nArray2) {
        for (int i = 0; i < n; ++i) {
            char c = (char)nArray[i];
            nArray2[i] = c >= this.xmapper.convertedGlyphs.length ? 0 : this.xmapper.convertedGlyphs[c];
        }
    }
}

