/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.crypto.CryptoPermissions;

final class JarVerifier {
    private URL jarURL;
    private boolean savePerms;
    private CryptoPermissions appPerms = null;

    JarVerifier(URL uRL, boolean bl) {
        this.jarURL = uRL;
        this.savePerms = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verify() throws JarException, IOException {
        block10: {
            if (!this.savePerms) {
                return;
            }
            final URL uRL = this.jarURL.getProtocol().equalsIgnoreCase("jar") ? this.jarURL : new URL("jar:" + this.jarURL.toString() + "!/");
            try (ZipFile zipFile = null;){
                try {
                    zipFile = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                            jarURLConnection.setUseCaches(false);
                            return jarURLConnection.getJarFile();
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    SecurityException securityException = new SecurityException("Cannot load " + uRL.toString());
                    securityException.initCause(privilegedActionException);
                    throw securityException;
                }
                if (zipFile == null) break block10;
                JarEntry jarEntry = ((JarFile)zipFile).getJarEntry("cryptoPerms");
                if (jarEntry == null) {
                    throw new JarException("Can not find cryptoPerms");
                }
                try {
                    this.appPerms = new CryptoPermissions();
                    this.appPerms.load(((JarFile)zipFile).getInputStream(jarEntry));
                }
                catch (Exception exception) {
                    JarException jarException = new JarException("Cannot load/parse" + this.jarURL.toString());
                    jarException.initCause(exception);
                    throw jarException;
                }
            }
        }
    }

    static void verifyPolicySigned(Certificate[] certificateArray) throws Exception {
    }

    CryptoPermissions getPermissions() {
        return this.appPerms;
    }
}

