/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import javax.swing.Action;
import javax.swing.ArrayTable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.SwingPropertyChangeSupport;
import sun.security.action.GetPropertyAction;

public abstract class AbstractAction
implements Action,
Cloneable,
Serializable {
    private static Boolean RECONFIGURE_ON_NULL;
    protected boolean enabled = true;
    private transient ArrayTable arrayTable;
    protected SwingPropertyChangeSupport changeSupport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean shouldReconfigure(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == null) {
            Class<AbstractAction> clazz = AbstractAction.class;
            synchronized (AbstractAction.class) {
                if (RECONFIGURE_ON_NULL == null) {
                    RECONFIGURE_ON_NULL = Boolean.valueOf(AccessController.doPrivileged(new GetPropertyAction("swing.actions.reconfigureOnNull", "false")));
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return RECONFIGURE_ON_NULL;
            }
        }
        return false;
    }

    static void setEnabledFromAction(JComponent jComponent, Action action) {
        jComponent.setEnabled(action != null ? action.isEnabled() : true);
    }

    static void setToolTipTextFromAction(JComponent jComponent, Action action) {
        jComponent.setToolTipText(action != null ? (String)action.getValue("ShortDescription") : null);
    }

    static boolean hasSelectedKey(Action action) {
        return action != null && action.getValue("SwingSelectedKey") != null;
    }

    static boolean isSelected(Action action) {
        return Boolean.TRUE.equals(action.getValue("SwingSelectedKey"));
    }

    public AbstractAction() {
    }

    public AbstractAction(String string) {
        this.putValue("Name", string);
    }

    public AbstractAction(String string, Icon icon) {
        this(string);
        this.putValue("SmallIcon", icon);
    }

    @Override
    public Object getValue(String string) {
        if (string == "enabled") {
            return this.enabled;
        }
        if (this.arrayTable == null) {
            return null;
        }
        return this.arrayTable.get(string);
    }

    @Override
    public void putValue(String string, Object object) {
        Object object2 = null;
        if (string == "enabled") {
            if (object == null || !(object instanceof Boolean)) {
                object = false;
            }
            object2 = this.enabled;
            this.enabled = (Boolean)object;
        } else {
            if (this.arrayTable == null) {
                this.arrayTable = new ArrayTable();
            }
            if (this.arrayTable.containsKey(string)) {
                object2 = this.arrayTable.get(string);
            }
            if (object == null) {
                this.arrayTable.remove(string);
            } else {
                this.arrayTable.put(string, object);
            }
        }
        this.firePropertyChange(string, object2, object);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        if (bl2 != bl) {
            this.enabled = bl;
            this.firePropertyChange("enabled", bl2, bl);
        }
    }

    public Object[] getKeys() {
        if (this.arrayTable == null) {
            return null;
        }
        Object[] objectArray = new Object[this.arrayTable.size()];
        this.arrayTable.getKeys(objectArray);
        return objectArray;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport == null || object != null && object2 != null && object.equals(object2)) {
            return;
        }
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object clone() throws CloneNotSupportedException {
        AbstractAction abstractAction = (AbstractAction)super.clone();
        AbstractAction abstractAction2 = this;
        synchronized (abstractAction2) {
            if (this.arrayTable != null) {
                abstractAction.arrayTable = (ArrayTable)this.arrayTable.clone();
            }
        }
        return abstractAction;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        ArrayTable.writeArrayTable(objectOutputStream, this.arrayTable);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        for (int i = objectInputStream.readInt() - 1; i >= 0; --i) {
            this.putValue((String)objectInputStream.readObject(), objectInputStream.readObject());
        }
    }
}

