/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.arrays;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.arrays.ArrayData;
import jdk.nashorn.internal.runtime.arrays.ContinuousArrayData;
import jdk.nashorn.internal.runtime.arrays.DeletedRangeArrayFilter;
import jdk.nashorn.internal.runtime.arrays.IntElements;
import jdk.nashorn.internal.runtime.arrays.IntOrLongElements;
import jdk.nashorn.internal.runtime.arrays.NumberArrayData;
import jdk.nashorn.internal.runtime.arrays.ObjectArrayData;
import jdk.nashorn.internal.runtime.arrays.SparseArrayData;
import jdk.nashorn.internal.runtime.arrays.UndefinedArrayFilter;

final class LongArrayData
extends ContinuousArrayData
implements IntOrLongElements {
    private long[] array;
    private static final MethodHandle HAS_GET_ELEM = CompilerConstants.specialCall(MethodHandles.lookup(), LongArrayData.class, "getElem", Long.TYPE, Integer.TYPE).methodHandle();
    private static final MethodHandle SET_ELEM = CompilerConstants.specialCall(MethodHandles.lookup(), LongArrayData.class, "setElem", Void.TYPE, Integer.TYPE, Long.TYPE).methodHandle();

    LongArrayData(long[] array, int length) {
        super(length);
        assert (array.length >= length);
        this.array = array;
    }

    @Override
    public final Class<?> getElementType() {
        return Long.TYPE;
    }

    @Override
    public final Class<?> getBoxedElementType() {
        return Long.class;
    }

    @Override
    public final ContinuousArrayData widest(ContinuousArrayData otherData) {
        return otherData instanceof IntElements ? this : otherData;
    }

    @Override
    public final int getElementWeight() {
        return 2;
    }

    @Override
    public LongArrayData copy() {
        return new LongArrayData((long[])this.array.clone(), (int)this.length());
    }

    @Override
    public Object[] asObjectArray() {
        return this.toObjectArray(true);
    }

    private Object[] toObjectArray(boolean trim) {
        assert (this.length() <= (long)this.array.length) : "length exceeds internal array size";
        int len = (int)this.length();
        Object[] oarray = new Object[trim ? len : this.array.length];
        for (int index = 0; index < len; ++index) {
            oarray[index] = this.array[index];
        }
        return oarray;
    }

    @Override
    public Object asArrayOfType(Class<?> componentType) {
        if (componentType == Long.TYPE) {
            int len = (int)this.length();
            return this.array.length == len ? (long[])this.array.clone() : Arrays.copyOf(this.array, len);
        }
        return super.asArrayOfType(componentType);
    }

    private double[] toDoubleArray() {
        assert (this.length() <= (long)this.array.length) : "length exceeds internal array size";
        int len = (int)this.length();
        double[] darray = new double[this.array.length];
        for (int index = 0; index < len; ++index) {
            darray[index] = this.array[index];
        }
        return darray;
    }

    @Override
    public ContinuousArrayData convert(Class<?> type) {
        if (type == Integer.class || type == Long.class || type == Byte.class || type == Short.class) {
            return this;
        }
        int len = (int)this.length();
        if (type == Double.class || type == Float.class) {
            return new NumberArrayData(this.toDoubleArray(), len);
        }
        return new ObjectArrayData(this.toObjectArray(false), len);
    }

    @Override
    public void shiftLeft(int by) {
        System.arraycopy(this.array, by, this.array, 0, this.array.length - by);
    }

    @Override
    public ArrayData shiftRight(int by) {
        ArrayData newData = this.ensure((long)by + this.length() - 1L);
        if (newData != this) {
            newData.shiftRight(by);
            return newData;
        }
        System.arraycopy(this.array, 0, this.array, by, this.array.length - by);
        return this;
    }

    @Override
    public ArrayData ensure(long safeIndex) {
        if (safeIndex >= 0x100000L) {
            return new SparseArrayData(this, safeIndex + 1L);
        }
        int alen = this.array.length;
        if (safeIndex >= (long)alen) {
            int newLength = ArrayData.nextSize((int)safeIndex);
            this.array = Arrays.copyOf(this.array, newLength);
        }
        if (safeIndex >= this.length()) {
            this.setLength(safeIndex + 1L);
        }
        return this;
    }

    @Override
    public ArrayData shrink(long newLength) {
        Arrays.fill(this.array, (int)newLength, this.array.length, 0L);
        return this;
    }

    @Override
    public ArrayData set(int index, Object value, boolean strict) {
        if (value instanceof Long || value instanceof Integer || value instanceof Byte || value instanceof Short) {
            return this.set(index, ((Number)value).longValue(), strict);
        }
        if (value == ScriptRuntime.UNDEFINED) {
            return new UndefinedArrayFilter(this).set(index, value, strict);
        }
        ArrayData newData = this.convert(value == null ? Object.class : value.getClass());
        return newData.set(index, value, strict);
    }

    @Override
    public ArrayData set(int index, int value, boolean strict) {
        this.array[index] = value;
        this.setLength(Math.max((long)(index + 1), this.length()));
        return this;
    }

    @Override
    public ArrayData set(int index, long value, boolean strict) {
        this.array[index] = value;
        this.setLength(Math.max((long)(index + 1), this.length()));
        return this;
    }

    @Override
    public ArrayData set(int index, double value, boolean strict) {
        if (JSType.isRepresentableAsLong(value)) {
            this.array[index] = (long)value;
            this.setLength(Math.max((long)(index + 1), this.length()));
            return this;
        }
        return this.convert((Class)Double.class).set(index, value, strict);
    }

    private long getElem(int index) {
        if (this.has(index)) {
            return this.array[index];
        }
        throw new ClassCastException();
    }

    private void setElem(int index, long elem) {
        if (this.hasRoomFor(index)) {
            this.array[index] = elem;
            return;
        }
        throw new ClassCastException();
    }

    @Override
    public MethodHandle getElementGetter(Class<?> returnType, int programPoint) {
        if (returnType == Integer.TYPE) {
            return null;
        }
        return this.getContinuousElementGetter(HAS_GET_ELEM, returnType, programPoint);
    }

    @Override
    public MethodHandle getElementSetter(Class<?> elementType) {
        return elementType == Integer.TYPE || elementType == Long.TYPE ? this.getContinuousElementSetter(Lookup.MH.asType(SET_ELEM, SET_ELEM.type().changeParameterType(2, elementType)), elementType) : null;
    }

    @Override
    public int getInt(int index) {
        return (int)this.array[index];
    }

    @Override
    public long getLong(int index) {
        return this.array[index];
    }

    @Override
    public long getLongOptimistic(int index, int programPoint) {
        return this.array[index];
    }

    @Override
    public double getDouble(int index) {
        return this.array[index];
    }

    @Override
    public double getDoubleOptimistic(int index, int programPoint) {
        return this.array[index];
    }

    @Override
    public Object getObject(int index) {
        return this.array[index];
    }

    @Override
    public boolean has(int index) {
        return 0 <= index && (long)index < this.length();
    }

    @Override
    public ArrayData delete(int index) {
        return new DeletedRangeArrayFilter(this, index, index);
    }

    @Override
    public ArrayData delete(long fromIndex, long toIndex) {
        return new DeletedRangeArrayFilter(this, fromIndex, toIndex);
    }

    @Override
    public Object pop() {
        int len = (int)this.length();
        if (len == 0) {
            return ScriptRuntime.UNDEFINED;
        }
        int newLength = len - 1;
        long elem = this.array[newLength];
        this.array[newLength] = 0L;
        this.setLength(newLength);
        return elem;
    }

    @Override
    public ArrayData slice(long from, long to) {
        long start = from < 0L ? from + this.length() : from;
        long newLength = to - start;
        return new LongArrayData(Arrays.copyOfRange(this.array, (int)from, (int)to), (int)newLength);
    }

    @Override
    public ArrayData fastSplice(int start, int removed, int added) throws UnsupportedOperationException {
        ArrayData returnValue;
        long oldLength = this.length();
        long newLength = oldLength - (long)removed + (long)added;
        if (newLength > 0x100000L && newLength > (long)this.array.length) {
            throw new UnsupportedOperationException();
        }
        ArrayData arrayData = returnValue = removed == 0 ? EMPTY_ARRAY : new LongArrayData(Arrays.copyOfRange(this.array, start, start + removed), removed);
        if (newLength != oldLength) {
            long[] newArray;
            if (newLength > (long)this.array.length) {
                newArray = new long[ArrayData.nextSize((int)newLength)];
                System.arraycopy(this.array, 0, newArray, 0, start);
            } else {
                newArray = this.array;
            }
            System.arraycopy(this.array, start + removed, newArray, start + added, (int)(oldLength - (long)start - (long)removed));
            this.array = newArray;
            this.setLength(newLength);
        }
        return returnValue;
    }

    @Override
    public long fastPush(int arg) {
        return this.fastPush((long)arg);
    }

    @Override
    public long fastPush(long arg) {
        int len = (int)this.length();
        if (len == this.array.length) {
            this.array = Arrays.copyOf(this.array, LongArrayData.nextSize(len));
        }
        this.array[len] = arg;
        return this.increaseLength();
    }

    @Override
    public long fastPopLong() {
        if (this.length() == 0L) {
            throw new ClassCastException();
        }
        int newLength = (int)this.decreaseLength();
        long elem = this.array[newLength];
        this.array[newLength] = 0L;
        return elem;
    }

    @Override
    public double fastPopDouble() {
        return this.fastPopLong();
    }

    @Override
    public Object fastPopObject() {
        return this.fastPopLong();
    }

    @Override
    public ContinuousArrayData fastConcat(ContinuousArrayData otherData) {
        int otherLength = (int)otherData.length();
        int thisLength = (int)this.length();
        assert (otherLength > 0 && thisLength > 0);
        long[] otherArray = ((LongArrayData)otherData).array;
        int newLength = otherLength + thisLength;
        long[] newArray = new long[ArrayData.alignUp(newLength)];
        System.arraycopy(this.array, 0, newArray, 0, thisLength);
        System.arraycopy(otherArray, 0, newArray, thisLength, otherLength);
        return new LongArrayData(newArray, newLength);
    }

    public String toString() {
        assert (this.length() <= (long)this.array.length) : this.length() + " > " + this.array.length;
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(": [");
        int len = (int)this.length();
        for (int i = 0; i < len; ++i) {
            sb.append(this.array[i]).append('L');
            if (i + 1 >= len) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }
}

