/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaBorder;
import com.apple.laf.AquaFocusHandler;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;

public class AquaTableUI
extends BasicTableUI {
    protected AquaFocusHandler focusHandler = new AquaFocusHandler(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            if (!"Frame.active".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            AquaFocusHandler.swapSelectionColors("Table", AquaTableUI.this.getComponent(), propertyChangeEvent.getNewValue());
        }
    };

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTableUI();
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.table.addFocusListener(this.focusHandler);
        this.table.addPropertyChangeListener(this.focusHandler);
    }

    @Override
    protected void uninstallListeners() {
        this.table.removePropertyChangeListener(this.focusHandler);
        this.table.removeFocusListener(this.focusHandler);
        super.uninstallListeners();
    }

    JTable getComponent() {
        return this.table;
    }

    public class MouseInputHandler
    extends BasicTableUI.MouseInputHandler {
    }

    public class FocusHandler
    extends BasicTableUI.FocusHandler {
        @Override
        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            AquaBorder.repaintBorder(AquaTableUI.this.getComponent());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            super.focusLost(focusEvent);
            AquaBorder.repaintBorder(AquaTableUI.this.getComponent());
        }
    }
}

