/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.util.Arrays;

public class SinglePixelPackedSampleModel
extends SampleModel {
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] bitSizes;
    private int maxBitSize;
    private int scanlineStride;

    private static native void initIDs();

    public SinglePixelPackedSampleModel(int n, int n2, int n3, int[] nArray) {
        this(n, n2, n3, n2, nArray);
        if (n != 0 && n != 1 && n != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n);
        }
    }

    public SinglePixelPackedSampleModel(int n, int n2, int n3, int n4, int[] nArray) {
        super(n, n2, n3, nArray.length);
        if (n != 0 && n != 1 && n != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n);
        }
        this.dataType = n;
        this.bitMasks = (int[])nArray.clone();
        this.scanlineStride = n4;
        this.bitOffsets = new int[this.numBands];
        this.bitSizes = new int[this.numBands];
        int n5 = (int)((1L << DataBuffer.getDataTypeSize(n)) - 1L);
        this.maxBitSize = 0;
        for (int i = 0; i < this.numBands; ++i) {
            int n6 = 0;
            int n7 = 0;
            int n8 = i;
            this.bitMasks[n8] = this.bitMasks[n8] & n5;
            int n9 = this.bitMasks[i];
            if (n9 != 0) {
                while ((n9 & 1) == 0) {
                    n9 >>>= 1;
                    ++n6;
                }
                while ((n9 & 1) == 1) {
                    n9 >>>= 1;
                    ++n7;
                }
                if (n9 != 0) {
                    throw new IllegalArgumentException("Mask " + nArray[i] + " must be contiguous");
                }
            }
            this.bitOffsets[i] = n6;
            this.bitSizes[i] = n7;
            if (n7 <= this.maxBitSize) continue;
            this.maxBitSize = n7;
        }
    }

    @Override
    public int getNumDataElements() {
        return 1;
    }

    private long getBufferSize() {
        long l = this.scanlineStride * (this.height - 1) + this.width;
        return l;
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n, int n2) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(this.dataType, n, n2, this.bitMasks);
        return singlePixelPackedSampleModel;
    }

    @Override
    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n = (int)this.getBufferSize();
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n);
            }
        }
        return dataBuffer;
    }

    @Override
    public int[] getSampleSize() {
        return (int[])this.bitSizes.clone();
    }

    @Override
    public int getSampleSize(int n) {
        return this.bitSizes[n];
    }

    public int getOffset(int n, int n2) {
        int n3 = n2 * this.scanlineStride + n;
        return n3;
    }

    public int[] getBitOffsets() {
        return (int[])this.bitOffsets.clone();
    }

    public int[] getBitMasks() {
        return (int[])this.bitMasks.clone();
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.numBands) {
            throw new RasterFormatException("There are only " + this.numBands + " bands");
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.bitMasks[nArray[i]];
        }
        return new SinglePixelPackedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, nArray2);
    }

    @Override
    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n3 = this.getTransferType();
        switch (n3) {
            case 0: {
                byte[] byArray = object == null ? new byte[1] : (byte[])object;
                byArray[0] = (byte)dataBuffer.getElem(n2 * this.scanlineStride + n);
                object = byArray;
                break;
            }
            case 1: {
                short[] sArray = object == null ? new short[1] : (short[])object;
                sArray[0] = (short)dataBuffer.getElem(n2 * this.scanlineStride + n);
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[1] : (int[])object;
                nArray[0] = dataBuffer.getElem(n2 * this.scanlineStride + n);
                object = nArray;
            }
        }
        return object;
    }

    @Override
    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray == null ? new int[this.numBands] : nArray;
        int n3 = dataBuffer.getElem(n2 * this.scanlineStride + n);
        for (int i = 0; i < this.numBands; ++i) {
            nArray2[i] = (n3 & this.bitMasks[i]) >>> this.bitOffsets[i];
        }
        return nArray2;
    }

    @Override
    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n5 < 0 || n5 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n6 < 0 || n6 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4 * this.numBands];
        int n7 = n2 * this.scanlineStride + n;
        int n8 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n9 = dataBuffer.getElem(n7 + j);
                for (int k = 0; k < this.numBands; ++k) {
                    nArray2[n8++] = (n9 & this.bitMasks[k]) >>> this.bitOffsets[k];
                }
            }
            n7 += this.scanlineStride;
        }
        return nArray2;
    }

    @Override
    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = dataBuffer.getElem(n2 * this.scanlineStride + n);
        return (n4 & this.bitMasks[n3]) >>> this.bitOffsets[n3];
    }

    @Override
    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n + n3 > this.width || n2 + n4 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4];
        int n6 = n2 * this.scanlineStride + n;
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n8 = dataBuffer.getElem(n6 + j);
                nArray2[n7++] = (n8 & this.bitMasks[n5]) >>> this.bitOffsets[n5];
            }
            n6 += this.scanlineStride;
        }
        return nArray2;
    }

    @Override
    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n3 = this.getTransferType();
        switch (n3) {
            case 0: {
                byte[] byArray = (byte[])object;
                dataBuffer.setElem(n2 * this.scanlineStride + n, byArray[0] & 0xFF);
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                dataBuffer.setElem(n2 * this.scanlineStride + n, sArray[0] & 0xFFFF);
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                dataBuffer.setElem(n2 * this.scanlineStride + n, nArray[0]);
            }
        }
    }

    @Override
    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n3 = n2 * this.scanlineStride + n;
        int n4 = dataBuffer.getElem(n3);
        for (int i = 0; i < this.numBands; ++i) {
            n4 &= ~this.bitMasks[i];
            n4 |= nArray[i] << this.bitOffsets[i] & this.bitMasks[i];
        }
        dataBuffer.setElem(n3, n4);
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n5 < 0 || n5 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n6 < 0 || n6 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n7 = n2 * this.scanlineStride + n;
        int n8 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n9 = dataBuffer.getElem(n7 + j);
                for (int k = 0; k < this.numBands; ++k) {
                    n9 &= ~this.bitMasks[k];
                    int n10 = nArray[n8++];
                    n9 |= n10 << this.bitOffsets[k] & this.bitMasks[k];
                }
                dataBuffer.setElem(n7 + j, n9);
            }
            n7 += this.scanlineStride;
        }
    }

    @Override
    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = dataBuffer.getElem(n2 * this.scanlineStride + n);
        n5 &= ~this.bitMasks[n3];
        dataBuffer.setElem(n2 * this.scanlineStride + n, n5 |= n4 << this.bitOffsets[n3] & this.bitMasks[n3]);
    }

    @Override
    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n + n3 > this.width || n2 + n4 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = n2 * this.scanlineStride + n;
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n8 = dataBuffer.getElem(n6 + j);
                n8 &= ~this.bitMasks[n5];
                int n9 = nArray[n7++];
                dataBuffer.setElem(n6 + j, n8 |= n9 << this.bitOffsets[n5] & this.bitMasks[n5]);
            }
            n6 += this.scanlineStride;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)object;
        return this.width == singlePixelPackedSampleModel.width && this.height == singlePixelPackedSampleModel.height && this.numBands == singlePixelPackedSampleModel.numBands && this.dataType == singlePixelPackedSampleModel.dataType && Arrays.equals(this.bitMasks, singlePixelPackedSampleModel.bitMasks) && Arrays.equals(this.bitOffsets, singlePixelPackedSampleModel.bitOffsets) && Arrays.equals(this.bitSizes, singlePixelPackedSampleModel.bitSizes) && this.maxBitSize == singlePixelPackedSampleModel.maxBitSize && this.scanlineStride == singlePixelPackedSampleModel.scanlineStride;
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        n2 = this.width;
        n2 <<= 8;
        n2 ^= this.height;
        n2 <<= 8;
        n2 ^= this.numBands;
        n2 <<= 8;
        n2 ^= this.dataType;
        n2 <<= 8;
        for (n = 0; n < this.bitMasks.length; ++n) {
            n2 ^= this.bitMasks[n];
            n2 <<= 8;
        }
        for (n = 0; n < this.bitOffsets.length; ++n) {
            n2 ^= this.bitOffsets[n];
            n2 <<= 8;
        }
        for (n = 0; n < this.bitSizes.length; ++n) {
            n2 ^= this.bitSizes[n];
            n2 <<= 8;
        }
        n2 ^= this.maxBitSize;
        n2 <<= 8;
        return n2 ^= this.scanlineStride;
    }

    static {
        ColorModel.loadLibraries();
        SinglePixelPackedSampleModel.initIDs();
    }
}

