/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

class CopyMoveHelper {
    private CopyMoveHelper() {
    }

    private static CopyOption[] convertMoveToCopyOptions(CopyOption ... copyOptionArray) throws AtomicMoveNotSupportedException {
        int n = copyOptionArray.length;
        CopyOption[] copyOptionArray2 = new CopyOption[n + 2];
        for (int i = 0; i < n; ++i) {
            CopyOption copyOption = copyOptionArray[i];
            if (copyOption == StandardCopyOption.ATOMIC_MOVE) {
                throw new AtomicMoveNotSupportedException(null, null, "Atomic move between providers is not supported");
            }
            copyOptionArray2[i] = copyOption;
        }
        copyOptionArray2[n] = LinkOption.NOFOLLOW_LINKS;
        copyOptionArray2[n + 1] = StandardCopyOption.COPY_ATTRIBUTES;
        return copyOptionArray2;
    }

    static void copyToForeignTarget(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        Object object;
        LinkOption[] linkOptionArray;
        CopyOptions copyOptions = CopyOptions.parse(copyOptionArray);
        if (copyOptions.followLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] linkOptionArray3 = linkOptionArray;
        BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, linkOptionArray3);
        if (basicFileAttributes.isSymbolicLink()) {
            throw new IOException("Copying of symbolic links not supported");
        }
        if (copyOptions.replaceExisting) {
            Files.deleteIfExists(path2);
        } else if (Files.exists(path2, new LinkOption[0])) {
            throw new FileAlreadyExistsException(path2.toString());
        }
        if (basicFileAttributes.isDirectory()) {
            Files.createDirectory(path2, new FileAttribute[0]);
        } else {
            object = Files.newInputStream(path, new OpenOption[0]);
            Throwable throwable = null;
            try {
                Files.copy((InputStream)object, path2, new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
        }
        if (copyOptions.copyAttributes) {
            object = Files.getFileAttributeView(path2, BasicFileAttributeView.class, linkOptionArray3);
            try {
                object.setTimes(basicFileAttributes.lastModifiedTime(), basicFileAttributes.lastAccessTime(), basicFileAttributes.creationTime());
            }
            catch (Throwable throwable) {
                try {
                    Files.delete(path2);
                }
                catch (Throwable throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    static void moveToForeignTarget(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        CopyMoveHelper.copyToForeignTarget(path, path2, CopyMoveHelper.convertMoveToCopyOptions(copyOptionArray));
        Files.delete(path);
    }

    private static class CopyOptions {
        boolean replaceExisting = false;
        boolean copyAttributes = false;
        boolean followLinks = true;

        private CopyOptions() {
        }

        static CopyOptions parse(CopyOption ... copyOptionArray) {
            CopyOptions copyOptions = new CopyOptions();
            for (CopyOption copyOption : copyOptionArray) {
                if (copyOption == StandardCopyOption.REPLACE_EXISTING) {
                    copyOptions.replaceExisting = true;
                    continue;
                }
                if (copyOption == LinkOption.NOFOLLOW_LINKS) {
                    copyOptions.followLinks = false;
                    continue;
                }
                if (copyOption == StandardCopyOption.COPY_ATTRIBUTES) {
                    copyOptions.copyAttributes = true;
                    continue;
                }
                if (copyOption == null) {
                    throw new NullPointerException();
                }
                throw new UnsupportedOperationException("'" + copyOption + "' is not a recognized copy option");
            }
            return copyOptions;
        }
    }
}

