/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.concurrent.ConcurrentHashMap;

abstract class Underline {
    private static final float DEFAULT_THICKNESS = 1.0f;
    private static final boolean USE_THICKNESS = true;
    private static final boolean IGNORE_THICKNESS = false;
    private static final ConcurrentHashMap<Object, Underline> UNDERLINES = new ConcurrentHashMap(6);
    private static final Underline[] UNDERLINE_LIST;

    Underline() {
    }

    abstract void drawUnderline(Graphics2D var1, float var2, float var3, float var4, float var5);

    abstract float getLowerDrawLimit(float var1);

    abstract Shape getUnderlineShape(float var1, float var2, float var3, float var4);

    static Underline getUnderline(Object object) {
        if (object == null) {
            return null;
        }
        return UNDERLINES.get(object);
    }

    static Underline getUnderline(int n) {
        return n < 0 ? null : UNDERLINE_LIST[n];
    }

    static {
        Underline[] underlineArray = new Underline[6];
        underlineArray[0] = new StandardUnderline(0.0f, 1.0f, null, true);
        UNDERLINES.put(TextAttribute.UNDERLINE_ON, underlineArray[0]);
        underlineArray[1] = new StandardUnderline(1.0f, 1.0f, null, false);
        UNDERLINES.put(TextAttribute.UNDERLINE_LOW_ONE_PIXEL, underlineArray[1]);
        underlineArray[2] = new StandardUnderline(1.0f, 2.0f, null, false);
        UNDERLINES.put(TextAttribute.UNDERLINE_LOW_TWO_PIXEL, underlineArray[2]);
        underlineArray[3] = new StandardUnderline(1.0f, 1.0f, new float[]{1.0f, 1.0f}, false);
        UNDERLINES.put(TextAttribute.UNDERLINE_LOW_DOTTED, underlineArray[3]);
        underlineArray[4] = new IMGrayUnderline();
        UNDERLINES.put(TextAttribute.UNDERLINE_LOW_GRAY, underlineArray[4]);
        underlineArray[5] = new StandardUnderline(1.0f, 1.0f, new float[]{4.0f, 4.0f}, false);
        UNDERLINES.put(TextAttribute.UNDERLINE_LOW_DASHED, underlineArray[5]);
        UNDERLINE_LIST = underlineArray;
    }

    private static class IMGrayUnderline
    extends Underline {
        private BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, 1.0f}, 0.0f);

        IMGrayUnderline() {
        }

        @Override
        void drawUnderline(Graphics2D graphics2D, float f, float f2, float f3, float f4) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.stroke);
            Line2D.Float float_ = new Line2D.Float(f2, f4, f3, f4);
            graphics2D.draw(float_);
            float_.y1 += 1.0f;
            float_.y2 += 1.0f;
            float_.x1 += 1.0f;
            graphics2D.draw(float_);
            graphics2D.setStroke(stroke);
        }

        @Override
        float getLowerDrawLimit(float f) {
            return 2.0f;
        }

        @Override
        Shape getUnderlineShape(float f, float f2, float f3, float f4) {
            GeneralPath generalPath = new GeneralPath();
            Line2D.Float float_ = new Line2D.Float(f2, f4, f3, f4);
            generalPath.append(this.stroke.createStrokedShape(float_), false);
            float_.y1 += 1.0f;
            float_.y2 += 1.0f;
            float_.x1 += 1.0f;
            generalPath.append(this.stroke.createStrokedShape(float_), false);
            return generalPath;
        }
    }

    private static final class StandardUnderline
    extends Underline {
        private float shift;
        private float thicknessMultiplier;
        private float[] dashPattern;
        private boolean useThickness;
        private BasicStroke cachedStroke;

        StandardUnderline(float f, float f2, float[] fArray, boolean bl) {
            this.shift = f;
            this.thicknessMultiplier = f2;
            this.dashPattern = fArray;
            this.useThickness = bl;
            this.cachedStroke = null;
        }

        private BasicStroke createStroke(float f) {
            if (this.dashPattern == null) {
                return new BasicStroke(f, 0, 0);
            }
            return new BasicStroke(f, 0, 0, 10.0f, this.dashPattern, 0.0f);
        }

        private float getLineThickness(float f) {
            if (this.useThickness) {
                return f * this.thicknessMultiplier;
            }
            return 1.0f * this.thicknessMultiplier;
        }

        private Stroke getStroke(float f) {
            float f2 = this.getLineThickness(f);
            BasicStroke basicStroke = this.cachedStroke;
            if (basicStroke == null || basicStroke.getLineWidth() != f2) {
                this.cachedStroke = basicStroke = this.createStroke(f2);
            }
            return basicStroke;
        }

        @Override
        void drawUnderline(Graphics2D graphics2D, float f, float f2, float f3, float f4) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.getStroke(f));
            graphics2D.draw(new Line2D.Float(f2, f4 + this.shift, f3, f4 + this.shift));
            graphics2D.setStroke(stroke);
        }

        @Override
        float getLowerDrawLimit(float f) {
            return this.shift + this.getLineThickness(f);
        }

        @Override
        Shape getUnderlineShape(float f, float f2, float f3, float f4) {
            Stroke stroke = this.getStroke(f);
            Line2D.Float float_ = new Line2D.Float(f2, f4 + this.shift, f3, f4 + this.shift);
            return stroke.createStrokedShape(float_);
        }
    }
}

