/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.util.Arrays;

public class GrowableByteArray {
    byte[] array;
    int size;
    int cellSize;

    public GrowableByteArray(int n, int n2) {
        this.array = new byte[n2];
        this.size = 0;
        this.cellSize = n;
    }

    private int getNextCellIndex() {
        int n = this.size;
        this.size += this.cellSize;
        if (this.size >= this.array.length) {
            this.growArray();
        }
        return n;
    }

    public byte[] getArray() {
        return this.array;
    }

    public byte[] getSizedArray() {
        return Arrays.copyOf(this.array, this.getSize());
    }

    public final int getByte(int n) {
        return this.array[this.getCellIndex(n)];
    }

    public final int getNextIndex() {
        return this.getNextCellIndex() / this.cellSize;
    }

    protected final int getCellIndex(int n) {
        return this.cellSize * n;
    }

    public final void addByte(byte by) {
        int n = this.getNextIndex();
        this.array[n] = by;
    }

    public final int getSize() {
        return this.size / this.cellSize;
    }

    public void clear() {
        this.size = 0;
    }

    protected void growArray() {
        int n = Math.max(this.array.length * 2, 10);
        byte[] byArray = this.array;
        this.array = new byte[n];
        System.arraycopy(byArray, 0, this.array, 0, byArray.length);
    }
}

