/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.PBKDF2KeyImpl;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;

abstract class PBKDF2Core
extends SecretKeyFactorySpi {
    private final String prfAlgo;

    PBKDF2Core(String string) {
        this.prfAlgo = string;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
        return new PBKDF2KeyImpl(pBEKeySpec, this.prfAlgo);
    }

    @Override
    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class<?> clazz) throws InvalidKeySpecException {
        if (secretKey instanceof PBEKey) {
            if (clazz != null && PBEKeySpec.class.isAssignableFrom(clazz)) {
                PBEKey pBEKey = (PBEKey)secretKey;
                return new PBEKeySpec(pBEKey.getPassword(), pBEKey.getSalt(), pBEKey.getIterationCount(), pBEKey.getEncoded().length * 8);
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        throw new InvalidKeySpecException("Invalid key format/algorithm");
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (secretKey != null && secretKey.getAlgorithm().equalsIgnoreCase("PBKDF2With" + this.prfAlgo) && secretKey.getFormat().equalsIgnoreCase("RAW")) {
            if (secretKey instanceof PBKDF2KeyImpl) {
                return secretKey;
            }
            if (secretKey instanceof PBEKey) {
                PBEKey pBEKey = (PBEKey)secretKey;
                try {
                    PBEKeySpec pBEKeySpec = new PBEKeySpec(pBEKey.getPassword(), pBEKey.getSalt(), pBEKey.getIterationCount(), pBEKey.getEncoded().length * 8);
                    return new PBKDF2KeyImpl(pBEKeySpec, this.prfAlgo);
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    InvalidKeyException invalidKeyException = new InvalidKeyException("Invalid key component(s)");
                    invalidKeyException.initCause(invalidKeySpecException);
                    throw invalidKeyException;
                }
            }
        }
        throw new InvalidKeyException("Invalid key format/algorithm");
    }

    public static final class HmacSHA512
    extends PBKDF2Core {
        public HmacSHA512() {
            super("HmacSHA512");
        }
    }

    public static final class HmacSHA384
    extends PBKDF2Core {
        public HmacSHA384() {
            super("HmacSHA384");
        }
    }

    public static final class HmacSHA256
    extends PBKDF2Core {
        public HmacSHA256() {
            super("HmacSHA256");
        }
    }

    public static final class HmacSHA224
    extends PBKDF2Core {
        public HmacSHA224() {
            super("HmacSHA224");
        }
    }

    public static final class HmacSHA1
    extends PBKDF2Core {
        public HmacSHA1() {
            super("HmacSHA1");
        }
    }
}

