/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.dnd.SunDropTargetEvent;
import sun.util.logging.PlatformLogger;

class LightweightDispatcher
implements Serializable,
AWTEventListener {
    private static final long serialVersionUID = 5184291520170872969L;
    private static final int LWD_MOUSE_DRAGGED_OVER = 1500;
    private static final PlatformLogger eventLog = PlatformLogger.getLogger("java.awt.event.LightweightDispatcher");
    private static final int BUTTONS_DOWN_MASK;
    private Container nativeContainer;
    private Component focus;
    private transient WeakReference<Component> mouseEventTarget;
    private transient WeakReference<Component> targetLastEntered;
    private transient WeakReference<Component> targetLastEnteredDT;
    private transient boolean isMouseInNativeContainer = false;
    private transient boolean isMouseDTInNativeContainer = false;
    private Cursor nativeCursor;
    private long eventMask;
    private static final long PROXY_EVENT_MASK = 131132L;
    private static final long MOUSE_MASK = 131120L;

    LightweightDispatcher(Container container) {
        this.nativeContainer = container;
        this.mouseEventTarget = new WeakReference<Object>(null);
        this.targetLastEntered = new WeakReference<Object>(null);
        this.targetLastEnteredDT = new WeakReference<Object>(null);
        this.eventMask = 0L;
    }

    void dispose() {
        this.stopListeningForOtherDrags();
        this.mouseEventTarget.clear();
        this.targetLastEntered.clear();
        this.targetLastEnteredDT.clear();
    }

    void enableEvents(long l) {
        this.eventMask |= l;
    }

    boolean dispatchEvent(AWTEvent aWTEvent) {
        boolean bl = false;
        if (aWTEvent instanceof SunDropTargetEvent) {
            SunDropTargetEvent sunDropTargetEvent = (SunDropTargetEvent)aWTEvent;
            bl = this.processDropTargetEvent(sunDropTargetEvent);
        } else {
            if (aWTEvent instanceof MouseEvent && (this.eventMask & 0x20030L) != 0L) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                bl = this.processMouseEvent(mouseEvent);
            }
            if (aWTEvent.getID() == 503) {
                this.nativeContainer.updateCursorImmediately();
            }
        }
        return bl;
    }

    private boolean isMouseGrab(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        if (mouseEvent.getID() == 501 || mouseEvent.getID() == 502) {
            n ^= InputEvent.getMaskForButton(mouseEvent.getButton());
        }
        return (n & BUTTONS_DOWN_MASK) != 0;
    }

    private boolean processMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        Component component = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), true);
        this.trackMouseEnterExit(component, mouseEvent);
        Component component2 = (Component)this.mouseEventTarget.get();
        if (!this.isMouseGrab(mouseEvent) && n != 500) {
            component2 = component != this.nativeContainer ? component : null;
            this.mouseEventTarget = new WeakReference<Component>(component2);
        }
        if (component2 != null) {
            switch (n) {
                case 504: 
                case 505: {
                    break;
                }
                case 501: {
                    this.retargetMouseEvent(component2, n, mouseEvent);
                    break;
                }
                case 502: {
                    this.retargetMouseEvent(component2, n, mouseEvent);
                    break;
                }
                case 500: {
                    if (component != component2) break;
                    this.retargetMouseEvent(component, n, mouseEvent);
                    break;
                }
                case 503: {
                    this.retargetMouseEvent(component2, n, mouseEvent);
                    break;
                }
                case 506: {
                    if (!this.isMouseGrab(mouseEvent)) break;
                    this.retargetMouseEvent(component2, n, mouseEvent);
                    break;
                }
                case 507: {
                    if (eventLog.isLoggable(PlatformLogger.Level.FINEST) && component != null) {
                        eventLog.finest("retargeting mouse wheel to " + component.getName() + ", " + component.getClass());
                    }
                    this.retargetMouseEvent(component, n, mouseEvent);
                }
            }
            if (n != 507) {
                mouseEvent.consume();
            }
        }
        return mouseEvent.isConsumed();
    }

    private boolean processDropTargetEvent(SunDropTargetEvent sunDropTargetEvent) {
        Serializable serializable;
        int n;
        int n2 = sunDropTargetEvent.getID();
        int n3 = sunDropTargetEvent.getX();
        if (!this.nativeContainer.contains(n3, n = sunDropTargetEvent.getY())) {
            serializable = this.nativeContainer.getSize();
            if (serializable.width <= n3) {
                n3 = serializable.width - 1;
            } else if (n3 < 0) {
                n3 = 0;
            }
            if (serializable.height <= n) {
                n = serializable.height - 1;
            } else if (n < 0) {
                n = 0;
            }
        }
        serializable = this.nativeContainer.getDropTargetEventTarget(n3, n, true);
        this.trackMouseEnterExit((Component)serializable, sunDropTargetEvent);
        if (serializable != this.nativeContainer && serializable != null) {
            switch (n2) {
                case 504: 
                case 505: {
                    break;
                }
                default: {
                    this.retargetMouseEvent((Component)serializable, n2, sunDropTargetEvent);
                    sunDropTargetEvent.consume();
                }
            }
        }
        return sunDropTargetEvent.isConsumed();
    }

    private void trackDropTargetEnterExit(Component component, MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        if (n == 504 && this.isMouseDTInNativeContainer) {
            this.targetLastEnteredDT.clear();
        } else if (n == 504) {
            this.isMouseDTInNativeContainer = true;
        } else if (n == 505) {
            this.isMouseDTInNativeContainer = false;
        }
        Component component2 = this.retargetMouseEnterExit(component, mouseEvent, (Component)this.targetLastEnteredDT.get(), this.isMouseDTInNativeContainer);
        this.targetLastEnteredDT = new WeakReference<Component>(component2);
    }

    private void trackMouseEnterExit(Component component, MouseEvent mouseEvent) {
        if (mouseEvent instanceof SunDropTargetEvent) {
            this.trackDropTargetEnterExit(component, mouseEvent);
            return;
        }
        int n = mouseEvent.getID();
        if (n != 505 && n != 506 && n != 1500 && !this.isMouseInNativeContainer) {
            this.isMouseInNativeContainer = true;
            this.startListeningForOtherDrags();
        } else if (n == 505) {
            this.isMouseInNativeContainer = false;
            this.stopListeningForOtherDrags();
        }
        Component component2 = this.retargetMouseEnterExit(component, mouseEvent, (Component)this.targetLastEntered.get(), this.isMouseInNativeContainer);
        this.targetLastEntered = new WeakReference<Component>(component2);
    }

    private Component retargetMouseEnterExit(Component component, MouseEvent mouseEvent, Component component2, boolean bl) {
        Component component3;
        int n = mouseEvent.getID();
        Component component4 = component3 = bl ? component : null;
        if (component2 != component3) {
            if (component2 != null) {
                this.retargetMouseEvent(component2, 505, mouseEvent);
            }
            if (n == 505) {
                mouseEvent.consume();
            }
            if (component3 != null) {
                this.retargetMouseEvent(component3, 504, mouseEvent);
            }
            if (n == 504) {
                mouseEvent.consume();
            }
        }
        return component3;
    }

    private void startListeningForOtherDrags() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                LightweightDispatcher.this.nativeContainer.getToolkit().addAWTEventListener(LightweightDispatcher.this, 48L);
                return null;
            }
        });
    }

    private void stopListeningForOtherDrags() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                LightweightDispatcher.this.nativeContainer.getToolkit().removeAWTEventListener(LightweightDispatcher.this);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        MouseEvent mouseEvent;
        boolean bl;
        boolean bl2 = bl = aWTEvent instanceof MouseEvent && !(aWTEvent instanceof SunDropTargetEvent) && aWTEvent.id == 506 && aWTEvent.getSource() != this.nativeContainer;
        if (!bl) {
            return;
        }
        MouseEvent mouseEvent2 = (MouseEvent)aWTEvent;
        Object object = this.nativeContainer.getTreeLock();
        synchronized (object) {
            Container container;
            Component component = mouseEvent2.getComponent();
            if (!component.isShowing()) {
                return;
            }
            for (container = this.nativeContainer; container != null && !(container instanceof Window); container = container.getParent_NoClientCode()) {
            }
            if (container == null || ((Window)container).isModalBlocked()) {
                return;
            }
            mouseEvent = new MouseEvent(this.nativeContainer, 1500, mouseEvent2.getWhen(), mouseEvent2.getModifiersEx() | mouseEvent2.getModifiers(), mouseEvent2.getX(), mouseEvent2.getY(), mouseEvent2.getXOnScreen(), mouseEvent2.getYOnScreen(), mouseEvent2.getClickCount(), mouseEvent2.isPopupTrigger(), mouseEvent2.getButton());
            mouseEvent2.copyPrivateDataInto(mouseEvent);
            final Point point = component.getLocationOnScreen();
            if (AppContext.getAppContext() != this.nativeContainer.appContext) {
                final MouseEvent mouseEvent3 = mouseEvent;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!LightweightDispatcher.this.nativeContainer.isShowing()) {
                            return;
                        }
                        Point point2 = LightweightDispatcher.this.nativeContainer.getLocationOnScreen();
                        mouseEvent3.translatePoint(point.x - point2.x, point.y - point2.y);
                        Component component = LightweightDispatcher.this.nativeContainer.getMouseEventTarget(mouseEvent3.getX(), mouseEvent3.getY(), true);
                        LightweightDispatcher.this.trackMouseEnterExit(component, mouseEvent3);
                    }
                };
                SunToolkit.executeOnEventHandlerThread(this.nativeContainer, runnable);
                return;
            }
            if (!this.nativeContainer.isShowing()) {
                return;
            }
            Point point2 = this.nativeContainer.getLocationOnScreen();
            mouseEvent.translatePoint(point.x - point2.x, point.y - point2.y);
        }
        object = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), true);
        this.trackMouseEnterExit((Component)object, mouseEvent);
    }

    void retargetMouseEvent(Component component, int n, MouseEvent mouseEvent) {
        Component component2;
        if (component == null) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        for (component2 = component; component2 != null && component2 != this.nativeContainer; component2 = component2.getParent()) {
            n2 -= component2.x;
            n3 -= component2.y;
        }
        if (component2 != null) {
            MouseEvent mouseEvent2 = mouseEvent instanceof SunDropTargetEvent ? new SunDropTargetEvent(component, n, n2, n3, ((SunDropTargetEvent)mouseEvent).getDispatcher()) : (n == 507 ? new MouseWheelEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiersEx() | mouseEvent.getModifiers(), n2, n3, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), ((MouseWheelEvent)mouseEvent).getScrollType(), ((MouseWheelEvent)mouseEvent).getScrollAmount(), ((MouseWheelEvent)mouseEvent).getWheelRotation(), ((MouseWheelEvent)mouseEvent).getPreciseWheelRotation()) : new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiersEx() | mouseEvent.getModifiers(), n2, n3, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
            mouseEvent.copyPrivateDataInto(mouseEvent2);
            if (component == this.nativeContainer) {
                ((Container)component).dispatchEventToSelf(mouseEvent2);
            } else {
                assert (AppContext.getAppContext() == component.appContext);
                if (this.nativeContainer.modalComp != null) {
                    if (((Container)this.nativeContainer.modalComp).isAncestorOf(component)) {
                        component.dispatchEvent(mouseEvent2);
                    } else {
                        mouseEvent.consume();
                    }
                } else {
                    component.dispatchEvent(mouseEvent2);
                }
            }
            if (n == 507 && mouseEvent2.isConsumed()) {
                mouseEvent.consume();
            }
        }
    }

    static {
        int[] nArray = AWTAccessor.getInputEventAccessor().getButtonDownMasks();
        int n = 0;
        for (int n2 : nArray) {
            n |= n2;
        }
        BUTTONS_DOWN_MASK = n;
    }
}

