#!/bin/sh

echo "keygen"
zenroom keygen.lua > key.json
echo "init"
zenroom -k key.json init.lua > votes.json
echo "verify init"
zenroom -a votes.json verify_init.lua
echo "vote opt"
cat votes.json | jq --arg opt yes '. +{option: $opt}' | tee votes.json
echo "vote"
zenroom -a votes.json vote.lua | tee votes.json
echo "verify vote"
zenroom -a votes.json verify_vote.lua
echo "tally"
zenroom -k key.json -a votes.json tally.lua
