/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.URL;
import java.util.HashMap;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpCallerInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.Negotiator;
import sun.util.logging.PlatformLogger;

class NegotiateAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 100L;
    private static final PlatformLogger logger = HttpURLConnection.getHttpLogger();
    private final HttpCallerInfo hci;
    static HashMap<String, Boolean> supported = null;
    static HashMap<String, Negotiator> cache = null;
    private Negotiator negotiator = null;

    public NegotiateAuthentication(HttpCallerInfo httpCallerInfo) {
        super(Authenticator.RequestorType.PROXY == httpCallerInfo.authType ? (char)'p' : 's', httpCallerInfo.scheme.equalsIgnoreCase("Negotiate") ? AuthScheme.NEGOTIATE : AuthScheme.KERBEROS, httpCallerInfo.url, "");
        this.hci = httpCallerInfo;
    }

    @Override
    public boolean supportsPreemptiveAuthorization() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSupported(HttpCallerInfo httpCallerInfo) {
        ClassLoader classLoader;
        block6: {
            classLoader = null;
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException securityException) {
                if (!logger.isLoggable(PlatformLogger.Level.FINER)) break block6;
                logger.finer("NegotiateAuthentication: Attempt to get the context class loader failed - " + securityException);
            }
        }
        if (classLoader != null) {
            ClassLoader classLoader2 = classLoader;
            synchronized (classLoader2) {
                return NegotiateAuthentication.isSupportedImpl(httpCallerInfo);
            }
        }
        return NegotiateAuthentication.isSupportedImpl(httpCallerInfo);
    }

    private static synchronized boolean isSupportedImpl(HttpCallerInfo httpCallerInfo) {
        if (supported == null) {
            supported = new HashMap();
            cache = new HashMap();
        }
        String string = httpCallerInfo.host;
        if (supported.containsKey(string = string.toLowerCase())) {
            return supported.get(string);
        }
        Negotiator negotiator = Negotiator.getNegotiator(httpCallerInfo);
        if (negotiator != null) {
            supported.put(string, true);
            cache.put(string, negotiator);
            return true;
        }
        supported.put(string, false);
        return false;
    }

    @Override
    public String getHeaderValue(URL uRL, String string) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    @Override
    public boolean isAuthorizationStale(String string) {
        return false;
    }

    @Override
    public synchronized boolean setHeaders(HttpURLConnection httpURLConnection, HeaderParser headerParser, String string) {
        try {
            byte[] byArray = null;
            String[] stringArray = string.split("\\s+");
            if (stringArray.length > 1) {
                byArray = new BASE64Decoder().decodeBuffer(stringArray[1]);
            }
            String string2 = this.hci.scheme + " " + new B64Encoder().encode(byArray == null ? this.firstToken() : this.nextToken(byArray));
            httpURLConnection.setAuthenticationProperty(this.getHeaderName(), string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] firstToken() throws IOException {
        Serializable serializable;
        this.negotiator = null;
        if (cache != null) {
            serializable = cache;
            synchronized (serializable) {
                this.negotiator = cache.get(this.getHost());
                if (this.negotiator != null) {
                    cache.remove(this.getHost());
                }
            }
        }
        if (this.negotiator == null) {
            this.negotiator = Negotiator.getNegotiator(this.hci);
            if (this.negotiator == null) {
                serializable = new IOException("Cannot initialize Negotiator");
                throw serializable;
            }
        }
        return this.negotiator.firstToken();
    }

    private byte[] nextToken(byte[] byArray) throws IOException {
        return this.negotiator.nextToken(byArray);
    }

    class B64Encoder
    extends BASE64Encoder {
        B64Encoder() {
        }

        @Override
        protected int bytesPerLine() {
            return 100000;
        }
    }
}

